/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.aws;

import com.amazonaws.regions.Region;
import com.amazonaws.regions.Regions;
import com.google.common.base.Suppliers;
import java.util.function.Supplier;

public final class AwsCurrentRegionHolder {
    private static final Supplier<Region> SUPPLIER = Suppliers.memoize(AwsCurrentRegionHolder::loadCurrentRegionOrThrowOnNull);

    private AwsCurrentRegionHolder() {
    }

    public static Region getCurrentRegionFromEC2Metadata() throws IllegalStateException {
        return SUPPLIER.get();
    }

    private static Region loadCurrentRegionOrThrowOnNull() throws IllegalStateException {
        Region result = Regions.getCurrentRegion();
        if (result == null) {
            throw new IllegalStateException("Failed to resolve current AWS region from EC2 metadata");
        }
        return result;
    }
}

