/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.metastore;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import io.prestosql.spi.security.ConnectorIdentity;
import io.prestosql.spi.security.PrestoPrincipal;
import io.prestosql.spi.security.PrincipalType;
import io.prestosql.spi.security.SelectedRole;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;

public class HivePrincipal {
    private final PrincipalType type;
    private final String name;

    public static HivePrincipal from(ConnectorIdentity identity) {
        if (!identity.getRole().isPresent()) {
            return HivePrincipal.ofUser(identity.getUser());
        }
        SelectedRole.Type type = ((SelectedRole)identity.getRole().get()).getType();
        if (type == SelectedRole.Type.ALL) {
            return HivePrincipal.ofUser(identity.getUser());
        }
        Preconditions.checkArgument((type == SelectedRole.Type.ROLE ? 1 : 0) != 0, (String)"Expected role type to be ALL or ROLE, but got: %s", (Object)type);
        return HivePrincipal.ofRole((String)((SelectedRole)identity.getRole().get()).getRole().get());
    }

    private static HivePrincipal ofUser(String user) {
        return new HivePrincipal(PrincipalType.USER, user);
    }

    private static HivePrincipal ofRole(String role) {
        return new HivePrincipal(PrincipalType.ROLE, role);
    }

    public static Set<HivePrincipal> from(Set<PrestoPrincipal> prestoPrincipals) {
        return (Set)prestoPrincipals.stream().map(HivePrincipal::from).collect(ImmutableSet.toImmutableSet());
    }

    public static HivePrincipal from(PrestoPrincipal prestoPrincipal) {
        return new HivePrincipal(prestoPrincipal.getType(), prestoPrincipal.getName());
    }

    @JsonCreator
    public HivePrincipal(@JsonProperty(value="type") PrincipalType type, @JsonProperty(value="name") String name) {
        this.type = Objects.requireNonNull(type, "type is null");
        Objects.requireNonNull(name, "name is null");
        if (type == PrincipalType.USER) {
            this.name = name;
        } else if (type == PrincipalType.ROLE) {
            this.name = name.toLowerCase(Locale.ENGLISH);
        } else {
            throw new IllegalArgumentException("Unsupported type: " + type);
        }
    }

    @JsonProperty
    public PrincipalType getType() {
        return this.type;
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HivePrincipal prestoPrincipal = (HivePrincipal)o;
        return this.type == prestoPrincipal.type && Objects.equals(this.name, prestoPrincipal.name);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.name);
    }

    public String toString() {
        return this.type + " " + this.name;
    }

    public PrestoPrincipal toPrestoPrincipal() {
        return new PrestoPrincipal(this.type, this.name);
    }
}

