/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.metastore.cache;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Streams;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.UncheckedExecutionException;
import io.airlift.units.Duration;
import io.prestosql.plugin.hive.HivePartition;
import io.prestosql.plugin.hive.HivePartitionManager;
import io.prestosql.plugin.hive.HiveType;
import io.prestosql.plugin.hive.PartitionNotFoundException;
import io.prestosql.plugin.hive.PartitionStatistics;
import io.prestosql.plugin.hive.authentication.HiveIdentity;
import io.prestosql.plugin.hive.metastore.Database;
import io.prestosql.plugin.hive.metastore.HiveMetastore;
import io.prestosql.plugin.hive.metastore.HivePartitionName;
import io.prestosql.plugin.hive.metastore.HivePrincipal;
import io.prestosql.plugin.hive.metastore.HivePrivilegeInfo;
import io.prestosql.plugin.hive.metastore.HiveTableName;
import io.prestosql.plugin.hive.metastore.MetastoreUtil;
import io.prestosql.plugin.hive.metastore.Partition;
import io.prestosql.plugin.hive.metastore.PartitionFilter;
import io.prestosql.plugin.hive.metastore.PartitionWithStatistics;
import io.prestosql.plugin.hive.metastore.PrincipalPrivileges;
import io.prestosql.plugin.hive.metastore.Table;
import io.prestosql.plugin.hive.metastore.TablesWithParameterCacheKey;
import io.prestosql.plugin.hive.metastore.UserTableKey;
import io.prestosql.plugin.hive.metastore.cache.CachingHiveMetastoreConfig;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.connector.SchemaTableName;
import io.prestosql.spi.connector.TableNotFoundException;
import io.prestosql.spi.security.RoleGrant;
import io.prestosql.spi.statistics.ColumnStatisticType;
import io.prestosql.spi.type.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javax.annotation.concurrent.ThreadSafe;
import org.weakref.jmx.Managed;

@ThreadSafe
public class CachingHiveMetastore
implements HiveMetastore {
    protected final HiveMetastore delegate;
    private final LoadingCache<String, Optional<Database>> databaseCache;
    private final LoadingCache<String, List<String>> databaseNamesCache;
    private final LoadingCache<WithIdentity<HiveTableName>, Optional<Table>> tableCache;
    private final LoadingCache<String, List<String>> tableNamesCache;
    private final LoadingCache<TablesWithParameterCacheKey, List<String>> tablesWithParameterCache;
    private final LoadingCache<WithIdentity<HiveTableName>, PartitionStatistics> tableStatisticsCache;
    private final LoadingCache<WithIdentity<HivePartitionName>, PartitionStatistics> partitionStatisticsCache;
    private final LoadingCache<String, List<String>> viewNamesCache;
    private final LoadingCache<WithIdentity<HivePartitionName>, Optional<Partition>> partitionCache;
    private final LoadingCache<WithIdentity<PartitionFilter>, Optional<List<String>>> partitionFilterCache;
    private final LoadingCache<WithIdentity<HiveTableName>, Optional<List<String>>> partitionNamesCache;
    private final LoadingCache<UserTableKey, Set<HivePrivilegeInfo>> tablePrivilegesCache;
    private final LoadingCache<String, Set<String>> rolesCache;
    private final LoadingCache<HivePrincipal, Set<RoleGrant>> roleGrantsCache;
    private final LoadingCache<String, Optional<String>> configValuesCache;

    public static HiveMetastore cachingHiveMetastore(HiveMetastore delegate, Executor executor, CachingHiveMetastoreConfig config) {
        return CachingHiveMetastore.cachingHiveMetastore(delegate, executor, config.getMetastoreCacheTtl(), config.getMetastoreRefreshInterval(), config.getMetastoreCacheMaximumSize());
    }

    public static HiveMetastore cachingHiveMetastore(HiveMetastore delegate, Executor executor, Duration cacheTtl, Optional<Duration> refreshInterval, long maximumSize) {
        if (cacheTtl.toMillis() == 0L || maximumSize == 0L) {
            return delegate;
        }
        return new CachingHiveMetastore(delegate, executor, OptionalLong.of(cacheTtl.toMillis()), refreshInterval.map(Duration::toMillis).map(OptionalLong::of).orElseGet(OptionalLong::empty), maximumSize);
    }

    public static CachingHiveMetastore memoizeMetastore(HiveMetastore delegate, long maximumSize) {
        return new CachingHiveMetastore(delegate, (Executor)MoreExecutors.newDirectExecutorService(), OptionalLong.empty(), OptionalLong.empty(), maximumSize);
    }

    protected CachingHiveMetastore(HiveMetastore delegate, Executor executor, OptionalLong expiresAfterWriteMillis, OptionalLong refreshMills, long maximumSize) {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        Objects.requireNonNull(executor, "executor is null");
        this.databaseNamesCache = CachingHiveMetastore.newCacheBuilder(expiresAfterWriteMillis, refreshMills, maximumSize).build(CacheLoader.asyncReloading((CacheLoader)CacheLoader.from(this::loadAllDatabases), (Executor)executor));
        this.databaseCache = CachingHiveMetastore.newCacheBuilder(expiresAfterWriteMillis, refreshMills, maximumSize).build(CacheLoader.asyncReloading((CacheLoader)CacheLoader.from(this::loadDatabase), (Executor)executor));
        this.tableNamesCache = CachingHiveMetastore.newCacheBuilder(expiresAfterWriteMillis, refreshMills, maximumSize).build(CacheLoader.asyncReloading((CacheLoader)CacheLoader.from(this::loadAllTables), (Executor)executor));
        this.tablesWithParameterCache = CachingHiveMetastore.newCacheBuilder(expiresAfterWriteMillis, refreshMills, maximumSize).build(CacheLoader.asyncReloading((CacheLoader)CacheLoader.from(this::loadTablesMatchingParameter), (Executor)executor));
        this.tableStatisticsCache = CachingHiveMetastore.newCacheBuilder(expiresAfterWriteMillis, refreshMills, maximumSize).build(CacheLoader.asyncReloading((CacheLoader)CacheLoader.from(this::loadTableColumnStatistics), (Executor)executor));
        this.partitionStatisticsCache = CachingHiveMetastore.newCacheBuilder(expiresAfterWriteMillis, refreshMills, maximumSize).build(CacheLoader.asyncReloading((CacheLoader)new CacheLoader<WithIdentity<HivePartitionName>, PartitionStatistics>(){

            public PartitionStatistics load(WithIdentity<HivePartitionName> key) {
                return CachingHiveMetastore.this.loadPartitionColumnStatistics(key);
            }

            public Map<WithIdentity<HivePartitionName>, PartitionStatistics> loadAll(Iterable<? extends WithIdentity<HivePartitionName>> keys) {
                return CachingHiveMetastore.this.loadPartitionColumnStatistics(keys);
            }
        }, (Executor)executor));
        this.tableCache = CachingHiveMetastore.newCacheBuilder(expiresAfterWriteMillis, refreshMills, maximumSize).build(CacheLoader.asyncReloading((CacheLoader)CacheLoader.from(this::loadTable), (Executor)executor));
        this.viewNamesCache = CachingHiveMetastore.newCacheBuilder(expiresAfterWriteMillis, refreshMills, maximumSize).build(CacheLoader.asyncReloading((CacheLoader)CacheLoader.from(this::loadAllViews), (Executor)executor));
        this.partitionNamesCache = CachingHiveMetastore.newCacheBuilder(expiresAfterWriteMillis, refreshMills, maximumSize).build(CacheLoader.asyncReloading((CacheLoader)CacheLoader.from(this::loadPartitionNames), (Executor)executor));
        this.partitionFilterCache = CachingHiveMetastore.newCacheBuilder(expiresAfterWriteMillis, refreshMills, maximumSize).build(CacheLoader.asyncReloading((CacheLoader)CacheLoader.from(this::loadPartitionNamesByParts), (Executor)executor));
        this.partitionCache = CachingHiveMetastore.newCacheBuilder(expiresAfterWriteMillis, refreshMills, maximumSize).build(CacheLoader.asyncReloading((CacheLoader)new CacheLoader<WithIdentity<HivePartitionName>, Optional<Partition>>(){

            public Optional<Partition> load(WithIdentity<HivePartitionName> partitionName) {
                return CachingHiveMetastore.this.loadPartitionByName(partitionName);
            }

            public Map<WithIdentity<HivePartitionName>, Optional<Partition>> loadAll(Iterable<? extends WithIdentity<HivePartitionName>> partitionNames) {
                return CachingHiveMetastore.this.loadPartitionsByNames(partitionNames);
            }
        }, (Executor)executor));
        this.tablePrivilegesCache = CachingHiveMetastore.newCacheBuilder(expiresAfterWriteMillis, refreshMills, maximumSize).build(CacheLoader.asyncReloading((CacheLoader)CacheLoader.from(key -> this.loadTablePrivileges(key.getDatabase(), key.getTable(), key.getOwner(), key.getPrincipal())), (Executor)executor));
        this.rolesCache = CachingHiveMetastore.newCacheBuilder(expiresAfterWriteMillis, refreshMills, maximumSize).build(CacheLoader.asyncReloading((CacheLoader)CacheLoader.from(this::loadRoles), (Executor)executor));
        this.roleGrantsCache = CachingHiveMetastore.newCacheBuilder(expiresAfterWriteMillis, refreshMills, maximumSize).build(CacheLoader.asyncReloading((CacheLoader)CacheLoader.from(this::loadRoleGrants), (Executor)executor));
        this.configValuesCache = CachingHiveMetastore.newCacheBuilder(expiresAfterWriteMillis, refreshMills, maximumSize).build(CacheLoader.asyncReloading((CacheLoader)CacheLoader.from(this::loadConfigValue), (Executor)executor));
    }

    @Managed
    public void flushCache() {
        this.databaseNamesCache.invalidateAll();
        this.tableNamesCache.invalidateAll();
        this.viewNamesCache.invalidateAll();
        this.partitionNamesCache.invalidateAll();
        this.databaseCache.invalidateAll();
        this.tableCache.invalidateAll();
        this.partitionCache.invalidateAll();
        this.partitionFilterCache.invalidateAll();
        this.tablePrivilegesCache.invalidateAll();
        this.tableStatisticsCache.invalidateAll();
        this.partitionStatisticsCache.invalidateAll();
        this.rolesCache.invalidateAll();
    }

    private static <K, V> V get(LoadingCache<K, V> cache, K key) {
        try {
            return (V)cache.getUnchecked(key);
        }
        catch (UncheckedExecutionException e) {
            Throwables.throwIfInstanceOf((Throwable)e.getCause(), PrestoException.class);
            throw e;
        }
    }

    private static <K, V> Map<K, V> getAll(LoadingCache<K, V> cache, Iterable<K> keys) {
        try {
            return cache.getAll(keys);
        }
        catch (UncheckedExecutionException | ExecutionException e) {
            Throwables.throwIfInstanceOf((Throwable)e.getCause(), PrestoException.class);
            Throwables.throwIfUnchecked((Throwable)e);
            throw new UncheckedExecutionException(e);
        }
    }

    @Override
    public Optional<Database> getDatabase(String databaseName) {
        return CachingHiveMetastore.get(this.databaseCache, databaseName);
    }

    private Optional<Database> loadDatabase(String databaseName) {
        return this.delegate.getDatabase(databaseName);
    }

    @Override
    public List<String> getAllDatabases() {
        return CachingHiveMetastore.get(this.databaseNamesCache, "");
    }

    private List<String> loadAllDatabases() {
        return this.delegate.getAllDatabases();
    }

    private Table getExistingTable(HiveIdentity identity, String databaseName, String tableName) {
        return this.getTable(identity, databaseName, tableName).orElseThrow(() -> new TableNotFoundException(new SchemaTableName(databaseName, tableName)));
    }

    @Override
    public Optional<Table> getTable(HiveIdentity identity, String databaseName, String tableName) {
        identity = this.updateIdentity(identity);
        return CachingHiveMetastore.get(this.tableCache, new WithIdentity<HiveTableName>(identity, HiveTableName.hiveTableName(databaseName, tableName)));
    }

    @Override
    public Set<ColumnStatisticType> getSupportedColumnStatistics(Type type) {
        return this.delegate.getSupportedColumnStatistics(type);
    }

    private Optional<Table> loadTable(WithIdentity<HiveTableName> hiveTableName) {
        return this.delegate.getTable(hiveTableName.getIdentity(), ((HiveTableName)((WithIdentity)hiveTableName).key).getDatabaseName(), ((HiveTableName)((WithIdentity)hiveTableName).key).getTableName());
    }

    @Override
    public PartitionStatistics getTableStatistics(HiveIdentity identity, Table table) {
        return CachingHiveMetastore.get(this.tableStatisticsCache, new WithIdentity<HiveTableName>(this.updateIdentity(identity), HiveTableName.hiveTableName(table.getDatabaseName(), table.getTableName())));
    }

    private PartitionStatistics loadTableColumnStatistics(WithIdentity<HiveTableName> hiveTableName) {
        HiveTableName tableName = hiveTableName.getKey();
        Table table = this.getExistingTable(hiveTableName.getIdentity(), tableName.getDatabaseName(), tableName.getTableName());
        return this.delegate.getTableStatistics(hiveTableName.getIdentity(), table);
    }

    @Override
    public Map<String, PartitionStatistics> getPartitionStatistics(HiveIdentity identity, Table table, List<Partition> partitions) {
        HiveTableName hiveTableName = HiveTableName.hiveTableName(table.getDatabaseName(), table.getTableName());
        List partitionNames = (List)partitions.stream().map(partition -> new WithIdentity<HivePartitionName>(this.updateIdentity(identity), HivePartitionName.hivePartitionName(hiveTableName, MetastoreUtil.makePartitionName(table, partition)))).collect(ImmutableList.toImmutableList());
        Map<WithIdentity<HivePartitionName>, PartitionStatistics> statistics = CachingHiveMetastore.getAll(this.partitionStatisticsCache, partitionNames);
        return (Map)statistics.entrySet().stream().collect(ImmutableMap.toImmutableMap(entry -> ((HivePartitionName)((WithIdentity)entry.getKey()).getKey()).getPartitionName().get(), Map.Entry::getValue));
    }

    private PartitionStatistics loadPartitionColumnStatistics(WithIdentity<HivePartitionName> partition) {
        HiveTableName tableName = partition.getKey().getHiveTableName();
        String partitionName = partition.getKey().getPartitionName().get();
        Table table = this.getExistingTable(partition.getIdentity(), tableName.getDatabaseName(), tableName.getTableName());
        Map<String, PartitionStatistics> partitionStatistics = this.delegate.getPartitionStatistics(partition.getIdentity(), table, (List<Partition>)ImmutableList.of((Object)this.getExistingPartition(partition.getIdentity(), table, partition.getKey().getPartitionValues())));
        return partitionStatistics.get(partitionName);
    }

    private Map<WithIdentity<HivePartitionName>, PartitionStatistics> loadPartitionColumnStatistics(Iterable<? extends WithIdentity<HivePartitionName>> keys) {
        SetMultimap tablePartitions = (SetMultimap)Streams.stream(keys).collect(ImmutableSetMultimap.toImmutableSetMultimap(value -> new WithIdentity<HiveTableName>(value.getIdentity(), ((HivePartitionName)value.getKey()).getHiveTableName()), Function.identity()));
        ImmutableMap.Builder result = ImmutableMap.builder();
        tablePartitions.keySet().forEach(tableName -> {
            Set partitionNames = tablePartitions.get(tableName);
            Set partitionNameStrings = (Set)partitionNames.stream().map(partitionName -> ((HivePartitionName)partitionName.getKey()).getPartitionName().get()).collect(ImmutableSet.toImmutableSet());
            Table table = this.getExistingTable(tableName.getIdentity(), ((HiveTableName)tableName.getKey()).getDatabaseName(), ((HiveTableName)tableName.getKey()).getTableName());
            List<Partition> partitions = this.getExistingPartitionsByNames(tableName.getIdentity(), table, (List<String>)ImmutableList.copyOf((Collection)partitionNameStrings));
            Map<String, PartitionStatistics> statisticsByPartitionName = this.delegate.getPartitionStatistics(tableName.getIdentity(), table, partitions);
            for (WithIdentity partitionName2 : partitionNames) {
                String stringNameForPartition = ((HivePartitionName)partitionName2.getKey()).getPartitionName().get();
                result.put((Object)partitionName2, (Object)statisticsByPartitionName.get(stringNameForPartition));
            }
        });
        return result.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateTableStatistics(HiveIdentity identity, String databaseName, String tableName, Function<PartitionStatistics, PartitionStatistics> update) {
        identity = this.updateIdentity(identity);
        try {
            this.delegate.updateTableStatistics(identity, databaseName, tableName, update);
        }
        finally {
            HiveTableName hiveTableName = HiveTableName.hiveTableName(databaseName, tableName);
            this.tableStatisticsCache.invalidate(new WithIdentity<HiveTableName>(identity, hiveTableName));
            this.tableCache.invalidate(new WithIdentity<HiveTableName>(identity, hiveTableName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updatePartitionStatistics(HiveIdentity identity, Table table, String partitionName, Function<PartitionStatistics, PartitionStatistics> update) {
        identity = this.updateIdentity(identity);
        try {
            this.delegate.updatePartitionStatistics(identity, table, partitionName, update);
        }
        finally {
            HivePartitionName hivePartitionName = HivePartitionName.hivePartitionName(HiveTableName.hiveTableName(table.getDatabaseName(), table.getTableName()), partitionName);
            this.partitionStatisticsCache.invalidate(new WithIdentity<HivePartitionName>(identity, hivePartitionName));
            this.partitionCache.invalidate(new WithIdentity<HivePartitionName>(identity, hivePartitionName));
        }
    }

    @Override
    public List<String> getAllTables(String databaseName) {
        return CachingHiveMetastore.get(this.tableNamesCache, databaseName);
    }

    private List<String> loadAllTables(String databaseName) {
        return this.delegate.getAllTables(databaseName);
    }

    @Override
    public List<String> getTablesWithParameter(String databaseName, String parameterKey, String parameterValue) {
        TablesWithParameterCacheKey key = new TablesWithParameterCacheKey(databaseName, parameterKey, parameterValue);
        return CachingHiveMetastore.get(this.tablesWithParameterCache, key);
    }

    private List<String> loadTablesMatchingParameter(TablesWithParameterCacheKey key) {
        return this.delegate.getTablesWithParameter(key.getDatabaseName(), key.getParameterKey(), key.getParameterValue());
    }

    @Override
    public List<String> getAllViews(String databaseName) {
        return CachingHiveMetastore.get(this.viewNamesCache, databaseName);
    }

    private List<String> loadAllViews(String databaseName) {
        return this.delegate.getAllViews(databaseName);
    }

    @Override
    public void createDatabase(HiveIdentity identity, Database database) {
        identity = this.updateIdentity(identity);
        try {
            this.delegate.createDatabase(identity, database);
        }
        finally {
            this.invalidateDatabase(database.getDatabaseName());
        }
    }

    @Override
    public void dropDatabase(HiveIdentity identity, String databaseName) {
        identity = this.updateIdentity(identity);
        try {
            this.delegate.dropDatabase(identity, databaseName);
        }
        finally {
            this.invalidateDatabase(databaseName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void renameDatabase(HiveIdentity identity, String databaseName, String newDatabaseName) {
        identity = this.updateIdentity(identity);
        try {
            this.delegate.renameDatabase(identity, databaseName, newDatabaseName);
        }
        finally {
            this.invalidateDatabase(databaseName);
            this.invalidateDatabase(newDatabaseName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDatabaseOwner(HiveIdentity identity, String databaseName, HivePrincipal principal) {
        identity = this.updateIdentity(identity);
        try {
            this.delegate.setDatabaseOwner(identity, databaseName, principal);
        }
        finally {
            this.invalidateDatabase(databaseName);
        }
    }

    protected void invalidateDatabase(String databaseName) {
        this.databaseCache.invalidate((Object)databaseName);
        this.databaseNamesCache.invalidateAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createTable(HiveIdentity identity, Table table, PrincipalPrivileges principalPrivileges) {
        identity = this.updateIdentity(identity);
        try {
            this.delegate.createTable(identity, table, principalPrivileges);
        }
        finally {
            this.invalidateTable(table.getDatabaseName(), table.getTableName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dropTable(HiveIdentity identity, String databaseName, String tableName, boolean deleteData) {
        identity = this.updateIdentity(identity);
        try {
            this.delegate.dropTable(identity, databaseName, tableName, deleteData);
        }
        finally {
            this.invalidateTable(databaseName, tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replaceTable(HiveIdentity identity, String databaseName, String tableName, Table newTable, PrincipalPrivileges principalPrivileges) {
        identity = this.updateIdentity(identity);
        try {
            this.delegate.replaceTable(identity, databaseName, tableName, newTable, principalPrivileges);
        }
        finally {
            this.invalidateTable(databaseName, tableName);
            this.invalidateTable(newTable.getDatabaseName(), newTable.getTableName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void renameTable(HiveIdentity identity, String databaseName, String tableName, String newDatabaseName, String newTableName) {
        identity = this.updateIdentity(identity);
        try {
            this.delegate.renameTable(identity, databaseName, tableName, newDatabaseName, newTableName);
        }
        finally {
            this.invalidateTable(databaseName, tableName);
            this.invalidateTable(newDatabaseName, newTableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commentTable(HiveIdentity identity, String databaseName, String tableName, Optional<String> comment) {
        identity = this.updateIdentity(identity);
        try {
            this.delegate.commentTable(identity, databaseName, tableName, comment);
        }
        finally {
            this.invalidateTable(databaseName, tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addColumn(HiveIdentity identity, String databaseName, String tableName, String columnName, HiveType columnType, String columnComment) {
        identity = this.updateIdentity(identity);
        try {
            this.delegate.addColumn(identity, databaseName, tableName, columnName, columnType, columnComment);
        }
        finally {
            this.invalidateTable(databaseName, tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void renameColumn(HiveIdentity identity, String databaseName, String tableName, String oldColumnName, String newColumnName) {
        identity = this.updateIdentity(identity);
        try {
            this.delegate.renameColumn(identity, databaseName, tableName, oldColumnName, newColumnName);
        }
        finally {
            this.invalidateTable(databaseName, tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dropColumn(HiveIdentity identity, String databaseName, String tableName, String columnName) {
        identity = this.updateIdentity(identity);
        try {
            this.delegate.dropColumn(identity, databaseName, tableName, columnName);
        }
        finally {
            this.invalidateTable(databaseName, tableName);
        }
    }

    protected void invalidateTable(String databaseName, String tableName) {
        this.invalidateTableCache(databaseName, tableName);
        this.tableNamesCache.invalidate((Object)databaseName);
        this.viewNamesCache.invalidate((Object)databaseName);
        this.tablePrivilegesCache.asMap().keySet().stream().filter(userTableKey -> userTableKey.matches(databaseName, tableName)).forEach(arg_0 -> this.tablePrivilegesCache.invalidate(arg_0));
        this.invalidateTableStatisticsCache(databaseName, tableName);
        this.invalidatePartitionCache(databaseName, tableName);
    }

    private void invalidateTableCache(String databaseName, String tableName) {
        this.tableCache.asMap().keySet().stream().filter(table -> ((HiveTableName)table.getKey()).getDatabaseName().equals(databaseName) && ((HiveTableName)table.getKey()).getTableName().equals(tableName)).forEach(arg_0 -> this.tableCache.invalidate(arg_0));
    }

    private void invalidateTableStatisticsCache(String databaseName, String tableName) {
        this.tableStatisticsCache.asMap().keySet().stream().filter(table -> ((HiveTableName)table.getKey()).getDatabaseName().equals(databaseName) && ((HiveTableName)table.getKey()).getTableName().equals(tableName)).forEach(arg_0 -> this.tableCache.invalidate(arg_0));
    }

    private Partition getExistingPartition(HiveIdentity identity, Table table, List<String> partitionValues) {
        return this.getPartition(identity, table, partitionValues).orElseThrow(() -> new PartitionNotFoundException(table.getSchemaTableName(), partitionValues));
    }

    private List<Partition> getExistingPartitionsByNames(HiveIdentity identity, Table table, List<String> partitionNames) {
        Map partitions = (Map)this.getPartitionsByNames(identity, table, partitionNames).entrySet().stream().map(entry -> Maps.immutableEntry(entry.getKey(), ((Optional)entry.getValue()).orElseThrow(() -> new PartitionNotFoundException(table.getSchemaTableName(), HivePartitionManager.extractPartitionValues((String)entry.getKey()))))).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
        return (List)partitionNames.stream().map(partitions::get).collect(ImmutableList.toImmutableList());
    }

    @Override
    public Optional<Partition> getPartition(HiveIdentity identity, Table table, List<String> partitionValues) {
        return CachingHiveMetastore.get(this.partitionCache, new WithIdentity<HivePartitionName>(this.updateIdentity(identity), HivePartitionName.hivePartitionName(HiveTableName.hiveTableName(table.getDatabaseName(), table.getTableName()), partitionValues)));
    }

    @Override
    public Optional<List<String>> getPartitionNames(HiveIdentity identity, String databaseName, String tableName) {
        return CachingHiveMetastore.get(this.partitionNamesCache, new WithIdentity<HiveTableName>(this.updateIdentity(identity), HiveTableName.hiveTableName(databaseName, tableName)));
    }

    private Optional<List<String>> loadPartitionNames(WithIdentity<HiveTableName> hiveTableName) {
        return this.delegate.getPartitionNames(hiveTableName.getIdentity(), hiveTableName.getKey().getDatabaseName(), hiveTableName.getKey().getTableName());
    }

    @Override
    public Optional<List<String>> getPartitionNamesByParts(HiveIdentity identity, String databaseName, String tableName, List<String> parts) {
        return CachingHiveMetastore.get(this.partitionFilterCache, new WithIdentity<PartitionFilter>(this.updateIdentity(identity), PartitionFilter.partitionFilter(databaseName, tableName, parts)));
    }

    private Optional<List<String>> loadPartitionNamesByParts(WithIdentity<PartitionFilter> partitionFilter) {
        return this.delegate.getPartitionNamesByParts(partitionFilter.getIdentity(), partitionFilter.getKey().getHiveTableName().getDatabaseName(), partitionFilter.getKey().getHiveTableName().getTableName(), partitionFilter.getKey().getParts());
    }

    @Override
    public Map<String, Optional<Partition>> getPartitionsByNames(HiveIdentity identity, Table table, List<String> partitionNames) {
        List names = (List)partitionNames.stream().map(name -> new WithIdentity<HivePartitionName>(this.updateIdentity(identity), HivePartitionName.hivePartitionName(HiveTableName.hiveTableName(table.getDatabaseName(), table.getTableName()), name))).collect(ImmutableList.toImmutableList());
        Map<WithIdentity<HivePartitionName>, Optional<Partition>> all = CachingHiveMetastore.getAll(this.partitionCache, names);
        ImmutableMap.Builder partitionsByName = ImmutableMap.builder();
        for (Map.Entry<WithIdentity<HivePartitionName>, Optional<Partition>> entry : all.entrySet()) {
            partitionsByName.put((Object)entry.getKey().getKey().getPartitionName().get(), entry.getValue());
        }
        return partitionsByName.build();
    }

    private Optional<Partition> loadPartitionByName(WithIdentity<HivePartitionName> partitionName) {
        HiveTableName hiveTableName = partitionName.getKey().getHiveTableName();
        return this.getTable(partitionName.getIdentity(), hiveTableName.getDatabaseName(), hiveTableName.getTableName()).flatMap(table -> this.delegate.getPartition(partitionName.getIdentity(), (Table)table, ((HivePartitionName)partitionName.getKey()).getPartitionValues()));
    }

    private Map<WithIdentity<HivePartitionName>, Optional<Partition>> loadPartitionsByNames(Iterable<? extends WithIdentity<HivePartitionName>> partitionNames) {
        Objects.requireNonNull(partitionNames, "partitionNames is null");
        Preconditions.checkArgument((!Iterables.isEmpty(partitionNames) ? 1 : 0) != 0, (Object)"partitionNames is empty");
        WithIdentity firstPartition = (WithIdentity)Iterables.get(partitionNames, (int)0);
        HiveTableName hiveTableName = ((HivePartitionName)firstPartition.getKey()).getHiveTableName();
        HiveIdentity identity = this.updateIdentity(firstPartition.getIdentity());
        Optional<Table> table = this.getTable(identity, hiveTableName.getDatabaseName(), hiveTableName.getTableName());
        if (!table.isPresent()) {
            return (Map)Streams.stream(partitionNames).collect(ImmutableMap.toImmutableMap(name -> name, name -> Optional.empty()));
        }
        ArrayList<String> partitionsToFetch = new ArrayList<String>();
        for (WithIdentity<HivePartitionName> withIdentity : partitionNames) {
            Preconditions.checkArgument((boolean)withIdentity.getKey().getHiveTableName().equals(hiveTableName), (String)"Expected table name %s but got %s", (Object)hiveTableName, (Object)withIdentity.getKey().getHiveTableName());
            Preconditions.checkArgument((boolean)identity.equals(withIdentity.getIdentity()), (String)"Expected identity %s but got %s", (Object)identity, (Object)withIdentity.getIdentity());
            partitionsToFetch.add(withIdentity.getKey().getPartitionName().get());
        }
        ImmutableMap.Builder partitions = ImmutableMap.builder();
        Map<String, Optional<Partition>> map = this.delegate.getPartitionsByNames(identity, table.get(), partitionsToFetch);
        for (WithIdentity<HivePartitionName> withIdentity : partitionNames) {
            partitions.put(withIdentity, map.getOrDefault(withIdentity.getKey().getPartitionName().get(), Optional.empty()));
        }
        return partitions.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPartitions(HiveIdentity identity, String databaseName, String tableName, List<PartitionWithStatistics> partitions) {
        identity = this.updateIdentity(identity);
        try {
            this.delegate.addPartitions(identity, databaseName, tableName, partitions);
        }
        finally {
            this.invalidatePartitionCache(databaseName, tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dropPartition(HiveIdentity identity, String databaseName, String tableName, List<String> parts, boolean deleteData) {
        identity = this.updateIdentity(identity);
        try {
            this.delegate.dropPartition(identity, databaseName, tableName, parts, deleteData);
        }
        finally {
            this.invalidatePartitionCache(databaseName, tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void alterPartition(HiveIdentity identity, String databaseName, String tableName, PartitionWithStatistics partition) {
        identity = this.updateIdentity(identity);
        try {
            this.delegate.alterPartition(identity, databaseName, tableName, partition);
        }
        finally {
            this.invalidatePartitionCache(databaseName, tableName);
        }
    }

    @Override
    public void createRole(String role, String grantor) {
        try {
            this.delegate.createRole(role, grantor);
        }
        finally {
            this.rolesCache.invalidateAll();
        }
    }

    @Override
    public void dropRole(String role) {
        try {
            this.delegate.dropRole(role);
        }
        finally {
            this.rolesCache.invalidateAll();
            this.roleGrantsCache.invalidateAll();
        }
    }

    @Override
    public Set<String> listRoles() {
        return CachingHiveMetastore.get(this.rolesCache, "");
    }

    private Set<String> loadRoles() {
        return this.delegate.listRoles();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void grantRoles(Set<String> roles, Set<HivePrincipal> grantees, boolean adminOption, HivePrincipal grantor) {
        try {
            this.delegate.grantRoles(roles, grantees, adminOption, grantor);
        }
        finally {
            this.roleGrantsCache.invalidateAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void revokeRoles(Set<String> roles, Set<HivePrincipal> grantees, boolean adminOption, HivePrincipal grantor) {
        try {
            this.delegate.revokeRoles(roles, grantees, adminOption, grantor);
        }
        finally {
            this.roleGrantsCache.invalidateAll();
        }
    }

    @Override
    public Set<RoleGrant> listRoleGrants(HivePrincipal principal) {
        return CachingHiveMetastore.get(this.roleGrantsCache, principal);
    }

    private Set<RoleGrant> loadRoleGrants(HivePrincipal principal) {
        return this.delegate.listRoleGrants(principal);
    }

    private void invalidatePartitionCache(String databaseName, String tableName) {
        HiveTableName hiveTableName = HiveTableName.hiveTableName(databaseName, tableName);
        this.partitionNamesCache.asMap().keySet().stream().filter(partitionName -> ((HiveTableName)partitionName.getKey()).equals(hiveTableName)).forEach(arg_0 -> this.partitionNamesCache.invalidate(arg_0));
        this.partitionCache.asMap().keySet().stream().filter(partitionName -> ((HivePartitionName)partitionName.getKey()).getHiveTableName().equals(hiveTableName)).forEach(arg_0 -> this.partitionCache.invalidate(arg_0));
        this.partitionFilterCache.asMap().keySet().stream().filter(partitionFilter -> ((PartitionFilter)partitionFilter.getKey()).getHiveTableName().equals(hiveTableName)).forEach(arg_0 -> this.partitionFilterCache.invalidate(arg_0));
        this.partitionStatisticsCache.asMap().keySet().stream().filter(partitionFilter -> ((HivePartitionName)partitionFilter.getKey()).getHiveTableName().equals(hiveTableName)).forEach(arg_0 -> this.partitionStatisticsCache.invalidate(arg_0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void grantTablePrivileges(String databaseName, String tableName, String tableOwner, HivePrincipal grantee, Set<HivePrivilegeInfo> privileges) {
        try {
            this.delegate.grantTablePrivileges(databaseName, tableName, tableOwner, grantee, privileges);
        }
        finally {
            this.tablePrivilegesCache.invalidate((Object)new UserTableKey(Optional.of(grantee), databaseName, tableName, tableOwner));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void revokeTablePrivileges(String databaseName, String tableName, String tableOwner, HivePrincipal grantee, Set<HivePrivilegeInfo> privileges) {
        try {
            this.delegate.revokeTablePrivileges(databaseName, tableName, tableOwner, grantee, privileges);
        }
        finally {
            this.tablePrivilegesCache.invalidate((Object)new UserTableKey(Optional.of(grantee), databaseName, tableName, tableOwner));
        }
    }

    @Override
    public Set<HivePrivilegeInfo> listTablePrivileges(String databaseName, String tableName, String tableOwner, Optional<HivePrincipal> principal) {
        return CachingHiveMetastore.get(this.tablePrivilegesCache, new UserTableKey(principal, databaseName, tableName, tableOwner));
    }

    @Override
    public Optional<String> getConfigValue(String name) {
        return CachingHiveMetastore.get(this.configValuesCache, name);
    }

    private Optional<String> loadConfigValue(String name) {
        return this.delegate.getConfigValue(name);
    }

    @Override
    public long openTransaction(HiveIdentity identity) {
        return this.delegate.openTransaction(identity);
    }

    @Override
    public void commitTransaction(HiveIdentity identity, long transactionId) {
        this.delegate.commitTransaction(identity, transactionId);
    }

    @Override
    public void sendTransactionHeartbeat(HiveIdentity identity, long transactionId) {
        this.delegate.sendTransactionHeartbeat(identity, transactionId);
    }

    @Override
    public void acquireSharedReadLock(HiveIdentity identity, String queryId, long transactionId, List<SchemaTableName> fullTables, List<HivePartition> partitions) {
        this.delegate.acquireSharedReadLock(identity, queryId, transactionId, fullTables, partitions);
    }

    @Override
    public String getValidWriteIds(HiveIdentity identity, List<SchemaTableName> tables, long currentTransactionId) {
        return this.delegate.getValidWriteIds(identity, tables, currentTransactionId);
    }

    @Override
    public boolean isImpersonationEnabled() {
        return this.delegate.isImpersonationEnabled();
    }

    private Set<HivePrivilegeInfo> loadTablePrivileges(String databaseName, String tableName, String tableOwner, Optional<HivePrincipal> principal) {
        return this.delegate.listTablePrivileges(databaseName, tableName, tableOwner, principal);
    }

    private static CacheBuilder<Object, Object> newCacheBuilder(OptionalLong expiresAfterWriteMillis, OptionalLong refreshMillis, long maximumSize) {
        CacheBuilder cacheBuilder = CacheBuilder.newBuilder();
        if (expiresAfterWriteMillis.isPresent()) {
            cacheBuilder = cacheBuilder.expireAfterWrite(expiresAfterWriteMillis.getAsLong(), TimeUnit.MILLISECONDS);
        }
        if (refreshMillis.isPresent() && (!expiresAfterWriteMillis.isPresent() || expiresAfterWriteMillis.getAsLong() > refreshMillis.getAsLong())) {
            cacheBuilder = cacheBuilder.refreshAfterWrite(refreshMillis.getAsLong(), TimeUnit.MILLISECONDS);
        }
        cacheBuilder = cacheBuilder.maximumSize(maximumSize);
        return cacheBuilder;
    }

    private HiveIdentity updateIdentity(HiveIdentity identity) {
        return this.delegate.isImpersonationEnabled() ? identity : HiveIdentity.none();
    }

    private static class WithIdentity<T> {
        private final HiveIdentity identity;
        private final T key;
        private final int hashCode;

        public WithIdentity(HiveIdentity identity, T key) {
            this.identity = Objects.requireNonNull(identity, "identity is null");
            this.key = Objects.requireNonNull(key, "key is null");
            this.hashCode = Objects.hash(identity, key);
        }

        public HiveIdentity getIdentity() {
            return this.identity;
        }

        public T getKey() {
            return this.key;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            WithIdentity other = (WithIdentity)o;
            return this.hashCode == other.hashCode && Objects.equals(this.identity, other.identity) && Objects.equals(this.key, other.key);
        }

        public int hashCode() {
            return this.hashCode;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("identity", (Object)this.identity).add("key", this.key).toString();
        }
    }
}

