/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.metastore.thrift;

import com.google.common.net.HostAndPort;
import io.airlift.security.pem.PemReader;
import io.airlift.units.Duration;
import io.prestosql.plugin.hive.authentication.HiveMetastoreAuthentication;
import io.prestosql.plugin.hive.metastore.thrift.ThriftHiveMetastoreClient;
import io.prestosql.plugin.hive.metastore.thrift.ThriftMetastoreClient;
import io.prestosql.plugin.hive.metastore.thrift.ThriftMetastoreConfig;
import io.prestosql.plugin.hive.metastore.thrift.Transport;
import io.prestosql.spi.NodeManager;
import java.io.File;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import javax.security.auth.x500.X500Principal;
import org.apache.thrift.transport.TTransportException;

public class ThriftMetastoreClientFactory {
    private final Optional<SSLContext> sslContext;
    private final Optional<HostAndPort> socksProxy;
    private final int timeoutMillis;
    private final HiveMetastoreAuthentication metastoreAuthentication;
    private final String hostname;

    public ThriftMetastoreClientFactory(Optional<SSLContext> sslContext, Optional<HostAndPort> socksProxy, Duration timeout, HiveMetastoreAuthentication metastoreAuthentication, String hostname) {
        this.sslContext = Objects.requireNonNull(sslContext, "sslContext is null");
        this.socksProxy = Objects.requireNonNull(socksProxy, "socksProxy is null");
        this.timeoutMillis = Math.toIntExact(timeout.toMillis());
        this.metastoreAuthentication = Objects.requireNonNull(metastoreAuthentication, "metastoreAuthentication is null");
        this.hostname = Objects.requireNonNull(hostname, "hostname is null");
    }

    @Inject
    public ThriftMetastoreClientFactory(ThriftMetastoreConfig config, HiveMetastoreAuthentication metastoreAuthentication, NodeManager nodeManager) {
        this(ThriftMetastoreClientFactory.buildSslContext(config.isTlsEnabled(), Optional.ofNullable(config.getKeystorePath()), Optional.ofNullable(config.getKeystorePassword()), config.getTruststorePath()), Optional.ofNullable(config.getSocksProxy()), config.getMetastoreTimeout(), metastoreAuthentication, nodeManager.getCurrentNode().getHost());
    }

    public ThriftMetastoreClient create(HostAndPort address, Optional<String> delegationToken) throws TTransportException {
        return new ThriftHiveMetastoreClient(Transport.create(address, this.sslContext, this.socksProxy, this.timeoutMillis, this.metastoreAuthentication, delegationToken), this.hostname);
    }

    private static Optional<SSLContext> buildSslContext(boolean tlsEnabled, Optional<File> keyStorePath, Optional<String> keyStorePassword, File trustStorePath) {
        if (!tlsEnabled) {
            return Optional.empty();
        }
        try {
            KeyManager[] keyManagers = null;
            if (keyStorePath.isPresent()) {
                KeyStore keyStore = PemReader.loadKeyStore((File)keyStorePath.get(), (File)keyStorePath.get(), keyStorePassword);
                ThriftMetastoreClientFactory.validateCertificates(keyStore);
                KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                keyManagerFactory.init(keyStore, new char[0]);
                keyManagers = keyManagerFactory.getKeyManagers();
            }
            KeyStore trustStore = ThriftMetastoreClientFactory.loadTrustStore(trustStorePath);
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(trustStore);
            Object[] trustManagers = trustManagerFactory.getTrustManagers();
            if (trustManagers.length != 1 || !(trustManagers[0] instanceof X509TrustManager)) {
                throw new RuntimeException("Unexpected default trust managers:" + Arrays.toString(trustManagers));
            }
            SSLContext sslContext = SSLContext.getInstance("SSL");
            sslContext.init(keyManagers, (TrustManager[])trustManagers, null);
            return Optional.of(sslContext);
        }
        catch (IOException | GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
    }

    private static KeyStore loadTrustStore(File trustStorePath) throws IOException, GeneralSecurityException {
        List certificateChain = PemReader.readCertificateChain((File)trustStorePath);
        KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
        trustStore.load(null, null);
        for (X509Certificate certificate : certificateChain) {
            X500Principal principal = certificate.getSubjectX500Principal();
            trustStore.setCertificateEntry(principal.getName(), certificate);
        }
        return trustStore;
    }

    private static void validateCertificates(KeyStore keyStore) throws GeneralSecurityException {
        for (String alias : Collections.list(keyStore.aliases())) {
            Certificate certificate;
            if (!keyStore.isKeyEntry(alias) || !((certificate = keyStore.getCertificate(alias)) instanceof X509Certificate)) continue;
            try {
                ((X509Certificate)certificate).checkValidity();
            }
            catch (CertificateExpiredException e) {
                throw new CertificateExpiredException("KeyStore certificate is expired: " + e.getMessage());
            }
            catch (CertificateNotYetValidException e) {
                throw new CertificateNotYetValidException("KeyStore certificate is not yet valid: " + e.getMessage());
            }
        }
    }
}

