/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.procedure;

import com.google.common.collect.ImmutableList;
import io.prestosql.plugin.hive.metastore.Column;
import io.prestosql.plugin.hive.metastore.Table;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import java.util.List;
import java.util.Objects;
import org.apache.hadoop.hive.metastore.TableType;

final class Procedures {
    private Procedures() {
    }

    public static void checkIsPartitionedTable(Table table) {
        if (table.getTableType().equals(TableType.VIRTUAL_VIEW.name())) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_PROCEDURE_ARGUMENT, "Table is a view: " + table.getSchemaTableName());
        }
        if (table.getTableType().equals(TableType.MATERIALIZED_VIEW.name())) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_PROCEDURE_ARGUMENT, "Table is a materialized view: " + table.getSchemaTableName());
        }
        if (table.getPartitionColumns().isEmpty()) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_PROCEDURE_ARGUMENT, "Table is not partitioned: " + table.getSchemaTableName());
        }
    }

    public static void checkPartitionColumns(Table table, List<String> expectedPartitions) {
        List actualPartitionColumnNames = (List)table.getPartitionColumns().stream().map(Column::getName).collect(ImmutableList.toImmutableList());
        if (!Objects.equals(expectedPartitions, actualPartitionColumnNames)) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_PROCEDURE_ARGUMENT, "Provided partition column names do not match actual partition column names: " + actualPartitionColumnNames);
        }
    }
}

