/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.procedure;

import com.google.common.collect.ImmutableList;
import io.prestosql.plugin.hive.HiveMetadata;
import io.prestosql.plugin.hive.HiveMetastoreClosure;
import io.prestosql.plugin.hive.TransactionalMetadataFactory;
import io.prestosql.plugin.hive.authentication.HiveIdentity;
import io.prestosql.plugin.hive.metastore.HiveMetastore;
import io.prestosql.plugin.hive.metastore.Partition;
import io.prestosql.plugin.hive.metastore.SemiTransactionalHiveMetastore;
import io.prestosql.plugin.hive.metastore.Table;
import io.prestosql.plugin.hive.procedure.Procedures;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.block.MethodHandleUtil;
import io.prestosql.spi.classloader.ThreadContextClassLoader;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.connector.SchemaTableName;
import io.prestosql.spi.connector.TableNotFoundException;
import io.prestosql.spi.procedure.Procedure;
import io.prestosql.spi.type.ArrayType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarcharType;
import java.lang.invoke.MethodHandle;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Provider;
import org.apache.hadoop.hive.common.FileUtils;

public class UnregisterPartitionProcedure
implements Provider<Procedure> {
    private static final MethodHandle UNREGISTER_PARTITION = MethodHandleUtil.methodHandle(UnregisterPartitionProcedure.class, (String)"unregisterPartition", (Class[])new Class[]{ConnectorSession.class, String.class, String.class, List.class, List.class});
    private final TransactionalMetadataFactory hiveMetadataFactory;
    private final HiveMetastoreClosure metastore;

    @Inject
    public UnregisterPartitionProcedure(TransactionalMetadataFactory hiveMetadataFactory, HiveMetastore metastore) {
        this.hiveMetadataFactory = Objects.requireNonNull(hiveMetadataFactory, "hiveMetadataFactory is null");
        this.metastore = new HiveMetastoreClosure(Objects.requireNonNull(metastore, "metastore is null"));
    }

    public Procedure get() {
        return new Procedure("system", "unregister_partition", (List)ImmutableList.of((Object)new Procedure.Argument("schema_name", (Type)VarcharType.VARCHAR), (Object)new Procedure.Argument("table_name", (Type)VarcharType.VARCHAR), (Object)new Procedure.Argument("partition_columns", (Type)new ArrayType((Type)VarcharType.VARCHAR)), (Object)new Procedure.Argument("partition_values", (Type)new ArrayType((Type)VarcharType.VARCHAR))), UNREGISTER_PARTITION.bindTo(this));
    }

    public void unregisterPartition(ConnectorSession session, String schemaName, String tableName, List<String> partitionColumn, List<String> partitionValues) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.getClass().getClassLoader());){
            this.doUnregisterPartition(session, schemaName, tableName, partitionColumn, partitionValues);
        }
    }

    private void doUnregisterPartition(ConnectorSession session, String schemaName, String tableName, List<String> partitionColumn, List<String> partitionValues) {
        HiveIdentity identity = new HiveIdentity(session);
        SchemaTableName schemaTableName = new SchemaTableName(schemaName, tableName);
        Table table = this.metastore.getTable(identity, schemaName, tableName).orElseThrow(() -> new TableNotFoundException(schemaTableName));
        Procedures.checkIsPartitionedTable(table);
        Procedures.checkPartitionColumns(table, partitionColumn);
        String partitionName = FileUtils.makePartName(partitionColumn, partitionValues);
        Partition partition = this.metastore.getPartition(new HiveIdentity(session), schemaName, tableName, partitionValues).orElseThrow(() -> new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_FOUND, String.format("Partition '%s' does not exist", partitionName)));
        SemiTransactionalHiveMetastore metastore = ((HiveMetadata)this.hiveMetadataFactory.create()).getMetastore();
        metastore.dropPartition(session, table.getDatabaseName(), table.getTableName(), partition.getValues(), false);
        metastore.commit();
    }
}

