/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.s3;

import io.airlift.units.Duration;
import io.prestosql.plugin.hive.aws.AbstractSdkMetricsCollector;
import io.prestosql.plugin.hive.s3.PrestoS3FileSystemStats;
import java.util.Objects;

public class PrestoS3FileSystemMetricCollector
extends AbstractSdkMetricsCollector {
    private final PrestoS3FileSystemStats stats;

    public PrestoS3FileSystemMetricCollector(PrestoS3FileSystemStats stats) {
        this.stats = Objects.requireNonNull(stats, "stats is null");
    }

    @Override
    protected void recordRequestCount(long count) {
        this.stats.updateAwsRequestCount(count);
    }

    @Override
    protected void recordRetryCount(long count) {
        this.stats.updateAwsRetryCount(count);
    }

    @Override
    protected void recordThrottleExceptionCount(long count) {
        this.stats.updateAwsThrottleExceptionsCount(count);
    }

    @Override
    protected void recordHttpRequestTime(Duration duration) {
        this.stats.addAwsRequestTime(duration);
    }

    @Override
    protected void recordClientExecutionTime(Duration duration) {
        this.stats.addAwsClientExecuteTime(duration);
    }

    @Override
    protected void recordRetryPauseTime(Duration duration) {
        this.stats.addAwsClientRetryPauseTime(duration);
    }
}

