/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.s3;

import com.google.common.base.Suppliers;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableSet;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import io.airlift.log.Logger;
import io.prestosql.plugin.base.util.JsonUtils;
import io.prestosql.plugin.hive.DynamicConfigurationProvider;
import io.prestosql.plugin.hive.HdfsEnvironment;
import io.prestosql.plugin.hive.s3.S3SecurityMapping;
import io.prestosql.plugin.hive.s3.S3SecurityMappingConfig;
import io.prestosql.plugin.hive.s3.S3SecurityMappings;
import io.prestosql.spi.security.AccessDeniedException;
import java.io.File;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.inject.Inject;
import org.apache.hadoop.conf.Configuration;

public class S3SecurityMappingConfigurationProvider
implements DynamicConfigurationProvider {
    private static final Logger log = Logger.get(S3SecurityMappingConfigurationProvider.class);
    private static final Set<String> SCHEMES = ImmutableSet.of((Object)"s3", (Object)"s3a", (Object)"s3n");
    private final Supplier<S3SecurityMappings> mappings;
    private final Optional<String> roleCredentialName;
    private final Optional<String> colonReplacement;

    @Inject
    public S3SecurityMappingConfigurationProvider(S3SecurityMappingConfig config) {
        this(S3SecurityMappingConfigurationProvider.getMappings(config), config.getRoleCredentialName(), config.getColonReplacement());
    }

    private static Supplier<S3SecurityMappings> getMappings(S3SecurityMappingConfig config) {
        File configFile = config.getConfigFile().orElseThrow(() -> new IllegalArgumentException("config file not set"));
        Supplier<S3SecurityMappings> supplier = () -> (S3SecurityMappings)JsonUtils.parseJson((Path)configFile.toPath(), S3SecurityMappings.class);
        if (!config.getRefreshPeriod().isPresent()) {
            return Suppliers.memoize(supplier::get);
        }
        return Suppliers.memoizeWithExpiration(() -> {
            log.info("Refreshing S3 security mapping configuration from %s", new Object[]{configFile});
            return (S3SecurityMappings)supplier.get();
        }, (long)config.getRefreshPeriod().get().toMillis(), (TimeUnit)TimeUnit.MILLISECONDS);
    }

    public S3SecurityMappingConfigurationProvider(Supplier<S3SecurityMappings> mappings, Optional<String> roleCredentialName, Optional<String> colonReplacement) {
        this.mappings = Objects.requireNonNull(mappings, "mappings is null");
        this.roleCredentialName = Objects.requireNonNull(roleCredentialName, "roleCredentialName is null");
        this.colonReplacement = Objects.requireNonNull(colonReplacement, "colonReplacement is null");
    }

    @Override
    public void updateConfiguration(Configuration configuration, HdfsEnvironment.HdfsContext context, URI uri) {
        if (!SCHEMES.contains(uri.getScheme())) {
            return;
        }
        S3SecurityMapping mapping = this.mappings.get().getMapping(context.getIdentity(), uri).orElseThrow(() -> new AccessDeniedException("No matching S3 security mapping"));
        Hasher hasher = Hashing.sha256().newHasher();
        mapping.getCredentials().ifPresent(credentials -> {
            configuration.set("presto.s3.access-key", credentials.getAWSAccessKeyId());
            configuration.set("presto.s3.secret-key", credentials.getAWSSecretKey());
            hasher.putString((CharSequence)credentials.getAWSAccessKeyId(), StandardCharsets.UTF_8);
            hasher.putString((CharSequence)credentials.getAWSSecretKey(), StandardCharsets.UTF_8);
        });
        this.selectRole(mapping, context).ifPresent(role -> {
            configuration.set("presto.s3.iam-role", role);
            hasher.putString((CharSequence)role, StandardCharsets.UTF_8);
        });
        DynamicConfigurationProvider.setCacheKey(configuration, hasher.hash().toString());
    }

    private Optional<String> selectRole(S3SecurityMapping mapping, HdfsEnvironment.HdfsContext context) {
        Optional<String> optionalSelected = this.getRoleFromExtraCredential(context);
        if (!optionalSelected.isPresent()) {
            if (!mapping.getAllowedIamRoles().isEmpty() && !mapping.getIamRole().isPresent()) {
                throw new AccessDeniedException("No S3 role selected and mapping has no default role");
            }
            Verify.verify((mapping.getIamRole().isPresent() || mapping.getCredentials().isPresent() ? 1 : 0) != 0, (String)"mapping must have role or credential", (Object[])new Object[0]);
            return mapping.getIamRole();
        }
        String selected = optionalSelected.get();
        if (!selected.equals(mapping.getIamRole().orElse(null)) && !mapping.getAllowedIamRoles().contains(selected)) {
            throw new AccessDeniedException("Selected S3 role is not allowed: " + selected);
        }
        return optionalSelected;
    }

    private Optional<String> getRoleFromExtraCredential(HdfsEnvironment.HdfsContext context) {
        Optional<String> extraCredentialRole = this.roleCredentialName.map(name -> (String)context.getIdentity().getExtraCredentials().get(name));
        if (this.colonReplacement.isPresent()) {
            return extraCredentialRole.map(role -> role.replace(this.colonReplacement.get(), ":"));
        }
        return extraCredentialRole;
    }
}

