/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.util;

import io.prestosql.plugin.hive.RecordFileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.io.BinaryComparable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.util.Progressable;

public class TextRecordWriter
implements RecordFileWriter.ExtendedRecordWriter {
    private final FSDataOutputStream output;
    private final OutputStream compressedOutput;
    private final int rowSeparator;

    public TextRecordWriter(Path path, JobConf jobConf, Properties properties, boolean isCompressed) throws IOException {
        char rowSeparatorByte;
        String rowSeparatorString = properties.getProperty("line.delim", "\n");
        try {
            rowSeparatorByte = Byte.parseByte(rowSeparatorString);
        }
        catch (NumberFormatException e) {
            rowSeparatorByte = rowSeparatorString.charAt(0);
        }
        this.rowSeparator = rowSeparatorByte;
        this.output = path.getFileSystem((Configuration)jobConf).create(path, (Progressable)Reporter.NULL);
        this.compressedOutput = Utilities.createCompressedStream((JobConf)jobConf, (OutputStream)this.output, (boolean)isCompressed);
    }

    @Override
    public long getWrittenBytes() {
        return this.output.getPos();
    }

    public void write(Writable writable) throws IOException {
        BinaryComparable binary = (BinaryComparable)writable;
        this.compressedOutput.write(binary.getBytes(), 0, binary.getLength());
        this.compressedOutput.write(this.rowSeparator);
    }

    public void close(boolean abort) throws IOException {
        this.compressedOutput.close();
    }
}

