/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.hadoop.fs.Path;

public class AcidInfo {
    private final String partitionLocation;
    private final List<DeleteDeltaInfo> deleteDeltas;

    @JsonCreator
    public AcidInfo(@JsonProperty(value="partitionLocation") String partitionLocation, @JsonProperty(value="deleteDeltas") List<DeleteDeltaInfo> deleteDeltas) {
        this.partitionLocation = Objects.requireNonNull(partitionLocation, "partitionLocation is null");
        this.deleteDeltas = ImmutableList.copyOf((Collection)Objects.requireNonNull(deleteDeltas, "deleteDeltas is null"));
        Preconditions.checkArgument((!deleteDeltas.isEmpty() ? 1 : 0) != 0, (Object)"deleteDeltas is empty");
    }

    @JsonProperty
    public String getPartitionLocation() {
        return this.partitionLocation;
    }

    @JsonProperty
    public List<DeleteDeltaInfo> getDeleteDeltas() {
        return this.deleteDeltas;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AcidInfo that = (AcidInfo)o;
        return this.partitionLocation.equals(that.partitionLocation) && this.deleteDeltas.equals(that.deleteDeltas);
    }

    public int hashCode() {
        return Objects.hash(this.partitionLocation, this.deleteDeltas);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("partitionLocation", (Object)this.partitionLocation).add("deleteDeltas", this.deleteDeltas).toString();
    }

    public static Builder builder(Path partitionPath) {
        return new Builder(partitionPath);
    }

    public static Builder builder(AcidInfo acidInfo) {
        return new Builder(acidInfo);
    }

    public static class Builder {
        private final Path partitionLocation;
        private final ImmutableList.Builder<DeleteDeltaInfo> deleteDeltaInfoBuilder = ImmutableList.builder();

        private Builder(Path partitionPath) {
            this.partitionLocation = Objects.requireNonNull(partitionPath, "partitionPath is null");
        }

        private Builder(AcidInfo acidInfo) {
            this.partitionLocation = new Path(acidInfo.getPartitionLocation());
            this.deleteDeltaInfoBuilder.addAll(acidInfo.deleteDeltas);
        }

        public Builder addDeleteDelta(Path deleteDeltaPath, long minWriteId, long maxWriteId, int statementId) {
            Objects.requireNonNull(deleteDeltaPath, "deleteDeltaPath is null");
            Path partitionPathFromDeleteDelta = deleteDeltaPath.getParent();
            Preconditions.checkArgument((boolean)this.partitionLocation.equals((Object)partitionPathFromDeleteDelta), (String)"Partition location in DeleteDelta '%s' does not match stored location '%s'", (Object)deleteDeltaPath.getParent().toString(), (Object)this.partitionLocation);
            this.deleteDeltaInfoBuilder.add((Object)new DeleteDeltaInfo(minWriteId, maxWriteId, statementId));
            return this;
        }

        public Optional<AcidInfo> build() {
            ImmutableList deleteDeltas = this.deleteDeltaInfoBuilder.build();
            if (deleteDeltas.isEmpty()) {
                return Optional.empty();
            }
            return Optional.of(new AcidInfo(this.partitionLocation.toString(), (List<DeleteDeltaInfo>)deleteDeltas));
        }
    }

    public static class DeleteDeltaInfo {
        private final long minWriteId;
        private final long maxWriteId;
        private final int statementId;

        @JsonCreator
        public DeleteDeltaInfo(@JsonProperty(value="minWriteId") long minWriteId, @JsonProperty(value="maxWriteId") long maxWriteId, @JsonProperty(value="statementId") int statementId) {
            this.minWriteId = minWriteId;
            this.maxWriteId = maxWriteId;
            this.statementId = statementId;
        }

        @JsonProperty
        public long getMinWriteId() {
            return this.minWriteId;
        }

        @JsonProperty
        public long getMaxWriteId() {
            return this.maxWriteId;
        }

        @JsonProperty
        public int getStatementId() {
            return this.statementId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DeleteDeltaInfo that = (DeleteDeltaInfo)o;
            return this.minWriteId == that.minWriteId && this.maxWriteId == that.maxWriteId && this.statementId == that.statementId;
        }

        public int hashCode() {
            return Objects.hash(this.minWriteId, this.maxWriteId, this.statementId);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("minWriteId", this.minWriteId).add("maxWriteId", this.maxWriteId).add("statementId", this.statementId).toString();
        }
    }
}

