/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.prestosql.plugin.hive.HiveBucketProperty;
import io.prestosql.plugin.hive.HiveColumnHandle;
import io.prestosql.plugin.hive.HiveStorageFormat;
import io.prestosql.plugin.hive.HiveWritableTableHandle;
import io.prestosql.plugin.hive.LocationHandle;
import io.prestosql.plugin.hive.metastore.HivePageSinkMetadata;
import io.prestosql.spi.connector.ConnectorOutputTableHandle;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class HiveOutputTableHandle
extends HiveWritableTableHandle
implements ConnectorOutputTableHandle {
    private final List<String> partitionedBy;
    private final String tableOwner;
    private final Map<String, String> additionalTableParameters;
    private final boolean external;

    @JsonCreator
    public HiveOutputTableHandle(@JsonProperty(value="schemaName") String schemaName, @JsonProperty(value="tableName") String tableName, @JsonProperty(value="inputColumns") List<HiveColumnHandle> inputColumns, @JsonProperty(value="pageSinkMetadata") HivePageSinkMetadata pageSinkMetadata, @JsonProperty(value="locationHandle") LocationHandle locationHandle, @JsonProperty(value="tableStorageFormat") HiveStorageFormat tableStorageFormat, @JsonProperty(value="partitionStorageFormat") HiveStorageFormat partitionStorageFormat, @JsonProperty(value="partitionedBy") List<String> partitionedBy, @JsonProperty(value="bucketProperty") Optional<HiveBucketProperty> bucketProperty, @JsonProperty(value="tableOwner") String tableOwner, @JsonProperty(value="additionalTableParameters") Map<String, String> additionalTableParameters, @JsonProperty(value="external") boolean external) {
        super(schemaName, tableName, inputColumns, pageSinkMetadata, locationHandle, bucketProperty, tableStorageFormat, partitionStorageFormat);
        this.partitionedBy = ImmutableList.copyOf((Collection)Objects.requireNonNull(partitionedBy, "partitionedBy is null"));
        this.tableOwner = Objects.requireNonNull(tableOwner, "tableOwner is null");
        this.additionalTableParameters = ImmutableMap.copyOf(Objects.requireNonNull(additionalTableParameters, "additionalTableParameters is null"));
        this.external = external;
    }

    @JsonProperty
    public List<String> getPartitionedBy() {
        return this.partitionedBy;
    }

    @JsonProperty
    public String getTableOwner() {
        return this.tableOwner;
    }

    @JsonProperty
    public Map<String, String> getAdditionalTableParameters() {
        return this.additionalTableParameters;
    }

    @JsonProperty
    public boolean isExternal() {
        return this.external;
    }
}

