/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.prestosql.plugin.hive.HiveErrorCode;
import io.prestosql.plugin.hive.HiveStorageFormat;
import io.prestosql.plugin.hive.HiveTypeName;
import io.prestosql.plugin.hive.TypeTranslator;
import io.prestosql.plugin.hive.metastore.StorageFormat;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.BooleanType;
import io.prestosql.spi.type.CharType;
import io.prestosql.spi.type.DateType;
import io.prestosql.spi.type.DecimalType;
import io.prestosql.spi.type.DoubleType;
import io.prestosql.spi.type.IntegerType;
import io.prestosql.spi.type.NamedTypeSignature;
import io.prestosql.spi.type.RealType;
import io.prestosql.spi.type.RowFieldName;
import io.prestosql.spi.type.SmallintType;
import io.prestosql.spi.type.TimestampType;
import io.prestosql.spi.type.TinyintType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeManager;
import io.prestosql.spi.type.TypeSignature;
import io.prestosql.spi.type.TypeSignatureParameter;
import io.prestosql.spi.type.VarbinaryType;
import io.prestosql.spi.type.VarcharType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.CharTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.ListTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.MapTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.hive.serde2.typeinfo.UnionTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.VarcharTypeInfo;

public final class HiveType {
    public static final HiveType HIVE_BOOLEAN = new HiveType((TypeInfo)TypeInfoFactory.booleanTypeInfo);
    public static final HiveType HIVE_BYTE = new HiveType((TypeInfo)TypeInfoFactory.byteTypeInfo);
    public static final HiveType HIVE_SHORT = new HiveType((TypeInfo)TypeInfoFactory.shortTypeInfo);
    public static final HiveType HIVE_INT = new HiveType((TypeInfo)TypeInfoFactory.intTypeInfo);
    public static final HiveType HIVE_LONG = new HiveType((TypeInfo)TypeInfoFactory.longTypeInfo);
    public static final HiveType HIVE_FLOAT = new HiveType((TypeInfo)TypeInfoFactory.floatTypeInfo);
    public static final HiveType HIVE_DOUBLE = new HiveType((TypeInfo)TypeInfoFactory.doubleTypeInfo);
    public static final HiveType HIVE_STRING = new HiveType((TypeInfo)TypeInfoFactory.stringTypeInfo);
    public static final HiveType HIVE_TIMESTAMP = new HiveType((TypeInfo)TypeInfoFactory.timestampTypeInfo);
    public static final HiveType HIVE_DATE = new HiveType((TypeInfo)TypeInfoFactory.dateTypeInfo);
    public static final HiveType HIVE_BINARY = new HiveType((TypeInfo)TypeInfoFactory.binaryTypeInfo);
    private final HiveTypeName hiveTypeName;
    private final TypeInfo typeInfo;

    private HiveType(TypeInfo typeInfo) {
        Objects.requireNonNull(typeInfo, "typeInfo is null");
        this.hiveTypeName = new HiveTypeName(typeInfo.getTypeName());
        this.typeInfo = typeInfo;
    }

    public HiveTypeName getHiveTypeName() {
        return this.hiveTypeName;
    }

    public ObjectInspector.Category getCategory() {
        return this.typeInfo.getCategory();
    }

    public TypeInfo getTypeInfo() {
        return this.typeInfo;
    }

    public TypeSignature getTypeSignature() {
        return HiveType.getTypeSignature(this.typeInfo);
    }

    public Type getType(TypeManager typeManager) {
        return typeManager.getType(this.getTypeSignature());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HiveType hiveType = (HiveType)o;
        return this.hiveTypeName.equals(hiveType.hiveTypeName);
    }

    public int hashCode() {
        return this.hiveTypeName.hashCode();
    }

    @JsonValue
    public String toString() {
        return this.hiveTypeName.toString();
    }

    public boolean isSupportedType(StorageFormat storageFormat) {
        return HiveType.isSupportedType(this.getTypeInfo(), storageFormat);
    }

    public static boolean isSupportedType(TypeInfo typeInfo, StorageFormat storageFormat) {
        switch (typeInfo.getCategory()) {
            case PRIMITIVE: {
                return HiveType.getPrimitiveType((PrimitiveTypeInfo)typeInfo) != null;
            }
            case MAP: {
                MapTypeInfo mapTypeInfo = (MapTypeInfo)typeInfo;
                return HiveType.isSupportedType(mapTypeInfo.getMapKeyTypeInfo(), storageFormat) && HiveType.isSupportedType(mapTypeInfo.getMapValueTypeInfo(), storageFormat);
            }
            case LIST: {
                ListTypeInfo listTypeInfo = (ListTypeInfo)typeInfo;
                return HiveType.isSupportedType(listTypeInfo.getListElementTypeInfo(), storageFormat);
            }
            case STRUCT: {
                StructTypeInfo structTypeInfo = (StructTypeInfo)typeInfo;
                return structTypeInfo.getAllStructFieldTypeInfos().stream().allMatch(fieldTypeInfo -> HiveType.isSupportedType(fieldTypeInfo, storageFormat));
            }
            case UNION: {
                if (!storageFormat.getSerDe().equalsIgnoreCase(HiveStorageFormat.AVRO.getSerDe()) && !storageFormat.getSerDe().equalsIgnoreCase(HiveStorageFormat.ORC.getSerDe())) break;
                UnionTypeInfo unionTypeInfo = (UnionTypeInfo)typeInfo;
                return unionTypeInfo.getAllUnionObjectTypeInfos().stream().allMatch(fieldTypeInfo -> HiveType.isSupportedType(fieldTypeInfo, storageFormat));
            }
        }
        return false;
    }

    @JsonCreator
    public static HiveType valueOf(String hiveTypeName) {
        Objects.requireNonNull(hiveTypeName, "hiveTypeName is null");
        return HiveType.toHiveType(TypeInfoUtils.getTypeInfoFromTypeString((String)hiveTypeName));
    }

    public static List<HiveType> toHiveTypes(String hiveTypes) {
        Objects.requireNonNull(hiveTypes, "hiveTypes is null");
        return ImmutableList.copyOf((Collection)((Collection)TypeInfoUtils.getTypeInfosFromTypeString((String)hiveTypes).stream().map(HiveType::toHiveType).collect(ImmutableList.toImmutableList())));
    }

    public static HiveType toHiveType(TypeInfo typeInfo) {
        Objects.requireNonNull(typeInfo, "typeInfo is null");
        return new HiveType(typeInfo);
    }

    public static HiveType toHiveType(TypeTranslator typeTranslator, Type type) {
        Objects.requireNonNull(typeTranslator, "typeTranslator is null");
        Objects.requireNonNull(type, "type is null");
        return new HiveType(typeTranslator.translate(type));
    }

    private static TypeSignature getTypeSignature(TypeInfo typeInfo) {
        switch (typeInfo.getCategory()) {
            case PRIMITIVE: {
                Type primitiveType = HiveType.getPrimitiveType((PrimitiveTypeInfo)typeInfo);
                if (primitiveType == null) break;
                return primitiveType.getTypeSignature();
            }
            case MAP: {
                MapTypeInfo mapTypeInfo = (MapTypeInfo)typeInfo;
                TypeSignature keyType = HiveType.getTypeSignature(mapTypeInfo.getMapKeyTypeInfo());
                TypeSignature valueType = HiveType.getTypeSignature(mapTypeInfo.getMapValueTypeInfo());
                return new TypeSignature("map", (List)ImmutableList.of((Object)TypeSignatureParameter.typeParameter((TypeSignature)keyType), (Object)TypeSignatureParameter.typeParameter((TypeSignature)valueType)));
            }
            case LIST: {
                ListTypeInfo listTypeInfo = (ListTypeInfo)typeInfo;
                TypeSignature elementType = HiveType.getTypeSignature(listTypeInfo.getListElementTypeInfo());
                return new TypeSignature("array", (List)ImmutableList.of((Object)TypeSignatureParameter.typeParameter((TypeSignature)elementType)));
            }
            case STRUCT: {
                StructTypeInfo structTypeInfo = (StructTypeInfo)typeInfo;
                ArrayList structFieldTypeInfos = structTypeInfo.getAllStructFieldTypeInfos();
                ArrayList structFieldNames = structTypeInfo.getAllStructFieldNames();
                if (structFieldTypeInfos.size() != structFieldNames.size()) {
                    throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_METADATA, String.format("Invalid Hive struct type: %s", typeInfo));
                }
                ImmutableList.Builder typeSignatureBuilder = ImmutableList.builder();
                for (int i = 0; i < structFieldTypeInfos.size(); ++i) {
                    TypeSignature typeSignature = HiveType.getTypeSignature((TypeInfo)structFieldTypeInfos.get(i));
                    String rowFieldName = ((String)structFieldNames.get(i)).toLowerCase(Locale.US);
                    typeSignatureBuilder.add((Object)TypeSignatureParameter.namedTypeParameter((NamedTypeSignature)new NamedTypeSignature(Optional.of(new RowFieldName(rowFieldName)), typeSignature)));
                }
                return new TypeSignature("row", (List)typeSignatureBuilder.build());
            }
            case UNION: {
                UnionTypeInfo unionTypeInfo = (UnionTypeInfo)typeInfo;
                List unionObjectTypeInfos = unionTypeInfo.getAllUnionObjectTypeInfos();
                ImmutableList.Builder typeSignatures = ImmutableList.builder();
                typeSignatures.add((Object)TypeSignatureParameter.namedTypeParameter((NamedTypeSignature)new NamedTypeSignature(Optional.of(new RowFieldName("tag")), TinyintType.TINYINT.getTypeSignature())));
                for (int i = 0; i < unionObjectTypeInfos.size(); ++i) {
                    TypeSignature typeSignature = HiveType.getTypeSignature((TypeInfo)unionObjectTypeInfos.get(i));
                    typeSignatures.add((Object)TypeSignatureParameter.namedTypeParameter((NamedTypeSignature)new NamedTypeSignature(Optional.of(new RowFieldName("field" + i)), typeSignature)));
                }
                return new TypeSignature("row", (List)typeSignatures.build());
            }
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Unsupported Hive type: %s", typeInfo));
    }

    public static Type getPrimitiveType(PrimitiveTypeInfo typeInfo) {
        switch (typeInfo.getPrimitiveCategory()) {
            case BOOLEAN: {
                return BooleanType.BOOLEAN;
            }
            case BYTE: {
                return TinyintType.TINYINT;
            }
            case SHORT: {
                return SmallintType.SMALLINT;
            }
            case INT: {
                return IntegerType.INTEGER;
            }
            case LONG: {
                return BigintType.BIGINT;
            }
            case FLOAT: {
                return RealType.REAL;
            }
            case DOUBLE: {
                return DoubleType.DOUBLE;
            }
            case STRING: {
                return VarcharType.createUnboundedVarcharType();
            }
            case VARCHAR: {
                return VarcharType.createVarcharType((int)((VarcharTypeInfo)typeInfo).getLength());
            }
            case CHAR: {
                return CharType.createCharType((long)((CharTypeInfo)typeInfo).getLength());
            }
            case DATE: {
                return DateType.DATE;
            }
            case TIMESTAMP: {
                return TimestampType.TIMESTAMP;
            }
            case BINARY: {
                return VarbinaryType.VARBINARY;
            }
            case DECIMAL: {
                DecimalTypeInfo decimalTypeInfo = (DecimalTypeInfo)typeInfo;
                return DecimalType.createDecimalType((int)decimalTypeInfo.precision(), (int)decimalTypeInfo.scale());
            }
        }
        return null;
    }

    public Optional<HiveType> getHiveTypeForDereferences(List<Integer> dereferences) {
        TypeInfo typeInfo = this.getTypeInfo();
        for (int fieldIndex : dereferences) {
            Preconditions.checkArgument((boolean)(typeInfo instanceof StructTypeInfo), (String)"typeInfo should be struct type", (Object)typeInfo);
            StructTypeInfo structTypeInfo = (StructTypeInfo)typeInfo;
            try {
                typeInfo = (TypeInfo)structTypeInfo.getAllStructFieldTypeInfos().get(fieldIndex);
            }
            catch (RuntimeException e) {
                return Optional.empty();
            }
        }
        return Optional.of(HiveType.toHiveType(typeInfo));
    }

    public List<String> getHiveDereferenceNames(List<Integer> dereferences) {
        ImmutableList.Builder dereferenceNames = ImmutableList.builder();
        TypeInfo typeInfo = this.getTypeInfo();
        for (int fieldIndex : dereferences) {
            Preconditions.checkArgument((boolean)(typeInfo instanceof StructTypeInfo), (String)"typeInfo should be struct type", (Object)typeInfo);
            StructTypeInfo structTypeInfo = (StructTypeInfo)typeInfo;
            Preconditions.checkArgument((fieldIndex >= 0 ? 1 : 0) != 0, (Object)"fieldIndex cannot be negative");
            Preconditions.checkArgument((fieldIndex < structTypeInfo.getAllStructFieldNames().size() ? 1 : 0) != 0, (Object)"fieldIndex should be less than the number of fields in the struct");
            String fieldName = (String)structTypeInfo.getAllStructFieldNames().get(fieldIndex);
            dereferenceNames.add((Object)fieldName);
            typeInfo = (TypeInfo)structTypeInfo.getAllStructFieldTypeInfos().get(fieldIndex);
        }
        return dereferenceNames.build();
    }
}

