/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import io.prestosql.plugin.hive.HiveColumnHandle;
import io.prestosql.plugin.hive.HiveColumnProjectionInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class ReaderProjections {
    private final List<HiveColumnHandle> readerColumns;
    private final List<Integer> readerBlockIndices;

    private ReaderProjections(List<HiveColumnHandle> readerColumns, List<Integer> readerBlockIndices) {
        this.readerColumns = ImmutableList.copyOf((Collection)Objects.requireNonNull(readerColumns, "readerColumns is null"));
        readerBlockIndices.forEach(value -> Preconditions.checkArgument((value >= 0 && value < readerColumns.size() ? 1 : 0) != 0, (Object)"block index out of bounds"));
        this.readerBlockIndices = ImmutableList.copyOf((Collection)Objects.requireNonNull(readerBlockIndices, "readerBlockIndices is null"));
    }

    public HiveColumnHandle readerColumnForHiveColumnAt(int index) {
        Preconditions.checkArgument((index >= 0 && index < this.readerBlockIndices.size() ? 1 : 0) != 0, (Object)"index is not valid");
        int readerIndex = this.readerBlockIndices.get(index);
        return this.readerColumns.get(readerIndex);
    }

    public int readerColumnPositionForHiveColumnAt(int index) {
        Preconditions.checkArgument((index >= 0 && index < this.readerBlockIndices.size() ? 1 : 0) != 0, (Object)"index is invalid");
        return this.readerBlockIndices.get(index);
    }

    public List<HiveColumnHandle> getReaderColumns() {
        return this.readerColumns;
    }

    public static Optional<ReaderProjections> projectBaseColumns(List<HiveColumnHandle> columns) {
        Objects.requireNonNull(columns, "columns is null");
        if (columns.stream().allMatch(HiveColumnHandle::isBaseColumn)) {
            return Optional.empty();
        }
        ImmutableList.Builder projectedColumns = ImmutableList.builder();
        ImmutableList.Builder outputColumnMapping = ImmutableList.builder();
        HashMap<Integer, Integer> mappedHiveColumnIndices = new HashMap<Integer, Integer>();
        int projectedColumnCount = 0;
        for (HiveColumnHandle column : columns) {
            int hiveColumnIndex = column.getBaseHiveColumnIndex();
            Integer mapped = (Integer)mappedHiveColumnIndices.get(hiveColumnIndex);
            if (mapped == null) {
                projectedColumns.add((Object)column.getBaseColumn());
                mappedHiveColumnIndices.put(hiveColumnIndex, projectedColumnCount);
                outputColumnMapping.add((Object)projectedColumnCount);
                ++projectedColumnCount;
                continue;
            }
            outputColumnMapping.add((Object)mapped);
        }
        return Optional.of(new ReaderProjections((List<HiveColumnHandle>)projectedColumns.build(), (List<Integer>)outputColumnMapping.build()));
    }

    public static Optional<ReaderProjections> projectSufficientColumns(List<HiveColumnHandle> columns) {
        Objects.requireNonNull(columns, "columns is null");
        if (columns.stream().allMatch(HiveColumnHandle::isBaseColumn)) {
            return Optional.empty();
        }
        ImmutableBiMap.Builder dereferenceChainsBuilder = ImmutableBiMap.builder();
        for (HiveColumnHandle column : columns) {
            List indices = column.getHiveColumnProjectionInfo().map(HiveColumnProjectionInfo::getDereferenceIndices).orElse((List)ImmutableList.of());
            DereferenceChain dereferenceChain = new DereferenceChain(column.getBaseColumnName(), indices);
            dereferenceChainsBuilder.put((Object)dereferenceChain, (Object)column);
        }
        ImmutableBiMap dereferenceChains = dereferenceChainsBuilder.build();
        ArrayList<HiveColumnHandle> sufficientColumns = new ArrayList<HiveColumnHandle>();
        ImmutableList.Builder outputColumnMapping = ImmutableList.builder();
        HashMap<DereferenceChain, Integer> pickedColumns = new HashMap<DereferenceChain, Integer>();
        for (HiveColumnHandle columnHandle : columns) {
            int inputBlockIndex;
            DereferenceChain column = (DereferenceChain)dereferenceChains.inverse().get((Object)columnHandle);
            List<DereferenceChain> orderedPrefixes = column.getOrderedPrefixes();
            DereferenceChain chosenColumn = null;
            for (DereferenceChain prefix : orderedPrefixes) {
                if (!dereferenceChains.containsKey((Object)prefix)) continue;
                chosenColumn = prefix;
                break;
            }
            Preconditions.checkState((chosenColumn != null ? 1 : 0) != 0, (Object)"chosenColumn is null");
            if (pickedColumns.containsKey(chosenColumn)) {
                inputBlockIndex = (Integer)pickedColumns.get(chosenColumn);
            } else {
                sufficientColumns.add((HiveColumnHandle)dereferenceChains.get((Object)chosenColumn));
                pickedColumns.put(chosenColumn, sufficientColumns.size() - 1);
                inputBlockIndex = sufficientColumns.size() - 1;
            }
            outputColumnMapping.add((Object)inputBlockIndex);
        }
        return Optional.of(new ReaderProjections(sufficientColumns, (List<Integer>)outputColumnMapping.build()));
    }

    private static class DereferenceChain {
        private final String name;
        private final List<Integer> indices;

        public DereferenceChain(String name, List<Integer> indices) {
            this.name = Objects.requireNonNull(name, "name is null");
            this.indices = ImmutableList.copyOf((Collection)Objects.requireNonNull(indices, "indices is null"));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DereferenceChain that = (DereferenceChain)o;
            return Objects.equals(this.name, that.name) && Objects.equals(this.indices, that.indices);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.indices);
        }

        public List<DereferenceChain> getOrderedPrefixes() {
            ImmutableList.Builder prefixes = ImmutableList.builder();
            for (int prefixLen = 0; prefixLen <= this.indices.size(); ++prefixLen) {
                prefixes.add((Object)new DereferenceChain(this.name, this.indices.subList(0, prefixLen)));
            }
            return prefixes.build();
        }
    }
}

