/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.prestosql.plugin.hive.HiveColumnHandle;
import io.prestosql.plugin.hive.HiveColumnProjectionInfo;
import io.prestosql.plugin.hive.ReaderProjections;
import io.prestosql.spi.Page;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.block.ColumnarRow;
import io.prestosql.spi.block.LazyBlock;
import io.prestosql.spi.block.LazyBlockLoader;
import io.prestosql.spi.type.Type;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class ReaderProjectionsAdapter {
    private final List<ChannelMapping> outputToInputMapping;
    private final List<Type> outputTypes;
    private final List<Type> inputTypes;

    public ReaderProjectionsAdapter(List<HiveColumnHandle> expectedHiveColumns, ReaderProjections readerProjections) {
        Objects.requireNonNull(expectedHiveColumns, "expectedHiveColumns is null");
        Objects.requireNonNull(readerProjections, "readerProjections is null");
        ImmutableList.Builder mappingBuilder = ImmutableList.builder();
        for (int i = 0; i < expectedHiveColumns.size(); ++i) {
            HiveColumnHandle projectedColumnHandle = readerProjections.readerColumnForHiveColumnAt(i);
            int inputChannel = readerProjections.readerColumnPositionForHiveColumnAt(i);
            ChannelMapping mapping = ChannelMapping.createChannelMapping(expectedHiveColumns.get(i), projectedColumnHandle, inputChannel);
            mappingBuilder.add((Object)mapping);
        }
        this.outputToInputMapping = mappingBuilder.build();
        this.outputTypes = (List)expectedHiveColumns.stream().map(HiveColumnHandle::getType).collect(ImmutableList.toImmutableList());
        this.inputTypes = (List)readerProjections.getReaderColumns().stream().map(HiveColumnHandle::getType).collect(ImmutableList.toImmutableList());
    }

    public Page adaptPage(Page input) {
        if (input == null) {
            return null;
        }
        Block[] blocks = new Block[this.outputToInputMapping.size()];
        for (int i = 0; i < this.outputToInputMapping.size(); ++i) {
            ChannelMapping mapping = this.outputToInputMapping.get(i);
            Block inputBlock = input.getBlock(mapping.getInputChannelIndex());
            blocks[i] = ReaderProjectionsAdapter.createAdaptedLazyBlock(inputBlock, mapping.getDereferenceSequence(), this.outputTypes.get(i));
        }
        return new Page(input.getPositionCount(), blocks);
    }

    private static Block createAdaptedLazyBlock(Block inputBlock, List<Integer> dereferenceSequence, Type type) {
        if (dereferenceSequence.size() == 0) {
            return inputBlock;
        }
        if (inputBlock == null) {
            return null;
        }
        return new LazyBlock(inputBlock.getPositionCount(), (LazyBlockLoader)new DereferenceBlockLoader(inputBlock, dereferenceSequence, type));
    }

    List<ChannelMapping> getOutputToInputMapping() {
        return this.outputToInputMapping;
    }

    List<Type> getOutputTypes() {
        return this.outputTypes;
    }

    List<Type> getInputTypes() {
        return this.inputTypes;
    }

    @VisibleForTesting
    static class ChannelMapping {
        private final int inputChannelIndex;
        private final List<Integer> dereferenceSequence;

        private ChannelMapping(int inputBlockIndex, List<Integer> dereferenceSequence) {
            Preconditions.checkArgument((inputBlockIndex >= 0 ? 1 : 0) != 0, (Object)"inputBlockIndex cannot be negative");
            this.inputChannelIndex = inputBlockIndex;
            this.dereferenceSequence = ImmutableList.copyOf((Collection)Objects.requireNonNull(dereferenceSequence, "dereferences is null"));
        }

        public int getInputChannelIndex() {
            return this.inputChannelIndex;
        }

        public List<Integer> getDereferenceSequence() {
            return this.dereferenceSequence;
        }

        static ChannelMapping createChannelMapping(HiveColumnHandle expected, HiveColumnHandle delegate, int inputBlockIndex) {
            List<Integer> dereferences = ChannelMapping.validateProjectionAndExtractDereferences(expected, delegate);
            return new ChannelMapping(inputBlockIndex, dereferences);
        }

        private static List<Integer> validateProjectionAndExtractDereferences(HiveColumnHandle expectedColumn, HiveColumnHandle readerColumn) {
            Preconditions.checkArgument((boolean)expectedColumn.getBaseColumn().equals(readerColumn.getBaseColumn()), (Object)"reader column is not valid for expected column");
            List expectedDereferences = expectedColumn.getHiveColumnProjectionInfo().map(HiveColumnProjectionInfo::getDereferenceIndices).orElse((List)ImmutableList.of());
            List readerDereferences = readerColumn.getHiveColumnProjectionInfo().map(HiveColumnProjectionInfo::getDereferenceIndices).orElse((List)ImmutableList.of());
            Preconditions.checkArgument((readerDereferences.size() <= expectedDereferences.size() ? 1 : 0) != 0, (Object)"Field returned by the reader should include expected field");
            Preconditions.checkArgument((boolean)expectedDereferences.subList(0, readerDereferences.size()).equals(readerDereferences), (Object)"Field returned by the reader should be a prefix of expected field");
            return expectedDereferences.subList(readerDereferences.size(), expectedDereferences.size());
        }
    }

    private static class DereferenceBlockLoader
    implements LazyBlockLoader {
        private final List<Integer> dereferenceSequence;
        private final Type type;
        private boolean loaded;
        private Block inputBlock;

        DereferenceBlockLoader(Block inputBlock, List<Integer> dereferenceSequence, Type type) {
            this.inputBlock = Objects.requireNonNull(inputBlock, "inputBlock is null");
            this.dereferenceSequence = Objects.requireNonNull(dereferenceSequence, "dereferenceSequence is null");
            this.type = type;
        }

        public Block load() {
            Preconditions.checkState((!this.loaded ? 1 : 0) != 0, (Object)"Already loaded");
            Block loadedBlock = this.loadInternalBlock(this.dereferenceSequence, this.inputBlock);
            this.inputBlock = null;
            this.loaded = true;
            return loadedBlock;
        }

        private Block loadInternalBlock(List<Integer> dereferences, Block parentBlock) {
            if (dereferences.size() == 0) {
                return parentBlock.getLoadedBlock();
            }
            ColumnarRow columnarRow = ColumnarRow.toColumnarRow((Block)parentBlock);
            int dereferenceIndex = dereferences.get(0);
            List<Integer> remainingDereferences = dereferences.subList(1, dereferences.size());
            Block fieldBlock = columnarRow.getField(dereferenceIndex);
            Block loadedInternalBlock = this.loadInternalBlock(remainingDereferences, fieldBlock);
            return this.adaptNulls(columnarRow, loadedInternalBlock);
        }

        private Block adaptNulls(ColumnarRow columnarRow, Block loadedInternalBlock) {
            BlockBuilder newlyCreatedBlock = null;
            int fieldBlockPosition = 0;
            for (int i = 0; i < columnarRow.getPositionCount(); ++i) {
                boolean isRowNull = columnarRow.isNull(i);
                if (isRowNull) {
                    if (newlyCreatedBlock == null) {
                        newlyCreatedBlock = this.type.createBlockBuilder(null, columnarRow.getPositionCount());
                        for (int j = 0; j < i; ++j) {
                            this.type.appendTo(loadedInternalBlock, j, newlyCreatedBlock);
                        }
                    }
                    newlyCreatedBlock.appendNull();
                    continue;
                }
                if (newlyCreatedBlock != null) {
                    this.type.appendTo(loadedInternalBlock, fieldBlockPosition, newlyCreatedBlock);
                }
                ++fieldBlockPosition;
            }
            if (newlyCreatedBlock == null) {
                return loadedInternalBlock;
            }
            return newlyCreatedBlock.build();
        }
    }
}

