/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.authentication;

import com.google.common.base.Preconditions;
import com.google.inject.Binder;
import com.google.inject.Module;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.airlift.configuration.ConditionalModule;
import io.prestosql.plugin.hive.authentication.AuthenticationModules;
import io.prestosql.plugin.hive.authentication.HiveAuthenticationConfig;
import io.prestosql.plugin.hive.rubix.RubixEnabledConfig;
import java.util.function.Predicate;

public class HiveAuthenticationModule
extends AbstractConfigurationAwareModule {
    protected void setup(Binder binder) {
        this.bindAuthenticationModule(config -> HiveAuthenticationModule.noHdfsAuth(config) && !config.isHdfsImpersonationEnabled(), AuthenticationModules.noHdfsAuthenticationModule());
        this.bindAuthenticationModule(config -> HiveAuthenticationModule.noHdfsAuth(config) && config.isHdfsImpersonationEnabled(), AuthenticationModules.simpleImpersonatingHdfsAuthenticationModule());
        this.bindAuthenticationModule(config -> HiveAuthenticationModule.kerberosHdfsAuth(config) && !config.isHdfsImpersonationEnabled(), AuthenticationModules.kerberosHdfsAuthenticationModule());
        this.bindAuthenticationModule(config -> HiveAuthenticationModule.kerberosHdfsAuth(config) && config.isHdfsImpersonationEnabled(), AuthenticationModules.kerberosImpersonatingHdfsAuthenticationModule());
        Preconditions.checkArgument((!((HiveAuthenticationConfig)this.buildConfigObject(HiveAuthenticationConfig.class)).isHdfsImpersonationEnabled() || !((RubixEnabledConfig)this.buildConfigObject(RubixEnabledConfig.class)).isCacheEnabled() ? 1 : 0) != 0, (Object)"Hdfs impersonation is not compatible with Hive caching");
    }

    private void bindAuthenticationModule(Predicate<HiveAuthenticationConfig> predicate, Module module) {
        this.install(ConditionalModule.installModuleIf(HiveAuthenticationConfig.class, predicate, (Module)module));
    }

    private static boolean noHdfsAuth(HiveAuthenticationConfig config) {
        return config.getHdfsAuthenticationType() == HiveAuthenticationConfig.HdfsAuthenticationType.NONE;
    }

    private static boolean kerberosHdfsAuth(HiveAuthenticationConfig config) {
        return config.getHdfsAuthenticationType() == HiveAuthenticationConfig.HdfsAuthenticationType.KERBEROS;
    }
}

