/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.gcs;

import io.prestosql.plugin.hive.DynamicConfigurationProvider;
import io.prestosql.plugin.hive.HdfsEnvironment;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;

public class GcsConfigurationProvider
implements DynamicConfigurationProvider {
    private static final String GCS_OAUTH_KEY = "hive.gcs.oauth";

    @Override
    public void updateConfiguration(Configuration configuration, HdfsEnvironment.HdfsContext context, URI uri) {
        if (!uri.getScheme().equals("gs")) {
            return;
        }
        String accessToken = (String)context.getIdentity().getExtraCredentials().get(GCS_OAUTH_KEY);
        if (accessToken != null) {
            configuration.set("presto.gcs.oauth-access-token", accessToken);
            DynamicConfigurationProvider.setCacheKey(configuration, accessToken);
        }
    }
}

