/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.metastore;

import io.prestosql.plugin.hive.HiveMetastoreClosure;
import io.prestosql.plugin.hive.authentication.HiveIdentity;
import io.prestosql.plugin.hive.metastore.HivePageSinkMetadata;
import io.prestosql.plugin.hive.metastore.Partition;
import io.prestosql.plugin.hive.metastore.Table;
import io.prestosql.spi.connector.SchemaTableName;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class HivePageSinkMetadataProvider {
    private final HiveIdentity identity;
    private final HiveMetastoreClosure delegate;
    private final SchemaTableName schemaTableName;
    private final Optional<Table> table;
    private final Map<List<String>, Optional<Partition>> modifiedPartitions;

    public HivePageSinkMetadataProvider(HivePageSinkMetadata pageSinkMetadata, HiveMetastoreClosure delegate, HiveIdentity identity) {
        Objects.requireNonNull(pageSinkMetadata, "pageSinkMetadata is null");
        this.delegate = delegate;
        this.identity = Objects.requireNonNull(identity, "identity is null");
        this.schemaTableName = pageSinkMetadata.getSchemaTableName();
        this.table = pageSinkMetadata.getTable();
        this.modifiedPartitions = pageSinkMetadata.getModifiedPartitions();
    }

    public Optional<Table> getTable() {
        return this.table;
    }

    public Optional<Partition> getPartition(List<String> partitionValues) {
        if (this.table.isEmpty() || this.table.get().getPartitionColumns().isEmpty()) {
            throw new IllegalArgumentException(String.format("Unexpected call to getPartition. Table name: %s", this.schemaTableName));
        }
        Optional<Partition> modifiedPartition = this.modifiedPartitions.get(partitionValues);
        if (modifiedPartition == null) {
            return this.delegate.getPartition(this.identity, this.schemaTableName.getSchemaName(), this.schemaTableName.getTableName(), partitionValues);
        }
        return modifiedPartition;
    }
}

