/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.metastore;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import io.prestosql.plugin.hive.metastore.HivePrincipal;
import io.prestosql.spi.security.Privilege;
import io.prestosql.spi.security.PrivilegeInfo;
import java.util.Objects;
import java.util.Set;
import javax.annotation.concurrent.Immutable;

@Immutable
public class HivePrivilegeInfo {
    private final HivePrivilege hivePrivilege;
    private final boolean grantOption;
    private final HivePrincipal grantor;
    private final HivePrincipal grantee;

    @JsonCreator
    public HivePrivilegeInfo(@JsonProperty(value="hivePrivilege") HivePrivilege hivePrivilege, @JsonProperty(value="grantOption") boolean grantOption, @JsonProperty(value="grantor") HivePrincipal grantor, @JsonProperty(value="grantee") HivePrincipal grantee) {
        this.hivePrivilege = Objects.requireNonNull(hivePrivilege, "hivePrivilege is null");
        this.grantOption = grantOption;
        this.grantor = Objects.requireNonNull(grantor, "grantor is null");
        this.grantee = Objects.requireNonNull(grantee, "grantee is null");
    }

    @JsonProperty
    public HivePrivilege getHivePrivilege() {
        return this.hivePrivilege;
    }

    @JsonProperty
    public boolean isGrantOption() {
        return this.grantOption;
    }

    @JsonProperty
    public HivePrincipal getGrantor() {
        return this.grantor;
    }

    @JsonProperty
    public HivePrincipal getGrantee() {
        return this.grantee;
    }

    public static HivePrivilege toHivePrivilege(Privilege privilege) {
        switch (privilege) {
            case SELECT: {
                return HivePrivilege.SELECT;
            }
            case INSERT: {
                return HivePrivilege.INSERT;
            }
            case DELETE: {
                return HivePrivilege.DELETE;
            }
            case UPDATE: {
                return HivePrivilege.UPDATE;
            }
        }
        throw new IllegalArgumentException("Unexpected privilege: " + privilege);
    }

    public boolean isContainedIn(HivePrivilegeInfo hivePrivilegeInfo) {
        return this.getHivePrivilege() == hivePrivilegeInfo.getHivePrivilege() && (this.isGrantOption() == hivePrivilegeInfo.isGrantOption() || !this.isGrantOption() && hivePrivilegeInfo.isGrantOption());
    }

    public Set<PrivilegeInfo> toPrivilegeInfo() {
        switch (this.hivePrivilege) {
            case SELECT: {
                return ImmutableSet.of((Object)new PrivilegeInfo(Privilege.SELECT, this.isGrantOption()));
            }
            case INSERT: {
                return ImmutableSet.of((Object)new PrivilegeInfo(Privilege.INSERT, this.isGrantOption()));
            }
            case DELETE: {
                return ImmutableSet.of((Object)new PrivilegeInfo(Privilege.DELETE, this.isGrantOption()));
            }
            case UPDATE: {
                return ImmutableSet.of((Object)new PrivilegeInfo(Privilege.UPDATE, this.isGrantOption()));
            }
            case OWNERSHIP: {
                return ImmutableSet.of();
            }
        }
        throw new IllegalArgumentException("Unsupported hivePrivilege: " + this.hivePrivilege);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.hivePrivilege, this.grantOption, this.grantor, this.grantee});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HivePrivilegeInfo hivePrivilegeInfo = (HivePrivilegeInfo)o;
        return this.hivePrivilege == hivePrivilegeInfo.hivePrivilege && Objects.equals(this.grantOption, hivePrivilegeInfo.grantOption) && Objects.equals(this.grantor, hivePrivilegeInfo.grantor) && Objects.equals(this.grantee, hivePrivilegeInfo.grantee);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("privilege", (Object)this.hivePrivilege).add("grantOption", this.grantOption).add("grantor", (Object)this.grantor).add("grantee", (Object)this.grantee).toString();
    }

    public static enum HivePrivilege {
        SELECT,
        INSERT,
        UPDATE,
        DELETE,
        OWNERSHIP;

    }
}

