/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.metastore;

import com.google.common.collect.ImmutableList;
import io.prestosql.plugin.hive.HiveMetastoreClosure;
import io.prestosql.plugin.hive.HivePartition;
import io.prestosql.plugin.hive.HiveTableHandle;
import io.prestosql.plugin.hive.authentication.HiveIdentity;
import io.prestosql.spi.connector.SchemaTableName;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ScheduledFuture;
import org.apache.hadoop.hive.common.ValidTxnWriteIdList;

public class HiveTransaction {
    private final HiveIdentity identity;
    private final String queryId;
    private final long transactionId;
    private final ScheduledFuture<?> heartbeatTask;
    private final Map<SchemaTableName, ValidTxnWriteIdList> validHiveTransactionsForTable = new HashMap<SchemaTableName, ValidTxnWriteIdList>();

    public HiveTransaction(HiveIdentity identity, String queryId, long transactionId, ScheduledFuture<?> heartbeatTask) {
        this.identity = Objects.requireNonNull(identity, "identity is null");
        this.queryId = Objects.requireNonNull(queryId, "queryId is null");
        this.transactionId = transactionId;
        this.heartbeatTask = Objects.requireNonNull(heartbeatTask, "heartbeatTask is null");
    }

    public long getTransactionId() {
        return this.transactionId;
    }

    public ScheduledFuture<?> getHeartbeatTask() {
        return this.heartbeatTask;
    }

    public ValidTxnWriteIdList getValidWriteIds(HiveMetastoreClosure metastore, HiveTableHandle tableHandle) {
        metastore.acquireSharedReadLock(this.identity, this.queryId, this.transactionId, (List<SchemaTableName>)(tableHandle.getPartitions().isEmpty() ? ImmutableList.of((Object)tableHandle.getSchemaTableName()) : ImmutableList.of()), tableHandle.getPartitions().orElse((List<HivePartition>)ImmutableList.of()));
        return this.validHiveTransactionsForTable.computeIfAbsent(tableHandle.getSchemaTableName(), schemaTableName -> new ValidTxnWriteIdList(metastore.getValidWriteIds(this.identity, (List<SchemaTableName>)ImmutableList.of((Object)schemaTableName), this.transactionId)));
    }
}

