/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.metastore;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import io.airlift.concurrent.MoreFutures;
import io.airlift.log.Logger;
import io.airlift.units.Duration;
import io.prestosql.plugin.hive.HdfsEnvironment;
import io.prestosql.plugin.hive.HiveBasicStatistics;
import io.prestosql.plugin.hive.HiveErrorCode;
import io.prestosql.plugin.hive.HiveMetastoreClosure;
import io.prestosql.plugin.hive.HiveTableHandle;
import io.prestosql.plugin.hive.HiveType;
import io.prestosql.plugin.hive.LocationHandle;
import io.prestosql.plugin.hive.PartitionNotFoundException;
import io.prestosql.plugin.hive.PartitionStatistics;
import io.prestosql.plugin.hive.TableAlreadyExistsException;
import io.prestosql.plugin.hive.authentication.HiveIdentity;
import io.prestosql.plugin.hive.metastore.Column;
import io.prestosql.plugin.hive.metastore.Database;
import io.prestosql.plugin.hive.metastore.HiveColumnStatistics;
import io.prestosql.plugin.hive.metastore.HivePageSinkMetadata;
import io.prestosql.plugin.hive.metastore.HivePrincipal;
import io.prestosql.plugin.hive.metastore.HivePrivilegeInfo;
import io.prestosql.plugin.hive.metastore.HiveTransaction;
import io.prestosql.plugin.hive.metastore.Partition;
import io.prestosql.plugin.hive.metastore.PartitionWithStatistics;
import io.prestosql.plugin.hive.metastore.PrincipalPrivileges;
import io.prestosql.plugin.hive.metastore.Table;
import io.prestosql.plugin.hive.util.HiveUtil;
import io.prestosql.plugin.hive.util.HiveWriteUtils;
import io.prestosql.plugin.hive.util.Statistics;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.connector.SchemaTableName;
import io.prestosql.spi.connector.TableNotFoundException;
import io.prestosql.spi.security.PrincipalType;
import io.prestosql.spi.security.RoleGrant;
import io.prestosql.spi.statistics.ColumnStatisticType;
import io.prestosql.spi.type.Type;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import javax.annotation.concurrent.GuardedBy;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.common.ValidTxnWriteIdList;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.ql.io.AcidUtils;

public class SemiTransactionalHiveMetastore {
    private static final Logger log = Logger.get(SemiTransactionalHiveMetastore.class);
    private static final int PARTITION_COMMIT_BATCH_SIZE = 8;
    private final HiveMetastoreClosure delegate;
    private final HdfsEnvironment hdfsEnvironment;
    private final Executor renameExecutor;
    private final Executor dropExecutor;
    private final boolean skipDeletionForAlter;
    private final boolean skipTargetCleanupOnRollback;
    private final ScheduledExecutorService heartbeatExecutor;
    private final Optional<Duration> configuredTransactionHeartbeatInterval;
    private boolean throwOnCleanupFailure;
    @GuardedBy(value="this")
    private final Map<SchemaTableName, Action<TableAndMore>> tableActions = new HashMap<SchemaTableName, Action<TableAndMore>>();
    @GuardedBy(value="this")
    private final Map<SchemaTableName, Map<List<String>, Action<PartitionAndMore>>> partitionActions = new HashMap<SchemaTableName, Map<List<String>, Action<PartitionAndMore>>>();
    @GuardedBy(value="this")
    private final List<DeclaredIntentionToWrite> declaredIntentionsToWrite = new ArrayList<DeclaredIntentionToWrite>();
    @GuardedBy(value="this")
    private ExclusiveOperation bufferedExclusiveOperation;
    @GuardedBy(value="this")
    private State state = State.EMPTY;
    @GuardedBy(value="this")
    private Optional<String> currentQueryId = Optional.empty();
    @GuardedBy(value="this")
    private Optional<Supplier<HiveTransaction>> hiveTransactionSupplier = Optional.empty();
    @GuardedBy(value="this")
    private Optional<HiveTransaction> currentHiveTransaction = Optional.empty();

    public SemiTransactionalHiveMetastore(HdfsEnvironment hdfsEnvironment, HiveMetastoreClosure delegate, Executor renameExecutor, Executor dropExecutor, boolean skipDeletionForAlter, boolean skipTargetCleanupOnRollback, Optional<Duration> hiveTransactionHeartbeatInterval, ScheduledExecutorService heartbeatService) {
        this.hdfsEnvironment = Objects.requireNonNull(hdfsEnvironment, "hdfsEnvironment is null");
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        this.renameExecutor = Objects.requireNonNull(renameExecutor, "renameExecutor is null");
        this.dropExecutor = Objects.requireNonNull(dropExecutor, "dropExecutor is null");
        this.skipDeletionForAlter = skipDeletionForAlter;
        this.skipTargetCleanupOnRollback = skipTargetCleanupOnRollback;
        this.heartbeatExecutor = heartbeatService;
        this.configuredTransactionHeartbeatInterval = Objects.requireNonNull(hiveTransactionHeartbeatInterval, "hiveTransactionHeartbeatInterval is null");
    }

    public synchronized List<String> getAllDatabases() {
        this.checkReadable();
        return this.delegate.getAllDatabases();
    }

    public synchronized Optional<Database> getDatabase(String databaseName) {
        this.checkReadable();
        return this.delegate.getDatabase(databaseName);
    }

    public synchronized List<String> getAllTables(String databaseName) {
        this.checkReadable();
        if (!this.tableActions.isEmpty()) {
            throw new UnsupportedOperationException("Listing all tables after adding/dropping/altering tables/views in a transaction is not supported");
        }
        return this.delegate.getAllTables(databaseName);
    }

    public synchronized Optional<Table> getTable(HiveIdentity identity, String databaseName, String tableName) {
        this.checkReadable();
        Action<TableAndMore> tableAction = this.tableActions.get(new SchemaTableName(databaseName, tableName));
        if (tableAction == null) {
            return this.delegate.getTable(identity, databaseName, tableName);
        }
        switch (tableAction.getType()) {
            case ADD: 
            case ALTER: 
            case INSERT_EXISTING: {
                return Optional.of(tableAction.getData().getTable());
            }
            case DROP: {
                return Optional.empty();
            }
        }
        throw new IllegalStateException("Unknown action type");
    }

    public synchronized Set<ColumnStatisticType> getSupportedColumnStatistics(Type type) {
        return this.delegate.getSupportedColumnStatistics(type);
    }

    public synchronized PartitionStatistics getTableStatistics(HiveIdentity identity, String databaseName, String tableName) {
        this.checkReadable();
        Action<TableAndMore> tableAction = this.tableActions.get(new SchemaTableName(databaseName, tableName));
        if (tableAction == null) {
            return this.delegate.getTableStatistics(identity, databaseName, tableName);
        }
        switch (tableAction.getType()) {
            case ADD: 
            case ALTER: 
            case INSERT_EXISTING: {
                return tableAction.getData().getStatistics();
            }
            case DROP: {
                return PartitionStatistics.empty();
            }
        }
        throw new IllegalStateException("Unknown action type");
    }

    public synchronized Map<String, PartitionStatistics> getPartitionStatistics(HiveIdentity identity, String databaseName, String tableName, Set<String> partitionNames) {
        this.checkReadable();
        Optional<Table> table = this.getTable(identity, databaseName, tableName);
        if (table.isEmpty()) {
            return ImmutableMap.of();
        }
        TableSource tableSource = this.getTableSource(databaseName, tableName);
        Map partitionActionsOfTable = this.partitionActions.computeIfAbsent(table.get().getSchemaTableName(), k -> new HashMap());
        ImmutableSet.Builder partitionNamesToQuery = ImmutableSet.builder();
        ImmutableMap.Builder resultBuilder = ImmutableMap.builder();
        block4: for (String partitionName2 : partitionNames) {
            List<String> partitionValues = HiveUtil.toPartitionValues(partitionName2);
            Action partitionAction = (Action)partitionActionsOfTable.get(partitionValues);
            if (partitionAction == null) {
                switch (tableSource) {
                    case PRE_EXISTING_TABLE: {
                        partitionNamesToQuery.add((Object)partitionName2);
                        continue block4;
                    }
                    case CREATED_IN_THIS_TRANSACTION: {
                        resultBuilder.put((Object)partitionName2, (Object)PartitionStatistics.empty());
                        continue block4;
                    }
                }
                throw new UnsupportedOperationException("unknown table source");
            }
            resultBuilder.put((Object)partitionName2, (Object)((PartitionAndMore)partitionAction.getData()).getStatistics());
        }
        Map<String, PartitionStatistics> delegateResult = this.delegate.getPartitionStatistics(identity, databaseName, tableName, (Set<String>)partitionNamesToQuery.build());
        if (!delegateResult.isEmpty()) {
            resultBuilder.putAll(delegateResult);
        } else {
            partitionNamesToQuery.build().forEach(partitionName -> resultBuilder.put(partitionName, (Object)PartitionStatistics.empty()));
        }
        return resultBuilder.build();
    }

    @GuardedBy(value="this")
    private TableSource getTableSource(String databaseName, String tableName) {
        this.checkHoldsLock();
        this.checkReadable();
        Action<TableAndMore> tableAction = this.tableActions.get(new SchemaTableName(databaseName, tableName));
        if (tableAction == null) {
            return TableSource.PRE_EXISTING_TABLE;
        }
        switch (tableAction.getType()) {
            case ADD: {
                return TableSource.CREATED_IN_THIS_TRANSACTION;
            }
            case DROP: {
                throw new TableNotFoundException(new SchemaTableName(databaseName, tableName));
            }
            case ALTER: 
            case INSERT_EXISTING: {
                return TableSource.PRE_EXISTING_TABLE;
            }
        }
        throw new IllegalStateException("Unknown action type");
    }

    public synchronized HivePageSinkMetadata generatePageSinkMetadata(HiveIdentity identity, SchemaTableName schemaTableName) {
        ImmutableMap modifiedPartitionMap;
        this.checkReadable();
        Optional<Table> table = this.getTable(identity, schemaTableName.getSchemaName(), schemaTableName.getTableName());
        if (table.isEmpty()) {
            return new HivePageSinkMetadata(schemaTableName, Optional.empty(), (Map<List<String>, Optional<Partition>>)ImmutableMap.of());
        }
        Map<List<String>, Action<PartitionAndMore>> partitionActionMap = this.partitionActions.get(schemaTableName);
        if (partitionActionMap == null) {
            modifiedPartitionMap = ImmutableMap.of();
        } else {
            ImmutableMap.Builder modifiedPartitionMapBuilder = ImmutableMap.builder();
            for (Map.Entry<List<String>, Action<PartitionAndMore>> entry : partitionActionMap.entrySet()) {
                modifiedPartitionMapBuilder.put(entry.getKey(), SemiTransactionalHiveMetastore.getPartitionFromPartitionAction(entry.getValue()));
            }
            modifiedPartitionMap = modifiedPartitionMapBuilder.build();
        }
        return new HivePageSinkMetadata(schemaTableName, table, (Map<List<String>, Optional<Partition>>)modifiedPartitionMap);
    }

    public synchronized List<String> getAllViews(String databaseName) {
        this.checkReadable();
        if (!this.tableActions.isEmpty()) {
            throw new UnsupportedOperationException("Listing all tables after adding/dropping/altering tables/views in a transaction is not supported");
        }
        return this.delegate.getAllViews(databaseName);
    }

    public synchronized void createDatabase(HiveIdentity identity, Database database) {
        this.setExclusive((delegate, hdfsEnvironment) -> delegate.createDatabase(identity, database));
    }

    public synchronized void dropDatabase(HiveIdentity identity, String schemaName) {
        this.setExclusive((delegate, hdfsEnvironment) -> delegate.dropDatabase(identity, schemaName));
    }

    public synchronized void renameDatabase(HiveIdentity identity, String source, String target) {
        this.setExclusive((delegate, hdfsEnvironment) -> delegate.renameDatabase(identity, source, target));
    }

    public synchronized void setDatabaseOwner(HiveIdentity identity, String source, HivePrincipal principal) {
        this.setExclusive((delegate, hdfsEnvironment) -> delegate.setDatabaseOwner(identity, source, principal));
    }

    public synchronized void setTableStatistics(HiveIdentity identity, Table table, PartitionStatistics tableStatistics) {
        this.setExclusive((delegate, hdfsEnvironment) -> delegate.updateTableStatistics(identity, table.getDatabaseName(), table.getTableName(), statistics -> this.updatePartitionStatistics((PartitionStatistics)statistics, tableStatistics)));
    }

    public synchronized void setPartitionStatistics(HiveIdentity identity, Table table, Map<List<String>, PartitionStatistics> partitionStatisticsMap) {
        this.setExclusive((delegate, hdfsEnvironment) -> partitionStatisticsMap.forEach((partitionValues, newPartitionStats) -> delegate.updatePartitionStatistics(identity, table.getDatabaseName(), table.getTableName(), this.getPartitionName(table, (List<String>)partitionValues), oldPartitionStats -> this.updatePartitionStatistics((PartitionStatistics)oldPartitionStats, (PartitionStatistics)newPartitionStats))));
    }

    private PartitionStatistics updatePartitionStatistics(PartitionStatistics oldPartitionStats, PartitionStatistics newPartitionStats) {
        HiveBasicStatistics oldBasicStatistics = oldPartitionStats.getBasicStatistics();
        HiveBasicStatistics newBasicStatistics = newPartitionStats.getBasicStatistics();
        HiveBasicStatistics updatedBasicStatistics = new HiveBasicStatistics(SemiTransactionalHiveMetastore.firstPresent(newBasicStatistics.getFileCount(), oldBasicStatistics.getFileCount()), SemiTransactionalHiveMetastore.firstPresent(newBasicStatistics.getRowCount(), oldBasicStatistics.getRowCount()), SemiTransactionalHiveMetastore.firstPresent(newBasicStatistics.getInMemoryDataSizeInBytes(), oldBasicStatistics.getInMemoryDataSizeInBytes()), SemiTransactionalHiveMetastore.firstPresent(newBasicStatistics.getOnDiskDataSizeInBytes(), oldBasicStatistics.getOnDiskDataSizeInBytes()));
        Map<String, HiveColumnStatistics> updatedColumnStatistics = this.updateColumnStatistics(oldPartitionStats.getColumnStatistics(), newPartitionStats.getColumnStatistics());
        return new PartitionStatistics(updatedBasicStatistics, updatedColumnStatistics);
    }

    private Map<String, HiveColumnStatistics> updateColumnStatistics(Map<String, HiveColumnStatistics> oldColumnStats, Map<String, HiveColumnStatistics> newColumnStats) {
        HashMap<String, HiveColumnStatistics> result = new HashMap<String, HiveColumnStatistics>(oldColumnStats);
        result.putAll(newColumnStats);
        return ImmutableMap.copyOf(result);
    }

    private static OptionalLong firstPresent(OptionalLong first, OptionalLong second) {
        return first.isPresent() ? first : second;
    }

    public synchronized void createTable(ConnectorSession session, Table table, PrincipalPrivileges principalPrivileges, Optional<Path> currentPath, boolean ignoreExisting, PartitionStatistics statistics) {
        this.setShared();
        this.checkNoPartitionAction(table.getDatabaseName(), table.getTableName());
        Action<TableAndMore> oldTableAction = this.tableActions.get(table.getSchemaTableName());
        HiveIdentity identity = new HiveIdentity(session);
        TableAndMore tableAndMore = new TableAndMore(table, identity, Optional.of(principalPrivileges), currentPath, Optional.empty(), ignoreExisting, statistics, statistics);
        if (oldTableAction == null) {
            HdfsEnvironment.HdfsContext hdfsContext = new HdfsEnvironment.HdfsContext(session, table.getDatabaseName(), table.getTableName());
            this.tableActions.put(table.getSchemaTableName(), new Action<TableAndMore>(ActionType.ADD, tableAndMore, hdfsContext, identity));
            return;
        }
        switch (oldTableAction.getType()) {
            case DROP: {
                if (!oldTableAction.getHdfsContext().getIdentity().getUser().equals(session.getUser())) {
                    throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.TRANSACTION_CONFLICT, "Operation on the same table with different user in the same transaction is not supported");
                }
                HdfsEnvironment.HdfsContext hdfsContext = new HdfsEnvironment.HdfsContext(session, table.getDatabaseName(), table.getTableName());
                this.tableActions.put(table.getSchemaTableName(), new Action<TableAndMore>(ActionType.ALTER, tableAndMore, hdfsContext, identity));
                break;
            }
            case ADD: 
            case ALTER: 
            case INSERT_EXISTING: {
                throw new TableAlreadyExistsException(table.getSchemaTableName());
            }
            default: {
                throw new IllegalStateException("Unknown action type");
            }
        }
    }

    public synchronized void dropTable(ConnectorSession session, String databaseName, String tableName) {
        this.setShared();
        this.checkNoPartitionAction(databaseName, tableName);
        SchemaTableName schemaTableName = new SchemaTableName(databaseName, tableName);
        Action<TableAndMore> oldTableAction = this.tableActions.get(schemaTableName);
        if (oldTableAction == null || oldTableAction.getType() == ActionType.ALTER) {
            HdfsEnvironment.HdfsContext hdfsContext = new HdfsEnvironment.HdfsContext(session, databaseName, tableName);
            HiveIdentity identity = new HiveIdentity(session);
            this.tableActions.put(schemaTableName, new Action<Object>(ActionType.DROP, null, hdfsContext, identity));
            return;
        }
        switch (oldTableAction.getType()) {
            case DROP: {
                throw new TableNotFoundException(schemaTableName);
            }
            case ADD: 
            case ALTER: 
            case INSERT_EXISTING: {
                throw new UnsupportedOperationException("dropping a table added/modified in the same transaction is not supported");
            }
        }
        throw new IllegalStateException("Unknown action type");
    }

    public synchronized void replaceTable(HiveIdentity identity, String databaseName, String tableName, Table table, PrincipalPrivileges principalPrivileges) {
        this.setExclusive((delegate, hdfsEnvironment) -> delegate.replaceTable(identity, databaseName, tableName, table, principalPrivileges));
    }

    public synchronized void renameTable(HiveIdentity identity, String databaseName, String tableName, String newDatabaseName, String newTableName) {
        this.setExclusive((delegate, hdfsEnvironment) -> delegate.renameTable(identity, databaseName, tableName, newDatabaseName, newTableName));
    }

    public synchronized void commentTable(HiveIdentity identity, String databaseName, String tableName, Optional<String> comment) {
        this.setExclusive((delegate, hdfsEnvironment) -> delegate.commentTable(identity, databaseName, tableName, comment));
    }

    public synchronized void commentColumn(HiveIdentity identity, String databaseName, String tableName, String columnName, Optional<String> comment) {
        this.setExclusive((delegate, hdfsEnvironment) -> delegate.commentColumn(identity, databaseName, tableName, columnName, comment));
    }

    public synchronized void addColumn(HiveIdentity identity, String databaseName, String tableName, String columnName, HiveType columnType, String columnComment) {
        this.setExclusive((delegate, hdfsEnvironment) -> delegate.addColumn(identity, databaseName, tableName, columnName, columnType, columnComment));
    }

    public synchronized void renameColumn(HiveIdentity identity, String databaseName, String tableName, String oldColumnName, String newColumnName) {
        this.setExclusive((delegate, hdfsEnvironment) -> delegate.renameColumn(identity, databaseName, tableName, oldColumnName, newColumnName));
    }

    public synchronized void dropColumn(HiveIdentity identity, String databaseName, String tableName, String columnName) {
        this.setExclusive((delegate, hdfsEnvironment) -> delegate.dropColumn(identity, databaseName, tableName, columnName));
    }

    public synchronized void finishInsertIntoExistingTable(ConnectorSession session, String databaseName, String tableName, Path currentLocation, List<String> fileNames, PartitionStatistics statisticsUpdate) {
        this.setShared();
        HiveIdentity identity = new HiveIdentity(session);
        SchemaTableName schemaTableName = new SchemaTableName(databaseName, tableName);
        Action<TableAndMore> oldTableAction = this.tableActions.get(schemaTableName);
        if (oldTableAction == null) {
            Table table = this.getExistingTable(identity, schemaTableName.getSchemaName(), schemaTableName.getTableName());
            PartitionStatistics currentStatistics = this.getTableStatistics(identity, databaseName, tableName);
            HdfsEnvironment.HdfsContext hdfsContext = new HdfsEnvironment.HdfsContext(session, databaseName, tableName);
            this.tableActions.put(schemaTableName, new Action<TableAndMore>(ActionType.INSERT_EXISTING, new TableAndMore(table, identity, Optional.empty(), Optional.of(currentLocation), Optional.of(fileNames), false, Statistics.merge(currentStatistics, statisticsUpdate), statisticsUpdate), hdfsContext, identity));
            return;
        }
        switch (oldTableAction.getType()) {
            case DROP: {
                throw new TableNotFoundException(schemaTableName);
            }
            case ADD: 
            case ALTER: 
            case INSERT_EXISTING: {
                throw new UnsupportedOperationException("Inserting into an unpartitioned table that were added, altered, or inserted into in the same transaction is not supported");
            }
        }
        throw new IllegalStateException("Unknown action type");
    }

    public synchronized void truncateUnpartitionedTable(ConnectorSession session, String databaseName, String tableName) {
        this.checkReadable();
        Optional<Table> table = this.getTable(new HiveIdentity(session), databaseName, tableName);
        SchemaTableName schemaTableName = new SchemaTableName(databaseName, tableName);
        if (table.isEmpty()) {
            throw new TableNotFoundException(schemaTableName);
        }
        if (!table.get().getTableType().equals(TableType.MANAGED_TABLE.toString())) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Cannot delete from non-managed Hive table");
        }
        if (!table.get().getPartitionColumns().isEmpty()) {
            throw new IllegalArgumentException("Table is partitioned");
        }
        Path path = new Path(table.get().getStorage().getLocation());
        HdfsEnvironment.HdfsContext context = new HdfsEnvironment.HdfsContext(session, databaseName, tableName);
        this.setExclusive((delegate, hdfsEnvironment) -> {
            RecursiveDeleteResult recursiveDeleteResult = SemiTransactionalHiveMetastore.recursiveDeleteFiles(hdfsEnvironment, context, path, (Set<String>)ImmutableSet.of((Object)""), false);
            if (!recursiveDeleteResult.getNotDeletedEligibleItems().isEmpty()) {
                throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_FILESYSTEM_ERROR, String.format("Error deleting from unpartitioned table %s. These items cannot be deleted: %s", schemaTableName, recursiveDeleteResult.getNotDeletedEligibleItems()));
            }
        });
    }

    public synchronized Optional<List<String>> getPartitionNames(HiveIdentity identity, String databaseName, String tableName) {
        return this.doGetPartitionNames(identity, databaseName, tableName, Optional.empty());
    }

    public synchronized Optional<List<String>> getPartitionNamesByParts(HiveIdentity identity, String databaseName, String tableName, List<String> parts) {
        return this.doGetPartitionNames(identity, databaseName, tableName, Optional.of(parts));
    }

    @GuardedBy(value="this")
    private Optional<List<String>> doGetPartitionNames(HiveIdentity identity, String databaseName, String tableName, Optional<List<String>> parts) {
        Object partitionNames;
        this.checkHoldsLock();
        this.checkReadable();
        Optional<Table> table = this.getTable(identity, databaseName, tableName);
        if (table.isEmpty()) {
            return Optional.empty();
        }
        TableSource tableSource = this.getTableSource(databaseName, tableName);
        switch (tableSource) {
            case CREATED_IN_THIS_TRANSACTION: {
                partitionNames = ImmutableList.of();
                break;
            }
            case PRE_EXISTING_TABLE: {
                Optional<List<String>> partitionNameResult = parts.isPresent() ? this.delegate.getPartitionNamesByParts(identity, databaseName, tableName, parts.get()) : this.delegate.getPartitionNames(identity, databaseName, tableName);
                if (partitionNameResult.isEmpty()) {
                    throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.TRANSACTION_CONFLICT, String.format("Table '%s.%s' was dropped by another transaction", databaseName, tableName));
                }
                partitionNames = partitionNameResult.get();
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown table source");
            }
        }
        Map partitionActionsOfTable = this.partitionActions.computeIfAbsent(table.get().getSchemaTableName(), k -> new HashMap());
        ImmutableList.Builder resultBuilder = ImmutableList.builder();
        block9: for (String partitionName : partitionNames) {
            List<String> partitionValues = HiveUtil.toPartitionValues(partitionName);
            Action partitionAction = (Action)partitionActionsOfTable.get(partitionValues);
            if (partitionAction == null) {
                resultBuilder.add((Object)partitionName);
                continue;
            }
            switch (partitionAction.getType()) {
                case ADD: {
                    throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.TRANSACTION_CONFLICT, String.format("Another transaction created partition %s in table %s.%s", partitionValues, databaseName, tableName));
                }
                case DROP: 
                case DROP_PRESERVE_DATA: {
                    continue block9;
                }
                case ALTER: 
                case INSERT_EXISTING: {
                    resultBuilder.add((Object)partitionName);
                    continue block9;
                }
            }
            throw new IllegalStateException("Unknown action type");
        }
        if (!partitionActionsOfTable.isEmpty()) {
            List columnNames = table.get().getPartitionColumns().stream().map(Column::getName).collect(Collectors.toList());
            for (Action partitionAction : partitionActionsOfTable.values()) {
                if (partitionAction.getType() != ActionType.ADD) continue;
                List<String> values = ((PartitionAndMore)partitionAction.getData()).getPartition().getValues();
                if (!parts.isEmpty() && !SemiTransactionalHiveMetastore.partitionValuesMatch(values, parts.get())) continue;
                resultBuilder.add((Object)FileUtils.makePartName(columnNames, values));
            }
        }
        return Optional.of(resultBuilder.build());
    }

    private static boolean partitionValuesMatch(List<String> values, List<String> pattern) {
        Preconditions.checkArgument((values.size() == pattern.size() ? 1 : 0) != 0);
        for (int i = 0; i < values.size(); ++i) {
            if (pattern.get(i).isEmpty() || !values.get(i).equals(pattern.get(i))) continue;
            return false;
        }
        return true;
    }

    public synchronized Map<String, Optional<Partition>> getPartitionsByNames(HiveIdentity identity, String databaseName, String tableName, List<String> partitionNames) {
        this.checkReadable();
        TableSource tableSource = this.getTableSource(databaseName, tableName);
        Map partitionActionsOfTable = this.partitionActions.computeIfAbsent(new SchemaTableName(databaseName, tableName), k -> new HashMap());
        ImmutableList.Builder partitionNamesToQueryBuilder = ImmutableList.builder();
        ImmutableMap.Builder resultBuilder = ImmutableMap.builder();
        block4: for (String partitionName : partitionNames) {
            List<String> partitionValues = HiveUtil.toPartitionValues(partitionName);
            Action partitionAction = (Action)partitionActionsOfTable.get(partitionValues);
            if (partitionAction == null) {
                switch (tableSource) {
                    case PRE_EXISTING_TABLE: {
                        partitionNamesToQueryBuilder.add((Object)partitionName);
                        continue block4;
                    }
                    case CREATED_IN_THIS_TRANSACTION: {
                        resultBuilder.put((Object)partitionName, Optional.empty());
                        continue block4;
                    }
                }
                throw new UnsupportedOperationException("unknown table source");
            }
            resultBuilder.put((Object)partitionName, SemiTransactionalHiveMetastore.getPartitionFromPartitionAction(partitionAction));
        }
        ImmutableList partitionNamesToQuery = partitionNamesToQueryBuilder.build();
        if (!partitionNamesToQuery.isEmpty()) {
            Map<String, Optional<Partition>> delegateResult = this.delegate.getPartitionsByNames(identity, databaseName, tableName, (List<String>)partitionNamesToQuery);
            resultBuilder.putAll(delegateResult);
        }
        return resultBuilder.build();
    }

    private static Optional<Partition> getPartitionFromPartitionAction(Action<PartitionAndMore> partitionAction) {
        switch (partitionAction.getType()) {
            case ADD: 
            case ALTER: 
            case INSERT_EXISTING: {
                return Optional.of(partitionAction.getData().getAugmentedPartitionForInTransactionRead());
            }
            case DROP: 
            case DROP_PRESERVE_DATA: {
                return Optional.empty();
            }
        }
        throw new IllegalStateException("Unknown action type");
    }

    public synchronized void addPartition(ConnectorSession session, String databaseName, String tableName, Partition partition, Path currentLocation, PartitionStatistics statistics) {
        this.setShared();
        Preconditions.checkArgument((boolean)SemiTransactionalHiveMetastore.getPrestoQueryId(partition).isPresent());
        Map partitionActionsOfTable = this.partitionActions.computeIfAbsent(new SchemaTableName(databaseName, tableName), k -> new HashMap());
        Action oldPartitionAction = (Action)partitionActionsOfTable.get(partition.getValues());
        HdfsEnvironment.HdfsContext hdfsContext = new HdfsEnvironment.HdfsContext(session, databaseName, tableName);
        HiveIdentity identity = new HiveIdentity(session);
        if (oldPartitionAction == null) {
            partitionActionsOfTable.put(partition.getValues(), new Action<PartitionAndMore>(ActionType.ADD, new PartitionAndMore(identity, partition, currentLocation, Optional.empty(), statistics, statistics), hdfsContext, identity));
            return;
        }
        switch (oldPartitionAction.getType()) {
            case DROP: 
            case DROP_PRESERVE_DATA: {
                if (!oldPartitionAction.getHdfsContext().getIdentity().getUser().equals(session.getUser())) {
                    throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.TRANSACTION_CONFLICT, "Operation on the same partition with different user in the same transaction is not supported");
                }
                partitionActionsOfTable.put(partition.getValues(), new Action<PartitionAndMore>(ActionType.ALTER, new PartitionAndMore(identity, partition, currentLocation, Optional.empty(), statistics, statistics), hdfsContext, identity));
                break;
            }
            case ADD: 
            case ALTER: 
            case INSERT_EXISTING: {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.ALREADY_EXISTS, String.format("Partition already exists for table '%s.%s': %s", databaseName, tableName, partition.getValues()));
            }
            default: {
                throw new IllegalStateException("Unknown action type");
            }
        }
    }

    public synchronized void dropPartition(ConnectorSession session, String databaseName, String tableName, List<String> partitionValues, boolean deleteData) {
        this.setShared();
        Map partitionActionsOfTable = this.partitionActions.computeIfAbsent(new SchemaTableName(databaseName, tableName), k -> new HashMap());
        Action oldPartitionAction = (Action)partitionActionsOfTable.get(partitionValues);
        if (oldPartitionAction == null) {
            HdfsEnvironment.HdfsContext hdfsContext = new HdfsEnvironment.HdfsContext(session, databaseName, tableName);
            HiveIdentity identity = new HiveIdentity(session);
            if (deleteData) {
                partitionActionsOfTable.put(partitionValues, new Action<Object>(ActionType.DROP, null, hdfsContext, identity));
            } else {
                partitionActionsOfTable.put(partitionValues, new Action<Object>(ActionType.DROP_PRESERVE_DATA, null, hdfsContext, identity));
            }
            return;
        }
        switch (oldPartitionAction.getType()) {
            case DROP: 
            case DROP_PRESERVE_DATA: {
                throw new PartitionNotFoundException(new SchemaTableName(databaseName, tableName), partitionValues);
            }
            case ADD: 
            case ALTER: 
            case INSERT_EXISTING: {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("dropping a partition added in the same transaction is not supported: %s %s %s", databaseName, tableName, partitionValues));
            }
        }
        throw new IllegalStateException("Unknown action type");
    }

    public synchronized void finishInsertIntoExistingPartition(ConnectorSession session, String databaseName, String tableName, List<String> partitionValues, Path currentLocation, List<String> fileNames, PartitionStatistics statisticsUpdate) {
        this.setShared();
        HiveIdentity identity = new HiveIdentity(session);
        SchemaTableName schemaTableName = new SchemaTableName(databaseName, tableName);
        Map partitionActionsOfTable = this.partitionActions.computeIfAbsent(schemaTableName, k -> new HashMap());
        Action oldPartitionAction = (Action)partitionActionsOfTable.get(partitionValues);
        if (oldPartitionAction == null) {
            Partition partition = this.delegate.getPartition(identity, databaseName, tableName, partitionValues).orElseThrow(() -> new PartitionNotFoundException(schemaTableName, partitionValues));
            String partitionName = this.getPartitionName(identity, databaseName, tableName, partitionValues);
            PartitionStatistics currentStatistics = this.delegate.getPartitionStatistics(identity, databaseName, tableName, (Set<String>)ImmutableSet.of((Object)partitionName)).get(partitionName);
            if (currentStatistics == null) {
                throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, "currentStatistics is null");
            }
            HdfsEnvironment.HdfsContext context = new HdfsEnvironment.HdfsContext(session, databaseName, tableName);
            partitionActionsOfTable.put(partitionValues, new Action<PartitionAndMore>(ActionType.INSERT_EXISTING, new PartitionAndMore(identity, partition, currentLocation, Optional.of(fileNames), Statistics.merge(currentStatistics, statisticsUpdate), statisticsUpdate), context, identity));
            return;
        }
        switch (oldPartitionAction.getType()) {
            case DROP: 
            case DROP_PRESERVE_DATA: {
                throw new PartitionNotFoundException(schemaTableName, partitionValues);
            }
            case ADD: 
            case ALTER: 
            case INSERT_EXISTING: {
                throw new UnsupportedOperationException("Inserting into a partition that were added, altered, or inserted into in the same transaction is not supported");
            }
        }
        throw new IllegalStateException("Unknown action type");
    }

    private String getPartitionName(HiveIdentity identity, String databaseName, String tableName, List<String> partitionValues) {
        Table table = this.getTable(identity, databaseName, tableName).orElseThrow(() -> new TableNotFoundException(new SchemaTableName(databaseName, tableName)));
        return this.getPartitionName(table, partitionValues);
    }

    private String getPartitionName(Table table, List<String> partitionValues) {
        List columnNames = (List)table.getPartitionColumns().stream().map(Column::getName).collect(ImmutableList.toImmutableList());
        return FileUtils.makePartName((List)columnNames, partitionValues);
    }

    public synchronized void createRole(String role, String grantor) {
        this.setExclusive((delegate, hdfsEnvironment) -> delegate.createRole(role, grantor));
    }

    public synchronized void dropRole(String role) {
        this.setExclusive((delegate, hdfsEnvironment) -> delegate.dropRole(role));
    }

    public synchronized Set<String> listRoles() {
        this.checkReadable();
        return this.delegate.listRoles();
    }

    public synchronized void grantRoles(Set<String> roles, Set<HivePrincipal> grantees, boolean adminOption, HivePrincipal grantor) {
        this.setExclusive((delegate, hdfsEnvironment) -> delegate.grantRoles(roles, grantees, adminOption, grantor));
    }

    public synchronized void revokeRoles(Set<String> roles, Set<HivePrincipal> grantees, boolean adminOption, HivePrincipal grantor) {
        this.setExclusive((delegate, hdfsEnvironment) -> delegate.revokeRoles(roles, grantees, adminOption, grantor));
    }

    public synchronized Set<RoleGrant> listGrantedPrincipals(String role) {
        this.checkReadable();
        return this.delegate.listGrantedPrincipals(role);
    }

    public synchronized Set<RoleGrant> listRoleGrants(HivePrincipal principal) {
        this.checkReadable();
        return this.delegate.listRoleGrants(principal);
    }

    public synchronized Set<HivePrivilegeInfo> listTablePrivileges(HiveIdentity identity, String databaseName, String tableName, Optional<HivePrincipal> principal) {
        this.checkReadable();
        SchemaTableName schemaTableName = new SchemaTableName(databaseName, tableName);
        Action<TableAndMore> tableAction = this.tableActions.get(schemaTableName);
        if (tableAction == null) {
            return this.delegate.listTablePrivileges(databaseName, tableName, this.getTableOwner(identity, databaseName, tableName), principal);
        }
        switch (tableAction.getType()) {
            case ADD: 
            case ALTER: {
                if (principal.isPresent() && principal.get().getType() == PrincipalType.ROLE) {
                    return ImmutableSet.of();
                }
                String owner = tableAction.getData().getTable().getOwner();
                if (principal.isPresent() && !principal.get().getName().equals(owner)) {
                    return ImmutableSet.of();
                }
                Set privileges = tableAction.getData().getPrincipalPrivileges().getUserPrivileges().get((Object)owner);
                return ImmutableSet.builder().addAll((Iterable)privileges).add((Object)new HivePrivilegeInfo(HivePrivilegeInfo.HivePrivilege.OWNERSHIP, true, new HivePrincipal(PrincipalType.USER, owner), new HivePrincipal(PrincipalType.USER, owner))).build();
            }
            case INSERT_EXISTING: {
                return this.delegate.listTablePrivileges(databaseName, tableName, this.getTableOwner(identity, databaseName, tableName), principal);
            }
            case DROP: {
                throw new TableNotFoundException(schemaTableName);
            }
        }
        throw new IllegalStateException("Unknown action type");
    }

    private String getTableOwner(HiveIdentity identity, String databaseName, String tableName) {
        return this.getExistingTable(identity, databaseName, tableName).getOwner();
    }

    private Table getExistingTable(HiveIdentity identity, String databaseName, String tableName) {
        return this.delegate.getTable(identity, databaseName, tableName).orElseThrow(() -> new TableNotFoundException(new SchemaTableName(databaseName, tableName)));
    }

    public synchronized void grantTablePrivileges(HiveIdentity identity, String databaseName, String tableName, HivePrincipal grantee, Set<HivePrivilegeInfo> privileges) {
        this.setExclusive((delegate, hdfsEnvironment) -> delegate.grantTablePrivileges(databaseName, tableName, this.getTableOwner(identity, databaseName, tableName), grantee, privileges));
    }

    public synchronized void revokeTablePrivileges(HiveIdentity identity, String databaseName, String tableName, HivePrincipal grantee, Set<HivePrivilegeInfo> privileges) {
        this.setExclusive((delegate, hdfsEnvironment) -> delegate.revokeTablePrivileges(databaseName, tableName, this.getTableOwner(identity, databaseName, tableName), grantee, privileges));
    }

    public synchronized void declareIntentionToWrite(ConnectorSession session, LocationHandle.WriteMode writeMode, Path stagingPathRoot, SchemaTableName schemaTableName) {
        Map<List<String>, Action<PartitionAndMore>> partitionActionsOfTable;
        this.setShared();
        if (writeMode == LocationHandle.WriteMode.DIRECT_TO_TARGET_EXISTING_DIRECTORY && (partitionActionsOfTable = this.partitionActions.get(schemaTableName)) != null && !partitionActionsOfTable.isEmpty()) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Cannot insert into a table with a partition that has been modified in the same transaction when Presto is configured to skip temporary directories.");
        }
        HdfsEnvironment.HdfsContext hdfsContext = new HdfsEnvironment.HdfsContext(session, schemaTableName.getSchemaName(), schemaTableName.getTableName());
        HiveIdentity identity = new HiveIdentity(session);
        this.declaredIntentionsToWrite.add(new DeclaredIntentionToWrite(writeMode, hdfsContext, identity, session.getQueryId(), stagingPathRoot, schemaTableName));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void commit() {
        try {
            switch (this.state) {
                case EMPTY: {
                    return;
                }
                case SHARED_OPERATION_BUFFERED: {
                    this.commitShared();
                    return;
                }
                case EXCLUSIVE_OPERATION_BUFFERED: {
                    Objects.requireNonNull(this.bufferedExclusiveOperation, "bufferedExclusiveOperation is null");
                    this.bufferedExclusiveOperation.execute(this.delegate, this.hdfsEnvironment);
                    return;
                }
                case FINISHED: {
                    throw new IllegalStateException("Tried to commit buffered metastore operations after transaction has been committed/aborted");
                }
                default: {
                    throw new IllegalStateException("Unknown state");
                }
            }
        }
        finally {
            this.state = State.FINISHED;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void rollback() {
        try {
            switch (this.state) {
                case EMPTY: 
                case EXCLUSIVE_OPERATION_BUFFERED: {
                    return;
                }
                case SHARED_OPERATION_BUFFERED: {
                    this.rollbackShared();
                    return;
                }
                case FINISHED: {
                    throw new IllegalStateException("Tried to rollback buffered metastore operations after transaction has been committed/aborted");
                }
                default: {
                    throw new IllegalStateException("Unknown state");
                }
            }
        }
        finally {
            this.state = State.FINISHED;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beginQuery(ConnectorSession session) {
        String queryId = session.getQueryId();
        HiveIdentity identity = new HiveIdentity(session);
        SemiTransactionalHiveMetastore semiTransactionalHiveMetastore = this;
        synchronized (semiTransactionalHiveMetastore) {
            Preconditions.checkState((this.currentQueryId.isEmpty() && this.hiveTransactionSupplier.isEmpty() ? 1 : 0) != 0, (String)"Query already begun: %s while starting query %s", this.currentQueryId, (Object)queryId);
            this.currentQueryId = Optional.of(queryId);
            this.hiveTransactionSupplier = Optional.of(() -> {
                long heartbeatInterval = this.configuredTransactionHeartbeatInterval.map(Duration::toMillis).orElseGet(this::getServerExpectedHeartbeatIntervalMillis);
                long transactionId = this.delegate.openTransaction(identity);
                log.debug("Using hive transaction %s for query %s", new Object[]{transactionId, queryId});
                ScheduledFuture<?> heartbeatTask = this.heartbeatExecutor.scheduleAtFixedRate(() -> this.delegate.sendTransactionHeartbeat(identity, transactionId), 0L, heartbeatInterval, TimeUnit.MILLISECONDS);
                return new HiveTransaction(identity, queryId, transactionId, heartbeatTask);
            });
        }
    }

    private long getServerExpectedHeartbeatIntervalMillis() {
        String hiveServerTransactionTimeout = this.delegate.getConfigValue(MetastoreConf.ConfVars.TXN_TIMEOUT.getVarname()).orElseGet(() -> MetastoreConf.ConfVars.TXN_TIMEOUT.getDefaultVal().toString());
        Configuration configuration = new Configuration(false);
        configuration.set(MetastoreConf.ConfVars.TXN_TIMEOUT.toString(), hiveServerTransactionTimeout);
        return MetastoreConf.getTimeVar((Configuration)configuration, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.TXN_TIMEOUT, (TimeUnit)TimeUnit.MILLISECONDS) / 2L;
    }

    public synchronized Optional<ValidTxnWriteIdList> getValidWriteIds(ConnectorSession session, HiveTableHandle tableHandle) {
        String queryId = session.getQueryId();
        Preconditions.checkState((boolean)this.currentQueryId.equals(Optional.of(queryId)), (String)"Invalid query id %s while current query is", (Object)queryId, this.currentQueryId);
        if (!AcidUtils.isTransactionalTable(tableHandle.getTableParameters().orElseThrow(() -> new IllegalStateException("tableParameters missing")))) {
            return Optional.empty();
        }
        if (this.currentHiveTransaction.isEmpty()) {
            this.currentHiveTransaction = Optional.of((HiveTransaction)this.hiveTransactionSupplier.orElseThrow(() -> new IllegalStateException("hiveTransactionSupplier is not set")).get());
        }
        return Optional.of(this.currentHiveTransaction.get().getValidWriteIds(this.delegate, tableHandle));
    }

    public synchronized void cleanupQuery(ConnectorSession session) {
        String queryId = session.getQueryId();
        HiveIdentity identity = new HiveIdentity(session);
        Preconditions.checkState((boolean)this.currentQueryId.equals(Optional.of(queryId)), (String)"Invalid query id %s while current query is", (Object)queryId, this.currentQueryId);
        Optional<HiveTransaction> transaction = this.currentHiveTransaction;
        this.currentQueryId = Optional.empty();
        this.currentHiveTransaction = Optional.empty();
        this.hiveTransactionSupplier = Optional.empty();
        if (transaction.isEmpty()) {
            return;
        }
        long transactionId = transaction.get().getTransactionId();
        ScheduledFuture<?> heartbeatTask = transaction.get().getHeartbeatTask();
        heartbeatTask.cancel(true);
        this.delegate.commitTransaction(identity, transactionId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GuardedBy(value="this")
    private void commitShared() {
        this.checkHoldsLock();
        Committer committer = new Committer();
        try {
            SchemaTableName schemaTableName;
            block18: for (Map.Entry<SchemaTableName, Action<TableAndMore>> entry : this.tableActions.entrySet()) {
                schemaTableName = entry.getKey();
                Action<TableAndMore> action = entry.getValue();
                switch (action.getType()) {
                    case DROP: {
                        committer.prepareDropTable(action.getIdentity(), schemaTableName);
                        continue block18;
                    }
                    case ALTER: {
                        committer.prepareAlterTable(action.getHdfsContext(), action.getIdentity(), action.getData());
                        continue block18;
                    }
                    case ADD: {
                        committer.prepareAddTable(action.getHdfsContext(), action.getData());
                        continue block18;
                    }
                    case INSERT_EXISTING: {
                        committer.prepareInsertExistingTable(action.getHdfsContext(), action.getData());
                        continue block18;
                    }
                }
                throw new IllegalStateException("Unknown action type");
            }
            for (Map.Entry<SchemaTableName, Object> entry : this.partitionActions.entrySet()) {
                schemaTableName = entry.getKey();
                block20: for (Map.Entry partitionEntry : ((Map)entry.getValue()).entrySet()) {
                    List partitionValues = (List)partitionEntry.getKey();
                    Action action = (Action)partitionEntry.getValue();
                    switch (action.getType()) {
                        case DROP: {
                            committer.prepareDropPartition(action.getIdentity(), schemaTableName, partitionValues, true);
                            continue block20;
                        }
                        case DROP_PRESERVE_DATA: {
                            committer.prepareDropPartition(action.getIdentity(), schemaTableName, partitionValues, false);
                            continue block20;
                        }
                        case ALTER: {
                            committer.prepareAlterPartition(action.getHdfsContext(), action.getIdentity(), (PartitionAndMore)action.getData());
                            continue block20;
                        }
                        case ADD: {
                            committer.prepareAddPartition(action.getHdfsContext(), action.getIdentity(), (PartitionAndMore)action.getData());
                            continue block20;
                        }
                        case INSERT_EXISTING: {
                            committer.prepareInsertExistingPartition(action.getHdfsContext(), action.getIdentity(), (PartitionAndMore)action.getData());
                            continue block20;
                        }
                    }
                    throw new IllegalStateException("Unknown action type");
                }
            }
            committer.waitForAsyncRenames();
            committer.executeAddTableOperations();
            committer.executeAlterTableOperations();
            committer.executeAlterPartitionOperations();
            committer.executeAddPartitionOperations();
            committer.executeUpdateStatisticsOperations();
        }
        catch (Throwable t) {
            committer.cancelUnstartedAsyncRenames();
            committer.undoUpdateStatisticsOperations();
            committer.undoAddPartitionOperations();
            committer.undoAddTableOperations();
            committer.waitForAsyncRenamesSuppressThrowables();
            committer.executeCleanupTasksForAbort(this.declaredIntentionsToWrite);
            committer.executeRenameTasksForAbort();
            committer.undoAlterTableOperations();
            committer.undoAlterPartitionOperations();
            this.rollbackShared();
            throw t;
        }
        try {
            committer.executeIrreversibleMetastoreOperations();
        }
        finally {
            committer.executeDeletionTasksForFinish();
            committer.deleteEmptyStagingDirectories(this.declaredIntentionsToWrite);
        }
    }

    @GuardedBy(value="this")
    private void rollbackShared() {
        this.checkHoldsLock();
        block4: for (DeclaredIntentionToWrite declaredIntentionToWrite : this.declaredIntentionsToWrite) {
            switch (declaredIntentionToWrite.getMode()) {
                case STAGE_AND_MOVE_TO_TARGET_DIRECTORY: 
                case DIRECT_TO_TARGET_NEW_DIRECTORY: {
                    if (declaredIntentionToWrite.getMode() == LocationHandle.WriteMode.DIRECT_TO_TARGET_NEW_DIRECTORY && this.skipTargetCleanupOnRollback) break;
                    Path rootPath = declaredIntentionToWrite.getRootPath();
                    this.recursiveDeleteFilesAndLog(declaredIntentionToWrite.getHdfsContext(), rootPath, (Set<String>)ImmutableSet.of((Object)declaredIntentionToWrite.getQueryId()), true, String.format("staging/target_new directory rollback for table %s", declaredIntentionToWrite.getSchemaTableName()));
                    break;
                }
                case DIRECT_TO_TARGET_EXISTING_DIRECTORY: {
                    HashSet<Path> pathsToClean = new HashSet<Path>();
                    Path baseDirectory = declaredIntentionToWrite.getRootPath();
                    pathsToClean.add(baseDirectory);
                    HiveIdentity identity = declaredIntentionToWrite.getIdentity();
                    SchemaTableName schemaTableName = declaredIntentionToWrite.getSchemaTableName();
                    Optional<Table> table = this.delegate.getTable(identity, schemaTableName.getSchemaName(), schemaTableName.getTableName());
                    if (table.isPresent()) {
                        if (!table.get().getPartitionColumns().isEmpty()) {
                            List<String> partitionNames = this.delegate.getPartitionNames(identity, schemaTableName.getSchemaName(), schemaTableName.getTableName()).orElse((List<String>)ImmutableList.of());
                            for (List partitionNameBatch : Iterables.partition(partitionNames, (int)10)) {
                                Collection<Optional<Partition>> partitions = this.delegate.getPartitionsByNames(identity, schemaTableName.getSchemaName(), schemaTableName.getTableName(), partitionNameBatch).values();
                                partitions.stream().filter(Optional::isPresent).map(Optional::get).map(partition -> partition.getStorage().getLocation()).map(Path::new).filter(path -> !SemiTransactionalHiveMetastore.isSameOrParent(baseDirectory, path)).forEach(pathsToClean::add);
                            }
                        }
                    } else {
                        this.logCleanupFailure("Error rolling back write to table %s.%s. Data directory may contain temporary data. Table was dropped in another transaction.", schemaTableName.getSchemaName(), schemaTableName.getTableName());
                    }
                    for (Path path2 : pathsToClean) {
                        this.recursiveDeleteFilesAndLog(declaredIntentionToWrite.getHdfsContext(), path2, (Set<String>)ImmutableSet.of((Object)declaredIntentionToWrite.getQueryId()), false, String.format("target_existing directory rollback for table %s", schemaTableName));
                    }
                    continue block4;
                }
                default: {
                    throw new UnsupportedOperationException("Unknown write mode");
                }
            }
        }
    }

    @VisibleForTesting
    public synchronized void testOnlyCheckIsReadOnly() {
        if (this.state != State.EMPTY) {
            throw new AssertionError((Object)"Test did not commit or rollback");
        }
    }

    @VisibleForTesting
    public void testOnlyThrowOnCleanupFailures() {
        this.throwOnCleanupFailure = true;
    }

    @GuardedBy(value="this")
    private void checkReadable() {
        this.checkHoldsLock();
        switch (this.state) {
            case EMPTY: 
            case SHARED_OPERATION_BUFFERED: {
                return;
            }
            case EXCLUSIVE_OPERATION_BUFFERED: {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Unsupported combination of operations in a single transaction");
            }
            case FINISHED: {
                throw new IllegalStateException("Tried to access metastore after transaction has been committed/aborted");
            }
        }
    }

    @GuardedBy(value="this")
    private void setShared() {
        this.checkHoldsLock();
        this.checkReadable();
        this.state = State.SHARED_OPERATION_BUFFERED;
    }

    @GuardedBy(value="this")
    private void setExclusive(ExclusiveOperation exclusiveOperation) {
        this.checkHoldsLock();
        if (this.state != State.EMPTY) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Unsupported combination of operations in a single transaction");
        }
        this.state = State.EXCLUSIVE_OPERATION_BUFFERED;
        this.bufferedExclusiveOperation = exclusiveOperation;
    }

    @GuardedBy(value="this")
    private void checkNoPartitionAction(String databaseName, String tableName) {
        this.checkHoldsLock();
        Map<List<String>, Action<PartitionAndMore>> partitionActionsOfTable = this.partitionActions.get(new SchemaTableName(databaseName, tableName));
        if (partitionActionsOfTable != null && !partitionActionsOfTable.isEmpty()) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Cannot make schema changes to a table/view with modified partitions in the same transaction");
        }
    }

    private static boolean isSameOrParent(Path parent, Path child) {
        int childDepth;
        int parentDepth = parent.depth();
        if (parentDepth > (childDepth = child.depth())) {
            return false;
        }
        for (int i = childDepth; i > parentDepth; --i) {
            child = child.getParent();
        }
        return parent.equals((Object)child);
    }

    private void logCleanupFailure(String format, Object ... args) {
        if (this.throwOnCleanupFailure) {
            throw new RuntimeException(String.format(format, args));
        }
        log.warn(format, args);
    }

    private void logCleanupFailure(Throwable t, String format, Object ... args) {
        if (this.throwOnCleanupFailure) {
            throw new RuntimeException(String.format(format, args), t);
        }
        log.warn(t, format, args);
    }

    private static void asyncRename(HdfsEnvironment hdfsEnvironment, Executor executor, AtomicBoolean cancelled, List<CompletableFuture<?>> fileRenameFutures, HdfsEnvironment.HdfsContext context, Path currentPath, Path targetPath, List<String> fileNames) {
        FileSystem fileSystem;
        try {
            fileSystem = hdfsEnvironment.getFileSystem(context, currentPath);
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_FILESYSTEM_ERROR, String.format("Error moving data files to final location. Error listing directory %s", currentPath), (Throwable)e);
        }
        for (String fileName : fileNames) {
            Path source = new Path(currentPath, fileName);
            Path target = new Path(targetPath, fileName);
            fileRenameFutures.add(CompletableFuture.runAsync(() -> {
                if (cancelled.get()) {
                    return;
                }
                try {
                    if (fileSystem.exists(target) || !fileSystem.rename(source, target)) {
                        throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_FILESYSTEM_ERROR, String.format("Error moving data files from %s to final location %s", source, target));
                    }
                }
                catch (IOException e) {
                    throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_FILESYSTEM_ERROR, String.format("Error moving data files from %s to final location %s", source, target), (Throwable)e);
                }
            }, executor));
        }
    }

    private void recursiveDeleteFilesAndLog(HdfsEnvironment.HdfsContext context, Path directory, Set<String> queryIds, boolean deleteEmptyDirectories, String reason) {
        RecursiveDeleteResult recursiveDeleteResult = SemiTransactionalHiveMetastore.recursiveDeleteFiles(this.hdfsEnvironment, context, directory, queryIds, deleteEmptyDirectories);
        if (!recursiveDeleteResult.getNotDeletedEligibleItems().isEmpty()) {
            this.logCleanupFailure("Error deleting directory %s for %s. Some eligible items cannot be deleted: %s.", directory.toString(), reason, recursiveDeleteResult.getNotDeletedEligibleItems());
        } else if (deleteEmptyDirectories && !recursiveDeleteResult.isDirectoryNoLongerExists()) {
            this.logCleanupFailure("Error deleting directory %s for %s. Cannot delete the directory.", directory.toString(), reason);
        }
    }

    private static RecursiveDeleteResult recursiveDeleteFiles(HdfsEnvironment hdfsEnvironment, HdfsEnvironment.HdfsContext context, Path directory, Set<String> queryIds, boolean deleteEmptyDirectories) {
        FileSystem fileSystem;
        try {
            fileSystem = hdfsEnvironment.getFileSystem(context, directory);
            if (!fileSystem.exists(directory)) {
                return new RecursiveDeleteResult(true, (List<String>)ImmutableList.of());
            }
        }
        catch (IOException e) {
            ImmutableList.Builder notDeletedItems = ImmutableList.builder();
            notDeletedItems.add((Object)(directory.toString() + "/**"));
            return new RecursiveDeleteResult(false, (List<String>)notDeletedItems.build());
        }
        return SemiTransactionalHiveMetastore.doRecursiveDeleteFiles(fileSystem, directory, queryIds, deleteEmptyDirectories);
    }

    private static RecursiveDeleteResult doRecursiveDeleteFiles(FileSystem fileSystem, Path directory, Set<String> queryIds, boolean deleteEmptyDirectories) {
        FileStatus[] allFiles;
        if (directory.getName().startsWith(".presto")) {
            return new RecursiveDeleteResult(false, (List<String>)ImmutableList.of());
        }
        try {
            allFiles = fileSystem.listStatus(directory);
        }
        catch (IOException e) {
            ImmutableList.Builder notDeletedItems = ImmutableList.builder();
            notDeletedItems.add((Object)(directory.toString() + "/**"));
            return new RecursiveDeleteResult(false, (List<String>)notDeletedItems.build());
        }
        boolean allDescendentsDeleted = true;
        ImmutableList.Builder notDeletedEligibleItems = ImmutableList.builder();
        for (FileStatus fileStatus : allFiles) {
            if (fileStatus.isFile()) {
                Path filePath = fileStatus.getPath();
                String fileName = filePath.getName();
                boolean eligible = false;
                if (!fileName.startsWith(".presto")) {
                    eligible = queryIds.stream().anyMatch(id -> fileName.startsWith((String)id) || fileName.endsWith((String)id));
                }
                if (eligible) {
                    if (SemiTransactionalHiveMetastore.deleteIfExists(fileSystem, filePath, false)) continue;
                    allDescendentsDeleted = false;
                    notDeletedEligibleItems.add((Object)filePath.toString());
                    continue;
                }
                allDescendentsDeleted = false;
                continue;
            }
            if (fileStatus.isDirectory()) {
                RecursiveDeleteResult subResult = SemiTransactionalHiveMetastore.doRecursiveDeleteFiles(fileSystem, fileStatus.getPath(), queryIds, deleteEmptyDirectories);
                if (!subResult.isDirectoryNoLongerExists()) {
                    allDescendentsDeleted = false;
                }
                if (subResult.getNotDeletedEligibleItems().isEmpty()) continue;
                notDeletedEligibleItems.addAll(subResult.getNotDeletedEligibleItems());
                continue;
            }
            allDescendentsDeleted = false;
            notDeletedEligibleItems.add((Object)fileStatus.getPath().toString());
        }
        if (allDescendentsDeleted && deleteEmptyDirectories) {
            Verify.verify((boolean)notDeletedEligibleItems.build().isEmpty());
            if (!SemiTransactionalHiveMetastore.deleteIfExists(fileSystem, directory, false)) {
                return new RecursiveDeleteResult(false, (List<String>)ImmutableList.of((Object)(directory.toString() + "/")));
            }
            return new RecursiveDeleteResult(true, (List<String>)ImmutableList.of());
        }
        return new RecursiveDeleteResult(false, (List<String>)notDeletedEligibleItems.build());
    }

    private static boolean deleteIfExists(FileSystem fileSystem, Path path, boolean recursive) {
        try {
            if (fileSystem.delete(path, recursive)) {
                return true;
            }
            return !fileSystem.exists(path);
        }
        catch (FileNotFoundException ignored) {
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    private static boolean deleteRecursivelyIfExists(HdfsEnvironment.HdfsContext context, HdfsEnvironment hdfsEnvironment, Path path) {
        FileSystem fileSystem;
        try {
            fileSystem = hdfsEnvironment.getFileSystem(context, path);
        }
        catch (IOException ignored) {
            return false;
        }
        return SemiTransactionalHiveMetastore.deleteIfExists(fileSystem, path, true);
    }

    private static void renameDirectory(HdfsEnvironment.HdfsContext context, HdfsEnvironment hdfsEnvironment, Path source, Path target, Runnable runWhenPathDoesntExist) {
        if (HiveWriteUtils.pathExists(context, hdfsEnvironment, target)) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_PATH_ALREADY_EXISTS, String.format("Unable to rename from %s to %s: target directory already exists", source, target));
        }
        if (!HiveWriteUtils.pathExists(context, hdfsEnvironment, target.getParent())) {
            HiveWriteUtils.createDirectory(context, hdfsEnvironment, target.getParent());
        }
        runWhenPathDoesntExist.run();
        try {
            if (!hdfsEnvironment.getFileSystem(context, source).rename(source, target)) {
                throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_FILESYSTEM_ERROR, String.format("Failed to rename %s to %s: rename returned false", source, target));
            }
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_FILESYSTEM_ERROR, String.format("Failed to rename %s to %s", source, target), (Throwable)e);
        }
    }

    private static Optional<String> getPrestoQueryId(Table table) {
        return Optional.ofNullable(table.getParameters().get("presto_query_id"));
    }

    private static Optional<String> getPrestoQueryId(Partition partition) {
        return Optional.ofNullable(partition.getParameters().get("presto_query_id"));
    }

    private void checkHoldsLock() {
        if (!Thread.holdsLock(this)) {
            throw new IllegalStateException(String.format("Thread must hold a lock on the %s", this.getClass().getSimpleName()));
        }
    }

    private static interface ExclusiveOperation {
        public void execute(HiveMetastoreClosure var1, HdfsEnvironment var2);
    }

    private static class RecursiveDeleteResult {
        private final boolean directoryNoLongerExists;
        private final List<String> notDeletedEligibleItems;

        public RecursiveDeleteResult(boolean directoryNoLongerExists, List<String> notDeletedEligibleItems) {
            this.directoryNoLongerExists = directoryNoLongerExists;
            this.notDeletedEligibleItems = notDeletedEligibleItems;
        }

        public boolean isDirectoryNoLongerExists() {
            return this.directoryNoLongerExists;
        }

        public List<String> getNotDeletedEligibleItems() {
            return this.notDeletedEligibleItems;
        }
    }

    private static class PartitionAdder {
        private final HiveIdentity identity;
        private final String schemaName;
        private final String tableName;
        private final HiveMetastoreClosure metastore;
        private final int batchSize;
        private final List<PartitionWithStatistics> partitions;
        private List<List<String>> createdPartitionValues = new ArrayList<List<String>>();

        public PartitionAdder(HiveIdentity identity, String schemaName, String tableName, HiveMetastoreClosure metastore, int batchSize) {
            this.identity = identity;
            this.schemaName = schemaName;
            this.tableName = tableName;
            this.metastore = metastore;
            this.batchSize = batchSize;
            this.partitions = new ArrayList<PartitionWithStatistics>(batchSize);
        }

        public String getSchemaName() {
            return this.schemaName;
        }

        public String getTableName() {
            return this.tableName;
        }

        public void addPartition(PartitionWithStatistics partition) {
            Preconditions.checkArgument((boolean)SemiTransactionalHiveMetastore.getPrestoQueryId(partition.getPartition()).isPresent());
            this.partitions.add(partition);
        }

        public void execute() {
            List batchedPartitions = Lists.partition(this.partitions, (int)this.batchSize);
            for (List batch : batchedPartitions) {
                try {
                    this.metastore.addPartitions(this.identity, this.schemaName, this.tableName, batch);
                    for (PartitionWithStatistics partition : batch) {
                        this.createdPartitionValues.add(partition.getPartition().getValues());
                    }
                }
                catch (Throwable t) {
                    boolean batchCompletelyAdded = true;
                    for (PartitionWithStatistics partition : batch) {
                        try {
                            Optional<Partition> remotePartition = this.metastore.getPartition(this.identity, this.schemaName, this.tableName, partition.getPartition().getValues());
                            if (remotePartition.isPresent() && SemiTransactionalHiveMetastore.getPrestoQueryId(remotePartition.get()).equals(SemiTransactionalHiveMetastore.getPrestoQueryId(partition.getPartition()))) {
                                this.createdPartitionValues.add(partition.getPartition().getValues());
                                continue;
                            }
                            batchCompletelyAdded = false;
                        }
                        catch (Throwable ignored) {
                            batchCompletelyAdded = false;
                        }
                    }
                    if (batchCompletelyAdded) continue;
                    if (t instanceof TableNotFoundException) {
                        throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_TABLE_DROPPED_DURING_QUERY, t);
                    }
                    throw t;
                }
            }
            this.partitions.clear();
        }

        public List<List<String>> rollback() {
            ArrayList<List<String>> partitionsFailedToRollback = new ArrayList<List<String>>();
            for (List<String> createdPartitionValue : this.createdPartitionValues) {
                try {
                    this.metastore.dropPartition(this.identity, this.schemaName, this.tableName, createdPartitionValue, false);
                }
                catch (PartitionNotFoundException partitionNotFoundException) {
                }
                catch (Throwable t) {
                    partitionsFailedToRollback.add(createdPartitionValue);
                }
            }
            this.createdPartitionValues = partitionsFailedToRollback;
            return partitionsFailedToRollback;
        }
    }

    private static class UpdateStatisticsOperation {
        private final HiveIdentity identity;
        private final SchemaTableName tableName;
        private final Optional<String> partitionName;
        private final PartitionStatistics statistics;
        private final boolean merge;
        private boolean done;

        public UpdateStatisticsOperation(HiveIdentity identity, SchemaTableName tableName, Optional<String> partitionName, PartitionStatistics statistics, boolean merge) {
            this.identity = Objects.requireNonNull(identity, "identity is null");
            this.tableName = Objects.requireNonNull(tableName, "tableName is null");
            this.partitionName = Objects.requireNonNull(partitionName, "partitionValues is null");
            this.statistics = Objects.requireNonNull(statistics, "statistics is null");
            this.merge = merge;
        }

        public void run(HiveMetastoreClosure metastore) {
            if (this.partitionName.isPresent()) {
                metastore.updatePartitionStatistics(this.identity, this.tableName.getSchemaName(), this.tableName.getTableName(), this.partitionName.get(), this::updateStatistics);
            } else {
                metastore.updateTableStatistics(this.identity, this.tableName.getSchemaName(), this.tableName.getTableName(), this::updateStatistics);
            }
            this.done = true;
        }

        public void undo(HiveMetastoreClosure metastore) {
            if (!this.done) {
                return;
            }
            if (this.partitionName.isPresent()) {
                metastore.updatePartitionStatistics(this.identity, this.tableName.getSchemaName(), this.tableName.getTableName(), this.partitionName.get(), this::resetStatistics);
            } else {
                metastore.updateTableStatistics(this.identity, this.tableName.getSchemaName(), this.tableName.getTableName(), this::resetStatistics);
            }
        }

        public String getDescription() {
            if (this.partitionName.isPresent()) {
                return String.format("replace partition parameters %s %s", this.tableName, this.partitionName.get());
            }
            return String.format("replace table parameters %s", this.tableName);
        }

        private PartitionStatistics updateStatistics(PartitionStatistics currentStatistics) {
            return this.merge ? Statistics.merge(currentStatistics, this.statistics) : this.statistics;
        }

        private PartitionStatistics resetStatistics(PartitionStatistics currentStatistics) {
            return new PartitionStatistics(Statistics.reduce(currentStatistics.getBasicStatistics(), this.statistics.getBasicStatistics(), Statistics.ReduceOperator.SUBTRACT), (Map<String, HiveColumnStatistics>)ImmutableMap.of());
        }
    }

    private static class AlterPartitionOperation {
        private final HiveIdentity identity;
        private final PartitionWithStatistics newPartition;
        private final PartitionWithStatistics oldPartition;
        private boolean undo;

        public AlterPartitionOperation(HiveIdentity identity, PartitionWithStatistics newPartition, PartitionWithStatistics oldPartition) {
            this.identity = Objects.requireNonNull(identity, "identity is null");
            this.newPartition = Objects.requireNonNull(newPartition, "newPartition is null");
            this.oldPartition = Objects.requireNonNull(oldPartition, "oldPartition is null");
            Preconditions.checkArgument((boolean)newPartition.getPartition().getDatabaseName().equals(oldPartition.getPartition().getDatabaseName()));
            Preconditions.checkArgument((boolean)newPartition.getPartition().getTableName().equals(oldPartition.getPartition().getTableName()));
            Preconditions.checkArgument((boolean)newPartition.getPartition().getValues().equals(oldPartition.getPartition().getValues()));
        }

        public String getDescription() {
            return String.format("alter partition %s.%s %s", this.newPartition.getPartition().getDatabaseName(), this.newPartition.getPartition().getTableName(), this.newPartition.getPartition().getValues());
        }

        public void run(HiveMetastoreClosure metastore) {
            this.undo = true;
            metastore.alterPartition(this.identity, this.newPartition.getPartition().getDatabaseName(), this.newPartition.getPartition().getTableName(), this.newPartition);
        }

        public void undo(HiveMetastoreClosure metastore) {
            if (!this.undo) {
                return;
            }
            metastore.alterPartition(this.identity, this.oldPartition.getPartition().getDatabaseName(), this.oldPartition.getPartition().getTableName(), this.oldPartition);
        }
    }

    private static class AlterTableOperation {
        private final HiveIdentity identity;
        private final Table newTable;
        private final Table oldTable;
        private final PrincipalPrivileges principalPrivileges;
        private boolean undo;

        public AlterTableOperation(HiveIdentity identity, Table newTable, Table oldTable, PrincipalPrivileges principalPrivileges) {
            this.identity = Objects.requireNonNull(identity, "identity is null");
            this.newTable = Objects.requireNonNull(newTable, "newTable is null");
            this.oldTable = Objects.requireNonNull(oldTable, "oldTable is null");
            this.principalPrivileges = Objects.requireNonNull(principalPrivileges, "principalPrivileges is null");
            Preconditions.checkArgument((boolean)newTable.getDatabaseName().equals(oldTable.getDatabaseName()));
            Preconditions.checkArgument((boolean)newTable.getTableName().equals(oldTable.getTableName()));
        }

        public String getDescription() {
            return String.format("alter table %s.%s", this.newTable.getDatabaseName(), this.newTable.getTableName());
        }

        public void run(HiveMetastoreClosure metastore) {
            this.undo = true;
            metastore.replaceTable(this.identity, this.newTable.getDatabaseName(), this.newTable.getTableName(), this.newTable, this.principalPrivileges);
        }

        public void undo(HiveMetastoreClosure metastore) {
            if (!this.undo) {
                return;
            }
            metastore.replaceTable(this.identity, this.oldTable.getDatabaseName(), this.oldTable.getTableName(), this.oldTable, this.principalPrivileges);
        }
    }

    private static class CreateTableOperation {
        private final HiveIdentity identity;
        private final Table newTable;
        private final PrincipalPrivileges privileges;
        private boolean tableCreated;
        private final boolean ignoreExisting;
        private final String queryId;

        public CreateTableOperation(HiveIdentity identity, Table newTable, PrincipalPrivileges privileges, boolean ignoreExisting) {
            this.identity = Objects.requireNonNull(identity, "identity is null");
            Objects.requireNonNull(newTable, "newTable is null");
            this.newTable = newTable;
            this.privileges = Objects.requireNonNull(privileges, "privileges is null");
            this.ignoreExisting = ignoreExisting;
            this.queryId = SemiTransactionalHiveMetastore.getPrestoQueryId(newTable).orElseThrow(() -> new IllegalArgumentException("Query id is not present"));
        }

        public String getDescription() {
            return String.format("add table %s.%s", this.newTable.getDatabaseName(), this.newTable.getTableName());
        }

        public void run(HiveMetastoreClosure metastore) {
            block9: {
                boolean done = false;
                try {
                    metastore.createTable(this.identity, this.newTable, this.privileges);
                    done = true;
                }
                catch (RuntimeException e2) {
                    PrestoException e2;
                    try {
                        Optional<Table> existingTable = metastore.getTable(this.identity, this.newTable.getDatabaseName(), this.newTable.getTableName());
                        if (existingTable.isPresent()) {
                            Table table = existingTable.get();
                            Optional<String> existingTableQueryId = SemiTransactionalHiveMetastore.getPrestoQueryId(table);
                            if (existingTableQueryId.isPresent() && existingTableQueryId.get().equals(this.queryId)) {
                                done = true;
                            } else if (!this.hasTheSameSchema(this.newTable, table)) {
                                e2 = new PrestoException((ErrorCodeSupplier)StandardErrorCode.TRANSACTION_CONFLICT, String.format("Table already exists with a different schema: '%s'", this.newTable.getTableName()));
                            } else {
                                done = this.ignoreExisting;
                            }
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        // empty catch block
                    }
                    if (done) break block9;
                    throw e2;
                }
            }
            this.tableCreated = true;
        }

        private boolean hasTheSameSchema(Table newTable, Table existingTable) {
            List<Column> newTableColumns = newTable.getDataColumns();
            List<Column> existingTableColumns = existingTable.getDataColumns();
            if (newTableColumns.size() != existingTableColumns.size()) {
                return false;
            }
            for (Column existingColumn : existingTableColumns) {
                if (!newTableColumns.stream().noneMatch(newColumn -> newColumn.getName().equals(existingColumn.getName()) && newColumn.getType().equals(existingColumn.getType()))) continue;
                return false;
            }
            return true;
        }

        public void undo(HiveMetastoreClosure metastore) {
            if (!this.tableCreated) {
                return;
            }
            metastore.dropTable(this.identity, this.newTable.getDatabaseName(), this.newTable.getTableName(), false);
        }
    }

    private static class IrreversibleMetastoreOperation {
        private final String description;
        private final Runnable action;

        public IrreversibleMetastoreOperation(String description, Runnable action) {
            this.description = Objects.requireNonNull(description, "description is null");
            this.action = Objects.requireNonNull(action, "action is null");
        }

        public String getDescription() {
            return this.description;
        }

        public void run() {
            this.action.run();
        }
    }

    private static class DirectoryRenameTask {
        private final HdfsEnvironment.HdfsContext context;
        private final Path renameFrom;
        private final Path renameTo;

        public DirectoryRenameTask(HdfsEnvironment.HdfsContext context, Path renameFrom, Path renameTo) {
            this.context = Objects.requireNonNull(context, "context is null");
            this.renameFrom = Objects.requireNonNull(renameFrom, "renameFrom is null");
            this.renameTo = Objects.requireNonNull(renameTo, "renameTo is null");
        }

        public HdfsEnvironment.HdfsContext getContext() {
            return this.context;
        }

        public Path getRenameFrom() {
            return this.renameFrom;
        }

        public Path getRenameTo() {
            return this.renameTo;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("context", (Object)this.context).add("renameFrom", (Object)this.renameFrom).add("renameTo", (Object)this.renameTo).toString();
        }
    }

    private static class DirectoryDeletionTask {
        private final HdfsEnvironment.HdfsContext context;
        private final Path path;

        public DirectoryDeletionTask(HdfsEnvironment.HdfsContext context, Path path) {
            this.context = context;
            this.path = path;
        }

        public HdfsEnvironment.HdfsContext getContext() {
            return this.context;
        }

        public Path getPath() {
            return this.path;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("context", (Object)this.context).add("path", (Object)this.path).toString();
        }
    }

    private static class DirectoryCleanUpTask {
        private final HdfsEnvironment.HdfsContext context;
        private final Path path;
        private final boolean deleteEmptyDirectory;

        public DirectoryCleanUpTask(HdfsEnvironment.HdfsContext context, Path path, boolean deleteEmptyDirectory) {
            this.context = context;
            this.path = path;
            this.deleteEmptyDirectory = deleteEmptyDirectory;
        }

        public HdfsEnvironment.HdfsContext getContext() {
            return this.context;
        }

        public Path getPath() {
            return this.path;
        }

        public boolean isDeleteEmptyDirectory() {
            return this.deleteEmptyDirectory;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("context", (Object)this.context).add("path", (Object)this.path).add("deleteEmptyDirectory", this.deleteEmptyDirectory).toString();
        }
    }

    private static class DeclaredIntentionToWrite {
        private final LocationHandle.WriteMode mode;
        private final HdfsEnvironment.HdfsContext hdfsContext;
        private final HiveIdentity identity;
        private final String queryId;
        private final Path rootPath;
        private final SchemaTableName schemaTableName;

        public DeclaredIntentionToWrite(LocationHandle.WriteMode mode, HdfsEnvironment.HdfsContext hdfsContext, HiveIdentity identity, String queryId, Path stagingPathRoot, SchemaTableName schemaTableName) {
            this.mode = Objects.requireNonNull(mode, "mode is null");
            this.hdfsContext = Objects.requireNonNull(hdfsContext, "hdfsContext is null");
            this.identity = Objects.requireNonNull(identity, "identity is null");
            this.queryId = Objects.requireNonNull(queryId, "queryId is null");
            this.rootPath = Objects.requireNonNull(stagingPathRoot, "stagingPathRoot is null");
            this.schemaTableName = Objects.requireNonNull(schemaTableName, "schemaTableName is null");
        }

        public LocationHandle.WriteMode getMode() {
            return this.mode;
        }

        public HdfsEnvironment.HdfsContext getHdfsContext() {
            return this.hdfsContext;
        }

        public HiveIdentity getIdentity() {
            return this.identity;
        }

        public String getQueryId() {
            return this.queryId;
        }

        public Path getRootPath() {
            return this.rootPath;
        }

        public SchemaTableName getSchemaTableName() {
            return this.schemaTableName;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("mode", (Object)this.mode).add("hdfsContext", (Object)this.hdfsContext).add("identity", (Object)this.identity).add("queryId", (Object)this.queryId).add("rootPath", (Object)this.rootPath).add("schemaTableName", (Object)this.schemaTableName).toString();
        }
    }

    private static class PartitionAndMore {
        private final HiveIdentity identity;
        private final Partition partition;
        private final Path currentLocation;
        private final Optional<List<String>> fileNames;
        private final PartitionStatistics statistics;
        private final PartitionStatistics statisticsUpdate;

        public PartitionAndMore(HiveIdentity identity, Partition partition, Path currentLocation, Optional<List<String>> fileNames, PartitionStatistics statistics, PartitionStatistics statisticsUpdate) {
            this.identity = Objects.requireNonNull(identity, "identity is null");
            this.partition = Objects.requireNonNull(partition, "partition is null");
            this.currentLocation = Objects.requireNonNull(currentLocation, "currentLocation is null");
            this.fileNames = Objects.requireNonNull(fileNames, "fileNames is null");
            this.statistics = Objects.requireNonNull(statistics, "statistics is null");
            this.statisticsUpdate = Objects.requireNonNull(statisticsUpdate, "statisticsUpdate is null");
        }

        public HiveIdentity getIdentity() {
            return this.identity;
        }

        public Partition getPartition() {
            return this.partition;
        }

        public Path getCurrentLocation() {
            return this.currentLocation;
        }

        public List<String> getFileNames() {
            Preconditions.checkState((boolean)this.fileNames.isPresent());
            return this.fileNames.get();
        }

        public PartitionStatistics getStatistics() {
            return this.statistics;
        }

        public PartitionStatistics getStatisticsUpdate() {
            return this.statisticsUpdate;
        }

        public Partition getAugmentedPartitionForInTransactionRead() {
            Partition partition = this.partition;
            String currentLocation = this.currentLocation.toString();
            if (!currentLocation.equals(partition.getStorage().getLocation())) {
                partition = Partition.builder(partition).withStorage(storage -> storage.setLocation(currentLocation)).build();
            }
            return partition;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("partition", (Object)this.partition).add("currentLocation", (Object)this.currentLocation).add("fileNames", this.fileNames).toString();
        }
    }

    private static class TableAndMore {
        private final Table table;
        private final HiveIdentity identity;
        private final Optional<PrincipalPrivileges> principalPrivileges;
        private final Optional<Path> currentLocation;
        private final Optional<List<String>> fileNames;
        private final boolean ignoreExisting;
        private final PartitionStatistics statistics;
        private final PartitionStatistics statisticsUpdate;

        public TableAndMore(Table table, HiveIdentity identity, Optional<PrincipalPrivileges> principalPrivileges, Optional<Path> currentLocation, Optional<List<String>> fileNames, boolean ignoreExisting, PartitionStatistics statistics, PartitionStatistics statisticsUpdate) {
            this.table = Objects.requireNonNull(table, "table is null");
            this.identity = Objects.requireNonNull(identity, "identity is null");
            this.principalPrivileges = Objects.requireNonNull(principalPrivileges, "principalPrivileges is null");
            this.currentLocation = Objects.requireNonNull(currentLocation, "currentLocation is null");
            this.fileNames = Objects.requireNonNull(fileNames, "fileNames is null");
            this.ignoreExisting = ignoreExisting;
            this.statistics = Objects.requireNonNull(statistics, "statistics is null");
            this.statisticsUpdate = Objects.requireNonNull(statisticsUpdate, "statisticsUpdate is null");
            Preconditions.checkArgument((!table.getStorage().getLocation().isEmpty() || currentLocation.isEmpty() ? 1 : 0) != 0, (Object)"currentLocation cannot be supplied for table without location");
            Preconditions.checkArgument((fileNames.isEmpty() || currentLocation.isPresent() ? 1 : 0) != 0, (Object)"fileNames can be supplied only when currentLocation is supplied");
        }

        public boolean isIgnoreExisting() {
            return this.ignoreExisting;
        }

        public Table getTable() {
            return this.table;
        }

        public HiveIdentity getIdentity() {
            return this.identity;
        }

        public PrincipalPrivileges getPrincipalPrivileges() {
            Preconditions.checkState((boolean)this.principalPrivileges.isPresent());
            return this.principalPrivileges.get();
        }

        public Optional<Path> getCurrentLocation() {
            return this.currentLocation;
        }

        public Optional<List<String>> getFileNames() {
            return this.fileNames;
        }

        public PartitionStatistics getStatistics() {
            return this.statistics;
        }

        public PartitionStatistics getStatisticsUpdate() {
            return this.statisticsUpdate;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("table", (Object)this.table).add("principalPrivileges", this.principalPrivileges).add("currentLocation", this.currentLocation).add("fileNames", this.fileNames).add("ignoreExisting", this.ignoreExisting).add("statistics", (Object)this.statistics).add("statisticsUpdate", (Object)this.statisticsUpdate).toString();
        }
    }

    public static class Action<T> {
        private final ActionType type;
        private final T data;
        private final HdfsEnvironment.HdfsContext hdfsContext;
        private final HiveIdentity identity;

        public Action(ActionType type, T data, HdfsEnvironment.HdfsContext hdfsContext, HiveIdentity identity) {
            this.type = Objects.requireNonNull(type, "type is null");
            if (type == ActionType.DROP || type == ActionType.DROP_PRESERVE_DATA) {
                Preconditions.checkArgument((data == null ? 1 : 0) != 0, (Object)"data is not null");
            } else {
                Objects.requireNonNull(data, "data is null");
            }
            this.data = data;
            this.hdfsContext = Objects.requireNonNull(hdfsContext, "hdfsContext is null");
            this.identity = Objects.requireNonNull(identity, "identity is null");
        }

        public ActionType getType() {
            return this.type;
        }

        public T getData() {
            Preconditions.checkState((this.type != ActionType.DROP ? 1 : 0) != 0);
            return this.data;
        }

        public HdfsEnvironment.HdfsContext getHdfsContext() {
            return this.hdfsContext;
        }

        public HiveIdentity getIdentity() {
            return this.identity;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("type", (Object)this.type).add("data", this.data).toString();
        }
    }

    private static enum TableSource {
        CREATED_IN_THIS_TRANSACTION,
        PRE_EXISTING_TABLE;

    }

    private static enum ActionType {
        DROP,
        DROP_PRESERVE_DATA,
        ADD,
        ALTER,
        INSERT_EXISTING;

    }

    private static enum State {
        EMPTY,
        SHARED_OPERATION_BUFFERED,
        EXCLUSIVE_OPERATION_BUFFERED,
        FINISHED;

    }

    private class Committer {
        private final AtomicBoolean fileRenameCancelled = new AtomicBoolean(false);
        private final List<CompletableFuture<?>> fileRenameFutures = new ArrayList();
        private final List<DirectoryDeletionTask> deletionTasksForFinish = new ArrayList<DirectoryDeletionTask>();
        private final List<DirectoryCleanUpTask> cleanUpTasksForAbort = new ArrayList<DirectoryCleanUpTask>();
        private final List<DirectoryRenameTask> renameTasksForAbort = new ArrayList<DirectoryRenameTask>();
        private final List<CreateTableOperation> addTableOperations = new ArrayList<CreateTableOperation>();
        private final List<AlterTableOperation> alterTableOperations = new ArrayList<AlterTableOperation>();
        private final Map<SchemaTableName, PartitionAdder> partitionAdders = new HashMap<SchemaTableName, PartitionAdder>();
        private final List<AlterPartitionOperation> alterPartitionOperations = new ArrayList<AlterPartitionOperation>();
        private final List<UpdateStatisticsOperation> updateStatisticsOperations = new ArrayList<UpdateStatisticsOperation>();
        private final List<IrreversibleMetastoreOperation> metastoreDeleteOperations = new ArrayList<IrreversibleMetastoreOperation>();
        private boolean deleteOnly = true;

        private Committer() {
        }

        private void prepareDropTable(HiveIdentity identity, SchemaTableName schemaTableName) {
            this.metastoreDeleteOperations.add(new IrreversibleMetastoreOperation(String.format("drop table %s", schemaTableName), () -> SemiTransactionalHiveMetastore.this.delegate.dropTable(identity, schemaTableName.getSchemaName(), schemaTableName.getTableName(), true)));
        }

        private void prepareAlterTable(HdfsEnvironment.HdfsContext hdfsContext, HiveIdentity identity, TableAndMore tableAndMore) {
            this.deleteOnly = false;
            Table table = tableAndMore.getTable();
            String targetLocation = table.getStorage().getLocation();
            Table oldTable = SemiTransactionalHiveMetastore.this.delegate.getTable(identity, table.getDatabaseName(), table.getTableName()).orElseThrow(() -> new PrestoException((ErrorCodeSupplier)StandardErrorCode.TRANSACTION_CONFLICT, "The table that this transaction modified was deleted in another transaction. " + table.getSchemaTableName()));
            String oldTableLocation = oldTable.getStorage().getLocation();
            Path oldTablePath = new Path(oldTableLocation);
            if (targetLocation.equals(oldTableLocation)) {
                String queryId = hdfsContext.getQueryId().orElseThrow(() -> new IllegalArgumentException("query ID not present"));
                Path oldTableStagingPath = new Path(oldTablePath.getParent(), "_temp_" + oldTablePath.getName() + "_" + queryId);
                SemiTransactionalHiveMetastore.renameDirectory(hdfsContext, SemiTransactionalHiveMetastore.this.hdfsEnvironment, oldTablePath, oldTableStagingPath, () -> this.renameTasksForAbort.add(new DirectoryRenameTask(hdfsContext, oldTableStagingPath, oldTablePath)));
                if (!SemiTransactionalHiveMetastore.this.skipDeletionForAlter) {
                    this.deletionTasksForFinish.add(new DirectoryDeletionTask(hdfsContext, oldTableStagingPath));
                }
            } else if (!SemiTransactionalHiveMetastore.this.skipDeletionForAlter) {
                this.deletionTasksForFinish.add(new DirectoryDeletionTask(hdfsContext, oldTablePath));
            }
            Path currentPath = tableAndMore.getCurrentLocation().orElseThrow(() -> new IllegalArgumentException("location should be present for alter table"));
            Path targetPath = new Path(targetLocation);
            if (!targetPath.equals((Object)currentPath)) {
                SemiTransactionalHiveMetastore.renameDirectory(hdfsContext, SemiTransactionalHiveMetastore.this.hdfsEnvironment, currentPath, targetPath, () -> this.cleanUpTasksForAbort.add(new DirectoryCleanUpTask(hdfsContext, targetPath, true)));
            }
            this.alterTableOperations.add(new AlterTableOperation(tableAndMore.getIdentity(), tableAndMore.getTable(), oldTable, tableAndMore.getPrincipalPrivileges()));
            this.updateStatisticsOperations.add(new UpdateStatisticsOperation(tableAndMore.getIdentity(), table.getSchemaTableName(), Optional.empty(), tableAndMore.getStatisticsUpdate(), false));
        }

        private void prepareAddTable(HdfsEnvironment.HdfsContext context, TableAndMore tableAndMore) {
            this.deleteOnly = false;
            Table table = tableAndMore.getTable();
            if (table.getTableType().equals(TableType.MANAGED_TABLE.name())) {
                String targetLocation = table.getStorage().getLocation();
                Preconditions.checkArgument((!targetLocation.isEmpty() ? 1 : 0) != 0, (Object)"target location is empty");
                Optional<Path> currentPath = tableAndMore.getCurrentLocation();
                Path targetPath = new Path(targetLocation);
                if (table.getPartitionColumns().isEmpty() && currentPath.isPresent()) {
                    if (!targetPath.equals((Object)currentPath.get())) {
                        SemiTransactionalHiveMetastore.renameDirectory(context, SemiTransactionalHiveMetastore.this.hdfsEnvironment, currentPath.get(), targetPath, () -> this.cleanUpTasksForAbort.add(new DirectoryCleanUpTask(context, targetPath, true)));
                    }
                } else if (HiveWriteUtils.pathExists(context, SemiTransactionalHiveMetastore.this.hdfsEnvironment, targetPath)) {
                    if (!currentPath.isPresent() || !currentPath.get().equals((Object)targetPath)) {
                        throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_PATH_ALREADY_EXISTS, String.format("Unable to create directory %s: target directory already exists", targetPath));
                    }
                } else {
                    this.cleanUpTasksForAbort.add(new DirectoryCleanUpTask(context, targetPath, true));
                    HiveWriteUtils.createDirectory(context, SemiTransactionalHiveMetastore.this.hdfsEnvironment, targetPath);
                }
            }
            this.addTableOperations.add(new CreateTableOperation(tableAndMore.getIdentity(), table, tableAndMore.getPrincipalPrivileges(), tableAndMore.isIgnoreExisting()));
            if (!HiveUtil.isPrestoView(table)) {
                this.updateStatisticsOperations.add(new UpdateStatisticsOperation(tableAndMore.getIdentity(), table.getSchemaTableName(), Optional.empty(), tableAndMore.getStatisticsUpdate(), false));
            }
        }

        private void prepareInsertExistingTable(HdfsEnvironment.HdfsContext context, TableAndMore tableAndMore) {
            this.deleteOnly = false;
            Table table = tableAndMore.getTable();
            Path targetPath = new Path(table.getStorage().getLocation());
            Path currentPath = tableAndMore.getCurrentLocation().get();
            this.cleanUpTasksForAbort.add(new DirectoryCleanUpTask(context, targetPath, false));
            if (!targetPath.equals((Object)currentPath)) {
                SemiTransactionalHiveMetastore.asyncRename(SemiTransactionalHiveMetastore.this.hdfsEnvironment, SemiTransactionalHiveMetastore.this.renameExecutor, this.fileRenameCancelled, this.fileRenameFutures, context, currentPath, targetPath, tableAndMore.getFileNames().get());
            }
            this.updateStatisticsOperations.add(new UpdateStatisticsOperation(tableAndMore.getIdentity(), table.getSchemaTableName(), Optional.empty(), tableAndMore.getStatisticsUpdate(), true));
        }

        private void prepareDropPartition(HiveIdentity identity, SchemaTableName schemaTableName, List<String> partitionValues, boolean deleteData) {
            this.metastoreDeleteOperations.add(new IrreversibleMetastoreOperation(String.format("drop partition %s.%s %s", schemaTableName.getSchemaName(), schemaTableName.getTableName(), partitionValues), () -> SemiTransactionalHiveMetastore.this.delegate.dropPartition(identity, schemaTableName.getSchemaName(), schemaTableName.getTableName(), partitionValues, deleteData)));
        }

        private void prepareAlterPartition(HdfsEnvironment.HdfsContext hdfsContext, HiveIdentity identity, PartitionAndMore partitionAndMore) {
            this.deleteOnly = false;
            Partition partition = partitionAndMore.getPartition();
            String targetLocation = partition.getStorage().getLocation();
            Optional<Partition> oldPartition = SemiTransactionalHiveMetastore.this.delegate.getPartition(identity, partition.getDatabaseName(), partition.getTableName(), partition.getValues());
            if (oldPartition.isEmpty()) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.TRANSACTION_CONFLICT, String.format("The partition that this transaction modified was deleted in another transaction. %s %s", partition.getTableName(), partition.getValues()));
            }
            String partitionName = SemiTransactionalHiveMetastore.this.getPartitionName(identity, partition.getDatabaseName(), partition.getTableName(), partition.getValues());
            PartitionStatistics oldPartitionStatistics = this.getExistingPartitionStatistics(identity, partition, partitionName);
            String oldPartitionLocation = oldPartition.get().getStorage().getLocation();
            Path oldPartitionPath = new Path(oldPartitionLocation);
            if (targetLocation.equals(oldPartitionLocation)) {
                String queryId = hdfsContext.getQueryId().orElseThrow(() -> new IllegalArgumentException("query ID not present"));
                Path oldPartitionStagingPath = new Path(oldPartitionPath.getParent(), "_temp_" + oldPartitionPath.getName() + "_" + queryId);
                SemiTransactionalHiveMetastore.renameDirectory(hdfsContext, SemiTransactionalHiveMetastore.this.hdfsEnvironment, oldPartitionPath, oldPartitionStagingPath, () -> this.renameTasksForAbort.add(new DirectoryRenameTask(hdfsContext, oldPartitionStagingPath, oldPartitionPath)));
                if (!SemiTransactionalHiveMetastore.this.skipDeletionForAlter) {
                    this.deletionTasksForFinish.add(new DirectoryDeletionTask(hdfsContext, oldPartitionStagingPath));
                }
            } else if (!SemiTransactionalHiveMetastore.this.skipDeletionForAlter) {
                this.deletionTasksForFinish.add(new DirectoryDeletionTask(hdfsContext, oldPartitionPath));
            }
            Path currentPath = partitionAndMore.getCurrentLocation();
            Path targetPath = new Path(targetLocation);
            if (!targetPath.equals((Object)currentPath)) {
                SemiTransactionalHiveMetastore.renameDirectory(hdfsContext, SemiTransactionalHiveMetastore.this.hdfsEnvironment, currentPath, targetPath, () -> this.cleanUpTasksForAbort.add(new DirectoryCleanUpTask(hdfsContext, targetPath, true)));
            }
            this.alterPartitionOperations.add(new AlterPartitionOperation(partitionAndMore.getIdentity(), new PartitionWithStatistics(partition, partitionName, partitionAndMore.getStatisticsUpdate()), new PartitionWithStatistics(oldPartition.get(), partitionName, oldPartitionStatistics)));
        }

        private PartitionStatistics getExistingPartitionStatistics(HiveIdentity identity, Partition partition, String partitionName) {
            try {
                PartitionStatistics statistics = SemiTransactionalHiveMetastore.this.delegate.getPartitionStatistics(identity, partition.getDatabaseName(), partition.getTableName(), (Set<String>)ImmutableSet.of((Object)partitionName)).get(partitionName);
                if (statistics == null) {
                    throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.TRANSACTION_CONFLICT, String.format("The partition that this transaction modified was deleted in another transaction. %s %s", partition.getTableName(), partition.getValues()));
                }
                return statistics;
            }
            catch (PrestoException e) {
                if (e.getErrorCode().equals((Object)HiveErrorCode.HIVE_CORRUPTED_COLUMN_STATISTICS.toErrorCode())) {
                    log.warn((Throwable)e, "Corrupted statistics found when altering partition. Table: %s.%s. Partition: %s", new Object[]{partition.getDatabaseName(), partition.getTableName(), partition.getValues()});
                    return PartitionStatistics.empty();
                }
                throw e;
            }
        }

        private void prepareAddPartition(HdfsEnvironment.HdfsContext hdfsContext, HiveIdentity identity, PartitionAndMore partitionAndMore) {
            this.deleteOnly = false;
            Partition partition = partitionAndMore.getPartition();
            String targetLocation = partition.getStorage().getLocation();
            Path currentPath = partitionAndMore.getCurrentLocation();
            Path targetPath = new Path(targetLocation);
            PartitionAdder partitionAdder = this.partitionAdders.computeIfAbsent(partition.getSchemaTableName(), ignored -> new PartitionAdder(partitionAndMore.getIdentity(), partition.getDatabaseName(), partition.getTableName(), SemiTransactionalHiveMetastore.this.delegate, 8));
            if (HiveWriteUtils.pathExists(hdfsContext, SemiTransactionalHiveMetastore.this.hdfsEnvironment, currentPath)) {
                if (!targetPath.equals((Object)currentPath)) {
                    SemiTransactionalHiveMetastore.renameDirectory(hdfsContext, SemiTransactionalHiveMetastore.this.hdfsEnvironment, currentPath, targetPath, () -> this.cleanUpTasksForAbort.add(new DirectoryCleanUpTask(hdfsContext, targetPath, true)));
                }
            } else {
                this.cleanUpTasksForAbort.add(new DirectoryCleanUpTask(hdfsContext, targetPath, true));
                HiveWriteUtils.createDirectory(hdfsContext, SemiTransactionalHiveMetastore.this.hdfsEnvironment, targetPath);
            }
            String partitionName = SemiTransactionalHiveMetastore.this.getPartitionName(identity, partition.getDatabaseName(), partition.getTableName(), partition.getValues());
            partitionAdder.addPartition(new PartitionWithStatistics(partition, partitionName, partitionAndMore.getStatisticsUpdate()));
        }

        private void prepareInsertExistingPartition(HdfsEnvironment.HdfsContext hdfsContext, HiveIdentity identity, PartitionAndMore partitionAndMore) {
            this.deleteOnly = false;
            Partition partition = partitionAndMore.getPartition();
            Path targetPath = new Path(partition.getStorage().getLocation());
            Path currentPath = partitionAndMore.getCurrentLocation();
            this.cleanUpTasksForAbort.add(new DirectoryCleanUpTask(hdfsContext, targetPath, false));
            if (!targetPath.equals((Object)currentPath)) {
                SemiTransactionalHiveMetastore.asyncRename(SemiTransactionalHiveMetastore.this.hdfsEnvironment, SemiTransactionalHiveMetastore.this.renameExecutor, this.fileRenameCancelled, this.fileRenameFutures, hdfsContext, currentPath, targetPath, partitionAndMore.getFileNames());
            }
            this.updateStatisticsOperations.add(new UpdateStatisticsOperation(partitionAndMore.getIdentity(), partition.getSchemaTableName(), Optional.of(SemiTransactionalHiveMetastore.this.getPartitionName(identity, partition.getDatabaseName(), partition.getTableName(), partition.getValues())), partitionAndMore.getStatisticsUpdate(), true));
        }

        private void executeCleanupTasksForAbort(Collection<DeclaredIntentionToWrite> declaredIntentionsToWrite) {
            Set queryIds = (Set)declaredIntentionsToWrite.stream().map(DeclaredIntentionToWrite::getQueryId).collect(ImmutableSet.toImmutableSet());
            for (DirectoryCleanUpTask cleanUpTask : this.cleanUpTasksForAbort) {
                SemiTransactionalHiveMetastore.this.recursiveDeleteFilesAndLog(cleanUpTask.getContext(), cleanUpTask.getPath(), queryIds, cleanUpTask.isDeleteEmptyDirectory(), "temporary directory commit abort");
            }
        }

        private void executeDeletionTasksForFinish() {
            for (DirectoryDeletionTask deletionTask : this.deletionTasksForFinish) {
                if (SemiTransactionalHiveMetastore.deleteRecursivelyIfExists(deletionTask.getContext(), SemiTransactionalHiveMetastore.this.hdfsEnvironment, deletionTask.getPath())) continue;
                SemiTransactionalHiveMetastore.this.logCleanupFailure("Error deleting directory %s", deletionTask.getPath().toString());
            }
        }

        private void executeRenameTasksForAbort() {
            for (DirectoryRenameTask directoryRenameTask : this.renameTasksForAbort) {
                try {
                    if (!HiveWriteUtils.pathExists(directoryRenameTask.getContext(), SemiTransactionalHiveMetastore.this.hdfsEnvironment, directoryRenameTask.getRenameFrom())) continue;
                    SemiTransactionalHiveMetastore.renameDirectory(directoryRenameTask.getContext(), SemiTransactionalHiveMetastore.this.hdfsEnvironment, directoryRenameTask.getRenameFrom(), directoryRenameTask.getRenameTo(), () -> {});
                }
                catch (Throwable throwable) {
                    SemiTransactionalHiveMetastore.this.logCleanupFailure(throwable, "failed to undo rename of partition directory: %s to %s", directoryRenameTask.getRenameFrom(), directoryRenameTask.getRenameTo());
                }
            }
        }

        private void deleteEmptyStagingDirectories(List<DeclaredIntentionToWrite> declaredIntentionsToWrite) {
            for (DeclaredIntentionToWrite declaredIntentionToWrite : declaredIntentionsToWrite) {
                if (declaredIntentionToWrite.getMode() != LocationHandle.WriteMode.STAGE_AND_MOVE_TO_TARGET_DIRECTORY) continue;
                Path path = declaredIntentionToWrite.getRootPath();
                SemiTransactionalHiveMetastore.this.recursiveDeleteFilesAndLog(declaredIntentionToWrite.getHdfsContext(), path, (Set<String>)ImmutableSet.of(), true, "staging directory cleanup");
            }
        }

        private void waitForAsyncRenames() {
            for (CompletableFuture<?> fileRenameFuture : this.fileRenameFutures) {
                MoreFutures.getFutureValue(fileRenameFuture, PrestoException.class);
            }
        }

        private void waitForAsyncRenamesSuppressThrowables() {
            for (CompletableFuture<?> future : this.fileRenameFutures) {
                try {
                    future.get();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                catch (Throwable throwable) {}
            }
        }

        private void cancelUnstartedAsyncRenames() {
            this.fileRenameCancelled.set(true);
        }

        private void executeAddTableOperations() {
            for (CreateTableOperation addTableOperation : this.addTableOperations) {
                addTableOperation.run(SemiTransactionalHiveMetastore.this.delegate);
            }
        }

        private void executeAlterTableOperations() {
            for (AlterTableOperation alterTableOperation : this.alterTableOperations) {
                alterTableOperation.run(SemiTransactionalHiveMetastore.this.delegate);
            }
        }

        private void executeAlterPartitionOperations() {
            for (AlterPartitionOperation alterPartitionOperation : this.alterPartitionOperations) {
                alterPartitionOperation.run(SemiTransactionalHiveMetastore.this.delegate);
            }
        }

        private void executeAddPartitionOperations() {
            for (PartitionAdder partitionAdder : this.partitionAdders.values()) {
                partitionAdder.execute();
            }
        }

        private void executeUpdateStatisticsOperations() {
            for (UpdateStatisticsOperation operation : this.updateStatisticsOperations) {
                operation.run(SemiTransactionalHiveMetastore.this.delegate);
            }
        }

        private void undoAddPartitionOperations() {
            for (PartitionAdder partitionAdder : this.partitionAdders.values()) {
                List<List<String>> partitionsFailedToRollback = partitionAdder.rollback();
                if (partitionsFailedToRollback.isEmpty()) continue;
                SemiTransactionalHiveMetastore.this.logCleanupFailure("Failed to rollback: add_partition for partitions %s.%s %s", partitionAdder.getSchemaName(), partitionAdder.getTableName(), partitionsFailedToRollback.stream());
            }
        }

        private void undoAddTableOperations() {
            for (CreateTableOperation addTableOperation : this.addTableOperations) {
                try {
                    addTableOperation.undo(SemiTransactionalHiveMetastore.this.delegate);
                }
                catch (Throwable throwable) {
                    SemiTransactionalHiveMetastore.this.logCleanupFailure(throwable, "failed to rollback: %s", addTableOperation.getDescription());
                }
            }
        }

        private void undoAlterTableOperations() {
            for (AlterTableOperation alterTableOperation : this.alterTableOperations) {
                try {
                    alterTableOperation.undo(SemiTransactionalHiveMetastore.this.delegate);
                }
                catch (Throwable throwable) {
                    SemiTransactionalHiveMetastore.this.logCleanupFailure(throwable, "failed to rollback: %s", alterTableOperation.getDescription());
                }
            }
        }

        private void undoAlterPartitionOperations() {
            for (AlterPartitionOperation alterPartitionOperation : this.alterPartitionOperations) {
                try {
                    alterPartitionOperation.undo(SemiTransactionalHiveMetastore.this.delegate);
                }
                catch (Throwable throwable) {
                    SemiTransactionalHiveMetastore.this.logCleanupFailure(throwable, "failed to rollback: %s", alterPartitionOperation.getDescription());
                }
            }
        }

        private void undoUpdateStatisticsOperations() {
            for (UpdateStatisticsOperation operation : this.updateStatisticsOperations) {
                try {
                    operation.undo(SemiTransactionalHiveMetastore.this.delegate);
                }
                catch (Throwable throwable) {
                    SemiTransactionalHiveMetastore.this.logCleanupFailure(throwable, "failed to rollback: %s", operation.getDescription());
                }
            }
        }

        private void executeIrreversibleMetastoreOperations() {
            ArrayList failedIrreversibleOperationDescriptions = new ArrayList();
            ArrayList suppressedExceptions = new ArrayList();
            AtomicBoolean anySucceeded = new AtomicBoolean(false);
            ImmutableList.Builder dropFutures = ImmutableList.builder();
            for (IrreversibleMetastoreOperation irreversibleMetastoreOperation : this.metastoreDeleteOperations) {
                dropFutures.add(CompletableFuture.runAsync(() -> {
                    try {
                        irreversibleMetastoreOperation.run();
                        anySucceeded.set(true);
                    }
                    catch (Throwable t) {
                        List list = failedIrreversibleOperationDescriptions;
                        synchronized (list) {
                            failedIrreversibleOperationDescriptions.add(irreversibleMetastoreOperation.getDescription());
                            if (suppressedExceptions.size() < 5) {
                                suppressedExceptions.add(t);
                            }
                        }
                    }
                }, SemiTransactionalHiveMetastore.this.dropExecutor));
            }
            for (CompletableFuture dropFuture : dropFutures.build()) {
                MoreFutures.getFutureValue((Future)dropFuture);
            }
            if (!suppressedExceptions.isEmpty()) {
                StringBuilder message = new StringBuilder();
                if (this.deleteOnly && !anySucceeded.get()) {
                    message.append("The following metastore delete operations failed: ");
                } else {
                    message.append("The transaction didn't commit cleanly. All operations other than the following delete operations were completed: ");
                }
                Joiner.on((String)"; ").appendTo(message, failedIrreversibleOperationDescriptions);
                PrestoException prestoException = new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, message.toString());
                suppressedExceptions.forEach(prestoException::addSuppressed);
                throw prestoException;
            }
        }
    }
}

