/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.metastore.file;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableMap;
import io.prestosql.plugin.hive.metastore.Database;
import io.prestosql.spi.security.PrincipalType;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class DatabaseMetadata {
    private final String ownerName;
    private final PrincipalType ownerType;
    private final Optional<String> comment;
    private final Map<String, String> parameters;

    @JsonCreator
    public DatabaseMetadata(@JsonProperty(value="ownerName") String ownerName, @JsonProperty(value="ownerType") PrincipalType ownerType, @JsonProperty(value="comment") Optional<String> comment, @JsonProperty(value="parameters") Map<String, String> parameters) {
        this.ownerName = Objects.requireNonNull(ownerName, "ownerName is null");
        this.ownerType = Objects.requireNonNull(ownerType, "ownerType is null");
        this.comment = Objects.requireNonNull(comment, "comment is null");
        this.parameters = ImmutableMap.copyOf(Objects.requireNonNull(parameters, "parameters is null"));
    }

    public DatabaseMetadata(Database database) {
        this.ownerName = database.getOwnerName();
        this.ownerType = database.getOwnerType();
        this.comment = database.getComment();
        this.parameters = database.getParameters();
    }

    @JsonProperty
    public String getOwnerName() {
        return this.ownerName;
    }

    @JsonProperty
    public PrincipalType getOwnerType() {
        return this.ownerType;
    }

    @JsonProperty
    public Optional<String> getComment() {
        return this.comment;
    }

    @JsonProperty
    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public Database toDatabase(String databaseName, String location) {
        return Database.builder().setDatabaseName(databaseName).setLocation(Optional.of(location)).setOwnerName(this.ownerName).setOwnerType(this.ownerType).setParameters(this.parameters).build();
    }
}

