/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.metastore.thrift;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Ticker;
import com.google.common.collect.ImmutableList;
import com.google.common.net.HostAndPort;
import io.airlift.units.Duration;
import io.prestosql.plugin.hive.metastore.thrift.FailureAwareThriftMetastoreClient;
import io.prestosql.plugin.hive.metastore.thrift.MetastoreLocator;
import io.prestosql.plugin.hive.metastore.thrift.StaticMetastoreConfig;
import io.prestosql.plugin.hive.metastore.thrift.ThriftMetastoreAuthenticationConfig;
import io.prestosql.plugin.hive.metastore.thrift.ThriftMetastoreClient;
import io.prestosql.plugin.hive.metastore.thrift.ThriftMetastoreClientFactory;
import java.net.URI;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.apache.thrift.TException;

public class StaticMetastoreLocator
implements MetastoreLocator {
    private final List<HostAndPort> addresses;
    private final List<Backoff> backoffs;
    private final ThriftMetastoreClientFactory clientFactory;
    private final String metastoreUsername;

    @Inject
    public StaticMetastoreLocator(StaticMetastoreConfig config, ThriftMetastoreAuthenticationConfig authenticationConfig, ThriftMetastoreClientFactory clientFactory) {
        this(config.getMetastoreUris(), config.getMetastoreUsername(), clientFactory);
        Preconditions.checkArgument((Strings.isNullOrEmpty((String)this.metastoreUsername) || authenticationConfig.getAuthenticationType() == ThriftMetastoreAuthenticationConfig.ThriftMetastoreAuthenticationType.NONE ? 1 : 0) != 0, (String)"%s cannot be used together with %s authentication", (Object)"hive.metastore.username", (Object)((Object)authenticationConfig.getAuthenticationType()));
    }

    public StaticMetastoreLocator(List<URI> metastoreUris, @Nullable String metastoreUsername, ThriftMetastoreClientFactory clientFactory) {
        Objects.requireNonNull(metastoreUris, "metastoreUris is null");
        Preconditions.checkArgument((!metastoreUris.isEmpty() ? 1 : 0) != 0, (Object)"metastoreUris must specify at least one URI");
        this.addresses = metastoreUris.stream().map(StaticMetastoreLocator::checkMetastoreUri).map(uri -> HostAndPort.fromParts((String)uri.getHost(), (int)uri.getPort())).collect(Collectors.toList());
        this.backoffs = (List)IntStream.range(0, this.addresses.size()).mapToObj(ignore -> new Backoff()).collect(ImmutableList.toImmutableList());
        this.metastoreUsername = metastoreUsername;
        this.clientFactory = Objects.requireNonNull(clientFactory, "clientFactory is null");
    }

    @Override
    public ThriftMetastoreClient createMetastoreClient(Optional<String> delegationToken) throws TException {
        List indices = (List)this.backoffs.stream().sorted(Comparator.comparingLong(Backoff::getBackoffDuration)).map(this.backoffs::indexOf).collect(ImmutableList.toImmutableList());
        TException lastException = null;
        Iterator iterator = indices.iterator();
        while (iterator.hasNext()) {
            int index = (Integer)iterator.next();
            try {
                return this.getClient(this.addresses.get(index), this.backoffs.get(index), delegationToken);
            }
            catch (TException e) {
                lastException = e;
            }
        }
        throw new TException("Failed connecting to Hive metastore: " + this.addresses, lastException);
    }

    private ThriftMetastoreClient getClient(HostAndPort address, final Backoff backoff, Optional<String> delegationToken) throws TException {
        FailureAwareThriftMetastoreClient client = new FailureAwareThriftMetastoreClient(this.clientFactory.create(address, delegationToken), new FailureAwareThriftMetastoreClient.Callback(){

            @Override
            public void success() {
                backoff.success();
            }

            @Override
            public void failed(TException e) {
                backoff.fail();
            }
        });
        if (!Strings.isNullOrEmpty((String)this.metastoreUsername)) {
            client.setUGI(this.metastoreUsername);
        }
        return client;
    }

    private static URI checkMetastoreUri(URI uri) {
        Objects.requireNonNull(uri, "metastoreUri is null");
        String scheme = uri.getScheme();
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)scheme) ? 1 : 0) != 0, (String)"metastoreUri scheme is missing: %s", (Object)uri);
        Preconditions.checkArgument((boolean)scheme.equals("thrift"), (String)"metastoreUri scheme must be thrift: %s", (Object)uri);
        Preconditions.checkArgument((uri.getHost() != null ? 1 : 0) != 0, (String)"metastoreUri host is missing: %s", (Object)uri);
        Preconditions.checkArgument((uri.getPort() != -1 ? 1 : 0) != 0, (String)"metastoreUri port is missing: %s", (Object)uri);
        return uri;
    }

    private static class Backoff {
        private static final long MIN_BACKOFF = new Duration(50.0, TimeUnit.MILLISECONDS).roundTo(TimeUnit.NANOSECONDS);
        private static final long MAX_BACKOFF = new Duration(60.0, TimeUnit.SECONDS).roundTo(TimeUnit.NANOSECONDS);
        private final Ticker ticker = Ticker.systemTicker();
        private long backoffDuration = MIN_BACKOFF;
        private OptionalLong lastFailureTimestamps = OptionalLong.empty();

        private Backoff() {
        }

        synchronized void fail() {
            this.lastFailureTimestamps = OptionalLong.of(this.ticker.read());
            this.backoffDuration = Math.min(this.backoffDuration * 2L, MAX_BACKOFF);
        }

        synchronized void success() {
            this.lastFailureTimestamps = OptionalLong.empty();
            this.backoffDuration = MIN_BACKOFF;
        }

        synchronized long getBackoffDuration() {
            if (this.lastFailureTimestamps.isPresent()) {
                long timeSinceLastFail = this.ticker.read() - this.lastFailureTimestamps.getAsLong();
                return Math.max(this.backoffDuration - timeSinceLastFail, 0L);
            }
            return 0L;
        }
    }
}

