/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.orc;

import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import io.prestosql.memory.context.AggregatedMemoryContext;
import io.prestosql.orc.OrcColumn;
import io.prestosql.orc.OrcDataSource;
import io.prestosql.orc.OrcDataSourceId;
import io.prestosql.orc.OrcPredicate;
import io.prestosql.orc.OrcReader;
import io.prestosql.orc.OrcReaderOptions;
import io.prestosql.orc.OrcRecordReader;
import io.prestosql.plugin.hive.FileFormatDataSourceStats;
import io.prestosql.plugin.hive.HdfsEnvironment;
import io.prestosql.plugin.hive.HiveErrorCode;
import io.prestosql.plugin.hive.orc.HdfsOrcDataSource;
import io.prestosql.plugin.hive.orc.OrcPageSource;
import io.prestosql.plugin.hive.orc.OrcPageSourceFactory;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.Page;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.connector.ConnectorPageSource;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.IntegerType;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.BlockMissingException;
import org.joda.time.DateTimeZone;

public class OrcDeleteDeltaPageSource
implements ConnectorPageSource {
    private final OrcRecordReader recordReader;
    private final OrcDataSource orcDataSource;
    private final FileFormatDataSourceStats stats;
    private final AggregatedMemoryContext systemMemoryContext = AggregatedMemoryContext.newSimpleAggregatedMemoryContext();
    private boolean closed;

    public OrcDeleteDeltaPageSource(Path path, long fileSize, OrcReaderOptions options, String sessionUser, Configuration configuration, HdfsEnvironment hdfsEnvironment, FileFormatDataSourceStats stats) {
        this.stats = Objects.requireNonNull(stats, "stats is null");
        try {
            FileSystem fileSystem = hdfsEnvironment.getFileSystem(sessionUser, path, configuration);
            FSDataInputStream inputStream = hdfsEnvironment.doAs(sessionUser, () -> fileSystem.open(path));
            this.orcDataSource = new HdfsOrcDataSource(new OrcDataSourceId(path.toString()), fileSize, options, inputStream, stats);
        }
        catch (Exception e) {
            if (Strings.nullToEmpty((String)e.getMessage()).trim().equals("Filesystem closed") || e instanceof FileNotFoundException) {
                throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CANNOT_OPEN_SPLIT, (Throwable)e);
            }
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CANNOT_OPEN_SPLIT, OrcDeleteDeltaPageSource.openError(e, path), (Throwable)e);
        }
        try {
            OrcReader reader = new OrcReader(this.orcDataSource, options);
            OrcPageSourceFactory.verifyAcidSchema(reader, path);
            ImmutableMap acidColumns = Maps.uniqueIndex((Iterable)reader.getRootColumn().getNestedColumns(), orcColumn -> orcColumn.getColumnName().toLowerCase(Locale.ENGLISH));
            ImmutableList rowIdColumns = ImmutableList.of((Object)((OrcColumn)acidColumns.get("originalTransaction".toLowerCase(Locale.ENGLISH))), (Object)((OrcColumn)acidColumns.get("bucket".toLowerCase(Locale.ENGLISH))), (Object)((OrcColumn)acidColumns.get("rowId".toLowerCase(Locale.ENGLISH))));
            this.recordReader = reader.createRecordReader((List)rowIdColumns, (List)ImmutableList.of((Object)BigintType.BIGINT, (Object)IntegerType.INTEGER, (Object)BigintType.BIGINT), OrcPredicate.TRUE, 0L, fileSize, DateTimeZone.UTC, this.systemMemoryContext, 1024, exception -> OrcPageSource.handleException(this.orcDataSource.getId(), exception));
        }
        catch (Exception e) {
            try {
                this.orcDataSource.close();
            }
            catch (IOException ex) {
                e.addSuppressed(ex);
            }
            if (e instanceof PrestoException) {
                throw (PrestoException)((Object)e);
            }
            String message = OrcDeleteDeltaPageSource.openError(e, path);
            if (e instanceof BlockMissingException) {
                throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_MISSING_DATA, message, (Throwable)e);
            }
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CANNOT_OPEN_SPLIT, message, (Throwable)e);
        }
    }

    public long getCompletedBytes() {
        return this.orcDataSource.getReadBytes();
    }

    public long getReadTimeNanos() {
        return this.orcDataSource.getReadTimeNanos();
    }

    public boolean isFinished() {
        return this.closed;
    }

    public Page getNextPage() {
        try {
            Page page = this.recordReader.nextPage();
            if (page == null) {
                this.close();
            }
            return page;
        }
        catch (IOException | RuntimeException e) {
            this.closeWithSuppression(e);
            throw OrcPageSource.handleException(this.orcDataSource.getId(), e);
        }
    }

    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        try {
            this.stats.addMaxCombinedBytesPerRow(this.recordReader.getMaxCombinedBytesPerRow());
            this.recordReader.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("orcDataSource", (Object)this.orcDataSource.getId()).toString();
    }

    public long getSystemMemoryUsage() {
        return this.systemMemoryContext.getBytes();
    }

    private void closeWithSuppression(Throwable throwable) {
        block2: {
            Objects.requireNonNull(throwable, "throwable is null");
            try {
                this.close();
            }
            catch (RuntimeException e) {
                if (throwable == e) break block2;
                throwable.addSuppressed(e);
            }
        }
    }

    private static String openError(Throwable t, Path path) {
        return String.format("Error opening Hive delete delta file %s: %s", path, t.getMessage());
    }
}

