/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.orc;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import io.prestosql.memory.context.AggregatedMemoryContext;
import io.prestosql.orc.OrcColumn;
import io.prestosql.orc.OrcDataSource;
import io.prestosql.orc.OrcDataSourceId;
import io.prestosql.orc.OrcPredicate;
import io.prestosql.orc.OrcReader;
import io.prestosql.orc.OrcReaderOptions;
import io.prestosql.orc.OrcRecordReader;
import io.prestosql.orc.TupleDomainOrcPredicate;
import io.prestosql.orc.metadata.OrcType;
import io.prestosql.plugin.hive.AcidInfo;
import io.prestosql.plugin.hive.FileFormatDataSourceStats;
import io.prestosql.plugin.hive.HdfsEnvironment;
import io.prestosql.plugin.hive.HiveColumnHandle;
import io.prestosql.plugin.hive.HiveColumnProjectionInfo;
import io.prestosql.plugin.hive.HiveErrorCode;
import io.prestosql.plugin.hive.HivePageSourceFactory;
import io.prestosql.plugin.hive.HiveSessionProperties;
import io.prestosql.plugin.hive.ReaderProjections;
import io.prestosql.plugin.hive.orc.HdfsOrcDataSource;
import io.prestosql.plugin.hive.orc.OrcDeleteDeltaPageSourceFactory;
import io.prestosql.plugin.hive.orc.OrcDeletedRows;
import io.prestosql.plugin.hive.orc.OrcPageSource;
import io.prestosql.plugin.hive.orc.OrcReaderConfig;
import io.prestosql.plugin.hive.util.HiveUtil;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.connector.ConnectorPageSource;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.connector.FixedPageSource;
import io.prestosql.spi.predicate.Domain;
import io.prestosql.spi.predicate.TupleDomain;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.IntegerType;
import io.prestosql.spi.type.Type;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.BlockMissingException;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.io.orc.OrcSerde;
import org.joda.time.DateTimeZone;

public class OrcPageSourceFactory
implements HivePageSourceFactory {
    public static final String ACID_COLUMN_OPERATION = "operation";
    public static final String ACID_COLUMN_ORIGINAL_TRANSACTION = "originalTransaction";
    public static final String ACID_COLUMN_BUCKET = "bucket";
    public static final String ACID_COLUMN_ROW_ID = "rowId";
    public static final String ACID_COLUMN_CURRENT_TRANSACTION = "currentTransaction";
    public static final String ACID_COLUMN_ROW_STRUCT = "row";
    private static final Pattern DEFAULT_HIVE_COLUMN_NAME_PATTERN = Pattern.compile("_col\\d+");
    private final OrcReaderOptions orcReaderOptions;
    private final HdfsEnvironment hdfsEnvironment;
    private final FileFormatDataSourceStats stats;

    @Inject
    public OrcPageSourceFactory(OrcReaderConfig config, HdfsEnvironment hdfsEnvironment, FileFormatDataSourceStats stats) {
        this(config.toOrcReaderOptions(), hdfsEnvironment, stats);
    }

    public OrcPageSourceFactory(OrcReaderOptions orcReaderOptions, HdfsEnvironment hdfsEnvironment, FileFormatDataSourceStats stats) {
        this.orcReaderOptions = Objects.requireNonNull(orcReaderOptions, "orcReaderOptions is null");
        this.hdfsEnvironment = Objects.requireNonNull(hdfsEnvironment, "hdfsEnvironment is null");
        this.stats = Objects.requireNonNull(stats, "stats is null");
    }

    @Override
    public Optional<HivePageSourceFactory.ReaderPageSourceWithProjections> createPageSource(Configuration configuration, ConnectorSession session, Path path, long start, long length, long fileSize, Properties schema, List<HiveColumnHandle> columns, TupleDomain<HiveColumnHandle> effectivePredicate, DateTimeZone hiveStorageTimeZone, Optional<AcidInfo> acidInfo) {
        if (!HiveUtil.isDeserializerClass(schema, OrcSerde.class)) {
            return Optional.empty();
        }
        if (fileSize == 0L) {
            HivePageSourceFactory.ReaderPageSourceWithProjections context = HivePageSourceFactory.ReaderPageSourceWithProjections.noProjectionAdaptation((ConnectorPageSource)new FixedPageSource((Iterable)ImmutableList.of()));
            return Optional.of(context);
        }
        Optional<ReaderProjections> projectedReaderColumns = ReaderProjections.projectBaseColumns(columns);
        OrcPageSource orcPageSource = OrcPageSourceFactory.createOrcPageSource(this.hdfsEnvironment, session.getUser(), configuration, path, start, length, fileSize, projectedReaderColumns.map(ReaderProjections::getReaderColumns).orElse(columns), columns, HiveSessionProperties.isUseOrcColumnNames(session), AcidUtils.isFullAcidTable((Map)Maps.fromProperties((Properties)schema)), effectivePredicate, hiveStorageTimeZone, this.orcReaderOptions.withMaxMergeDistance(HiveSessionProperties.getOrcMaxMergeDistance(session)).withMaxBufferSize(HiveSessionProperties.getOrcMaxBufferSize(session)).withStreamBufferSize(HiveSessionProperties.getOrcStreamBufferSize(session)).withTinyStripeThreshold(HiveSessionProperties.getOrcTinyStripeThreshold(session)).withMaxReadBlockSize(HiveSessionProperties.getOrcMaxReadBlockSize(session)).withLazyReadSmallRanges(HiveSessionProperties.getOrcLazyReadSmallRanges(session)).withNestedLazy(HiveSessionProperties.isOrcNestedLazy(session)).withBloomFiltersEnabled(HiveSessionProperties.isOrcBloomFiltersEnabled(session)), acidInfo, this.stats);
        return Optional.of(new HivePageSourceFactory.ReaderPageSourceWithProjections(orcPageSource, projectedReaderColumns));
    }

    private static OrcPageSource createOrcPageSource(HdfsEnvironment hdfsEnvironment, String sessionUser, Configuration configuration, Path path, long start, long length, long fileSize, List<HiveColumnHandle> columns, List<HiveColumnHandle> projections, boolean useOrcColumnNames, boolean isFullAcid, TupleDomain<HiveColumnHandle> effectivePredicate, DateTimeZone hiveStorageTimeZone, OrcReaderOptions options, Optional<AcidInfo> acidInfo, FileFormatDataSourceStats stats) {
        HdfsOrcDataSource orcDataSource;
        for (HiveColumnHandle column2 : columns) {
            Preconditions.checkArgument((column2.getColumnType() == HiveColumnHandle.ColumnType.REGULAR ? 1 : 0) != 0, (String)"column type must be regular: %s", (Object)column2);
        }
        Preconditions.checkArgument((!effectivePredicate.isNone() ? 1 : 0) != 0);
        try {
            FileSystem fileSystem = hdfsEnvironment.getFileSystem(sessionUser, path, configuration);
            FSDataInputStream inputStream = hdfsEnvironment.doAs(sessionUser, () -> fileSystem.open(path));
            orcDataSource = new HdfsOrcDataSource(new OrcDataSourceId(path.toString()), fileSize, options, inputStream, stats);
        }
        catch (Exception e) {
            if (Strings.nullToEmpty((String)e.getMessage()).trim().equals("Filesystem closed") || e instanceof FileNotFoundException) {
                throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CANNOT_OPEN_SPLIT, (Throwable)e);
            }
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CANNOT_OPEN_SPLIT, OrcPageSourceFactory.splitError(e, path, start, length), (Throwable)e);
        }
        AggregatedMemoryContext systemMemoryUsage = AggregatedMemoryContext.newSimpleAggregatedMemoryContext();
        try {
            OrcReader reader = new OrcReader((OrcDataSource)orcDataSource, options);
            List fileColumns = reader.getRootColumn().getNestedColumns();
            ArrayList<OrcColumn> fileReadColumns = new ArrayList<OrcColumn>(columns.size() + (isFullAcid ? 3 : 0));
            ArrayList<Object> fileReadTypes = new ArrayList<Object>(columns.size() + (isFullAcid ? 3 : 0));
            ArrayList<OrcReader.ProjectedLayout> fileReadLayouts = new ArrayList<OrcReader.ProjectedLayout>(columns.size() + (isFullAcid ? 3 : 0));
            if (isFullAcid) {
                OrcPageSourceFactory.verifyAcidSchema(reader, path);
                ImmutableMap acidColumnsByName = Maps.uniqueIndex((Iterable)fileColumns, orcColumn -> orcColumn.getColumnName().toLowerCase(Locale.ENGLISH));
                fileColumns = ((OrcColumn)acidColumnsByName.get(ACID_COLUMN_ROW_STRUCT.toLowerCase(Locale.ENGLISH))).getNestedColumns();
                fileReadColumns.add((OrcColumn)acidColumnsByName.get(ACID_COLUMN_ORIGINAL_TRANSACTION.toLowerCase(Locale.ENGLISH)));
                fileReadTypes.add(BigintType.BIGINT);
                fileReadLayouts.add(OrcReader.ProjectedLayout.fullyProjectedLayout());
                fileReadColumns.add((OrcColumn)acidColumnsByName.get(ACID_COLUMN_BUCKET.toLowerCase(Locale.ENGLISH)));
                fileReadTypes.add(IntegerType.INTEGER);
                fileReadLayouts.add(OrcReader.ProjectedLayout.fullyProjectedLayout());
                fileReadColumns.add((OrcColumn)acidColumnsByName.get(ACID_COLUMN_ROW_ID.toLowerCase(Locale.ENGLISH)));
                fileReadTypes.add(BigintType.BIGINT);
                fileReadLayouts.add(OrcReader.ProjectedLayout.fullyProjectedLayout());
            }
            ImmutableMap fileColumnsByName = ImmutableMap.of();
            if (useOrcColumnNames || isFullAcid) {
                OrcPageSourceFactory.verifyFileHasColumnNames(fileColumns, path);
                fileColumnsByName = Maps.uniqueIndex((Iterable)fileColumns, orcColumn -> orcColumn.getColumnName().toLowerCase(Locale.ENGLISH));
            }
            Object projectionsByColumnName = ImmutableMap.of();
            Object projectionsByColumnIndex = ImmutableMap.of();
            if (useOrcColumnNames || isFullAcid) {
                projectionsByColumnName = projections.stream().collect(Collectors.groupingBy(HiveColumnHandle::getBaseColumnName, Collectors.mapping(column -> column.getHiveColumnProjectionInfo().map(HiveColumnProjectionInfo::getDereferenceNames).orElse((List)ImmutableList.of()), Collectors.toList())));
            } else {
                projectionsByColumnIndex = projections.stream().collect(Collectors.groupingBy(HiveColumnHandle::getBaseHiveColumnIndex, Collectors.mapping(column -> column.getHiveColumnProjectionInfo().map(HiveColumnProjectionInfo::getDereferenceNames).orElse((List)ImmutableList.of()), Collectors.toList())));
            }
            TupleDomainOrcPredicate.TupleDomainOrcPredicateBuilder predicateBuilder = TupleDomainOrcPredicate.builder().setBloomFiltersEnabled(options.isBloomFiltersEnabled());
            Map effectivePredicateDomains = (Map)effectivePredicate.getDomains().orElseThrow(() -> new IllegalArgumentException("Effective predicate is none"));
            ArrayList<OrcPageSource.ColumnAdaptation> columnAdaptations = new ArrayList<OrcPageSource.ColumnAdaptation>(columns.size());
            for (HiveColumnHandle column3 : columns) {
                OrcColumn orcColumn2 = null;
                OrcReader.ProjectedLayout projectedLayout = null;
                Map columnDomains = null;
                if (useOrcColumnNames || isFullAcid) {
                    String columnName = column3.getName().toLowerCase(Locale.ENGLISH);
                    orcColumn2 = (OrcColumn)fileColumnsByName.get(columnName);
                    if (orcColumn2 != null) {
                        projectedLayout = OrcReader.ProjectedLayout.createProjectedLayout((OrcColumn)orcColumn2, (List)((List)projectionsByColumnName.get(columnName)));
                        columnDomains = (Map)effectivePredicateDomains.entrySet().stream().filter(columnDomain -> ((HiveColumnHandle)columnDomain.getKey()).getBaseColumnName().toLowerCase(Locale.ENGLISH).equals(columnName)).collect(ImmutableMap.toImmutableMap(columnDomain -> ((HiveColumnHandle)columnDomain.getKey()).getHiveColumnProjectionInfo(), Map.Entry::getValue));
                    }
                } else if (column3.getBaseHiveColumnIndex() < fileColumns.size() && (orcColumn2 = (OrcColumn)fileColumns.get(column3.getBaseHiveColumnIndex())) != null) {
                    projectedLayout = OrcReader.ProjectedLayout.createProjectedLayout((OrcColumn)orcColumn2, (List)((List)projectionsByColumnIndex.get(column3.getBaseHiveColumnIndex())));
                    columnDomains = (Map)effectivePredicateDomains.entrySet().stream().filter(columnDomain -> ((HiveColumnHandle)columnDomain.getKey()).getBaseHiveColumnIndex() == column3.getBaseHiveColumnIndex()).collect(ImmutableMap.toImmutableMap(columnDomain -> ((HiveColumnHandle)columnDomain.getKey()).getHiveColumnProjectionInfo(), Map.Entry::getValue));
                }
                Type readType = column3.getType();
                if (orcColumn2 != null) {
                    int sourceIndex = fileReadColumns.size();
                    columnAdaptations.add(OrcPageSource.ColumnAdaptation.sourceColumn(sourceIndex));
                    fileReadColumns.add(orcColumn2);
                    fileReadTypes.add(readType);
                    fileReadLayouts.add(projectedLayout);
                    for (Map.Entry columnDomain2 : columnDomains.entrySet()) {
                        OrcColumn nestedColumn = OrcPageSourceFactory.getNestedColumn(orcColumn2, (Optional)columnDomain2.getKey());
                        if (nestedColumn == null) continue;
                        predicateBuilder.addColumn(nestedColumn.getColumnId(), (Domain)columnDomain2.getValue());
                    }
                    continue;
                }
                columnAdaptations.add(OrcPageSource.ColumnAdaptation.nullColumn(readType));
            }
            OrcRecordReader recordReader = reader.createRecordReader(fileReadColumns, fileReadTypes, fileReadLayouts, (OrcPredicate)predicateBuilder.build(), start, length, hiveStorageTimeZone, systemMemoryUsage, 1, arg_0 -> OrcPageSourceFactory.lambda$createOrcPageSource$10((OrcDataSource)orcDataSource, arg_0));
            Optional<OrcDeletedRows> deletedRows = acidInfo.map(locations -> new OrcDeletedRows(path.getName(), new OrcDeleteDeltaPageSourceFactory(options, sessionUser, configuration, hdfsEnvironment, stats), sessionUser, configuration, hdfsEnvironment, (AcidInfo)locations));
            return new OrcPageSource(recordReader, columnAdaptations, (OrcDataSource)orcDataSource, deletedRows, systemMemoryUsage, stats);
        }
        catch (Exception e) {
            try {
                orcDataSource.close();
            }
            catch (IOException fileColumns) {
                // empty catch block
            }
            if (e instanceof PrestoException) {
                throw (PrestoException)((Object)e);
            }
            String message = OrcPageSourceFactory.splitError(e, path, start, length);
            if (e instanceof BlockMissingException) {
                throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_MISSING_DATA, message, (Throwable)e);
            }
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CANNOT_OPEN_SPLIT, message, (Throwable)e);
        }
    }

    private static String splitError(Throwable t, Path path, long start, long length) {
        return String.format("Error opening Hive split %s (offset=%s, length=%s): %s", path, start, length, t.getMessage());
    }

    private static void verifyFileHasColumnNames(List<OrcColumn> columns, Path path) {
        if (!columns.isEmpty() && columns.stream().map(OrcColumn::getColumnName).allMatch(physicalColumnName -> DEFAULT_HIVE_COLUMN_NAME_PATTERN.matcher((CharSequence)physicalColumnName).matches())) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_FILE_MISSING_COLUMN_NAMES, "ORC file does not contain column names in the footer: " + path);
        }
    }

    static void verifyAcidSchema(OrcReader orcReader, Path path) {
        OrcColumn rootColumn = orcReader.getRootColumn();
        if (rootColumn.getNestedColumns().size() != 6) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_BAD_DATA, "ORC ACID file should have 6 columns: " + path);
        }
        OrcPageSourceFactory.verifyAcidColumn(orcReader, 0, ACID_COLUMN_OPERATION, OrcType.OrcTypeKind.INT, path);
        OrcPageSourceFactory.verifyAcidColumn(orcReader, 1, ACID_COLUMN_ORIGINAL_TRANSACTION, OrcType.OrcTypeKind.LONG, path);
        OrcPageSourceFactory.verifyAcidColumn(orcReader, 2, ACID_COLUMN_BUCKET, OrcType.OrcTypeKind.INT, path);
        OrcPageSourceFactory.verifyAcidColumn(orcReader, 3, ACID_COLUMN_ROW_ID, OrcType.OrcTypeKind.LONG, path);
        OrcPageSourceFactory.verifyAcidColumn(orcReader, 4, ACID_COLUMN_CURRENT_TRANSACTION, OrcType.OrcTypeKind.LONG, path);
        OrcPageSourceFactory.verifyAcidColumn(orcReader, 5, ACID_COLUMN_ROW_STRUCT, OrcType.OrcTypeKind.STRUCT, path);
    }

    private static void verifyAcidColumn(OrcReader orcReader, int columnIndex, String columnName, OrcType.OrcTypeKind columnType, Path path) {
        OrcColumn column = (OrcColumn)orcReader.getRootColumn().getNestedColumns().get(columnIndex);
        if (!column.getColumnName().toLowerCase(Locale.ENGLISH).equals(columnName.toLowerCase(Locale.ENGLISH))) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_BAD_DATA, String.format("ORC ACID file column %s should be named %s: %s", columnIndex, columnName, path));
        }
        if (column.getColumnType() != columnType) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_BAD_DATA, String.format("ORC ACID file %s column should be type %s: %s", columnName, columnType, path));
        }
    }

    private static OrcColumn getNestedColumn(OrcColumn baseColumn, Optional<HiveColumnProjectionInfo> projectionInfo) {
        if (projectionInfo.isEmpty()) {
            return baseColumn;
        }
        OrcColumn current = baseColumn;
        for (String field : projectionInfo.get().getDereferenceNames()) {
            Optional<OrcColumn> orcColumn = current.getNestedColumns().stream().filter(column -> column.getColumnName().toLowerCase(Locale.ENGLISH).equals(field)).findFirst();
            if (orcColumn.isEmpty()) {
                return null;
            }
            current = orcColumn.get();
        }
        return current;
    }

    private static /* synthetic */ RuntimeException lambda$createOrcPageSource$10(OrcDataSource orcDataSource, Exception exception) {
        return OrcPageSource.handleException(orcDataSource.getId(), exception);
    }
}

