/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.parquet;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.prestosql.memory.context.AggregatedMemoryContext;
import io.prestosql.parquet.Field;
import io.prestosql.parquet.ParquetCorruptionException;
import io.prestosql.parquet.ParquetDataSource;
import io.prestosql.parquet.ParquetReaderOptions;
import io.prestosql.parquet.ParquetTypeUtils;
import io.prestosql.parquet.RichColumnDescriptor;
import io.prestosql.parquet.predicate.Predicate;
import io.prestosql.parquet.predicate.PredicateUtils;
import io.prestosql.parquet.reader.MetadataReader;
import io.prestosql.parquet.reader.ParquetReader;
import io.prestosql.plugin.hive.AcidInfo;
import io.prestosql.plugin.hive.FileFormatDataSourceStats;
import io.prestosql.plugin.hive.HdfsEnvironment;
import io.prestosql.plugin.hive.HiveColumnHandle;
import io.prestosql.plugin.hive.HiveErrorCode;
import io.prestosql.plugin.hive.HivePageSourceFactory;
import io.prestosql.plugin.hive.HiveSessionProperties;
import io.prestosql.plugin.hive.ReaderProjections;
import io.prestosql.plugin.hive.parquet.HdfsParquetDataSource;
import io.prestosql.plugin.hive.parquet.ParquetColumnIOConverter;
import io.prestosql.plugin.hive.parquet.ParquetPageSource;
import io.prestosql.plugin.hive.parquet.ParquetReaderConfig;
import io.prestosql.plugin.hive.util.HiveUtil;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.predicate.Domain;
import io.prestosql.spi.predicate.TupleDomain;
import io.prestosql.spi.type.Type;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import javax.inject.Inject;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.BlockMissingException;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.hadoop.metadata.BlockMetaData;
import org.apache.parquet.hadoop.metadata.ColumnChunkMetaData;
import org.apache.parquet.hadoop.metadata.FileMetaData;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.parquet.io.GroupColumnIO;
import org.apache.parquet.io.MessageColumnIO;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.MessageType;
import org.joda.time.DateTimeZone;

public class ParquetPageSourceFactory
implements HivePageSourceFactory {
    private static final Set<String> PARQUET_SERDE_CLASS_NAMES = ImmutableSet.builder().add((Object)"org.apache.hadoop.hive.ql.io.parquet.serde.ParquetHiveSerDe").add((Object)"parquet.hive.serde.ParquetHiveSerDe").build();
    private final HdfsEnvironment hdfsEnvironment;
    private final FileFormatDataSourceStats stats;
    private final ParquetReaderOptions options;

    @Inject
    public ParquetPageSourceFactory(HdfsEnvironment hdfsEnvironment, FileFormatDataSourceStats stats, ParquetReaderConfig config) {
        this.hdfsEnvironment = Objects.requireNonNull(hdfsEnvironment, "hdfsEnvironment is null");
        this.stats = Objects.requireNonNull(stats, "stats is null");
        Objects.requireNonNull(config, "config is null");
        this.options = config.toParquetReaderOptions();
    }

    @Override
    public Optional<HivePageSourceFactory.ReaderPageSourceWithProjections> createPageSource(Configuration configuration, ConnectorSession session, Path path, long start, long length, long fileSize, Properties schema, List<HiveColumnHandle> columns, TupleDomain<HiveColumnHandle> effectivePredicate, DateTimeZone hiveStorageTimeZone, Optional<AcidInfo> acidInfo) {
        if (!PARQUET_SERDE_CLASS_NAMES.contains(HiveUtil.getDeserializerClassName(schema))) {
            return Optional.empty();
        }
        Preconditions.checkArgument((boolean)acidInfo.isEmpty(), (Object)"Acid is not supported");
        return Optional.of(ParquetPageSourceFactory.createPageSource(path, start, length, fileSize, columns, effectivePredicate, HiveSessionProperties.isUseParquetColumnNames(session), this.hdfsEnvironment, configuration, session.getUser(), this.stats, this.options.withFailOnCorruptedStatistics(HiveSessionProperties.isFailOnCorruptedParquetStatistics(session)).withMaxReadBlockSize(HiveSessionProperties.getParquetMaxReadBlockSize(session))));
    }

    public static HivePageSourceFactory.ReaderPageSourceWithProjections createPageSource(Path path, long start, long length, long fileSize, List<HiveColumnHandle> columns, TupleDomain<HiveColumnHandle> effectivePredicate, boolean useColumnNames, HdfsEnvironment hdfsEnvironment, Configuration configuration, String user, FileFormatDataSourceStats stats, ParquetReaderOptions options) {
        ParquetReader parquetReader;
        MessageColumnIO messageColumn;
        MessageType fileSchema;
        effectivePredicate = effectivePredicate.filter((column, domain) -> column.isBaseColumn());
        HdfsParquetDataSource dataSource = null;
        try {
            FileSystem fileSystem = hdfsEnvironment.getFileSystem(user, path, configuration);
            FSDataInputStream inputStream = hdfsEnvironment.doAs(user, () -> fileSystem.open(path));
            ParquetMetadata parquetMetadata = MetadataReader.readFooter((FSDataInputStream)inputStream, (Path)path, (long)fileSize);
            FileMetaData fileMetaData = parquetMetadata.getFileMetaData();
            fileSchema = fileMetaData.getSchema();
            dataSource = HdfsParquetDataSource.buildHdfsParquetDataSource(inputStream, path, fileSize, stats, options);
            Optional<MessageType> message = ReaderProjections.projectSufficientColumns(columns).map(ReaderProjections::getReaderColumns).orElse(columns).stream().filter(column -> column.getColumnType() == HiveColumnHandle.ColumnType.REGULAR).map(column -> ParquetPageSourceFactory.getColumnType(column, fileSchema, useColumnNames)).filter(Optional::isPresent).map(Optional::get).map(type -> new MessageType(fileSchema.getName(), new org.apache.parquet.schema.Type[]{type})).reduce(MessageType::union);
            MessageType requestedSchema = message.orElse(new MessageType(fileSchema.getName(), (List)ImmutableList.of()));
            messageColumn = ParquetTypeUtils.getColumnIO((MessageType)fileSchema, (MessageType)requestedSchema);
            ImmutableList.Builder footerBlocks = ImmutableList.builder();
            for (BlockMetaData block : parquetMetadata.getBlocks()) {
                long firstDataPage = ((ColumnChunkMetaData)block.getColumns().get(0)).getFirstDataPageOffset();
                if (firstDataPage < start || firstDataPage >= start + length) continue;
                footerBlocks.add((Object)block);
            }
            Map descriptorsByPath = ParquetTypeUtils.getDescriptors((MessageType)fileSchema, (MessageType)requestedSchema);
            TupleDomain<ColumnDescriptor> parquetTupleDomain = ParquetPageSourceFactory.getParquetTupleDomain(descriptorsByPath, (TupleDomain<HiveColumnHandle>)effectivePredicate, fileSchema, useColumnNames);
            Predicate parquetPredicate = PredicateUtils.buildPredicate((MessageType)requestedSchema, parquetTupleDomain, (Map)descriptorsByPath);
            ImmutableList.Builder blocks = ImmutableList.builder();
            for (BlockMetaData block : footerBlocks.build()) {
                if (!PredicateUtils.predicateMatches((Predicate)parquetPredicate, (BlockMetaData)block, (ParquetDataSource)dataSource, (Map)descriptorsByPath, parquetTupleDomain, (boolean)options.isFailOnCorruptedStatistics())) continue;
                blocks.add((Object)block);
            }
            parquetReader = new ParquetReader(Optional.ofNullable(fileMetaData.getCreatedBy()), messageColumn, (List)blocks.build(), (ParquetDataSource)dataSource, AggregatedMemoryContext.newSimpleAggregatedMemoryContext(), options);
        }
        catch (Exception e) {
            try {
                if (dataSource != null) {
                    dataSource.close();
                }
            }
            catch (IOException inputStream) {
                // empty catch block
            }
            if (e instanceof PrestoException) {
                throw (PrestoException)((Object)e);
            }
            if (e instanceof ParquetCorruptionException) {
                throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_BAD_DATA, (Throwable)e);
            }
            if (Strings.nullToEmpty((String)e.getMessage()).trim().equals("Filesystem closed") || e instanceof FileNotFoundException) {
                throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CANNOT_OPEN_SPLIT, (Throwable)e);
            }
            String message = String.format("Error opening Hive split %s (offset=%s, length=%s): %s", path, start, length, e.getMessage());
            if (e instanceof BlockMissingException) {
                throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_MISSING_DATA, message, (Throwable)e);
            }
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CANNOT_OPEN_SPLIT, message, (Throwable)e);
        }
        Optional<ReaderProjections> readerProjections = ReaderProjections.projectBaseColumns(columns);
        List<HiveColumnHandle> baseColumns = readerProjections.map(ReaderProjections::getReaderColumns).orElse(columns);
        for (HiveColumnHandle column2 : baseColumns) {
            Preconditions.checkArgument((column2.getColumnType() == HiveColumnHandle.ColumnType.REGULAR ? 1 : 0) != 0, (String)"column type must be REGULAR: %s", (Object)column2);
        }
        List parquetFields = (List)baseColumns.stream().map(column -> ParquetPageSourceFactory.getParquetType(column, fileSchema, useColumnNames)).map(Optional::ofNullable).collect(ImmutableList.toImmutableList());
        ImmutableList.Builder prestoTypes = ImmutableList.builder();
        ImmutableList.Builder internalFields = ImmutableList.builder();
        for (int columnIndex = 0; columnIndex < baseColumns.size(); ++columnIndex) {
            HiveColumnHandle column3 = baseColumns.get(columnIndex);
            Optional parquetField = (Optional)parquetFields.get(columnIndex);
            prestoTypes.add((Object)column3.getBaseType());
            internalFields.add(parquetField.flatMap(field -> {
                String columnName = useColumnNames ? column3.getBaseColumnName() : ((org.apache.parquet.schema.Type)fileSchema.getFields().get(column3.getBaseHiveColumnIndex())).getName();
                return ParquetColumnIOConverter.constructField(column3.getBaseType(), ParquetTypeUtils.lookupColumnByName((GroupColumnIO)messageColumn, (String)columnName));
            }));
        }
        ParquetPageSource parquetPageSource = new ParquetPageSource(parquetReader, (List<Type>)prestoTypes.build(), (List<Optional<Field>>)internalFields.build());
        return new HivePageSourceFactory.ReaderPageSourceWithProjections(parquetPageSource, readerProjections);
    }

    public static Optional<org.apache.parquet.schema.Type> getParquetType(GroupType groupType, boolean useParquetColumnNames, HiveColumnHandle column) {
        if (useParquetColumnNames) {
            return Optional.ofNullable(ParquetTypeUtils.getParquetTypeByName((String)column.getBaseColumnName(), (GroupType)groupType));
        }
        if (column.getBaseHiveColumnIndex() < groupType.getFieldCount()) {
            return Optional.of(groupType.getType(column.getBaseHiveColumnIndex()));
        }
        return Optional.empty();
    }

    public static Optional<org.apache.parquet.schema.Type> getColumnType(HiveColumnHandle column, MessageType messageType, boolean useParquetColumnNames) {
        Optional<org.apache.parquet.schema.Type> columnType = ParquetPageSourceFactory.getParquetType((GroupType)messageType, useParquetColumnNames, column);
        if (columnType.isEmpty() || column.getHiveColumnProjectionInfo().isEmpty()) {
            return columnType;
        }
        GroupType baseType = columnType.get().asGroupType();
        ImmutableList.Builder typeBuilder = ImmutableList.builder();
        GroupType parentType = baseType;
        for (String name : column.getHiveColumnProjectionInfo().get().getDereferenceNames()) {
            org.apache.parquet.schema.Type childType = ParquetTypeUtils.getParquetTypeByName((String)name, (GroupType)parentType.asGroupType());
            if (childType == null) {
                return Optional.empty();
            }
            typeBuilder.add((Object)childType);
            parentType = childType;
        }
        ImmutableList subfieldTypes = typeBuilder.build();
        org.apache.parquet.schema.Type type = (org.apache.parquet.schema.Type)subfieldTypes.get(subfieldTypes.size() - 1);
        for (int i = subfieldTypes.size() - 2; i >= 0; --i) {
            GroupType groupType = ((org.apache.parquet.schema.Type)subfieldTypes.get(i)).asGroupType();
            type = new GroupType(type.getRepetition(), groupType.getName(), (List)ImmutableList.of((Object)type));
        }
        return Optional.of(new GroupType(baseType.getRepetition(), baseType.getName(), (List)ImmutableList.of((Object)type)));
    }

    public static TupleDomain<ColumnDescriptor> getParquetTupleDomain(Map<List<String>, RichColumnDescriptor> descriptorsByPath, TupleDomain<HiveColumnHandle> effectivePredicate, MessageType fileSchema, boolean useColumnNames) {
        if (effectivePredicate.isNone()) {
            return TupleDomain.none();
        }
        ImmutableMap.Builder predicate = ImmutableMap.builder();
        for (Map.Entry entry : ((Map)effectivePredicate.getDomains().get()).entrySet()) {
            RichColumnDescriptor descriptor;
            HiveColumnHandle columnHandle = (HiveColumnHandle)entry.getKey();
            if (columnHandle.getHiveType().getCategory() != ObjectInspector.Category.PRIMITIVE || columnHandle.getColumnType() != HiveColumnHandle.ColumnType.REGULAR) continue;
            if (useColumnNames) {
                descriptor = descriptorsByPath.get(ImmutableList.of((Object)columnHandle.getName()));
            } else {
                org.apache.parquet.schema.Type parquetField = ParquetPageSourceFactory.getParquetType(columnHandle, fileSchema, false);
                if (parquetField == null || !parquetField.isPrimitive()) continue;
                descriptor = descriptorsByPath.get(ImmutableList.of((Object)parquetField.getName()));
            }
            if (descriptor == null) continue;
            predicate.put((Object)descriptor, (Object)((Domain)entry.getValue()));
        }
        return TupleDomain.withColumnDomains((Map)predicate.build());
    }

    private static org.apache.parquet.schema.Type getParquetType(HiveColumnHandle column, MessageType messageType, boolean useParquetColumnNames) {
        if (useParquetColumnNames) {
            return ParquetTypeUtils.getParquetTypeByName((String)column.getBaseColumnName(), (GroupType)messageType);
        }
        if (column.getBaseHiveColumnIndex() < messageType.getFieldCount()) {
            return messageType.getType(column.getBaseHiveColumnIndex());
        }
        return null;
    }
}

