/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.procedure;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import io.prestosql.plugin.hive.HdfsEnvironment;
import io.prestosql.plugin.hive.HiveErrorCode;
import io.prestosql.plugin.hive.HiveMetadata;
import io.prestosql.plugin.hive.HivePartitionManager;
import io.prestosql.plugin.hive.PartitionStatistics;
import io.prestosql.plugin.hive.TransactionalMetadataFactory;
import io.prestosql.plugin.hive.authentication.HiveIdentity;
import io.prestosql.plugin.hive.metastore.Column;
import io.prestosql.plugin.hive.metastore.Partition;
import io.prestosql.plugin.hive.metastore.SemiTransactionalHiveMetastore;
import io.prestosql.plugin.hive.metastore.Table;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.block.MethodHandleUtil;
import io.prestosql.spi.classloader.ThreadContextClassLoader;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.connector.SchemaTableName;
import io.prestosql.spi.connector.TableNotFoundException;
import io.prestosql.spi.procedure.Procedure;
import io.prestosql.spi.type.BooleanType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarcharType;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.net.URI;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Provider;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class SyncPartitionMetadataProcedure
implements Provider<Procedure> {
    private static final MethodHandle SYNC_PARTITION_METADATA = MethodHandleUtil.methodHandle(SyncPartitionMetadataProcedure.class, (String)"syncPartitionMetadata", (Class[])new Class[]{ConnectorSession.class, String.class, String.class, String.class, Boolean.TYPE});
    private final TransactionalMetadataFactory hiveMetadataFactory;
    private final HdfsEnvironment hdfsEnvironment;

    @Inject
    public SyncPartitionMetadataProcedure(TransactionalMetadataFactory hiveMetadataFactory, HdfsEnvironment hdfsEnvironment) {
        this.hiveMetadataFactory = Objects.requireNonNull(hiveMetadataFactory, "hiveMetadataFactory is null");
        this.hdfsEnvironment = Objects.requireNonNull(hdfsEnvironment, "hdfsEnvironment is null");
    }

    public Procedure get() {
        return new Procedure("system", "sync_partition_metadata", (List)ImmutableList.of((Object)new Procedure.Argument("schema_name", (Type)VarcharType.VARCHAR), (Object)new Procedure.Argument("table_name", (Type)VarcharType.VARCHAR), (Object)new Procedure.Argument("mode", (Type)VarcharType.VARCHAR), (Object)new Procedure.Argument("case_sensitive", (Type)BooleanType.BOOLEAN, false, (Object)Boolean.TRUE)), SYNC_PARTITION_METADATA.bindTo(this));
    }

    public void syncPartitionMetadata(ConnectorSession session, String schemaName, String tableName, String mode, boolean caseSensitive) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.getClass().getClassLoader());){
            this.doSyncPartitionMetadata(session, schemaName, tableName, mode, caseSensitive);
        }
    }

    private void doSyncPartitionMetadata(ConnectorSession session, String schemaName, String tableName, String mode, boolean caseSensitive) {
        Set<String> partitionsToDrop;
        Set<String> partitionsToAdd;
        SyncMode syncMode = SyncPartitionMetadataProcedure.toSyncMode(mode);
        HdfsEnvironment.HdfsContext hdfsContext = new HdfsEnvironment.HdfsContext(session, schemaName, tableName);
        HiveIdentity identity = new HiveIdentity(session);
        SemiTransactionalHiveMetastore metastore = ((HiveMetadata)this.hiveMetadataFactory.create()).getMetastore();
        SchemaTableName schemaTableName = new SchemaTableName(schemaName, tableName);
        Table table = metastore.getTable(identity, schemaName, tableName).orElseThrow(() -> new TableNotFoundException(schemaTableName));
        if (table.getPartitionColumns().isEmpty()) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_PROCEDURE_ARGUMENT, "Table is not partitioned: " + schemaTableName);
        }
        Path tableLocation = new Path(table.getStorage().getLocation());
        try {
            FileSystem fileSystem = this.hdfsEnvironment.getFileSystem(hdfsContext, tableLocation);
            List<String> partitionsInMetastore = metastore.getPartitionNames(identity, schemaName, tableName).orElseThrow(() -> new TableNotFoundException(schemaTableName));
            List partitionsInFileSystem = (List)SyncPartitionMetadataProcedure.listDirectory(fileSystem, fileSystem.getFileStatus(tableLocation), table.getPartitionColumns(), table.getPartitionColumns().size(), caseSensitive).stream().map(fileStatus -> fileStatus.getPath().toUri()).map(uri -> tableLocation.toUri().relativize((URI)uri).getPath()).collect(ImmutableList.toImmutableList());
            partitionsToAdd = SyncPartitionMetadataProcedure.difference(partitionsInFileSystem, partitionsInMetastore);
            partitionsToDrop = SyncPartitionMetadataProcedure.difference(partitionsInMetastore, partitionsInFileSystem);
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_FILESYSTEM_ERROR, (Throwable)e);
        }
        SyncPartitionMetadataProcedure.syncPartitions(partitionsToAdd, partitionsToDrop, syncMode, metastore, session, table);
    }

    private static List<FileStatus> listDirectory(FileSystem fileSystem, FileStatus current, List<Column> partitionColumns, int depth, boolean caseSensitive) {
        if (depth == 0) {
            return ImmutableList.of((Object)current);
        }
        try {
            return (List)Stream.of(fileSystem.listStatus(current.getPath())).filter(fileStatus -> SyncPartitionMetadataProcedure.isValidPartitionPath(fileStatus, (Column)partitionColumns.get(partitionColumns.size() - depth), caseSensitive)).flatMap(directory -> SyncPartitionMetadataProcedure.listDirectory(fileSystem, directory, partitionColumns, depth - 1, caseSensitive).stream()).collect(ImmutableList.toImmutableList());
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_FILESYSTEM_ERROR, (Throwable)e);
        }
    }

    private static boolean isValidPartitionPath(FileStatus file, Column column, boolean caseSensitive) {
        String path = file.getPath().getName();
        if (!caseSensitive) {
            path = path.toLowerCase(Locale.ENGLISH);
        }
        String prefix = column.getName() + "=";
        return file.isDirectory() && path.startsWith(prefix);
    }

    private static Set<String> difference(List<String> a, List<String> b) {
        return Sets.difference(new HashSet<String>(a), new HashSet<String>(b));
    }

    private static void syncPartitions(Set<String> partitionsToAdd, Set<String> partitionsToDrop, SyncMode syncMode, SemiTransactionalHiveMetastore metastore, ConnectorSession session, Table table) {
        if (syncMode == SyncMode.ADD || syncMode == SyncMode.FULL) {
            SyncPartitionMetadataProcedure.addPartitions(metastore, session, table, partitionsToAdd);
        }
        if (syncMode == SyncMode.DROP || syncMode == SyncMode.FULL) {
            SyncPartitionMetadataProcedure.dropPartitions(metastore, session, table, partitionsToDrop);
        }
        metastore.commit();
    }

    private static void addPartitions(SemiTransactionalHiveMetastore metastore, ConnectorSession session, Table table, Set<String> partitions) {
        for (String name : partitions) {
            metastore.addPartition(session, table.getDatabaseName(), table.getTableName(), SyncPartitionMetadataProcedure.buildPartitionObject(session, table, name), new Path(table.getStorage().getLocation(), name), PartitionStatistics.empty());
        }
    }

    private static void dropPartitions(SemiTransactionalHiveMetastore metastore, ConnectorSession session, Table table, Set<String> partitions) {
        for (String name : partitions) {
            metastore.dropPartition(session, table.getDatabaseName(), table.getTableName(), HivePartitionManager.extractPartitionValues(name), false);
        }
    }

    private static Partition buildPartitionObject(ConnectorSession session, Table table, String partitionName) {
        return Partition.builder().setDatabaseName(table.getDatabaseName()).setTableName(table.getTableName()).setColumns(table.getDataColumns()).setValues(HivePartitionManager.extractPartitionValues(partitionName)).setParameters((Map<String, String>)ImmutableMap.of((Object)"presto_query_id", (Object)session.getQueryId())).withStorage(storage -> storage.setStorageFormat(table.getStorage().getStorageFormat()).setLocation(new Path(table.getStorage().getLocation(), partitionName).toString()).setBucketProperty(table.getStorage().getBucketProperty()).setSerdeParameters(table.getStorage().getSerdeParameters())).build();
    }

    private static SyncMode toSyncMode(String mode) {
        try {
            return SyncMode.valueOf(mode.toUpperCase(Locale.ENGLISH));
        }
        catch (IllegalArgumentException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_PROCEDURE_ARGUMENT, "Invalid partition metadata sync mode: " + mode);
        }
    }

    public static enum SyncMode {
        ADD,
        DROP,
        FULL;

    }
}

