/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.rubix;

import com.google.common.base.Preconditions;
import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Scopes;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.multibindings.OptionalBinder;
import io.airlift.configuration.ConfigBinder;
import io.prestosql.plugin.hive.ConfigurationInitializer;
import io.prestosql.plugin.hive.DynamicConfigurationProvider;
import io.prestosql.plugin.hive.rubix.ForRubix;
import io.prestosql.plugin.hive.rubix.RubixConfig;
import io.prestosql.plugin.hive.rubix.RubixConfigurationInitializer;
import io.prestosql.plugin.hive.rubix.RubixInitializer;
import java.util.Set;

public class RubixModule
implements Module {
    public void configure(Binder binder) {
        ConfigBinder.configBinder((Binder)binder).bindConfig(RubixConfig.class);
        binder.bind(RubixConfigurationInitializer.class).in(Scopes.SINGLETON);
        binder.bind(RubixInitializer.class).in(Scopes.SINGLETON);
        binder.bind(RubixStarter.class).asEagerSingleton();
        OptionalBinder.newOptionalBinder((Binder)binder, (Key)Key.get(ConfigurationInitializer.class, ForRubix.class));
        Multibinder.newSetBinder((Binder)binder, DynamicConfigurationProvider.class).addBinding().to(RubixConfigurationInitializer.class).in(Scopes.SINGLETON);
    }

    private static class RubixStarter {
        @Inject
        private RubixStarter(RubixInitializer rubixInitializer, Set<DynamicConfigurationProvider> configProviders) {
            Preconditions.checkArgument((configProviders.size() == 1 ? 1 : 0) != 0, (Object)"Rubix cache does not work with dynamic configuration providers");
            rubixInitializer.initializeRubix();
        }
    }
}

