/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.s3;

import com.google.common.base.StandardSystemProperty;
import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.configuration.ConfigSecuritySensitive;
import io.airlift.configuration.DefunctConfig;
import io.airlift.configuration.validation.FileExists;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.airlift.units.MinDataSize;
import io.airlift.units.MinDuration;
import io.prestosql.plugin.hive.s3.PrestoS3AclType;
import io.prestosql.plugin.hive.s3.PrestoS3SignerType;
import io.prestosql.plugin.hive.s3.PrestoS3SseType;
import io.prestosql.plugin.hive.s3.PrestoS3StorageClass;
import java.io.File;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

@DefunctConfig(value={"hive.s3.use-instance-credentials"})
public class HiveS3Config {
    private String s3AwsAccessKey;
    private String s3AwsSecretKey;
    private String s3Endpoint;
    private PrestoS3StorageClass s3StorageClass = PrestoS3StorageClass.STANDARD;
    private PrestoS3SignerType s3SignerType;
    private String s3SignerClass;
    private boolean s3PathStyleAccess;
    private String s3IamRole;
    private String s3ExternalId;
    private boolean s3SslEnabled = true;
    private boolean s3SseEnabled;
    private PrestoS3SseType s3SseType = PrestoS3SseType.S3;
    private String s3EncryptionMaterialsProvider;
    private String s3KmsKeyId;
    private String s3SseKmsKeyId;
    private int s3MaxClientRetries = 5;
    private int s3MaxErrorRetries = 10;
    private Duration s3MaxBackoffTime = new Duration(10.0, TimeUnit.MINUTES);
    private Duration s3MaxRetryTime = new Duration(10.0, TimeUnit.MINUTES);
    private Duration s3ConnectTimeout = new Duration(5.0, TimeUnit.SECONDS);
    private Duration s3SocketTimeout = new Duration(5.0, TimeUnit.SECONDS);
    private int s3MaxConnections = 500;
    private File s3StagingDirectory = new File(StandardSystemProperty.JAVA_IO_TMPDIR.value());
    private DataSize s3MultipartMinFileSize = DataSize.of((long)16L, (DataSize.Unit)DataSize.Unit.MEGABYTE);
    private DataSize s3MultipartMinPartSize = DataSize.of((long)5L, (DataSize.Unit)DataSize.Unit.MEGABYTE);
    private boolean pinS3ClientToCurrentRegion;
    private String s3UserAgentPrefix = "";
    private PrestoS3AclType s3AclType = PrestoS3AclType.PRIVATE;
    private boolean skipGlacierObjects;
    private boolean requesterPaysEnabled;

    public String getS3AwsAccessKey() {
        return this.s3AwsAccessKey;
    }

    @Config(value="hive.s3.aws-access-key")
    public HiveS3Config setS3AwsAccessKey(String s3AwsAccessKey) {
        this.s3AwsAccessKey = s3AwsAccessKey;
        return this;
    }

    public String getS3AwsSecretKey() {
        return this.s3AwsSecretKey;
    }

    @Config(value="hive.s3.aws-secret-key")
    @ConfigSecuritySensitive
    public HiveS3Config setS3AwsSecretKey(String s3AwsSecretKey) {
        this.s3AwsSecretKey = s3AwsSecretKey;
        return this;
    }

    public String getS3Endpoint() {
        return this.s3Endpoint;
    }

    @Config(value="hive.s3.endpoint")
    public HiveS3Config setS3Endpoint(String s3Endpoint) {
        this.s3Endpoint = s3Endpoint;
        return this;
    }

    @NotNull
    public PrestoS3StorageClass getS3StorageClass() {
        return this.s3StorageClass;
    }

    @Config(value="hive.s3.storage-class")
    @ConfigDescription(value="AWS S3 storage class to use when writing the data")
    public HiveS3Config setS3StorageClass(PrestoS3StorageClass s3StorageClass) {
        this.s3StorageClass = s3StorageClass;
        return this;
    }

    public PrestoS3SignerType getS3SignerType() {
        return this.s3SignerType;
    }

    @Config(value="hive.s3.signer-type")
    public HiveS3Config setS3SignerType(PrestoS3SignerType s3SignerType) {
        this.s3SignerType = s3SignerType;
        return this;
    }

    public String getS3SignerClass() {
        return this.s3SignerClass;
    }

    @Config(value="hive.s3.signer-class")
    public HiveS3Config setS3SignerClass(String s3SignerClass) {
        this.s3SignerClass = s3SignerClass;
        return this;
    }

    public boolean isS3PathStyleAccess() {
        return this.s3PathStyleAccess;
    }

    @Config(value="hive.s3.path-style-access")
    @ConfigDescription(value="Use path-style access for all request to S3")
    public HiveS3Config setS3PathStyleAccess(boolean s3PathStyleAccess) {
        this.s3PathStyleAccess = s3PathStyleAccess;
        return this;
    }

    public String getS3IamRole() {
        return this.s3IamRole;
    }

    @Config(value="hive.s3.iam-role")
    @ConfigDescription(value="ARN of an IAM role to assume when connecting to S3")
    public HiveS3Config setS3IamRole(String s3IamRole) {
        this.s3IamRole = s3IamRole;
        return this;
    }

    public String getS3ExternalId() {
        return this.s3ExternalId;
    }

    @Config(value="hive.s3.external-id")
    @ConfigDescription(value="External ID for the IAM role trust policy when connecting to S3")
    public HiveS3Config setS3ExternalId(String s3ExternalId) {
        this.s3ExternalId = s3ExternalId;
        return this;
    }

    public boolean isS3SslEnabled() {
        return this.s3SslEnabled;
    }

    @Config(value="hive.s3.ssl.enabled")
    public HiveS3Config setS3SslEnabled(boolean s3SslEnabled) {
        this.s3SslEnabled = s3SslEnabled;
        return this;
    }

    public String getS3EncryptionMaterialsProvider() {
        return this.s3EncryptionMaterialsProvider;
    }

    @Config(value="hive.s3.encryption-materials-provider")
    @ConfigDescription(value="Use a custom encryption materials provider for S3 data encryption")
    public HiveS3Config setS3EncryptionMaterialsProvider(String s3EncryptionMaterialsProvider) {
        this.s3EncryptionMaterialsProvider = s3EncryptionMaterialsProvider;
        return this;
    }

    public String getS3KmsKeyId() {
        return this.s3KmsKeyId;
    }

    @Config(value="hive.s3.kms-key-id")
    @ConfigDescription(value="Use an AWS KMS key for S3 data encryption")
    public HiveS3Config setS3KmsKeyId(String s3KmsKeyId) {
        this.s3KmsKeyId = s3KmsKeyId;
        return this;
    }

    public String getS3SseKmsKeyId() {
        return this.s3SseKmsKeyId;
    }

    @Config(value="hive.s3.sse.kms-key-id")
    @ConfigDescription(value="KMS Key ID to use for S3 server-side encryption with KMS-managed key")
    public HiveS3Config setS3SseKmsKeyId(String s3SseKmsKeyId) {
        this.s3SseKmsKeyId = s3SseKmsKeyId;
        return this;
    }

    public boolean isS3SseEnabled() {
        return this.s3SseEnabled;
    }

    @Config(value="hive.s3.sse.enabled")
    @ConfigDescription(value="Enable S3 server side encryption")
    public HiveS3Config setS3SseEnabled(boolean s3SseEnabled) {
        this.s3SseEnabled = s3SseEnabled;
        return this;
    }

    @NotNull
    public PrestoS3SseType getS3SseType() {
        return this.s3SseType;
    }

    @Config(value="hive.s3.sse.type")
    @ConfigDescription(value="Key management type for S3 server-side encryption (S3 or KMS)")
    public HiveS3Config setS3SseType(PrestoS3SseType s3SseType) {
        this.s3SseType = s3SseType;
        return this;
    }

    @Min(value=0L)
    public @Min(value=0L) int getS3MaxClientRetries() {
        return this.s3MaxClientRetries;
    }

    @Config(value="hive.s3.max-client-retries")
    public HiveS3Config setS3MaxClientRetries(int s3MaxClientRetries) {
        this.s3MaxClientRetries = s3MaxClientRetries;
        return this;
    }

    @Min(value=0L)
    public @Min(value=0L) int getS3MaxErrorRetries() {
        return this.s3MaxErrorRetries;
    }

    @Config(value="hive.s3.max-error-retries")
    public HiveS3Config setS3MaxErrorRetries(int s3MaxErrorRetries) {
        this.s3MaxErrorRetries = s3MaxErrorRetries;
        return this;
    }

    @MinDuration(value="1s")
    @NotNull
    public @MinDuration(value="1s") @NotNull Duration getS3MaxBackoffTime() {
        return this.s3MaxBackoffTime;
    }

    @Config(value="hive.s3.max-backoff-time")
    public HiveS3Config setS3MaxBackoffTime(Duration s3MaxBackoffTime) {
        this.s3MaxBackoffTime = s3MaxBackoffTime;
        return this;
    }

    @MinDuration(value="1ms")
    @NotNull
    public @MinDuration(value="1ms") @NotNull Duration getS3MaxRetryTime() {
        return this.s3MaxRetryTime;
    }

    @Config(value="hive.s3.max-retry-time")
    public HiveS3Config setS3MaxRetryTime(Duration s3MaxRetryTime) {
        this.s3MaxRetryTime = s3MaxRetryTime;
        return this;
    }

    @MinDuration(value="1ms")
    @NotNull
    public @MinDuration(value="1ms") @NotNull Duration getS3ConnectTimeout() {
        return this.s3ConnectTimeout;
    }

    @Config(value="hive.s3.connect-timeout")
    public HiveS3Config setS3ConnectTimeout(Duration s3ConnectTimeout) {
        this.s3ConnectTimeout = s3ConnectTimeout;
        return this;
    }

    @MinDuration(value="1ms")
    @NotNull
    public @MinDuration(value="1ms") @NotNull Duration getS3SocketTimeout() {
        return this.s3SocketTimeout;
    }

    @Config(value="hive.s3.socket-timeout")
    public HiveS3Config setS3SocketTimeout(Duration s3SocketTimeout) {
        this.s3SocketTimeout = s3SocketTimeout;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getS3MaxConnections() {
        return this.s3MaxConnections;
    }

    @Config(value="hive.s3.max-connections")
    public HiveS3Config setS3MaxConnections(int s3MaxConnections) {
        this.s3MaxConnections = s3MaxConnections;
        return this;
    }

    @NotNull
    @FileExists
    public File getS3StagingDirectory() {
        return this.s3StagingDirectory;
    }

    @Config(value="hive.s3.staging-directory")
    @ConfigDescription(value="Temporary directory for staging files before uploading to S3")
    public HiveS3Config setS3StagingDirectory(File s3StagingDirectory) {
        this.s3StagingDirectory = s3StagingDirectory;
        return this;
    }

    @NotNull
    @MinDataSize(value="16MB")
    public @NotNull @MinDataSize(value="16MB") DataSize getS3MultipartMinFileSize() {
        return this.s3MultipartMinFileSize;
    }

    @Config(value="hive.s3.multipart.min-file-size")
    @ConfigDescription(value="Minimum file size for an S3 multipart upload")
    public HiveS3Config setS3MultipartMinFileSize(DataSize size) {
        this.s3MultipartMinFileSize = size;
        return this;
    }

    @NotNull
    @MinDataSize(value="5MB")
    public @NotNull @MinDataSize(value="5MB") DataSize getS3MultipartMinPartSize() {
        return this.s3MultipartMinPartSize;
    }

    @Config(value="hive.s3.multipart.min-part-size")
    @ConfigDescription(value="Minimum part size for an S3 multipart upload")
    public HiveS3Config setS3MultipartMinPartSize(DataSize size) {
        this.s3MultipartMinPartSize = size;
        return this;
    }

    public boolean isPinS3ClientToCurrentRegion() {
        return this.pinS3ClientToCurrentRegion;
    }

    @Config(value="hive.s3.pin-client-to-current-region")
    @ConfigDescription(value="Should the S3 client be pinned to the current EC2 region")
    public HiveS3Config setPinS3ClientToCurrentRegion(boolean pinS3ClientToCurrentRegion) {
        this.pinS3ClientToCurrentRegion = pinS3ClientToCurrentRegion;
        return this;
    }

    @NotNull
    public String getS3UserAgentPrefix() {
        return this.s3UserAgentPrefix;
    }

    @Config(value="hive.s3.user-agent-prefix")
    @ConfigDescription(value="The user agent prefix to use for S3 calls")
    public HiveS3Config setS3UserAgentPrefix(String s3UserAgentPrefix) {
        this.s3UserAgentPrefix = s3UserAgentPrefix;
        return this;
    }

    @NotNull
    public PrestoS3AclType getS3AclType() {
        return this.s3AclType;
    }

    @Config(value="hive.s3.upload-acl-type")
    @ConfigDescription(value="Canned ACL type for S3 uploads")
    public HiveS3Config setS3AclType(PrestoS3AclType s3AclType) {
        this.s3AclType = s3AclType;
        return this;
    }

    public boolean isSkipGlacierObjects() {
        return this.skipGlacierObjects;
    }

    @Config(value="hive.s3.skip-glacier-objects")
    public HiveS3Config setSkipGlacierObjects(boolean skipGlacierObjects) {
        this.skipGlacierObjects = skipGlacierObjects;
        return this;
    }

    public boolean isRequesterPaysEnabled() {
        return this.requesterPaysEnabled;
    }

    @Config(value="hive.s3.requester-pays.enabled")
    public HiveS3Config setRequesterPaysEnabled(boolean requesterPaysEnabled) {
        this.requesterPaysEnabled = requesterPaysEnabled;
        return this;
    }
}

