/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.security;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.prestosql.plugin.base.CatalogName;
import io.prestosql.plugin.hive.HiveTransactionHandle;
import io.prestosql.plugin.hive.authentication.HiveIdentity;
import io.prestosql.plugin.hive.metastore.Database;
import io.prestosql.plugin.hive.metastore.HivePrincipal;
import io.prestosql.plugin.hive.metastore.HivePrivilegeInfo;
import io.prestosql.plugin.hive.metastore.SemiTransactionalHiveMetastore;
import io.prestosql.plugin.hive.metastore.thrift.ThriftMetastoreUtil;
import io.prestosql.spi.connector.ColumnMetadata;
import io.prestosql.spi.connector.ConnectorAccessControl;
import io.prestosql.spi.connector.ConnectorSecurityContext;
import io.prestosql.spi.connector.SchemaRoutineName;
import io.prestosql.spi.connector.SchemaTableName;
import io.prestosql.spi.security.AccessDeniedException;
import io.prestosql.spi.security.ConnectorIdentity;
import io.prestosql.spi.security.PrestoPrincipal;
import io.prestosql.spi.security.PrincipalType;
import io.prestosql.spi.security.Privilege;
import io.prestosql.spi.security.RoleGrant;
import io.prestosql.spi.security.ViewExpression;
import io.prestosql.spi.type.Type;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Inject;

public class SqlStandardAccessControl
implements ConnectorAccessControl {
    public static final String ADMIN_ROLE_NAME = "admin";
    private static final String INFORMATION_SCHEMA_NAME = "information_schema";
    private static final SchemaTableName ROLES = new SchemaTableName("information_schema", "roles");
    private static final SchemaTableName ROLE_AUHTORIZATION_DESCRIPTORS = new SchemaTableName("information_schema", "role_authorization_descriptors");
    private final String catalogName;
    private final Function<HiveTransactionHandle, SemiTransactionalHiveMetastore> metastoreProvider;

    @Inject
    public SqlStandardAccessControl(CatalogName catalogName, Function<HiveTransactionHandle, SemiTransactionalHiveMetastore> metastoreProvider) {
        this.catalogName = Objects.requireNonNull(catalogName, "catalogName is null").toString();
        this.metastoreProvider = Objects.requireNonNull(metastoreProvider, "metastoreProvider is null");
    }

    public void checkCanCreateSchema(ConnectorSecurityContext context, String schemaName) {
        if (!this.isAdmin(context)) {
            AccessDeniedException.denyCreateSchema((String)schemaName);
        }
    }

    public void checkCanDropSchema(ConnectorSecurityContext context, String schemaName) {
        if (!this.isDatabaseOwner(context, schemaName)) {
            AccessDeniedException.denyDropSchema((String)schemaName);
        }
    }

    public void checkCanRenameSchema(ConnectorSecurityContext context, String schemaName, String newSchemaName) {
        if (!this.isDatabaseOwner(context, schemaName)) {
            AccessDeniedException.denyRenameSchema((String)schemaName, (String)newSchemaName);
        }
    }

    public void checkCanSetSchemaAuthorization(ConnectorSecurityContext context, String schemaName, PrestoPrincipal principal) {
        if (!this.isDatabaseOwner(context, schemaName)) {
            AccessDeniedException.denySetSchemaAuthorization((String)schemaName, (PrestoPrincipal)principal);
        }
    }

    public void checkCanShowSchemas(ConnectorSecurityContext context) {
    }

    public Set<String> filterSchemas(ConnectorSecurityContext context, Set<String> schemaNames) {
        return schemaNames;
    }

    public void checkCanShowCreateTable(ConnectorSecurityContext context, SchemaTableName tableName) {
        if (!this.checkTablePermission(context, tableName, HivePrivilegeInfo.HivePrivilege.SELECT, true)) {
            AccessDeniedException.denyShowCreateTable((String)tableName.toString());
        }
    }

    public void checkCanShowCreateSchema(ConnectorSecurityContext context, String schemaName) {
        if (!this.isDatabaseOwner(context, schemaName)) {
            AccessDeniedException.denyShowCreateSchema((String)schemaName);
        }
    }

    public void checkCanCreateTable(ConnectorSecurityContext context, SchemaTableName tableName) {
        if (!this.isDatabaseOwner(context, tableName.getSchemaName())) {
            AccessDeniedException.denyCreateTable((String)tableName.toString());
        }
    }

    public void checkCanDropTable(ConnectorSecurityContext context, SchemaTableName tableName) {
        if (!this.isTableOwner(context, tableName)) {
            AccessDeniedException.denyDropTable((String)tableName.toString());
        }
    }

    public void checkCanRenameTable(ConnectorSecurityContext context, SchemaTableName tableName, SchemaTableName newTableName) {
        if (!this.isTableOwner(context, tableName)) {
            AccessDeniedException.denyRenameTable((String)tableName.toString(), (String)newTableName.toString());
        }
    }

    public void checkCanSetTableComment(ConnectorSecurityContext context, SchemaTableName tableName) {
        if (!this.isTableOwner(context, tableName)) {
            AccessDeniedException.denyCommentTable((String)tableName.toString());
        }
    }

    public void checkCanSetColumnComment(ConnectorSecurityContext context, SchemaTableName tableName) {
        if (!this.isTableOwner(context, tableName)) {
            AccessDeniedException.denyCommentColumn((String)tableName.toString());
        }
    }

    public void checkCanShowTables(ConnectorSecurityContext context, String schemaName) {
    }

    public Set<SchemaTableName> filterTables(ConnectorSecurityContext context, Set<SchemaTableName> tableNames) {
        return tableNames;
    }

    public void checkCanShowColumns(ConnectorSecurityContext context, SchemaTableName tableName) {
        if (!this.hasAnyTablePermission(context, tableName)) {
            AccessDeniedException.denyShowColumns((String)tableName.toString());
        }
    }

    public List<ColumnMetadata> filterColumns(ConnectorSecurityContext context, SchemaTableName tableName, List<ColumnMetadata> columns) {
        if (!this.hasAnyTablePermission(context, tableName)) {
            return ImmutableList.of();
        }
        return columns;
    }

    public void checkCanAddColumn(ConnectorSecurityContext context, SchemaTableName tableName) {
        if (!this.isTableOwner(context, tableName)) {
            AccessDeniedException.denyAddColumn((String)tableName.toString());
        }
    }

    public void checkCanDropColumn(ConnectorSecurityContext context, SchemaTableName tableName) {
        if (!this.isTableOwner(context, tableName)) {
            AccessDeniedException.denyDropColumn((String)tableName.toString());
        }
    }

    public void checkCanRenameColumn(ConnectorSecurityContext context, SchemaTableName tableName) {
        if (!this.isTableOwner(context, tableName)) {
            AccessDeniedException.denyRenameColumn((String)tableName.toString());
        }
    }

    public void checkCanSelectFromColumns(ConnectorSecurityContext context, SchemaTableName tableName, Set<String> columnNames) {
        if (!this.checkTablePermission(context, tableName, HivePrivilegeInfo.HivePrivilege.SELECT, false)) {
            AccessDeniedException.denySelectTable((String)tableName.toString());
        }
    }

    public void checkCanInsertIntoTable(ConnectorSecurityContext context, SchemaTableName tableName) {
        if (!this.checkTablePermission(context, tableName, HivePrivilegeInfo.HivePrivilege.INSERT, false)) {
            AccessDeniedException.denyInsertTable((String)tableName.toString());
        }
    }

    public void checkCanDeleteFromTable(ConnectorSecurityContext context, SchemaTableName tableName) {
        if (!this.checkTablePermission(context, tableName, HivePrivilegeInfo.HivePrivilege.DELETE, false)) {
            AccessDeniedException.denyDeleteTable((String)tableName.toString());
        }
    }

    public void checkCanCreateView(ConnectorSecurityContext context, SchemaTableName viewName) {
        if (!this.isDatabaseOwner(context, viewName.getSchemaName())) {
            AccessDeniedException.denyCreateView((String)viewName.toString());
        }
    }

    public void checkCanRenameView(ConnectorSecurityContext context, SchemaTableName viewName, SchemaTableName newViewName) {
        if (!this.isTableOwner(context, viewName)) {
            AccessDeniedException.denyRenameView((String)viewName.toString(), (String)newViewName.toString());
        }
    }

    public void checkCanDropView(ConnectorSecurityContext context, SchemaTableName viewName) {
        if (!this.isTableOwner(context, viewName)) {
            AccessDeniedException.denyDropView((String)viewName.toString());
        }
    }

    public void checkCanCreateViewWithSelectFromColumns(ConnectorSecurityContext context, SchemaTableName tableName, Set<String> columnNames) {
        this.checkCanSelectFromColumns(context, tableName, columnNames);
        if (!this.checkTablePermission(context, tableName, HivePrivilegeInfo.HivePrivilege.SELECT, true)) {
            AccessDeniedException.denyCreateViewWithSelect((String)tableName.toString(), (ConnectorIdentity)context.getIdentity());
        }
    }

    public void checkCanSetCatalogSessionProperty(ConnectorSecurityContext context, String propertyName) {
        if (!this.isAdmin(context)) {
            AccessDeniedException.denySetCatalogSessionProperty((String)this.catalogName, (String)propertyName);
        }
    }

    public void checkCanGrantTablePrivilege(ConnectorSecurityContext context, Privilege privilege, SchemaTableName tableName, PrestoPrincipal grantee, boolean grantOption) {
        if (this.isTableOwner(context, tableName)) {
            return;
        }
        if (!this.hasGrantOptionForPrivilege(context, privilege, tableName)) {
            AccessDeniedException.denyGrantTablePrivilege((String)privilege.name(), (String)tableName.toString());
        }
    }

    public void checkCanRevokeTablePrivilege(ConnectorSecurityContext context, Privilege privilege, SchemaTableName tableName, PrestoPrincipal revokee, boolean grantOption) {
        if (this.isTableOwner(context, tableName)) {
            return;
        }
        if (!this.hasGrantOptionForPrivilege(context, privilege, tableName)) {
            AccessDeniedException.denyRevokeTablePrivilege((String)privilege.name(), (String)tableName.toString());
        }
    }

    public void checkCanCreateRole(ConnectorSecurityContext context, String role, Optional<PrestoPrincipal> grantor) {
        if (grantor.isPresent()) {
            throw new AccessDeniedException("Hive Connector does not support WITH ADMIN statement");
        }
        if (!this.isAdmin(context)) {
            AccessDeniedException.denyCreateRole((String)role);
        }
    }

    public void checkCanDropRole(ConnectorSecurityContext context, String role) {
        if (!this.isAdmin(context)) {
            AccessDeniedException.denyDropRole((String)role);
        }
    }

    public void checkCanGrantRoles(ConnectorSecurityContext context, Set<String> roles, Set<PrestoPrincipal> grantees, boolean adminOption, Optional<PrestoPrincipal> grantor, String catalogName) {
        if (grantor.isPresent()) {
            throw new AccessDeniedException("Hive Connector does not support GRANTED BY statement");
        }
        if (!this.hasAdminOptionForRoles(context, roles)) {
            AccessDeniedException.denyGrantRoles(roles, grantees);
        }
    }

    public void checkCanRevokeRoles(ConnectorSecurityContext context, Set<String> roles, Set<PrestoPrincipal> grantees, boolean adminOption, Optional<PrestoPrincipal> grantor, String catalogName) {
        if (grantor.isPresent()) {
            throw new AccessDeniedException("Hive Connector does not support GRANTED BY statement");
        }
        if (!this.hasAdminOptionForRoles(context, roles)) {
            AccessDeniedException.denyRevokeRoles(roles, grantees);
        }
    }

    public void checkCanSetRole(ConnectorSecurityContext context, String role, String catalogName) {
        SemiTransactionalHiveMetastore metastore = this.metastoreProvider.apply((HiveTransactionHandle)context.getTransactionHandle());
        if (!ThriftMetastoreUtil.isRoleApplicable(metastore, new HivePrincipal(PrincipalType.USER, context.getIdentity().getUser()), role)) {
            AccessDeniedException.denySetRole((String)role);
        }
    }

    public void checkCanShowRoleAuthorizationDescriptors(ConnectorSecurityContext context, String catalogName) {
        if (!this.isAdmin(context)) {
            AccessDeniedException.denyShowRoleAuthorizationDescriptors((String)catalogName);
        }
    }

    public void checkCanShowRoles(ConnectorSecurityContext context, String catalogName) {
        if (!this.isAdmin(context)) {
            AccessDeniedException.denyShowRoles((String)catalogName);
        }
    }

    public void checkCanShowCurrentRoles(ConnectorSecurityContext context, String catalogName) {
    }

    public void checkCanShowRoleGrants(ConnectorSecurityContext context, String catalogName) {
    }

    public void checkCanExecuteProcedure(ConnectorSecurityContext context, SchemaRoutineName procedure) {
    }

    public Optional<ViewExpression> getRowFilter(ConnectorSecurityContext context, SchemaTableName tableName) {
        return Optional.empty();
    }

    public Optional<ViewExpression> getColumnMask(ConnectorSecurityContext context, SchemaTableName tableName, String columnName, Type type) {
        return Optional.empty();
    }

    private boolean isAdmin(ConnectorSecurityContext context) {
        SemiTransactionalHiveMetastore metastore = this.metastoreProvider.apply((HiveTransactionHandle)context.getTransactionHandle());
        return ThriftMetastoreUtil.isRoleEnabled(context.getIdentity(), metastore::listRoleGrants, ADMIN_ROLE_NAME);
    }

    private boolean isDatabaseOwner(ConnectorSecurityContext context, String databaseName) {
        if ("default".equalsIgnoreCase(databaseName)) {
            return true;
        }
        if (this.isAdmin(context)) {
            return true;
        }
        SemiTransactionalHiveMetastore metastore = this.metastoreProvider.apply((HiveTransactionHandle)context.getTransactionHandle());
        Optional<Database> databaseMetadata = metastore.getDatabase(databaseName);
        if (databaseMetadata.isEmpty()) {
            return false;
        }
        Database database = databaseMetadata.get();
        ConnectorIdentity identity = context.getIdentity();
        if (database.getOwnerType() == PrincipalType.USER && identity.getUser().equals(database.getOwnerName())) {
            return true;
        }
        if (database.getOwnerType() == PrincipalType.ROLE) {
            if (ThriftMetastoreUtil.isRoleEnabled(identity, metastore::listRoleGrants, database.getOwnerName())) {
                return true;
            }
        }
        return false;
    }

    private boolean isTableOwner(ConnectorSecurityContext context, SchemaTableName tableName) {
        return this.checkTablePermission(context, tableName, HivePrivilegeInfo.HivePrivilege.OWNERSHIP, false);
    }

    private boolean checkTablePermission(ConnectorSecurityContext context, SchemaTableName tableName, HivePrivilegeInfo.HivePrivilege requiredPrivilege, boolean grantOptionRequired) {
        if (this.isAdmin(context)) {
            return true;
        }
        if (tableName.equals((Object)ROLES) || tableName.equals((Object)ROLE_AUHTORIZATION_DESCRIPTORS)) {
            return false;
        }
        if (INFORMATION_SCHEMA_NAME.equals(tableName.getSchemaName())) {
            return true;
        }
        SemiTransactionalHiveMetastore metastore = this.metastoreProvider.apply((HiveTransactionHandle)context.getTransactionHandle());
        Set allowedPrincipals = (Set)metastore.listTablePrivileges(new HiveIdentity(context.getIdentity()), tableName.getSchemaName(), tableName.getTableName(), Optional.empty()).stream().filter(privilegeInfo -> privilegeInfo.getHivePrivilege() == requiredPrivilege).filter(privilegeInfo -> !grantOptionRequired || privilegeInfo.isGrantOption()).map(HivePrivilegeInfo::getGrantee).collect(ImmutableSet.toImmutableSet());
        return ThriftMetastoreUtil.listEnabledPrincipals(metastore, context.getIdentity()).anyMatch(allowedPrincipals::contains);
    }

    private boolean hasGrantOptionForPrivilege(ConnectorSecurityContext context, Privilege privilege, SchemaTableName tableName) {
        if (this.isAdmin(context)) {
            return true;
        }
        SemiTransactionalHiveMetastore metastore = this.metastoreProvider.apply((HiveTransactionHandle)context.getTransactionHandle());
        return ThriftMetastoreUtil.listApplicableTablePrivileges(metastore, tableName.getSchemaName(), tableName.getTableName(), context.getIdentity()).anyMatch(privilegeInfo -> privilegeInfo.getHivePrivilege() == HivePrivilegeInfo.toHivePrivilege(privilege) && privilegeInfo.isGrantOption());
    }

    private boolean hasAdminOptionForRoles(ConnectorSecurityContext context, Set<String> roles) {
        if (this.isAdmin(context)) {
            return true;
        }
        SemiTransactionalHiveMetastore metastore = this.metastoreProvider.apply((HiveTransactionHandle)context.getTransactionHandle());
        Set rolesWithGrantOption = ThriftMetastoreUtil.listApplicableRoles(new HivePrincipal(PrincipalType.USER, context.getIdentity().getUser()), metastore::listRoleGrants).filter(RoleGrant::isGrantable).map(RoleGrant::getRoleName).collect(Collectors.toSet());
        return rolesWithGrantOption.containsAll(roles);
    }

    private boolean hasAnyTablePermission(ConnectorSecurityContext context, SchemaTableName tableName) {
        if (this.isAdmin(context)) {
            return true;
        }
        if (tableName.equals((Object)ROLES)) {
            return false;
        }
        if (INFORMATION_SCHEMA_NAME.equals(tableName.getSchemaName())) {
            return true;
        }
        SemiTransactionalHiveMetastore metastore = this.metastoreProvider.apply((HiveTransactionHandle)context.getTransactionHandle());
        Set allowedPrincipals = (Set)metastore.listTablePrivileges(new HiveIdentity(context.getIdentity()), tableName.getSchemaName(), tableName.getTableName(), Optional.empty()).stream().map(HivePrivilegeInfo::getGrantee).collect(ImmutableSet.toImmutableSet());
        return ThriftMetastoreUtil.listEnabledPrincipals(metastore, context.getIdentity()).anyMatch(allowedPrincipals::contains);
    }
}

