/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.util;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Shorts;
import com.google.common.primitives.SignedBytes;
import io.airlift.slice.Slice;
import io.prestosql.plugin.hive.HiveType;
import io.prestosql.spi.Page;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.type.Type;
import java.util.List;
import java.util.Objects;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.ListTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.MapTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;

final class HiveBucketingV1 {
    private HiveBucketingV1() {
    }

    static int getBucketHashCode(List<TypeInfo> types, Page page, int position) {
        Preconditions.checkArgument((types.size() == page.getChannelCount() ? 1 : 0) != 0);
        int result = 0;
        for (int i = 0; i < page.getChannelCount(); ++i) {
            int fieldHash = HiveBucketingV1.hash(types.get(i), page.getBlock(i), position);
            result = result * 31 + fieldHash;
        }
        return result;
    }

    static int getBucketHashCode(List<TypeInfo> types, Object[] values) {
        Preconditions.checkArgument((types.size() == values.length ? 1 : 0) != 0);
        int result = 0;
        for (int i = 0; i < values.length; ++i) {
            int fieldHash = HiveBucketingV1.hash(types.get(i), values[i]);
            result = result * 31 + fieldHash;
        }
        return result;
    }

    static int hash(TypeInfo type, Block block, int position) {
        if (block.isNull(position)) {
            return 0;
        }
        switch (type.getCategory()) {
            case PRIMITIVE: {
                PrimitiveTypeInfo typeInfo = (PrimitiveTypeInfo)type;
                PrimitiveObjectInspector.PrimitiveCategory primitiveCategory = typeInfo.getPrimitiveCategory();
                Type prestoType = Objects.requireNonNull(HiveType.getPrimitiveType(typeInfo));
                switch (primitiveCategory) {
                    case BOOLEAN: {
                        return prestoType.getBoolean(block, position) ? 1 : 0;
                    }
                    case BYTE: {
                        return SignedBytes.checkedCast((long)prestoType.getLong(block, position));
                    }
                    case SHORT: {
                        return Shorts.checkedCast((long)prestoType.getLong(block, position));
                    }
                    case INT: {
                        return Math.toIntExact(prestoType.getLong(block, position));
                    }
                    case LONG: {
                        long bigintValue = prestoType.getLong(block, position);
                        return (int)(bigintValue >>> 32 ^ bigintValue);
                    }
                    case FLOAT: {
                        return Float.floatToIntBits(Float.intBitsToFloat(Math.toIntExact(prestoType.getLong(block, position))));
                    }
                    case DOUBLE: {
                        long doubleValue = Double.doubleToLongBits(prestoType.getDouble(block, position));
                        return (int)(doubleValue >>> 32 ^ doubleValue);
                    }
                    case STRING: {
                        return HiveBucketingV1.hashBytes(0, prestoType.getSlice(block, position));
                    }
                    case VARCHAR: {
                        return HiveBucketingV1.hashBytes(1, prestoType.getSlice(block, position));
                    }
                    case DATE: {
                        return Math.toIntExact(prestoType.getLong(block, position));
                    }
                    case TIMESTAMP: {
                        return HiveBucketingV1.hashTimestamp(prestoType.getLong(block, position));
                    }
                }
                throw new UnsupportedOperationException("Computation of Hive bucket hashCode is not supported for Hive primitive category: " + primitiveCategory);
            }
            case LIST: {
                return HiveBucketingV1.hashOfList((ListTypeInfo)type, (Block)block.getObject(position, Block.class));
            }
            case MAP: {
                return HiveBucketingV1.hashOfMap((MapTypeInfo)type, (Block)block.getObject(position, Block.class));
            }
        }
        throw new UnsupportedOperationException("Computation of Hive bucket hashCode is not supported for Hive category: " + type.getCategory());
    }

    private static int hash(TypeInfo type, Object value) {
        if (value == null) {
            return 0;
        }
        switch (type.getCategory()) {
            case PRIMITIVE: {
                PrimitiveTypeInfo typeInfo = (PrimitiveTypeInfo)type;
                PrimitiveObjectInspector.PrimitiveCategory primitiveCategory = typeInfo.getPrimitiveCategory();
                switch (primitiveCategory) {
                    case BOOLEAN: {
                        return (Boolean)value != false ? 1 : 0;
                    }
                    case BYTE: {
                        return SignedBytes.checkedCast((long)((Long)value));
                    }
                    case SHORT: {
                        return Shorts.checkedCast((long)((Long)value));
                    }
                    case INT: {
                        return Math.toIntExact((Long)value);
                    }
                    case LONG: {
                        long bigintValue = (Long)value;
                        return (int)(bigintValue >>> 32 ^ bigintValue);
                    }
                    case FLOAT: {
                        return Float.floatToIntBits(Float.intBitsToFloat(Math.toIntExact((Long)value)));
                    }
                    case DOUBLE: {
                        long doubleValue = Double.doubleToLongBits((Double)value);
                        return (int)(doubleValue >>> 32 ^ doubleValue);
                    }
                    case STRING: {
                        return HiveBucketingV1.hashBytes(0, (Slice)value);
                    }
                    case VARCHAR: {
                        return HiveBucketingV1.hashBytes(1, (Slice)value);
                    }
                    case DATE: {
                        return Math.toIntExact((Long)value);
                    }
                    case TIMESTAMP: {
                        return HiveBucketingV1.hashTimestamp((Long)value);
                    }
                }
                throw new UnsupportedOperationException("Computation of Hive bucket hashCode is not supported for Hive primitive category: " + primitiveCategory);
            }
            case LIST: {
                return HiveBucketingV1.hashOfList((ListTypeInfo)type, (Block)value);
            }
            case MAP: {
                return HiveBucketingV1.hashOfMap((MapTypeInfo)type, (Block)value);
            }
        }
        throw new UnsupportedOperationException("Computation of Hive bucket hashCode is not supported for Hive category: " + type.getCategory());
    }

    private static int hashTimestamp(long epochMillis) {
        long seconds = Math.floorDiv(epochMillis, 1000L) << 30;
        long nanos = (long)Math.floorMod(epochMillis, 1000) * 1000000L;
        long secondsAndNanos = seconds | nanos;
        return (int)(secondsAndNanos >>> 32 ^ secondsAndNanos);
    }

    private static int hashOfMap(MapTypeInfo type, Block singleMapBlock) {
        TypeInfo keyTypeInfo = type.getMapKeyTypeInfo();
        TypeInfo valueTypeInfo = type.getMapValueTypeInfo();
        int result = 0;
        for (int i = 0; i < singleMapBlock.getPositionCount(); i += 2) {
            result += HiveBucketingV1.hash(keyTypeInfo, singleMapBlock, i) ^ HiveBucketingV1.hash(valueTypeInfo, singleMapBlock, i + 1);
        }
        return result;
    }

    private static int hashOfList(ListTypeInfo type, Block singleListBlock) {
        TypeInfo elementTypeInfo = type.getListElementTypeInfo();
        int result = 0;
        for (int i = 0; i < singleListBlock.getPositionCount(); ++i) {
            result = result * 31 + HiveBucketingV1.hash(elementTypeInfo, singleListBlock, i);
        }
        return result;
    }

    private static int hashBytes(int initialValue, Slice bytes) {
        int result = initialValue;
        for (int i = 0; i < bytes.length(); ++i) {
            result = result * 31 + bytes.getByte(i);
        }
        return result;
    }
}

