/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slices;
import io.prestosql.plugin.hive.AcidInfo;
import io.prestosql.plugin.hive.HiveColumnHandle;
import io.prestosql.plugin.hive.HivePartitionKey;
import io.prestosql.plugin.hive.HiveSplit;
import io.prestosql.plugin.hive.InternalHiveSplit;
import io.prestosql.plugin.hive.TableToPartitionMapping;
import io.prestosql.plugin.hive.s3select.S3SelectPushdown;
import io.prestosql.plugin.hive.util.HiveUtil;
import io.prestosql.spi.HostAddress;
import io.prestosql.spi.predicate.Domain;
import io.prestosql.spi.predicate.TupleDomain;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Properties;
import java.util.function.BooleanSupplier;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputFormat;

public class InternalHiveSplitFactory {
    private final FileSystem fileSystem;
    private final String partitionName;
    private final InputFormat<?, ?> inputFormat;
    private final Properties schema;
    private final List<HivePartitionKey> partitionKeys;
    private final Optional<Domain> pathDomain;
    private final TableToPartitionMapping tableToPartitionMapping;
    private final BooleanSupplier partitionMatchSupplier;
    private final Optional<HiveSplit.BucketConversion> bucketConversion;
    private final boolean forceLocalScheduling;
    private final boolean s3SelectPushdownEnabled;

    public InternalHiveSplitFactory(FileSystem fileSystem, String partitionName, InputFormat<?, ?> inputFormat, Properties schema, List<HivePartitionKey> partitionKeys, TupleDomain<HiveColumnHandle> effectivePredicate, BooleanSupplier partitionMatchSupplier, TableToPartitionMapping tableToPartitionMapping, Optional<HiveSplit.BucketConversion> bucketConversion, boolean forceLocalScheduling, boolean s3SelectPushdownEnabled) {
        this.fileSystem = Objects.requireNonNull(fileSystem, "fileSystem is null");
        this.partitionName = Objects.requireNonNull(partitionName, "partitionName is null");
        this.inputFormat = Objects.requireNonNull(inputFormat, "inputFormat is null");
        this.schema = Objects.requireNonNull(schema, "schema is null");
        this.partitionKeys = Objects.requireNonNull(partitionKeys, "partitionKeys is null");
        this.pathDomain = InternalHiveSplitFactory.getPathDomain(Objects.requireNonNull(effectivePredicate, "effectivePredicate is null"));
        this.partitionMatchSupplier = Objects.requireNonNull(partitionMatchSupplier, "partitionMatchSupplier is null");
        this.tableToPartitionMapping = Objects.requireNonNull(tableToPartitionMapping, "tableToPartitionMapping is null");
        this.bucketConversion = Objects.requireNonNull(bucketConversion, "bucketConversion is null");
        this.forceLocalScheduling = forceLocalScheduling;
        this.s3SelectPushdownEnabled = s3SelectPushdownEnabled;
    }

    public String getPartitionName() {
        return this.partitionName;
    }

    public Optional<InternalHiveSplit> createInternalHiveSplit(LocatedFileStatus status, OptionalInt bucketNumber, boolean splittable, Optional<AcidInfo> acidInfo) {
        splittable = splittable && HiveUtil.isSplittable(this.inputFormat, this.fileSystem, status.getPath());
        return this.createInternalHiveSplit(status.getPath(), status.getBlockLocations(), 0L, status.getLen(), status.getLen(), status.getModificationTime(), bucketNumber, splittable, acidInfo);
    }

    public Optional<InternalHiveSplit> createInternalHiveSplit(FileSplit split) throws IOException {
        FileStatus file = this.fileSystem.getFileStatus(split.getPath());
        return this.createInternalHiveSplit(split.getPath(), this.fileSystem.getFileBlockLocations(file, split.getStart(), split.getLength()), split.getStart(), split.getLength(), file.getLen(), file.getModificationTime(), OptionalInt.empty(), false, Optional.empty());
    }

    private Optional<InternalHiveSplit> createInternalHiveSplit(Path path, BlockLocation[] blockLocations, long start, long length, long fileSize, long fileModificationTime, OptionalInt bucketNumber, boolean splittable, Optional<AcidInfo> acidInfo) {
        String pathString = path.toString();
        if (!InternalHiveSplitFactory.pathMatchesPredicate(this.pathDomain, pathString)) {
            return Optional.empty();
        }
        if (!this.partitionMatchSupplier.getAsBoolean()) {
            return Optional.empty();
        }
        boolean forceLocalScheduling = this.forceLocalScheduling;
        if (fileSize == 0L && blockLocations.length == 0) {
            blockLocations = new BlockLocation[]{new BlockLocation()};
            forceLocalScheduling = false;
        }
        ImmutableList.Builder blockBuilder = ImmutableList.builder();
        for (BlockLocation blockLocation : blockLocations) {
            long blockEnd;
            long blockStart = Math.max(start, blockLocation.getOffset());
            if (blockStart > (blockEnd = Math.min(start + length, blockLocation.getOffset() + blockLocation.getLength())) || blockStart == blockEnd && (blockStart != start || blockEnd != start + length)) continue;
            blockBuilder.add((Object)new InternalHiveSplit.InternalHiveBlock(blockStart, blockEnd, InternalHiveSplitFactory.getHostAddresses(blockLocation)));
        }
        ImmutableList blocks = blockBuilder.build();
        InternalHiveSplitFactory.checkBlocks((List<InternalHiveSplit.InternalHiveBlock>)blocks, start, length);
        if (!splittable) {
            blocks = ImmutableList.of((Object)new InternalHiveSplit.InternalHiveBlock(start, start + length, ((InternalHiveSplit.InternalHiveBlock)blocks.get(0)).getAddresses()));
        }
        return Optional.of(new InternalHiveSplit(this.partitionName, pathString, start, start + length, fileSize, fileModificationTime, this.schema, this.partitionKeys, (List<InternalHiveSplit.InternalHiveBlock>)blocks, bucketNumber, splittable, forceLocalScheduling && InternalHiveSplitFactory.allBlocksHaveAddress((Collection<InternalHiveSplit.InternalHiveBlock>)blocks), this.tableToPartitionMapping, this.bucketConversion, this.s3SelectPushdownEnabled && S3SelectPushdown.isCompressionCodecSupported(this.inputFormat, path), acidInfo));
    }

    private static void checkBlocks(List<InternalHiveSplit.InternalHiveBlock> blocks, long start, long length) {
        Preconditions.checkArgument((length >= 0L ? 1 : 0) != 0);
        Preconditions.checkArgument((!blocks.isEmpty() ? 1 : 0) != 0);
        Preconditions.checkArgument((start == blocks.get(0).getStart() ? 1 : 0) != 0);
        Preconditions.checkArgument((start + length == blocks.get(blocks.size() - 1).getEnd() ? 1 : 0) != 0);
        for (int i = 1; i < blocks.size(); ++i) {
            Preconditions.checkArgument((blocks.get(i - 1).getEnd() == blocks.get(i).getStart() ? 1 : 0) != 0);
        }
    }

    private static boolean allBlocksHaveAddress(Collection<InternalHiveSplit.InternalHiveBlock> blocks) {
        return blocks.stream().map(InternalHiveSplit.InternalHiveBlock::getAddresses).noneMatch(List::isEmpty);
    }

    private static List<HostAddress> getHostAddresses(BlockLocation blockLocation) {
        return (List)Arrays.stream(InternalHiveSplitFactory.getBlockHosts(blockLocation)).map(HostAddress::fromString).filter(address -> !address.getHostText().equals("localhost")).collect(ImmutableList.toImmutableList());
    }

    private static String[] getBlockHosts(BlockLocation blockLocation) {
        try {
            return blockLocation.getHosts();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static Optional<Domain> getPathDomain(TupleDomain<HiveColumnHandle> effectivePredicate) {
        return effectivePredicate.getDomains().flatMap(domains -> domains.entrySet().stream().filter(entry -> HiveColumnHandle.isPathColumnHandle((HiveColumnHandle)entry.getKey())).map(Map.Entry::getValue).findFirst());
    }

    private static boolean pathMatchesPredicate(Optional<Domain> pathDomain, String path) {
        return pathDomain.map(domain -> domain.includesNullableValue((Object)Slices.utf8Slice((String)path))).orElse(true);
    }
}

