/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import io.prestosql.plugin.hive.util.SortBuffer;
import io.prestosql.spi.Page;
import io.prestosql.spi.PageBuilder;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.SortOrder;
import io.prestosql.spi.type.Type;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class MergingPageIterator
extends AbstractIterator<Page> {
    private final List<Type> types;
    private final List<Integer> sortFields;
    private final List<SortOrder> sortOrders;
    private final PageBuilder pageBuilder;
    private final Iterator<PagePosition> pagePositions;

    public MergingPageIterator(Collection<Iterator<Page>> iterators, List<Type> types, List<Integer> sortFields, List<SortOrder> sortOrders) {
        Objects.requireNonNull(sortFields, "sortFields is null");
        Objects.requireNonNull(sortOrders, "sortOrders is null");
        Preconditions.checkArgument((sortFields.size() == sortOrders.size() ? 1 : 0) != 0, (Object)"sortFields and sortOrders size must match");
        this.types = ImmutableList.copyOf((Collection)Objects.requireNonNull(types, "types is null"));
        this.sortFields = ImmutableList.copyOf(sortFields);
        this.sortOrders = ImmutableList.copyOf(sortOrders);
        this.pageBuilder = new PageBuilder(types);
        this.pagePositions = Iterators.mergeSorted((Iterable)iterators.stream().map(pages -> Iterators.concat((Iterator)Iterators.transform((Iterator)pages, x$0 -> new PagePositionIterator((Page)x$0)))).collect(Collectors.toList()), Comparator.naturalOrder());
    }

    protected Page computeNext() {
        while (!this.pageBuilder.isFull() && this.pagePositions.hasNext()) {
            this.pagePositions.next().appendTo(this.pageBuilder);
        }
        if (this.pageBuilder.isEmpty()) {
            return (Page)this.endOfData();
        }
        Page page = this.pageBuilder.build();
        this.pageBuilder.reset();
        return page;
    }

    private class PagePosition
    implements Comparable<PagePosition> {
        private final Page page;
        private final int position;

        public PagePosition(Page page, int position) {
            this.page = Objects.requireNonNull(page, "page is null");
            this.position = position;
        }

        public void appendTo(PageBuilder pageBuilder) {
            SortBuffer.appendPositionTo(this.page, this.position, pageBuilder);
        }

        @Override
        public int compareTo(PagePosition other) {
            for (int i = 0; i < MergingPageIterator.this.sortFields.size(); ++i) {
                Block otherBlock;
                Block block;
                Type type;
                int channel = MergingPageIterator.this.sortFields.get(i);
                SortOrder order = MergingPageIterator.this.sortOrders.get(i);
                int result = order.compareBlockValue(type = MergingPageIterator.this.types.get(channel), block = this.page.getBlock(channel), this.position, otherBlock = other.page.getBlock(channel), other.position);
                if (result == 0) continue;
                return result;
            }
            return 0;
        }
    }

    private class PagePositionIterator
    extends AbstractIterator<PagePosition> {
        private final Page page;
        private int position = -1;

        private PagePositionIterator(Page page) {
            this.page = Objects.requireNonNull(page, "page is null");
        }

        protected PagePosition computeNext() {
            ++this.position;
            if (this.position == this.page.getPositionCount()) {
                return (PagePosition)this.endOfData();
            }
            return new PagePosition(this.page, this.position);
        }
    }
}

