/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.util;

import com.google.common.collect.AbstractIterator;
import io.prestosql.memory.context.AggregatedMemoryContext;
import io.prestosql.orc.OrcDataSource;
import io.prestosql.orc.OrcPredicate;
import io.prestosql.orc.OrcReader;
import io.prestosql.orc.OrcReaderOptions;
import io.prestosql.orc.OrcRecordReader;
import io.prestosql.plugin.hive.HiveErrorCode;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.Page;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.type.Type;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.List;
import java.util.Objects;
import org.joda.time.DateTimeZone;

public class TempFileReader
extends AbstractIterator<Page> {
    private final OrcRecordReader reader;

    public TempFileReader(List<Type> types, OrcDataSource dataSource) {
        Objects.requireNonNull(types, "types is null");
        try {
            OrcReader orcReader = new OrcReader(dataSource, new OrcReaderOptions());
            this.reader = orcReader.createRecordReader(orcReader.getRootColumn().getNestedColumns(), types, OrcPredicate.TRUE, DateTimeZone.UTC, AggregatedMemoryContext.newSimpleAggregatedMemoryContext(), 1, TempFileReader::handleException);
        }
        catch (IOException e) {
            throw TempFileReader.handleException(e);
        }
    }

    protected Page computeNext() {
        try {
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedIOException();
            }
            Page page = this.reader.nextPage();
            if (page == null) {
                return (Page)this.endOfData();
            }
            return page.getLoadedPage();
        }
        catch (IOException e) {
            throw TempFileReader.handleException(e);
        }
    }

    private static PrestoException handleException(Exception e) {
        return new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_WRITER_DATA_ERROR, "Failed to read temporary data", (Throwable)e);
    }
}

