/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.net.HostAndPort;
import com.google.common.util.concurrent.MoreExecutors;
import io.airlift.concurrent.BoundedExecutor;
import io.airlift.concurrent.MoreFutures;
import io.airlift.concurrent.Threads;
import io.airlift.event.client.EventClient;
import io.airlift.json.JsonCodec;
import io.airlift.stats.CounterStat;
import io.prestosql.GroupByHashPageIndexerFactory;
import io.prestosql.plugin.base.CatalogName;
import io.prestosql.plugin.hive.AbstractTestHive;
import io.prestosql.plugin.hive.CachingDirectoryLister;
import io.prestosql.plugin.hive.DirectoryLister;
import io.prestosql.plugin.hive.GenericHiveRecordCursorProvider;
import io.prestosql.plugin.hive.HdfsConfig;
import io.prestosql.plugin.hive.HdfsConfiguration;
import io.prestosql.plugin.hive.HdfsEnvironment;
import io.prestosql.plugin.hive.HiveColumnHandle;
import io.prestosql.plugin.hive.HiveConfig;
import io.prestosql.plugin.hive.HiveEventClient;
import io.prestosql.plugin.hive.HiveLocationService;
import io.prestosql.plugin.hive.HiveMetadata;
import io.prestosql.plugin.hive.HiveMetadataFactory;
import io.prestosql.plugin.hive.HiveOutputTableHandle;
import io.prestosql.plugin.hive.HivePageSinkProvider;
import io.prestosql.plugin.hive.HivePageSourceProvider;
import io.prestosql.plugin.hive.HivePartitionManager;
import io.prestosql.plugin.hive.HiveSplitManager;
import io.prestosql.plugin.hive.HiveStorageFormat;
import io.prestosql.plugin.hive.HiveTestUtils;
import io.prestosql.plugin.hive.HiveTransactionManager;
import io.prestosql.plugin.hive.HiveWriterStats;
import io.prestosql.plugin.hive.LocationService;
import io.prestosql.plugin.hive.NamenodeStats;
import io.prestosql.plugin.hive.NodeVersion;
import io.prestosql.plugin.hive.PartitionUpdate;
import io.prestosql.plugin.hive.authentication.HdfsAuthentication;
import io.prestosql.plugin.hive.authentication.HiveIdentity;
import io.prestosql.plugin.hive.authentication.NoHdfsAuthentication;
import io.prestosql.plugin.hive.metastore.Column;
import io.prestosql.plugin.hive.metastore.Database;
import io.prestosql.plugin.hive.metastore.HiveMetastore;
import io.prestosql.plugin.hive.metastore.MetastoreConfig;
import io.prestosql.plugin.hive.metastore.PrincipalPrivileges;
import io.prestosql.plugin.hive.metastore.Table;
import io.prestosql.plugin.hive.metastore.cache.CachingHiveMetastore;
import io.prestosql.plugin.hive.metastore.thrift.BridgingHiveMetastore;
import io.prestosql.plugin.hive.metastore.thrift.MetastoreLocator;
import io.prestosql.plugin.hive.metastore.thrift.TestingMetastoreLocator;
import io.prestosql.plugin.hive.metastore.thrift.ThriftHiveMetastore;
import io.prestosql.plugin.hive.metastore.thrift.ThriftMetastore;
import io.prestosql.plugin.hive.metastore.thrift.ThriftMetastoreConfig;
import io.prestosql.plugin.hive.security.SqlStandardAccessControlMetadata;
import io.prestosql.plugin.hive.util.HiveWriteUtils;
import io.prestosql.spi.NodeManager;
import io.prestosql.spi.PageIndexerFactory;
import io.prestosql.spi.connector.ColumnHandle;
import io.prestosql.spi.connector.ColumnMetadata;
import io.prestosql.spi.connector.ConnectorMetadata;
import io.prestosql.spi.connector.ConnectorOutputTableHandle;
import io.prestosql.spi.connector.ConnectorPageSink;
import io.prestosql.spi.connector.ConnectorPageSinkProvider;
import io.prestosql.spi.connector.ConnectorPageSource;
import io.prestosql.spi.connector.ConnectorPageSourceProvider;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.connector.ConnectorSplit;
import io.prestosql.spi.connector.ConnectorSplitManager;
import io.prestosql.spi.connector.ConnectorSplitSource;
import io.prestosql.spi.connector.ConnectorTableHandle;
import io.prestosql.spi.connector.ConnectorTableMetadata;
import io.prestosql.spi.connector.ConnectorTransactionHandle;
import io.prestosql.spi.connector.DynamicFilter;
import io.prestosql.spi.connector.SchemaTableName;
import io.prestosql.spi.connector.TableNotFoundException;
import io.prestosql.spi.predicate.TupleDomain;
import io.prestosql.spi.security.ConnectorIdentity;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeOperators;
import io.prestosql.sql.gen.JoinCompiler;
import io.prestosql.testing.MaterializedResult;
import io.prestosql.testing.MaterializedRow;
import io.prestosql.testing.QueryAssertions;
import io.prestosql.testing.TestingNodeManager;
import io.prestosql.type.BlockTypeOperators;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.stream.IntStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.azurebfs.AzureBlobFileSystem;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public abstract class AbstractTestHiveFileSystem {
    protected static final HdfsEnvironment.HdfsContext TESTING_CONTEXT = new HdfsEnvironment.HdfsContext(ConnectorIdentity.ofUser((String)"test"));
    protected String database;
    protected SchemaTableName table;
    protected SchemaTableName tableWithHeader;
    protected SchemaTableName tableWithHeaderAndFooter;
    protected SchemaTableName temporaryCreateTable;
    protected HdfsEnvironment hdfsEnvironment;
    protected LocationService locationService;
    protected TestingHiveMetastore metastoreClient;
    protected HiveMetadataFactory metadataFactory;
    protected HiveTransactionManager transactionManager;
    protected ConnectorSplitManager splitManager;
    protected ConnectorPageSinkProvider pageSinkProvider;
    protected ConnectorPageSourceProvider pageSourceProvider;
    private ExecutorService executor;
    private HiveConfig config;
    private ScheduledExecutorService heartbeatService;

    @BeforeClass
    public void setUp() {
        this.executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"hive-%s"));
        this.heartbeatService = Executors.newScheduledThreadPool(1);
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() {
        if (this.executor != null) {
            this.executor.shutdownNow();
            this.executor = null;
        }
        if (this.heartbeatService != null) {
            this.heartbeatService.shutdownNow();
            this.heartbeatService = null;
        }
    }

    protected abstract Path getBasePath();

    protected void onSetupComplete() {
    }

    protected void setup(String host, int port, String databaseName, boolean s3SelectPushdownEnabled, HdfsConfiguration hdfsConfiguration) {
        this.database = databaseName;
        this.table = new SchemaTableName(this.database, "presto_test_external_fs");
        this.tableWithHeader = new SchemaTableName(this.database, "presto_test_external_fs_with_header");
        this.tableWithHeaderAndFooter = new SchemaTableName(this.database, "presto_test_external_fs_with_header_and_footer");
        String random = UUID.randomUUID().toString().toLowerCase(Locale.ENGLISH).replace("-", "");
        this.temporaryCreateTable = new SchemaTableName(this.database, "tmp_presto_test_create_" + random);
        this.config = new HiveConfig().setS3SelectPushdownEnabled(s3SelectPushdownEnabled);
        Optional<HostAndPort> proxy = Optional.ofNullable(System.getProperty("hive.metastore.thrift.client.socks-proxy")).map(HostAndPort::fromString);
        TestingMetastoreLocator metastoreLocator = new TestingMetastoreLocator(proxy, HostAndPort.fromParts((String)host, (int)port));
        ExecutorService executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"AbstractTestHiveFileSystem-%s"));
        HivePartitionManager hivePartitionManager = new HivePartitionManager(this.config);
        this.hdfsEnvironment = new HdfsEnvironment(hdfsConfiguration, new HdfsConfig(), (HdfsAuthentication)new NoHdfsAuthentication());
        MetastoreConfig metastoreConfig = new MetastoreConfig();
        this.metastoreClient = new TestingHiveMetastore((HiveMetastore)new BridgingHiveMetastore((ThriftMetastore)new ThriftHiveMetastore((MetastoreLocator)metastoreLocator, new HiveConfig(), metastoreConfig, new ThriftMetastoreConfig(), this.hdfsEnvironment, false)), executor, this.getBasePath(), this.hdfsEnvironment);
        this.locationService = new HiveLocationService(this.hdfsEnvironment);
        JsonCodec partitionUpdateCodec = JsonCodec.jsonCodec(PartitionUpdate.class);
        this.metadataFactory = new HiveMetadataFactory(new CatalogName("hive"), this.config, metastoreConfig, (HiveMetastore)this.metastoreClient, this.hdfsEnvironment, hivePartitionManager, (ExecutorService)MoreExecutors.newDirectExecutorService(), this.heartbeatService, HiveTestUtils.TYPE_MANAGER, this.locationService, partitionUpdateCodec, new NodeVersion("test_version"), SqlStandardAccessControlMetadata::new);
        this.transactionManager = new HiveTransactionManager();
        this.splitManager = new HiveSplitManager(transactionHandle -> ((HiveMetadata)this.transactionManager.get((ConnectorTransactionHandle)transactionHandle)).getMetastore(), hivePartitionManager, new NamenodeStats(), this.hdfsEnvironment, (DirectoryLister)new CachingDirectoryLister(new HiveConfig()), (Executor)new BoundedExecutor((Executor)executor, this.config.getMaxSplitIteratorThreads()), new CounterStat(), this.config.getMaxOutstandingSplits(), this.config.getMaxOutstandingSplitsSize(), this.config.getMinPartitionBatchSize(), this.config.getMaxPartitionBatchSize(), this.config.getMaxInitialSplits(), this.config.getSplitLoaderConcurrency(), this.config.getMaxSplitsPerSecond(), this.config.getRecursiveDirWalkerEnabled(), HiveTestUtils.TYPE_MANAGER);
        TypeOperators typeOperators = new TypeOperators();
        BlockTypeOperators blockTypeOperators = new BlockTypeOperators(typeOperators);
        this.pageSinkProvider = new HivePageSinkProvider(HiveTestUtils.getDefaultHiveFileWriterFactories(this.config, this.hdfsEnvironment), this.hdfsEnvironment, HiveTestUtils.PAGE_SORTER, (HiveMetastore)this.metastoreClient, (PageIndexerFactory)new GroupByHashPageIndexerFactory(new JoinCompiler(typeOperators), blockTypeOperators), HiveTestUtils.TYPE_MANAGER, this.config, this.locationService, partitionUpdateCodec, (NodeManager)new TestingNodeManager("fake-environment"), (EventClient)new HiveEventClient(), HiveTestUtils.getHiveSessionProperties(this.config), new HiveWriterStats());
        this.pageSourceProvider = new HivePageSourceProvider(HiveTestUtils.TYPE_MANAGER, this.hdfsEnvironment, this.config, HiveTestUtils.getDefaultHivePageSourceFactories(this.hdfsEnvironment, this.config), HiveTestUtils.getDefaultHiveRecordCursorProviders(this.config, this.hdfsEnvironment), new GenericHiveRecordCursorProvider(this.hdfsEnvironment, this.config), Optional.empty());
        this.onSetupComplete();
    }

    protected ConnectorSession newSession() {
        return HiveTestUtils.getHiveSession(this.config);
    }

    protected AbstractTestHive.Transaction newTransaction() {
        return new AbstractTestHive.HiveTransaction(this.transactionManager, (HiveMetadata)this.metadataFactory.create());
    }

    @Test
    public void testGetRecords() throws Exception {
        QueryAssertions.assertEqualsIgnoreOrder((Iterable)this.readTable(this.table), (Iterable)MaterializedResult.resultBuilder((ConnectorSession)this.newSession(), (Type[])new Type[]{BigintType.BIGINT}).row(new Object[]{3L}).row(new Object[]{14L}).row(new Object[]{15L}).row(new Object[]{92L}).row(new Object[]{65L}).row(new Object[]{35L}).row(new Object[]{89L}).row(new Object[]{79L}).row(new Object[]{32L}).row(new Object[]{38L}).row(new Object[]{46L}).row(new Object[]{26L}).build());
    }

    @Test
    public void testGetRecordsWithHeader() throws IOException {
        QueryAssertions.assertEqualsIgnoreOrder((Iterable)this.readTable(this.tableWithHeader), (Iterable)MaterializedResult.resultBuilder((ConnectorSession)this.newSession(), (Type[])new Type[]{BigintType.BIGINT}).row(new Object[]{2L}).row(new Object[]{71L}).row(new Object[]{82L}).row(new Object[]{81L}).row(new Object[]{82L}).row(new Object[]{84L}).row(new Object[]{59L}).row(new Object[]{4L}).row(new Object[]{52L}).row(new Object[]{35L}).row(new Object[]{36L}).row(new Object[]{2L}).build());
    }

    @Test
    public void testGetRecordsWithHeaderAndFooter() throws IOException {
        QueryAssertions.assertEqualsIgnoreOrder((Iterable)this.readTable(this.tableWithHeaderAndFooter), (Iterable)MaterializedResult.resultBuilder((ConnectorSession)this.newSession(), (Type[])new Type[]{BigintType.BIGINT}).row(new Object[]{1L}).row(new Object[]{41L}).row(new Object[]{42L}).row(new Object[]{13L}).row(new Object[]{56L}).row(new Object[]{23L}).row(new Object[]{73L}).row(new Object[]{9L}).row(new Object[]{50L}).row(new Object[]{48L}).row(new Object[]{80L}).row(new Object[]{16L}).build());
    }

    @Test
    public void testGetFileStatus() throws Exception {
        Path basePath = this.getBasePath();
        Path tablePath = new Path(basePath, "presto_test_external_fs");
        Path filePath = new Path(tablePath, "test_table.csv");
        FileSystem fs = this.hdfsEnvironment.getFileSystem(TESTING_CONTEXT, basePath);
        Assert.assertTrue((boolean)fs.getFileStatus(basePath).isDirectory(), (String)"basePath should be considered a directory");
        Assert.assertTrue((boolean)fs.getFileStatus(tablePath).isDirectory(), (String)"tablePath should be considered a directory");
        Assert.assertTrue((boolean)fs.getFileStatus(filePath).isFile(), (String)"filePath should be considered a file");
        Assert.assertFalse((boolean)fs.getFileStatus(filePath).isDirectory(), (String)"filePath should not be considered a directory");
        Assert.assertFalse((boolean)fs.exists(new Path(basePath, "foo-" + UUID.randomUUID())), (String)"foo-random path should be found not to exist");
        Assert.assertFalse((boolean)fs.exists(new Path(basePath, "foo")), (String)"foo path should be found not to exist");
    }

    @Test
    public void testRename() throws Exception {
        Path basePath = new Path(this.getBasePath(), UUID.randomUUID().toString());
        FileSystem fs = this.hdfsEnvironment.getFileSystem(TESTING_CONTEXT, basePath);
        Assert.assertFalse((boolean)fs.exists(basePath));
        Path path = new Path(basePath, "foo.txt");
        Assert.assertTrue((boolean)fs.createNewFile(path));
        Assert.assertTrue((boolean)fs.exists(path));
        Path newPath = new Path(basePath, "bar.txt");
        Assert.assertFalse((boolean)fs.exists(newPath));
        Assert.assertTrue((boolean)fs.rename(path, newPath));
        Assert.assertFalse((boolean)fs.exists(path));
        Assert.assertTrue((boolean)fs.exists(newPath));
        Assert.assertFalse((boolean)fs.rename(path, path));
        Assert.assertTrue((boolean)fs.createNewFile(path));
        Assert.assertFalse((boolean)fs.rename(path, newPath));
        Assert.assertEquals((boolean)fs.rename(path, path), (boolean)(HiveWriteUtils.getRawFileSystem((FileSystem)fs) instanceof AzureBlobFileSystem));
        Assert.assertTrue((boolean)fs.delete(path, false));
        Assert.assertFalse((boolean)fs.exists(path));
        Path source = new Path(basePath, "source");
        Assert.assertTrue((boolean)fs.createNewFile(new Path(source, "test.txt")));
        Path target = new Path(basePath, "target");
        Assert.assertFalse((boolean)fs.exists(target));
        Assert.assertTrue((boolean)fs.rename(source, target));
        Assert.assertFalse((boolean)fs.exists(source));
        Assert.assertTrue((boolean)fs.exists(target));
        Assert.assertTrue((boolean)fs.createNewFile(new Path(source, "test.txt")));
        Assert.assertTrue((boolean)fs.rename(source, target));
        Assert.assertFalse((boolean)fs.exists(source));
        target = new Path(target, "source");
        Assert.assertTrue((boolean)fs.exists(target));
        Assert.assertTrue((boolean)fs.exists(new Path(target, "test.txt")));
        target = new Path(basePath, "target");
        Assert.assertTrue((boolean)fs.exists(target));
        Assert.assertTrue((boolean)fs.delete(target, true));
        Assert.assertFalse((boolean)fs.exists(target));
        fs.delete(basePath, true);
    }

    @Test
    public void testTableCreation() throws Exception {
        for (HiveStorageFormat storageFormat : HiveStorageFormat.values()) {
            if (storageFormat == HiveStorageFormat.CSV) continue;
            this.createTable(this.temporaryCreateTable, storageFormat);
            this.dropTable(this.temporaryCreateTable);
        }
    }

    private void createTable(SchemaTableName tableName, HiveStorageFormat storageFormat) throws Exception {
        ConnectorSession session;
        ConnectorMetadata metadata;
        ImmutableList columns = ImmutableList.builder().add((Object)new ColumnMetadata("id", (Type)BigintType.BIGINT)).build();
        MaterializedResult data = MaterializedResult.resultBuilder((ConnectorSession)this.newSession(), (Type[])new Type[]{BigintType.BIGINT}).row(new Object[]{1L}).row(new Object[]{3L}).row(new Object[]{2L}).build();
        try (AbstractTestHive.Transaction transaction = this.newTransaction();){
            metadata = transaction.getMetadata();
            session = this.newSession();
            ConnectorTableMetadata tableMetadata = new ConnectorTableMetadata(tableName, (List)columns, AbstractTestHive.createTableProperties(storageFormat));
            ConnectorOutputTableHandle outputHandle = metadata.beginCreateTable(session, tableMetadata, Optional.empty());
            ConnectorPageSink sink = this.pageSinkProvider.createPageSink(transaction.getTransactionHandle(), session, outputHandle);
            sink.appendPage(data.toPage());
            Collection fragments = (Collection)MoreFutures.getFutureValue((Future)sink.finish());
            metadata.finishCreateTable(session, outputHandle, fragments, (Collection)ImmutableList.of());
            transaction.commit();
            this.metastoreClient.updateTableLocation(this.database, tableName.getTableName(), this.locationService.getTableWriteInfo(((HiveOutputTableHandle)outputHandle).getLocationHandle(), false).getTargetPath().toString());
        }
        transaction = this.newTransaction();
        try {
            metadata = transaction.getMetadata();
            session = this.newSession();
            ConnectorTableHandle tableHandle = this.getTableHandle(metadata, tableName);
            List<ColumnHandle> columnHandles = AbstractTestHive.filterNonHiddenColumnHandles(metadata.getColumnHandles(session, tableHandle).values());
            ConnectorTableMetadata tableMetadata = metadata.getTableMetadata(session, this.getTableHandle(metadata, tableName));
            Assert.assertEquals(AbstractTestHive.filterNonHiddenColumnMetadata(tableMetadata.getColumns()), (Collection)columns);
            metadata.beginQuery(session);
            ConnectorSplitSource splitSource = AbstractTestHive.getSplits(this.splitManager, transaction, session, tableHandle);
            ConnectorSplit split = (ConnectorSplit)Iterables.getOnlyElement(AbstractTestHive.getAllSplits(splitSource));
            try (ConnectorPageSource pageSource = this.pageSourceProvider.createPageSource(transaction.getTransactionHandle(), session, split, tableHandle, columnHandles, DynamicFilter.EMPTY);){
                MaterializedResult result = MaterializedResult.materializeSourceDataStream((ConnectorSession)session, (ConnectorPageSource)pageSource, HiveTestUtils.getTypes(columnHandles));
                QueryAssertions.assertEqualsIgnoreOrder((Iterable)result.getMaterializedRows(), (Iterable)data.getMaterializedRows());
            }
            metadata.cleanupQuery(session);
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    private void dropTable(SchemaTableName table) {
        try (AbstractTestHive.Transaction transaction = this.newTransaction();){
            transaction.getMetastore().dropTable(this.newSession(), table.getSchemaName(), table.getTableName());
            transaction.commit();
        }
    }

    protected MaterializedResult readTable(SchemaTableName tableName) throws IOException {
        try (AbstractTestHive.Transaction transaction = this.newTransaction();){
            ConnectorMetadata metadata = transaction.getMetadata();
            ConnectorSession session = this.newSession();
            ConnectorTableHandle table = this.getTableHandle(metadata, tableName);
            ImmutableList columnHandles = ImmutableList.copyOf(metadata.getColumnHandles(session, table).values());
            metadata.beginQuery(session);
            ConnectorSplitSource splitSource = AbstractTestHive.getSplits(this.splitManager, transaction, session, table);
            List<Type> allTypes = HiveTestUtils.getTypes((List<? extends ColumnHandle>)columnHandles);
            List<Type> dataTypes = HiveTestUtils.getTypes((List)columnHandles.stream().filter(columnHandle -> !((HiveColumnHandle)columnHandle).isHidden()).collect(ImmutableList.toImmutableList()));
            MaterializedResult.Builder result = MaterializedResult.resultBuilder((ConnectorSession)session, dataTypes);
            List<ConnectorSplit> splits = AbstractTestHive.getAllSplits(splitSource);
            for (ConnectorSplit split : splits) {
                ConnectorPageSource pageSource = this.pageSourceProvider.createPageSource(transaction.getTransactionHandle(), session, split, table, (List)columnHandles, DynamicFilter.EMPTY);
                try {
                    MaterializedResult pageSourceResult = MaterializedResult.materializeSourceDataStream((ConnectorSession)session, (ConnectorPageSource)pageSource, allTypes);
                    for (MaterializedRow row : pageSourceResult.getMaterializedRows()) {
                        Object[] dataValues = IntStream.range(0, row.getFieldCount()).filter(arg_0 -> AbstractTestHiveFileSystem.lambda$readTable$2((List)columnHandles, arg_0)).mapToObj(arg_0 -> ((MaterializedRow)row).getField(arg_0)).toArray();
                        result.row(dataValues);
                    }
                }
                finally {
                    if (pageSource == null) continue;
                    pageSource.close();
                }
            }
            metadata.cleanupQuery(session);
            MaterializedResult materializedResult = result.build();
            return materializedResult;
        }
    }

    private ConnectorTableHandle getTableHandle(ConnectorMetadata metadata, SchemaTableName tableName) {
        ConnectorTableHandle handle = metadata.getTableHandle(this.newSession(), tableName);
        Preconditions.checkArgument((handle != null ? 1 : 0) != 0, (String)"table not found: %s", (Object)tableName);
        return handle;
    }

    private static /* synthetic */ boolean lambda$readTable$2(List columnHandles, int channel) {
        return !((HiveColumnHandle)columnHandles.get(channel)).isHidden();
    }

    protected static class TestingHiveMetastore
    extends CachingHiveMetastore {
        private final Path basePath;
        private final HdfsEnvironment hdfsEnvironment;

        public TestingHiveMetastore(HiveMetastore delegate, Executor executor, Path basePath, HdfsEnvironment hdfsEnvironment) {
            super(delegate, executor, OptionalLong.empty(), OptionalLong.empty(), 0L, CachingHiveMetastore.StatsRecording.ENABLED);
            this.basePath = basePath;
            this.hdfsEnvironment = hdfsEnvironment;
        }

        public Optional<Database> getDatabase(String databaseName) {
            return super.getDatabase(databaseName).map(database -> Database.builder((Database)database).setLocation(Optional.of(this.basePath.toString())).build());
        }

        public void createTable(HiveIdentity identity, Table table, PrincipalPrivileges privileges) {
            Table.Builder tableBuilder = Table.builder((Table)table);
            tableBuilder.getStorageBuilder().setLocation("/");
            super.createTable(identity, tableBuilder.build(), privileges);
        }

        public void dropTable(HiveIdentity identity, String databaseName, String tableName, boolean deleteData) {
            try {
                Optional table = this.getTable(identity, databaseName, tableName);
                if (table.isEmpty()) {
                    throw new TableNotFoundException(new SchemaTableName(databaseName, tableName));
                }
                List<String> locations = this.listAllDataPaths(identity, databaseName, tableName);
                Table.Builder tableBuilder = Table.builder((Table)((Table)table.get()));
                tableBuilder.getStorageBuilder().setLocation("/");
                this.replaceTable(identity, databaseName, tableName, tableBuilder.build(), new PrincipalPrivileges((Multimap)ImmutableMultimap.of(), (Multimap)ImmutableMultimap.of()));
                this.delegate.dropTable(identity, databaseName, tableName, false);
                if (deleteData) {
                    for (String location : locations) {
                        Path path = new Path(location);
                        this.hdfsEnvironment.getFileSystem(TESTING_CONTEXT, path).delete(path, true);
                    }
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            finally {
                this.invalidateTable(databaseName, tableName);
            }
        }

        public void updateTableLocation(String databaseName, String tableName, String location) {
            HiveIdentity identity = new HiveIdentity(TESTING_CONTEXT.getIdentity());
            Optional table = this.getTable(identity, databaseName, tableName);
            if (table.isEmpty()) {
                throw new TableNotFoundException(new SchemaTableName(databaseName, tableName));
            }
            Table.Builder tableBuilder = Table.builder((Table)((Table)table.get()));
            tableBuilder.getStorageBuilder().setLocation(location);
            this.replaceTable(identity, databaseName, tableName, tableBuilder.build(), new PrincipalPrivileges((Multimap)ImmutableMultimap.of(), (Multimap)ImmutableMultimap.of()));
        }

        private List<String> listAllDataPaths(HiveIdentity identity, String schemaName, String tableName) {
            Optional partitionNames;
            ImmutableList.Builder locations = ImmutableList.builder();
            Table table = (Table)this.getTable(identity, schemaName, tableName).get();
            List partitionColumnNames = (List)table.getPartitionColumns().stream().map(Column::getName).collect(ImmutableList.toImmutableList());
            if (table.getStorage().getLocation() != null) {
                locations.add((Object)table.getStorage().getLocation());
            }
            if ((partitionNames = this.getPartitionNamesByFilter(identity, schemaName, tableName, partitionColumnNames, TupleDomain.all())).isPresent()) {
                this.getPartitionsByNames(identity, table, (List)partitionNames.get()).values().stream().map(Optional::get).map(partition -> partition.getStorage().getLocation()).filter(location -> !location.startsWith(table.getStorage().getLocation())).forEach(arg_0 -> ((ImmutableList.Builder)locations).add(arg_0));
            }
            return locations.build();
        }
    }
}

