/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive;

import com.google.common.io.Files;
import com.google.common.io.MoreFiles;
import com.google.common.io.RecursiveDeleteOption;
import io.prestosql.plugin.hive.AbstractTestHive;
import io.prestosql.plugin.hive.HiveConfig;
import io.prestosql.plugin.hive.HiveTestUtils;
import io.prestosql.plugin.hive.authentication.HiveIdentity;
import io.prestosql.plugin.hive.metastore.Database;
import io.prestosql.plugin.hive.metastore.HiveMetastore;
import io.prestosql.spi.connector.ConnectorMetadata;
import io.prestosql.spi.connector.ConnectorTableHandle;
import io.prestosql.spi.connector.SchemaTableName;
import io.prestosql.spi.security.PrincipalType;
import io.prestosql.testing.TestingConnectorSession;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Objects;
import org.testng.SkipException;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;

public abstract class AbstractTestHiveLocal
extends AbstractTestHive {
    private static final String DEFAULT_TEST_DB_NAME = "test";
    private static final HiveIdentity HIVE_IDENTITY = new HiveIdentity(TestingConnectorSession.SESSION);
    private File tempDir;
    private final String testDbName;

    protected AbstractTestHiveLocal() {
        this(DEFAULT_TEST_DB_NAME);
    }

    protected AbstractTestHiveLocal(String testDbName) {
        this.testDbName = Objects.requireNonNull(testDbName, "testDbName is null");
    }

    protected abstract HiveMetastore createMetastore(File var1);

    @BeforeClass(alwaysRun=true)
    public void initialize() {
        this.tempDir = Files.createTempDir();
        HiveMetastore metastore = this.createMetastore(this.tempDir);
        metastore.createDatabase(HIVE_IDENTITY, Database.builder().setDatabaseName(this.testDbName).setOwnerName("public").setOwnerType(PrincipalType.ROLE).build());
        HiveConfig hiveConfig = new HiveConfig().setParquetTimeZone("America/Los_Angeles").setRcfileTimeZone("America/Los_Angeles");
        this.setup(this.testDbName, hiveConfig, metastore, HiveTestUtils.HDFS_ENVIRONMENT);
    }

    @AfterClass(alwaysRun=true)
    public void cleanup() throws IOException {
        try {
            this.getMetastoreClient().dropDatabase(HIVE_IDENTITY, this.testDbName);
        }
        catch (Throwable throwable) {
            MoreFiles.deleteRecursively((Path)this.tempDir.toPath(), (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
            throw throwable;
        }
        MoreFiles.deleteRecursively((Path)this.tempDir.toPath(), (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
    }

    @Override
    protected ConnectorTableHandle getTableHandle(ConnectorMetadata metadata, SchemaTableName tableName) {
        if (tableName.getTableName().startsWith("tmp_presto_test_")) {
            return super.getTableHandle(metadata, tableName);
        }
        throw new SkipException("tests using existing tables are not supported");
    }

    @Override
    public void testGetAllTableNames() {
        throw new SkipException("Test disabled for this subclass");
    }

    @Override
    public void testGetAllTableColumns() {
        throw new SkipException("Test disabled for this subclass");
    }

    @Override
    public void testGetAllTableColumnsInSchema() {
        throw new SkipException("Test disabled for this subclass");
    }

    @Override
    public void testGetTableNames() {
        throw new SkipException("Test disabled for this subclass");
    }

    @Override
    public void testGetTableSchemaOffline() {
        throw new SkipException("Test disabled for this subclass");
    }
}

