/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive;

import com.google.common.collect.ImmutableMap;
import com.google.common.io.Files;
import com.google.common.io.MoreFiles;
import com.google.common.io.RecursiveDeleteOption;
import io.prestosql.Session;
import io.prestosql.benchmark.BenchmarkSuite;
import io.prestosql.plugin.hive.authentication.HiveIdentity;
import io.prestosql.plugin.hive.metastore.Database;
import io.prestosql.plugin.hive.metastore.HiveMetastore;
import io.prestosql.plugin.hive.metastore.file.FileHiveMetastore;
import io.prestosql.plugin.hive.testing.TestingHiveConnectorFactory;
import io.prestosql.plugin.tpch.TpchConnectorFactory;
import io.prestosql.spi.connector.ConnectorFactory;
import io.prestosql.spi.security.PrincipalType;
import io.prestosql.testing.LocalQueryRunner;
import io.prestosql.testing.TestingConnectorSession;
import io.prestosql.testing.TestingSession;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Map;
import java.util.Objects;

public final class HiveBenchmarkQueryRunner {
    private HiveBenchmarkQueryRunner() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        String outputDirectory = Objects.requireNonNull(System.getProperty("outputDirectory"), "Must specify -DoutputDirectory=...");
        File tempDir = Files.createTempDir();
        try (LocalQueryRunner localQueryRunner = HiveBenchmarkQueryRunner.createLocalQueryRunner(tempDir);){
            new BenchmarkSuite(localQueryRunner, outputDirectory).runAllBenchmarks();
        }
        catch (Throwable throwable) {
            MoreFiles.deleteRecursively((Path)tempDir.toPath(), (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
            throw throwable;
        }
        MoreFiles.deleteRecursively((Path)tempDir.toPath(), (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
    }

    public static LocalQueryRunner createLocalQueryRunner(File tempDir) {
        Session session = TestingSession.testSessionBuilder().setCatalog("hive").setSchema("tpch").build();
        LocalQueryRunner localQueryRunner = LocalQueryRunner.create((Session)session);
        localQueryRunner.createCatalog("tpch", (ConnectorFactory)new TpchConnectorFactory(1), (Map)ImmutableMap.of());
        File hiveDir = new File(tempDir, "hive_data");
        FileHiveMetastore metastore = FileHiveMetastore.createTestingFileHiveMetastore((File)hiveDir);
        HiveIdentity identity = new HiveIdentity(TestingConnectorSession.SESSION);
        metastore.createDatabase(identity, Database.builder().setDatabaseName("tpch").setOwnerName("public").setOwnerType(PrincipalType.ROLE).build());
        ImmutableMap hiveCatalogConfig = ImmutableMap.builder().put((Object)"hive.max-split-size", (Object)"10GB").build();
        localQueryRunner.createCatalog("hive", (ConnectorFactory)new TestingHiveConnectorFactory((HiveMetastore)metastore), (Map)hiveCatalogConfig);
        localQueryRunner.execute("CREATE TABLE orders AS SELECT * FROM tpch.sf1.orders");
        localQueryRunner.execute("CREATE TABLE lineitem AS SELECT * FROM tpch.sf1.lineitem");
        return localQueryRunner;
    }
}

