/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Module;
import com.google.inject.util.Modules;
import io.airlift.log.Level;
import io.airlift.log.Logger;
import io.airlift.log.Logging;
import io.airlift.units.Duration;
import io.prestosql.Session;
import io.prestosql.metadata.QualifiedObjectName;
import io.prestosql.plugin.hive.HiveTestUtils;
import io.prestosql.plugin.hive.NodeVersion;
import io.prestosql.plugin.hive.authentication.HiveIdentity;
import io.prestosql.plugin.hive.metastore.Database;
import io.prestosql.plugin.hive.metastore.HiveMetastore;
import io.prestosql.plugin.hive.metastore.MetastoreConfig;
import io.prestosql.plugin.hive.metastore.file.FileHiveMetastore;
import io.prestosql.plugin.hive.metastore.file.FileHiveMetastoreConfig;
import io.prestosql.plugin.hive.testing.TestingHivePlugin;
import io.prestosql.plugin.tpch.TpchPlugin;
import io.prestosql.spi.Plugin;
import io.prestosql.spi.security.Identity;
import io.prestosql.spi.security.PrincipalType;
import io.prestosql.spi.security.SelectedRole;
import io.prestosql.testing.DistributedQueryRunner;
import io.prestosql.testing.MaterializedRow;
import io.prestosql.testing.QueryAssertions;
import io.prestosql.testing.QueryRunner;
import io.prestosql.testing.TestingConnectorSession;
import io.prestosql.testing.TestingSession;
import io.prestosql.tpch.TpchTable;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.joda.time.DateTimeZone;
import org.testng.Assert;

public final class HiveQueryRunner {
    private static final Logger log = Logger.get(HiveQueryRunner.class);
    public static final String HIVE_CATALOG = "hive";
    private static final String HIVE_BUCKETED_CATALOG = "hive_bucketed";
    public static final String TPCH_SCHEMA = "tpch";
    private static final String TPCH_BUCKETED_SCHEMA = "tpch_bucketed";
    private static final DateTimeZone TIME_ZONE = DateTimeZone.forID((String)"America/Bahia_Banderas");

    private HiveQueryRunner() {
    }

    public static DistributedQueryRunner create() throws Exception {
        return HiveQueryRunner.builder().build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static void setupLogging() {
        Logging logging = Logging.initialize();
        logging.setLevel("org.apache.parquet.hadoop", Level.WARN);
    }

    private static Database createDatabaseMetastoreObject(String name) {
        return Database.builder().setDatabaseName(name).setOwnerName("public").setOwnerType(PrincipalType.ROLE).build();
    }

    private static Session createSession(Optional<SelectedRole> role) {
        return TestingSession.testSessionBuilder().setIdentity(Identity.forUser((String)HIVE_CATALOG).withRoles((Map)role.map(selectedRole -> ImmutableMap.of((Object)HIVE_CATALOG, (Object)selectedRole)).orElse(ImmutableMap.of())).build()).setCatalog(HIVE_CATALOG).setSchema(TPCH_SCHEMA).build();
    }

    public static Session createBucketedSession(Optional<SelectedRole> role) {
        return TestingSession.testSessionBuilder().setIdentity(Identity.forUser((String)HIVE_CATALOG).withRoles((Map)role.map(selectedRole -> ImmutableMap.of((Object)HIVE_CATALOG, (Object)selectedRole)).orElse(ImmutableMap.of())).build()).setCatalog(HIVE_BUCKETED_CATALOG).setSchema(TPCH_BUCKETED_SCHEMA).build();
    }

    private static void copyTpchTablesBucketed(QueryRunner queryRunner, String sourceCatalog, String sourceSchema, Session session, Iterable<TpchTable<?>> tables) {
        log.info("Loading data from %s.%s...", new Object[]{sourceCatalog, sourceSchema});
        long startTime = System.nanoTime();
        for (TpchTable<?> table : tables) {
            HiveQueryRunner.copyTableBucketed(queryRunner, new QualifiedObjectName(sourceCatalog, sourceSchema, table.getTableName().toLowerCase(Locale.ENGLISH)), session);
        }
        log.info("Loading from %s.%s complete in %s", new Object[]{sourceCatalog, sourceSchema, Duration.nanosSince((long)startTime).toString(TimeUnit.SECONDS)});
    }

    private static void copyTableBucketed(QueryRunner queryRunner, QualifiedObjectName table, Session session) {
        String sql;
        long start = System.nanoTime();
        log.info("Running import for %s", new Object[]{table.getObjectName()});
        switch (table.getObjectName()) {
            case "part": 
            case "partsupp": 
            case "supplier": 
            case "nation": 
            case "region": {
                sql = String.format("CREATE TABLE %s AS SELECT * FROM %s", table.getObjectName(), table);
                break;
            }
            case "lineitem": {
                sql = String.format("CREATE TABLE %s WITH (bucketed_by=array['orderkey'], bucket_count=11) AS SELECT * FROM %s", table.getObjectName(), table);
                break;
            }
            case "customer": {
                sql = String.format("CREATE TABLE %s WITH (bucketed_by=array['custkey'], bucket_count=11) AS SELECT * FROM %s", table.getObjectName(), table);
                break;
            }
            case "orders": {
                sql = String.format("CREATE TABLE %s WITH (bucketed_by=array['custkey'], bucket_count=11) AS SELECT * FROM %s", table.getObjectName(), table);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        long rows = (Long)((MaterializedRow)queryRunner.execute(session, sql).getMaterializedRows().get(0)).getField(0);
        log.info("Imported %s rows for %s in %s", new Object[]{rows, table.getObjectName(), Duration.nanosSince((long)start).convertToMostSuccinctTimeUnit()});
    }

    public static void main(String[] args) throws Exception {
        Optional<Object> baseDataDir = Optional.empty();
        if (args.length > 0) {
            if (args.length != 1) {
                System.err.println("usage: HiveQueryRunner [baseDataDir]");
                System.exit(1);
            }
            Path path = Paths.get(args[0], new String[0]);
            Files.createDirectories(path, new FileAttribute[0]);
            baseDataDir = Optional.of(path);
        }
        DistributedQueryRunner queryRunner = HiveQueryRunner.builder().setExtraProperties((Map)ImmutableMap.of((Object)"http-server.http.port", (Object)"8080")).setHiveProperties((Map<String, String>)ImmutableMap.of()).setInitialTables(TpchTable.getTables()).setBaseDataDir(baseDataDir).build();
        Thread.sleep(10L);
        log.info("======== SERVER STARTED ========");
        log.info("\n====\n%s\n====", new Object[]{queryRunner.getCoordinator().getBaseUrl()});
    }

    public static class Builder
    extends DistributedQueryRunner.Builder {
        private Map<String, String> hiveProperties = ImmutableMap.of();
        private List<TpchTable<?>> initialTables = ImmutableList.of();
        private Function<DistributedQueryRunner, HiveMetastore> metastore = queryRunner -> {
            File baseDir = queryRunner.getCoordinator().getBaseDataDir().resolve("hive_data").toFile();
            return new FileHiveMetastore(new NodeVersion("test_version"), HiveTestUtils.HDFS_ENVIRONMENT, new MetastoreConfig(), new FileHiveMetastoreConfig().setCatalogDirectory(baseDir.toURI().toString()).setMetastoreUser("test").setAssumeCanonicalPartitionKeys(true));
        };
        private Module module = Modules.EMPTY_MODULE;

        protected Builder() {
            super(HiveQueryRunner.createSession(Optional.of(new SelectedRole(SelectedRole.Type.ROLE, Optional.of("admin")))));
        }

        public Builder setExtraProperties(Map<String, String> extraProperties) {
            return (Builder)super.setExtraProperties(extraProperties);
        }

        public Builder addExtraProperty(String key, String value) {
            return (Builder)super.addExtraProperty(key, value);
        }

        public Builder setHiveProperties(Map<String, String> hiveProperties) {
            this.hiveProperties = ImmutableMap.copyOf(Objects.requireNonNull(hiveProperties, "hiveProperties is null"));
            return this;
        }

        public Builder setInitialTables(Iterable<TpchTable<?>> initialTables) {
            this.initialTables = ImmutableList.copyOf(Objects.requireNonNull(initialTables, "initialTables is null"));
            return this;
        }

        public Builder setMetastore(Function<DistributedQueryRunner, HiveMetastore> metastore) {
            this.metastore = Objects.requireNonNull(metastore, "metastore is null");
            return this;
        }

        public Builder setModule(Module module) {
            this.module = Objects.requireNonNull(module, "module is null");
            return this;
        }

        public DistributedQueryRunner build() throws Exception {
            Assert.assertEquals((Object)DateTimeZone.getDefault(), (Object)TIME_ZONE, (String)"Timezone not configured correctly. Add -Duser.timezone=America/Bahia_Banderas to your JVM arguments");
            HiveQueryRunner.setupLogging();
            DistributedQueryRunner queryRunner = super.build();
            try {
                queryRunner.installPlugin((Plugin)new TpchPlugin());
                queryRunner.createCatalog(HiveQueryRunner.TPCH_SCHEMA, HiveQueryRunner.TPCH_SCHEMA);
                HiveMetastore metastore = this.metastore.apply(queryRunner);
                queryRunner.installPlugin((Plugin)new TestingHivePlugin(metastore, this.module));
                Object hiveProperties = ImmutableMap.builder().put((Object)"hive.rcfile.time-zone", (Object)TIME_ZONE.getID()).put((Object)"hive.parquet.time-zone", (Object)TIME_ZONE.getID()).put((Object)"hive.max-partitions-per-scan", (Object)"1000").build();
                hiveProperties = new HashMap(hiveProperties);
                hiveProperties.putAll(this.hiveProperties);
                hiveProperties.putIfAbsent("hive.security", "sql-standard");
                ImmutableMap hiveBucketedProperties = ImmutableMap.builder().putAll((Map)hiveProperties).put((Object)"hive.max-initial-split-size", (Object)"10kB").put((Object)"hive.max-split-size", (Object)"10kB").put((Object)"hive.storage-format", (Object)"TEXTFILE").put((Object)"hive.compression-codec", (Object)"NONE").build();
                queryRunner.createCatalog(HiveQueryRunner.HIVE_CATALOG, HiveQueryRunner.HIVE_CATALOG, (Map)hiveProperties);
                queryRunner.createCatalog(HiveQueryRunner.HIVE_BUCKETED_CATALOG, HiveQueryRunner.HIVE_CATALOG, (Map)hiveBucketedProperties);
                if (!this.initialTables.isEmpty()) {
                    this.populateData(queryRunner, metastore);
                }
                return queryRunner;
            }
            catch (Exception e) {
                queryRunner.close();
                throw e;
            }
        }

        private void populateData(DistributedQueryRunner queryRunner, HiveMetastore metastore) {
            HiveIdentity identity = new HiveIdentity(TestingConnectorSession.SESSION);
            if (metastore.getDatabase(HiveQueryRunner.TPCH_SCHEMA).isEmpty()) {
                metastore.createDatabase(identity, HiveQueryRunner.createDatabaseMetastoreObject(HiveQueryRunner.TPCH_SCHEMA));
                QueryAssertions.copyTpchTables((QueryRunner)queryRunner, (String)HiveQueryRunner.TPCH_SCHEMA, (String)"tiny", (Session)HiveQueryRunner.createSession(Optional.empty()), this.initialTables);
            }
            if (metastore.getDatabase(HiveQueryRunner.TPCH_BUCKETED_SCHEMA).isEmpty()) {
                metastore.createDatabase(identity, HiveQueryRunner.createDatabaseMetastoreObject(HiveQueryRunner.TPCH_BUCKETED_SCHEMA));
                HiveQueryRunner.copyTpchTablesBucketed((QueryRunner)queryRunner, HiveQueryRunner.TPCH_SCHEMA, "tiny", HiveQueryRunner.createBucketedSession(Optional.empty()), this.initialTables);
            }
        }
    }
}

