/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.airlift.slice.Slice;
import io.airlift.units.DataSize;
import io.prestosql.PagesIndexPageSorter;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.MetadataManager;
import io.prestosql.operator.PagesIndex;
import io.prestosql.plugin.hive.FileFormatDataSourceStats;
import io.prestosql.plugin.hive.GenericHiveRecordCursorProvider;
import io.prestosql.plugin.hive.HdfsConfig;
import io.prestosql.plugin.hive.HdfsConfiguration;
import io.prestosql.plugin.hive.HdfsConfigurationInitializer;
import io.prestosql.plugin.hive.HdfsEnvironment;
import io.prestosql.plugin.hive.HiveColumnHandle;
import io.prestosql.plugin.hive.HiveConfig;
import io.prestosql.plugin.hive.HiveFileWriterFactory;
import io.prestosql.plugin.hive.HiveHdfsConfiguration;
import io.prestosql.plugin.hive.HivePageSourceFactory;
import io.prestosql.plugin.hive.HiveRecordCursorProvider;
import io.prestosql.plugin.hive.HiveSessionProperties;
import io.prestosql.plugin.hive.NodeVersion;
import io.prestosql.plugin.hive.RcFileFileWriterFactory;
import io.prestosql.plugin.hive.authentication.HdfsAuthentication;
import io.prestosql.plugin.hive.authentication.NoHdfsAuthentication;
import io.prestosql.plugin.hive.azure.HiveAzureConfig;
import io.prestosql.plugin.hive.azure.PrestoAzureConfigurationInitializer;
import io.prestosql.plugin.hive.gcs.GoogleGcsConfigurationInitializer;
import io.prestosql.plugin.hive.gcs.HiveGcsConfig;
import io.prestosql.plugin.hive.orc.OrcFileWriterFactory;
import io.prestosql.plugin.hive.orc.OrcPageSourceFactory;
import io.prestosql.plugin.hive.orc.OrcReaderConfig;
import io.prestosql.plugin.hive.orc.OrcWriterConfig;
import io.prestosql.plugin.hive.parquet.ParquetPageSourceFactory;
import io.prestosql.plugin.hive.parquet.ParquetReaderConfig;
import io.prestosql.plugin.hive.parquet.ParquetWriterConfig;
import io.prestosql.plugin.hive.rcfile.RcFilePageSourceFactory;
import io.prestosql.plugin.hive.rubix.RubixEnabledConfig;
import io.prestosql.plugin.hive.s3.HiveS3Config;
import io.prestosql.plugin.hive.s3.PrestoS3ConfigurationInitializer;
import io.prestosql.plugin.hive.s3select.PrestoS3ClientFactory;
import io.prestosql.plugin.hive.s3select.S3SelectRecordCursorProvider;
import io.prestosql.spi.PageSorter;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.connector.ColumnHandle;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.function.InvocationConvention;
import io.prestosql.spi.type.ArrayType;
import io.prestosql.spi.type.Decimals;
import io.prestosql.spi.type.MapType;
import io.prestosql.spi.type.NamedTypeSignature;
import io.prestosql.spi.type.RowType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeManager;
import io.prestosql.spi.type.TypeOperators;
import io.prestosql.spi.type.TypeSignature;
import io.prestosql.spi.type.TypeSignatureParameter;
import io.prestosql.testing.TestingConnectorSession;
import io.prestosql.type.InternalTypeManager;
import java.lang.invoke.MethodHandle;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.hive.common.type.Timestamp;

public final class HiveTestUtils {
    public static final ConnectorSession SESSION = HiveTestUtils.getHiveSession(new HiveConfig());
    private static final Metadata METADATA = MetadataManager.createTestMetadataManager();
    public static final TypeManager TYPE_MANAGER = new InternalTypeManager(METADATA, new TypeOperators());
    public static final HdfsEnvironment HDFS_ENVIRONMENT = HiveTestUtils.createTestHdfsEnvironment();
    public static final PageSorter PAGE_SORTER = new PagesIndexPageSorter((PagesIndex.Factory)new PagesIndex.TestingFactory(false));

    private HiveTestUtils() {
    }

    public static ConnectorSession getHiveSession(HiveConfig hiveConfig) {
        return HiveTestUtils.getHiveSession(hiveConfig, new OrcReaderConfig());
    }

    public static TestingConnectorSession getHiveSession(HiveConfig hiveConfig, OrcReaderConfig orcReaderConfig) {
        return TestingConnectorSession.builder().setPropertyMetadata(HiveTestUtils.getHiveSessionProperties(hiveConfig, orcReaderConfig).getSessionProperties()).build();
    }

    public static TestingConnectorSession getHiveSession(HiveConfig hiveConfig, ParquetWriterConfig parquetWriterConfig) {
        return TestingConnectorSession.builder().setPropertyMetadata(HiveTestUtils.getHiveSessionProperties(hiveConfig, parquetWriterConfig).getSessionProperties()).build();
    }

    public static HiveSessionProperties getHiveSessionProperties(HiveConfig hiveConfig) {
        return HiveTestUtils.getHiveSessionProperties(hiveConfig, new OrcReaderConfig());
    }

    public static HiveSessionProperties getHiveSessionProperties(HiveConfig hiveConfig, OrcReaderConfig orcReaderConfig) {
        return HiveTestUtils.getHiveSessionProperties(hiveConfig, new RubixEnabledConfig(), orcReaderConfig);
    }

    public static HiveSessionProperties getHiveSessionProperties(HiveConfig hiveConfig, RubixEnabledConfig rubixEnabledConfig, OrcReaderConfig orcReaderConfig) {
        return new HiveSessionProperties(hiveConfig, orcReaderConfig, new OrcWriterConfig(), new ParquetReaderConfig(), new ParquetWriterConfig());
    }

    public static HiveSessionProperties getHiveSessionProperties(HiveConfig hiveConfig, ParquetWriterConfig parquetWriterConfig) {
        return new HiveSessionProperties(hiveConfig, new OrcReaderConfig(), new OrcWriterConfig(), new ParquetReaderConfig(), parquetWriterConfig);
    }

    public static Set<HivePageSourceFactory> getDefaultHivePageSourceFactories(HdfsEnvironment hdfsEnvironment, HiveConfig hiveConfig) {
        FileFormatDataSourceStats stats = new FileFormatDataSourceStats();
        return ImmutableSet.builder().add((Object)new RcFilePageSourceFactory(TYPE_MANAGER, hdfsEnvironment, stats, hiveConfig)).add((Object)new OrcPageSourceFactory(new OrcReaderConfig(), hdfsEnvironment, stats, hiveConfig)).add((Object)new ParquetPageSourceFactory(hdfsEnvironment, stats, new ParquetReaderConfig(), hiveConfig)).build();
    }

    public static Set<HiveRecordCursorProvider> getDefaultHiveRecordCursorProviders(HiveConfig hiveConfig, HdfsEnvironment hdfsEnvironment) {
        return ImmutableSet.builder().add((Object)new S3SelectRecordCursorProvider(hdfsEnvironment, new PrestoS3ClientFactory(hiveConfig))).build();
    }

    public static Set<HiveFileWriterFactory> getDefaultHiveFileWriterFactories(HiveConfig hiveConfig, HdfsEnvironment hdfsEnvironment) {
        return ImmutableSet.builder().add((Object)new RcFileFileWriterFactory(hdfsEnvironment, TYPE_MANAGER, new NodeVersion("test_version"), hiveConfig, new FileFormatDataSourceStats())).add((Object)HiveTestUtils.getDefaultOrcFileWriterFactory(hdfsEnvironment)).build();
    }

    private static OrcFileWriterFactory getDefaultOrcFileWriterFactory(HdfsEnvironment hdfsEnvironment) {
        return new OrcFileWriterFactory(hdfsEnvironment, TYPE_MANAGER, new NodeVersion("test_version"), new OrcWriterConfig(), new FileFormatDataSourceStats(), new OrcWriterConfig());
    }

    public static List<Type> getTypes(List<? extends ColumnHandle> columnHandles) {
        ImmutableList.Builder types = ImmutableList.builder();
        for (ColumnHandle columnHandle : columnHandles) {
            types.add((Object)((HiveColumnHandle)columnHandle).getType());
        }
        return types.build();
    }

    public static HiveRecordCursorProvider createGenericHiveRecordCursorProvider(HdfsEnvironment hdfsEnvironment) {
        return new GenericHiveRecordCursorProvider(hdfsEnvironment, DataSize.of((long)100L, (DataSize.Unit)DataSize.Unit.MEGABYTE));
    }

    private static HdfsEnvironment createTestHdfsEnvironment() {
        HiveHdfsConfiguration hdfsConfig = new HiveHdfsConfiguration(new HdfsConfigurationInitializer(new HdfsConfig(), (Set)ImmutableSet.of((Object)new PrestoS3ConfigurationInitializer(new HiveS3Config()), (Object)new GoogleGcsConfigurationInitializer(new HiveGcsConfig()), (Object)new PrestoAzureConfigurationInitializer(new HiveAzureConfig()))), (Set)ImmutableSet.of());
        return new HdfsEnvironment((HdfsConfiguration)hdfsConfig, new HdfsConfig(), (HdfsAuthentication)new NoHdfsAuthentication());
    }

    public static MapType mapType(Type keyType, Type valueType) {
        return (MapType)METADATA.getParameterizedType("map", (List)ImmutableList.of((Object)TypeSignatureParameter.typeParameter((TypeSignature)keyType.getTypeSignature()), (Object)TypeSignatureParameter.typeParameter((TypeSignature)valueType.getTypeSignature())));
    }

    public static ArrayType arrayType(Type elementType) {
        return (ArrayType)METADATA.getParameterizedType("array", (List)ImmutableList.of((Object)TypeSignatureParameter.typeParameter((TypeSignature)elementType.getTypeSignature())));
    }

    public static RowType rowType(List<NamedTypeSignature> elementTypeSignatures) {
        return (RowType)METADATA.getParameterizedType("row", (List)ImmutableList.copyOf((Collection)((Collection)elementTypeSignatures.stream().map(TypeSignatureParameter::namedTypeParameter).collect(ImmutableList.toImmutableList()))));
    }

    public static Long shortDecimal(String value) {
        return new BigDecimal(value).unscaledValue().longValueExact();
    }

    public static Slice longDecimal(String value) {
        return Decimals.encodeScaledValue((BigDecimal)new BigDecimal(value));
    }

    public static MethodHandle distinctFromOperator(Type type) {
        return TYPE_MANAGER.getTypeOperators().getDistinctFromOperator(type, InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.NULL_FLAG, InvocationConvention.InvocationArgumentConvention.NULL_FLAG}));
    }

    public static boolean isDistinctFrom(MethodHandle handle, Block left, Block right) {
        try {
            return handle.invokeExact(left, left == null, right, right == null);
        }
        catch (Throwable t) {
            throw new AssertionError((Object)t);
        }
    }

    public static Timestamp hiveTimestamp(LocalDateTime local) {
        return Timestamp.ofEpochSecond((long)local.toEpochSecond(ZoneOffset.UTC), (int)local.getNano());
    }
}

