/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import com.google.common.io.MoreFiles;
import com.google.common.io.RecursiveDeleteOption;
import com.google.common.util.concurrent.MoreExecutors;
import io.airlift.concurrent.Threads;
import io.airlift.slice.Slices;
import io.airlift.stats.CounterStat;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.prestosql.plugin.hive.BackgroundHiveSplitLoader;
import io.prestosql.plugin.hive.CachingDirectoryLister;
import io.prestosql.plugin.hive.DirectoryLister;
import io.prestosql.plugin.hive.HdfsConfig;
import io.prestosql.plugin.hive.HdfsConfiguration;
import io.prestosql.plugin.hive.HdfsConfigurationInitializer;
import io.prestosql.plugin.hive.HdfsEnvironment;
import io.prestosql.plugin.hive.HiveBucketHandle;
import io.prestosql.plugin.hive.HiveBucketProperty;
import io.prestosql.plugin.hive.HiveColumnHandle;
import io.prestosql.plugin.hive.HiveConfig;
import io.prestosql.plugin.hive.HiveErrorCode;
import io.prestosql.plugin.hive.HiveHdfsConfiguration;
import io.prestosql.plugin.hive.HivePartition;
import io.prestosql.plugin.hive.HivePartitionMetadata;
import io.prestosql.plugin.hive.HiveSessionProperties;
import io.prestosql.plugin.hive.HiveSplit;
import io.prestosql.plugin.hive.HiveSplitLoader;
import io.prestosql.plugin.hive.HiveSplitSource;
import io.prestosql.plugin.hive.HiveStorageFormat;
import io.prestosql.plugin.hive.HiveTestUtils;
import io.prestosql.plugin.hive.HiveTimestampPrecision;
import io.prestosql.plugin.hive.HiveType;
import io.prestosql.plugin.hive.InternalHiveSplit;
import io.prestosql.plugin.hive.NamenodeStats;
import io.prestosql.plugin.hive.TableToPartitionMapping;
import io.prestosql.plugin.hive.acid.AcidTransaction;
import io.prestosql.plugin.hive.authentication.HdfsAuthentication;
import io.prestosql.plugin.hive.authentication.NoHdfsAuthentication;
import io.prestosql.plugin.hive.metastore.Column;
import io.prestosql.plugin.hive.metastore.StorageFormat;
import io.prestosql.plugin.hive.metastore.Table;
import io.prestosql.plugin.hive.util.HiveBucketing;
import io.prestosql.plugin.hive.util.HiveUtil;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.connector.ColumnHandle;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.connector.ConnectorSplitSource;
import io.prestosql.spi.connector.DynamicFilter;
import io.prestosql.spi.connector.NotPartitionedPartitionHandle;
import io.prestosql.spi.connector.SchemaTableName;
import io.prestosql.spi.predicate.Domain;
import io.prestosql.spi.predicate.TupleDomain;
import io.prestosql.spi.type.IntegerType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeManager;
import io.prestosql.spi.type.VarcharType;
import io.prestosql.testing.assertions.PrestoExceptionAssert;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hive.common.ValidReaderWriteIdList;
import org.apache.hadoop.hive.common.ValidWriteIdList;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.ql.io.SymlinkTextInputFormat;
import org.apache.hadoop.hive.ql.io.avro.AvroContainerInputFormat;
import org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.util.Progressable;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class TestBackgroundHiveSplitLoader {
    private static final int BUCKET_COUNT = 2;
    private static final String SAMPLE_PATH = "hdfs://VOL1:9000/db_name/table_name/000000_0";
    private static final String SAMPLE_PATH_FILTERED = "hdfs://VOL1:9000/db_name/table_name/000000_1";
    private static final org.apache.hadoop.fs.Path RETURNED_PATH = new org.apache.hadoop.fs.Path("hdfs://VOL1:9000/db_name/table_name/000000_0");
    private static final org.apache.hadoop.fs.Path FILTERED_PATH = new org.apache.hadoop.fs.Path("hdfs://VOL1:9000/db_name/table_name/000000_1");
    private static final TupleDomain<HiveColumnHandle> RETURNED_PATH_DOMAIN = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)HiveColumnHandle.pathColumnHandle(), (Object)Domain.singleValue((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)RETURNED_PATH.toString()))));
    private static final List<LocatedFileStatus> TEST_FILES = ImmutableList.of((Object)TestBackgroundHiveSplitLoader.locatedFileStatus(RETURNED_PATH), (Object)TestBackgroundHiveSplitLoader.locatedFileStatus(FILTERED_PATH));
    private static final List<Column> PARTITION_COLUMNS = ImmutableList.of((Object)new Column("partitionColumn", HiveType.HIVE_INT, Optional.empty()));
    private static final List<HiveColumnHandle> BUCKET_COLUMN_HANDLES = ImmutableList.of((Object)HiveColumnHandle.createBaseColumn((String)"col1", (int)0, (HiveType)HiveType.HIVE_INT, (Type)IntegerType.INTEGER, (HiveColumnHandle.ColumnType)HiveColumnHandle.ColumnType.REGULAR, Optional.empty()));
    private static final Optional<HiveBucketProperty> BUCKET_PROPERTY = Optional.of(new HiveBucketProperty((List)ImmutableList.of((Object)"col1"), HiveBucketing.BucketingVersion.BUCKETING_V1, 2, (List)ImmutableList.of()));
    private static final Table SIMPLE_TABLE = TestBackgroundHiveSplitLoader.table((List<Column>)ImmutableList.of(), Optional.empty(), (ImmutableMap<String, String>)ImmutableMap.of());
    private static final Table PARTITIONED_TABLE = TestBackgroundHiveSplitLoader.table(PARTITION_COLUMNS, BUCKET_PROPERTY, (ImmutableMap<String, String>)ImmutableMap.of());
    private ExecutorService executor;

    @BeforeClass
    public void setUp() {
        this.executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)(this.getClass().getSimpleName() + "-%s")));
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() {
        this.executor.shutdownNow();
        this.executor = null;
    }

    @Test
    public void testNoPathFilter() throws Exception {
        BackgroundHiveSplitLoader backgroundHiveSplitLoader = this.backgroundHiveSplitLoader(TEST_FILES, (TupleDomain<HiveColumnHandle>)TupleDomain.none());
        HiveSplitSource hiveSplitSource = this.hiveSplitSource((HiveSplitLoader)backgroundHiveSplitLoader);
        backgroundHiveSplitLoader.start(hiveSplitSource);
        Assert.assertEquals((int)TestBackgroundHiveSplitLoader.drain(hiveSplitSource).size(), (int)2);
    }

    @Test
    public void testCsv() throws Exception {
        DataSize fileSize = DataSize.of((long)2L, (DataSize.Unit)DataSize.Unit.GIGABYTE);
        this.assertSplitCount(HiveStorageFormat.CSV, (Map<String, String>)ImmutableMap.of(), fileSize, 33);
        this.assertSplitCount(HiveStorageFormat.CSV, (Map<String, String>)ImmutableMap.of((Object)"skip.header.line.count", (Object)"1"), fileSize, 33);
        this.assertSplitCount(HiveStorageFormat.CSV, (Map<String, String>)ImmutableMap.of((Object)"skip.header.line.count", (Object)"2"), fileSize, 1);
        this.assertSplitCount(HiveStorageFormat.CSV, (Map<String, String>)ImmutableMap.of((Object)"skip.footer.line.count", (Object)"1"), fileSize, 1);
        this.assertSplitCount(HiveStorageFormat.CSV, (Map<String, String>)ImmutableMap.of((Object)"skip.header.line.count", (Object)"1", (Object)"skip.footer.line.count", (Object)"1"), fileSize, 1);
    }

    @Test
    public void testSplittableNotCheckedOnSmallFiles() throws Exception {
        DataSize initialSplitSize = HiveSessionProperties.getMaxInitialSplitSize((ConnectorSession)HiveTestUtils.SESSION);
        Table table = TestBackgroundHiveSplitLoader.table((List<Column>)ImmutableList.of(), Optional.empty(), (Map<String, String>)ImmutableMap.of(), StorageFormat.create((String)LazySimpleSerDe.class.getName(), (String)TestSplittableFailureInputFormat.class.getName(), (String)TestSplittableFailureInputFormat.class.getName()));
        BackgroundHiveSplitLoader backgroundHiveSplitLoader = this.backgroundHiveSplitLoader((List<LocatedFileStatus>)ImmutableList.of((Object)TestBackgroundHiveSplitLoader.locatedFileStatus(new org.apache.hadoop.fs.Path(SAMPLE_PATH), initialSplitSize.toBytes())), (TupleDomain<HiveColumnHandle>)TupleDomain.all(), Optional.empty(), table, Optional.empty());
        HiveSplitSource hiveSplitSource = this.hiveSplitSource((HiveSplitLoader)backgroundHiveSplitLoader);
        backgroundHiveSplitLoader.start(hiveSplitSource);
        Assert.assertEquals((int)TestBackgroundHiveSplitLoader.drainSplits(hiveSplitSource).size(), (int)1);
        backgroundHiveSplitLoader = this.backgroundHiveSplitLoader((List<LocatedFileStatus>)ImmutableList.of((Object)TestBackgroundHiveSplitLoader.locatedFileStatus(new org.apache.hadoop.fs.Path(SAMPLE_PATH), initialSplitSize.toBytes() + 1L)), (TupleDomain<HiveColumnHandle>)TupleDomain.all(), Optional.empty(), table, Optional.empty());
        hiveSplitSource = this.hiveSplitSource((HiveSplitLoader)backgroundHiveSplitLoader);
        backgroundHiveSplitLoader.start(hiveSplitSource);
        try {
            TestBackgroundHiveSplitLoader.drainSplits(hiveSplitSource);
            Assert.fail((String)"Expected split generation to call isSplittable and fail");
        }
        catch (PrestoException e) {
            Throwable cause = Throwables.getRootCause((Throwable)e);
            Assert.assertTrue((boolean)(cause instanceof IllegalStateException));
            Assert.assertEquals((String)cause.getMessage(), (String)"isSplittable called");
        }
    }

    private void assertSplitCount(HiveStorageFormat storageFormat, Map<String, String> tableProperties, DataSize fileSize, int expectedSplitCount) throws Exception {
        Table table = TestBackgroundHiveSplitLoader.table((List<Column>)ImmutableList.of(), Optional.empty(), (Map<String, String>)ImmutableMap.copyOf(tableProperties), StorageFormat.fromHiveStorageFormat((HiveStorageFormat)storageFormat));
        BackgroundHiveSplitLoader backgroundHiveSplitLoader = this.backgroundHiveSplitLoader((List<LocatedFileStatus>)ImmutableList.of((Object)TestBackgroundHiveSplitLoader.locatedFileStatus(new org.apache.hadoop.fs.Path(SAMPLE_PATH), fileSize.toBytes())), (TupleDomain<HiveColumnHandle>)TupleDomain.all(), Optional.empty(), table, Optional.empty());
        HiveSplitSource hiveSplitSource = this.hiveSplitSource((HiveSplitLoader)backgroundHiveSplitLoader);
        backgroundHiveSplitLoader.start(hiveSplitSource);
        Assert.assertEquals((int)TestBackgroundHiveSplitLoader.drainSplits(hiveSplitSource).size(), (int)expectedSplitCount);
    }

    @Test
    public void testPathFilter() throws Exception {
        BackgroundHiveSplitLoader backgroundHiveSplitLoader = this.backgroundHiveSplitLoader(TEST_FILES, RETURNED_PATH_DOMAIN);
        HiveSplitSource hiveSplitSource = this.hiveSplitSource((HiveSplitLoader)backgroundHiveSplitLoader);
        backgroundHiveSplitLoader.start(hiveSplitSource);
        List<String> paths = TestBackgroundHiveSplitLoader.drain(hiveSplitSource);
        Assert.assertEquals((int)paths.size(), (int)1);
        Assert.assertEquals((String)paths.get(0), (String)RETURNED_PATH.toString());
    }

    @Test
    public void testPathFilterOneBucketMatchPartitionedTable() throws Exception {
        BackgroundHiveSplitLoader backgroundHiveSplitLoader = this.backgroundHiveSplitLoader(TEST_FILES, RETURNED_PATH_DOMAIN, Optional.of(new HiveBucketing.HiveBucketFilter((Set)ImmutableSet.of((Object)0, (Object)1))), PARTITIONED_TABLE, Optional.of(new HiveBucketHandle(BUCKET_COLUMN_HANDLES, HiveBucketing.BucketingVersion.BUCKETING_V1, 2, 2)));
        HiveSplitSource hiveSplitSource = this.hiveSplitSource((HiveSplitLoader)backgroundHiveSplitLoader);
        backgroundHiveSplitLoader.start(hiveSplitSource);
        List<String> paths = TestBackgroundHiveSplitLoader.drain(hiveSplitSource);
        Assert.assertEquals((int)paths.size(), (int)1);
        Assert.assertEquals((String)paths.get(0), (String)RETURNED_PATH.toString());
    }

    @Test
    public void testPathFilterBucketedPartitionedTable() throws Exception {
        BackgroundHiveSplitLoader backgroundHiveSplitLoader = this.backgroundHiveSplitLoader(TEST_FILES, RETURNED_PATH_DOMAIN, Optional.empty(), PARTITIONED_TABLE, Optional.of(new HiveBucketHandle(HiveUtil.getRegularColumnHandles((Table)PARTITIONED_TABLE, (TypeManager)HiveTestUtils.TYPE_MANAGER, (HiveTimestampPrecision)HiveTimestampPrecision.DEFAULT_PRECISION), HiveBucketing.BucketingVersion.BUCKETING_V1, 2, 2)));
        HiveSplitSource hiveSplitSource = this.hiveSplitSource((HiveSplitLoader)backgroundHiveSplitLoader);
        backgroundHiveSplitLoader.start(hiveSplitSource);
        List<String> paths = TestBackgroundHiveSplitLoader.drain(hiveSplitSource);
        Assert.assertEquals((int)paths.size(), (int)1);
        Assert.assertEquals((String)paths.get(0), (String)RETURNED_PATH.toString());
    }

    @Test
    public void testEmptyFileWithNoBlocks() throws Exception {
        BackgroundHiveSplitLoader backgroundHiveSplitLoader = this.backgroundHiveSplitLoader((List<LocatedFileStatus>)ImmutableList.of((Object)TestBackgroundHiveSplitLoader.locatedFileStatusWithNoBlocks(RETURNED_PATH)), (TupleDomain<HiveColumnHandle>)TupleDomain.none());
        HiveSplitSource hiveSplitSource = this.hiveSplitSource((HiveSplitLoader)backgroundHiveSplitLoader);
        backgroundHiveSplitLoader.start(hiveSplitSource);
        List<HiveSplit> splits = TestBackgroundHiveSplitLoader.drainSplits(hiveSplitSource);
        Assert.assertEquals((int)splits.size(), (int)1);
        Assert.assertEquals((String)splits.get(0).getPath(), (String)RETURNED_PATH.toString());
        Assert.assertEquals((long)splits.get(0).getLength(), (long)0L);
    }

    @Test
    public void testNoHangIfPartitionIsOffline() {
        BackgroundHiveSplitLoader backgroundHiveSplitLoader = TestBackgroundHiveSplitLoader.backgroundHiveSplitLoaderOfflinePartitions();
        HiveSplitSource hiveSplitSource = this.hiveSplitSource((HiveSplitLoader)backgroundHiveSplitLoader);
        backgroundHiveSplitLoader.start(hiveSplitSource);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestBackgroundHiveSplitLoader.drain(hiveSplitSource)).isInstanceOf(PrestoException.class)).hasMessage("OFFLINE");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((HiveSplitSource)hiveSplitSource).isFinished()).isInstanceOf(PrestoException.class)).hasMessage("OFFLINE");
    }

    @Test(timeOut=30000L)
    public void testIncompleteDynamicFilterTimeout() throws Exception {
        BackgroundHiveSplitLoader backgroundHiveSplitLoader = this.backgroundHiveSplitLoader(new DynamicFilter(){

            public CompletableFuture<?> isBlocked() {
                return CompletableFuture.runAsync(() -> {
                    try {
                        TimeUnit.HOURS.sleep(1L);
                    }
                    catch (InterruptedException e) {
                        throw new IllegalStateException(e);
                    }
                });
            }

            public boolean isComplete() {
                return false;
            }

            public boolean isAwaitable() {
                return true;
            }

            public TupleDomain<ColumnHandle> getCurrentPredicate() {
                return TupleDomain.all();
            }
        }, Duration.valueOf((String)"1s"));
        HiveSplitSource hiveSplitSource = this.hiveSplitSource((HiveSplitLoader)backgroundHiveSplitLoader);
        backgroundHiveSplitLoader.start(hiveSplitSource);
        Assert.assertEquals((int)TestBackgroundHiveSplitLoader.drain(hiveSplitSource).size(), (int)2);
        Assert.assertTrue((boolean)hiveSplitSource.isFinished());
    }

    @Test
    public void testCachedDirectoryLister() throws Exception {
        CachingDirectoryLister cachingDirectoryLister = new CachingDirectoryLister(new Duration(5.0, TimeUnit.MINUTES), 1000L, (List)ImmutableList.of((Object)"test_dbname.test_table"));
        Assert.assertEquals((long)cachingDirectoryLister.getRequestCount(), (long)0L);
        int totalCount = 100;
        CountDownLatch firstVisit = new CountDownLatch(1);
        ArrayList<Future<List>> futures = new ArrayList<Future<List>>();
        futures.add(this.executor.submit(() -> {
            BackgroundHiveSplitLoader backgroundHiveSplitLoader = this.backgroundHiveSplitLoader(TEST_FILES, (DirectoryLister)cachingDirectoryLister);
            HiveSplitSource hiveSplitSource = this.hiveSplitSource((HiveSplitLoader)backgroundHiveSplitLoader);
            backgroundHiveSplitLoader.start(hiveSplitSource);
            try {
                List<HiveSplit> list = TestBackgroundHiveSplitLoader.drainSplits(hiveSplitSource);
                return list;
            }
            finally {
                firstVisit.countDown();
            }
        }));
        for (int i = 0; i < totalCount - 1; ++i) {
            futures.add(this.executor.submit(() -> {
                firstVisit.await();
                BackgroundHiveSplitLoader backgroundHiveSplitLoader = this.backgroundHiveSplitLoader(TEST_FILES, (DirectoryLister)cachingDirectoryLister);
                HiveSplitSource hiveSplitSource = this.hiveSplitSource((HiveSplitLoader)backgroundHiveSplitLoader);
                backgroundHiveSplitLoader.start(hiveSplitSource);
                return TestBackgroundHiveSplitLoader.drainSplits(hiveSplitSource);
            }));
        }
        for (Future future : futures) {
            Assert.assertEquals((int)((List)future.get()).size(), (int)TEST_FILES.size());
        }
        Assert.assertEquals((long)cachingDirectoryLister.getRequestCount(), (long)totalCount);
        Assert.assertEquals((long)cachingDirectoryLister.getHitCount(), (long)(totalCount - 1));
        Assert.assertEquals((long)cachingDirectoryLister.getMissCount(), (long)1L);
    }

    @Test
    public void testGetBucketNumber() {
        Assert.assertEquals((Object)BackgroundHiveSplitLoader.getBucketNumber((String)"20190526_072952_00009_fn7s5_bucket-00234"), (Object)OptionalInt.of(234));
        Assert.assertEquals((Object)BackgroundHiveSplitLoader.getBucketNumber((String)"20190526_072952_00009_fn7s5_bucket-00234.txt"), (Object)OptionalInt.of(234));
        Assert.assertEquals((Object)BackgroundHiveSplitLoader.getBucketNumber((String)"20190526_235847_87654_fn7s5_bucket-56789"), (Object)OptionalInt.of(56789));
        Assert.assertEquals((Object)BackgroundHiveSplitLoader.getBucketNumber((String)"0234_0"), (Object)OptionalInt.of(234));
        Assert.assertEquals((Object)BackgroundHiveSplitLoader.getBucketNumber((String)"000234_0"), (Object)OptionalInt.of(234));
        Assert.assertEquals((Object)BackgroundHiveSplitLoader.getBucketNumber((String)"0234_99"), (Object)OptionalInt.of(234));
        Assert.assertEquals((Object)BackgroundHiveSplitLoader.getBucketNumber((String)"0234_0.txt"), (Object)OptionalInt.of(234));
        Assert.assertEquals((Object)BackgroundHiveSplitLoader.getBucketNumber((String)"0234_0_copy_1"), (Object)OptionalInt.of(234));
        Assert.assertEquals((Object)BackgroundHiveSplitLoader.getBucketNumber((String)"234_99"), (Object)OptionalInt.of(234));
        Assert.assertEquals((Object)BackgroundHiveSplitLoader.getBucketNumber((String)"1234_0_copy_1"), (Object)OptionalInt.of(1234));
        Assert.assertEquals((Object)BackgroundHiveSplitLoader.getBucketNumber((String)"bucket_1234"), (Object)OptionalInt.of(1234));
        Assert.assertEquals((Object)BackgroundHiveSplitLoader.getBucketNumber((String)"bucket_01234"), (Object)OptionalInt.of(1234));
        Assert.assertEquals((Object)BackgroundHiveSplitLoader.getBucketNumber((String)"0234.txt"), (Object)OptionalInt.empty());
        Assert.assertEquals((Object)BackgroundHiveSplitLoader.getBucketNumber((String)"0234.txt"), (Object)OptionalInt.empty());
    }

    @Test
    public void testGetAttemptId() {
        Assert.assertFalse((boolean)BackgroundHiveSplitLoader.hasAttemptId((String)"bucket_00000"));
        Assert.assertTrue((boolean)BackgroundHiveSplitLoader.hasAttemptId((String)"bucket_00000_0"));
        Assert.assertTrue((boolean)BackgroundHiveSplitLoader.hasAttemptId((String)"bucket_00000_10"));
        Assert.assertTrue((boolean)BackgroundHiveSplitLoader.hasAttemptId((String)"bucket_00000_1000"));
        Assert.assertFalse((boolean)BackgroundHiveSplitLoader.hasAttemptId((String)"bucket_00000__1000"));
        Assert.assertFalse((boolean)BackgroundHiveSplitLoader.hasAttemptId((String)"bucket_00000_a"));
        Assert.assertFalse((boolean)BackgroundHiveSplitLoader.hasAttemptId((String)"bucket_00000_ad"));
        Assert.assertFalse((boolean)BackgroundHiveSplitLoader.hasAttemptId((String)"base_00000_00"));
    }

    @Test(dataProvider="testPropagateExceptionDataProvider", timeOut=60000L)
    public void testPropagateException(final boolean error, int threads) {
        final AtomicBoolean iteratorUsedAfterException = new AtomicBoolean();
        BackgroundHiveSplitLoader backgroundHiveSplitLoader = new BackgroundHiveSplitLoader(SIMPLE_TABLE, AcidTransaction.NO_ACID_TRANSACTION, () -> new Iterator<HivePartitionMetadata>(){
            private boolean threw;

            @Override
            public boolean hasNext() {
                iteratorUsedAfterException.compareAndSet(false, this.threw);
                return !this.threw;
            }

            @Override
            public HivePartitionMetadata next() {
                iteratorUsedAfterException.compareAndSet(false, this.threw);
                this.threw = true;
                if (error) {
                    throw new Error("loading error occurred");
                }
                throw new RuntimeException("loading error occurred");
            }
        }, TupleDomain.all(), DynamicFilter.EMPTY, Duration.valueOf((String)"0s"), HiveTestUtils.TYPE_MANAGER, BackgroundHiveSplitLoader.BucketSplitInfo.createBucketSplitInfo(Optional.empty(), Optional.empty()), HiveTestUtils.SESSION, (HdfsEnvironment)new TestingHdfsEnvironment(TEST_FILES), new NamenodeStats(), (DirectoryLister)new CachingDirectoryLister(new HiveConfig()), (Executor)this.executor, threads, false, false, true, Optional.empty());
        HiveSplitSource hiveSplitSource = this.hiveSplitSource((HiveSplitLoader)backgroundHiveSplitLoader);
        backgroundHiveSplitLoader.start(hiveSplitSource);
        Assertions.assertThatThrownBy(() -> TestBackgroundHiveSplitLoader.drain(hiveSplitSource)).hasMessageEndingWith("loading error occurred");
        Assertions.assertThatThrownBy(() -> ((HiveSplitSource)hiveSplitSource).isFinished()).hasMessageEndingWith("loading error occurred");
        if (threads == 1) {
            Assert.assertFalse((boolean)iteratorUsedAfterException.get());
        }
    }

    @DataProvider
    public Object[][] testPropagateExceptionDataProvider() {
        return new Object[][]{{false, 1}, {true, 1}, {false, 2}, {true, 2}, {false, 4}, {true, 4}};
    }

    @Test
    public void testMultipleSplitsPerBucket() throws Exception {
        BackgroundHiveSplitLoader backgroundHiveSplitLoader = this.backgroundHiveSplitLoader((List<LocatedFileStatus>)ImmutableList.of((Object)TestBackgroundHiveSplitLoader.locatedFileStatus(new org.apache.hadoop.fs.Path(SAMPLE_PATH), DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.GIGABYTE).toBytes())), (TupleDomain<HiveColumnHandle>)TupleDomain.all(), Optional.empty(), SIMPLE_TABLE, Optional.of(new HiveBucketHandle(BUCKET_COLUMN_HANDLES, HiveBucketing.BucketingVersion.BUCKETING_V1, 2, 2)));
        HiveSplitSource hiveSplitSource = this.hiveSplitSource((HiveSplitLoader)backgroundHiveSplitLoader);
        backgroundHiveSplitLoader.start(hiveSplitSource);
        Assert.assertEquals((int)TestBackgroundHiveSplitLoader.drainSplits(hiveSplitSource).size(), (int)17);
    }

    @Test
    public void testSplitsGenerationWithAbortedTransactions() throws Exception {
        Path tablePath = Files.createTempDirectory("TestBackgroundHiveSplitLoader", new FileAttribute[0]);
        Table table = TestBackgroundHiveSplitLoader.table(tablePath.toString(), (List<Column>)ImmutableList.of(), Optional.empty(), (ImmutableMap<String, String>)ImmutableMap.of((Object)"transactional", (Object)"true", (Object)"transactional_properties", (Object)"insert_only"));
        ImmutableList filePaths = ImmutableList.of((Object)(tablePath + "/delta_0000001_0000001_0000/_orc_acid_version"), (Object)(tablePath + "/delta_0000001_0000001_0000/bucket_00000"), (Object)(tablePath + "/delta_0000002_0000002_0000/_orc_acid_version"), (Object)(tablePath + "/delta_0000002_0000002_0000/bucket_00000"), (Object)(tablePath + "/delta_0000003_0000003_0000/_orc_acid_version"), (Object)(tablePath + "/delta_0000003_0000003_0000/bucket_00000"));
        for (String path : filePaths) {
            File file = new File(path);
            Assert.assertTrue((file.getParentFile().exists() || file.getParentFile().mkdirs() ? 1 : 0) != 0, (String)("Failed creating directory " + file.getParentFile()));
            TestBackgroundHiveSplitLoader.createOrcAcidFile(file);
        }
        String validWriteIdsList = String.format("4$%s.%s:3:9223372036854775807::2", table.getDatabaseName(), table.getTableName());
        BackgroundHiveSplitLoader backgroundHiveSplitLoader = this.backgroundHiveSplitLoader(HiveTestUtils.HDFS_ENVIRONMENT, (TupleDomain<HiveColumnHandle>)TupleDomain.none(), Optional.empty(), table, Optional.empty(), Optional.of(new ValidReaderWriteIdList(validWriteIdsList)));
        HiveSplitSource hiveSplitSource = this.hiveSplitSource((HiveSplitLoader)backgroundHiveSplitLoader);
        backgroundHiveSplitLoader.start(hiveSplitSource);
        List<String> splits = TestBackgroundHiveSplitLoader.drain(hiveSplitSource);
        Assert.assertTrue((boolean)splits.stream().anyMatch(arg_0 -> TestBackgroundHiveSplitLoader.lambda$testSplitsGenerationWithAbortedTransactions$5((List)filePaths, arg_0)), (String)String.format("%s not found in splits %s", filePaths.get(1), splits));
        Assert.assertTrue((boolean)splits.stream().anyMatch(arg_0 -> TestBackgroundHiveSplitLoader.lambda$testSplitsGenerationWithAbortedTransactions$6((List)filePaths, arg_0)), (String)String.format("%s not found in splits %s", filePaths.get(5), splits));
        MoreFiles.deleteRecursively((Path)tablePath, (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
    }

    @Test
    public void testFullAcidTableWithOriginalFiles() throws Exception {
        Path tablePath = Files.createTempDirectory("TestBackgroundHiveSplitLoader", new FileAttribute[0]);
        Table table = TestBackgroundHiveSplitLoader.table(tablePath.toString(), (List<Column>)ImmutableList.of(), Optional.empty(), (ImmutableMap<String, String>)ImmutableMap.of((Object)"transactional", (Object)"true"));
        String originalFile = tablePath + "/000000_1";
        ImmutableList filePaths = ImmutableList.of((Object)(tablePath + "/delta_0000002_0000002_0000/_orc_acid_version"), (Object)(tablePath + "/delta_0000002_0000002_0000/bucket_00000"));
        for (String path : filePaths) {
            File file = new File(path);
            Assert.assertTrue((file.getParentFile().exists() || file.getParentFile().mkdirs() ? 1 : 0) != 0, (String)("Failed creating directory " + file.getParentFile()));
            TestBackgroundHiveSplitLoader.createOrcAcidFile(file);
        }
        Files.write(Paths.get(originalFile, new String[0]), "test".getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        ValidReaderWriteIdList validWriteIdsList = new ValidReaderWriteIdList(String.format("4$%s.%s:3:9223372036854775807::", table.getDatabaseName(), table.getTableName()));
        BackgroundHiveSplitLoader backgroundHiveSplitLoader = this.backgroundHiveSplitLoader(HiveTestUtils.HDFS_ENVIRONMENT, (TupleDomain<HiveColumnHandle>)TupleDomain.all(), Optional.empty(), table, Optional.empty(), Optional.of(validWriteIdsList));
        HiveSplitSource hiveSplitSource = this.hiveSplitSource((HiveSplitLoader)backgroundHiveSplitLoader);
        backgroundHiveSplitLoader.start(hiveSplitSource);
        List<String> splits = TestBackgroundHiveSplitLoader.drain(hiveSplitSource);
        Assert.assertTrue((boolean)splits.stream().anyMatch(p -> p.contains(originalFile)), (String)String.format("%s not found in splits %s", filePaths.get(0), splits));
        Assert.assertTrue((boolean)splits.stream().anyMatch(arg_0 -> TestBackgroundHiveSplitLoader.lambda$testFullAcidTableWithOriginalFiles$8((List)filePaths, arg_0)), (String)String.format("%s not found in splits %s", filePaths.get(1), splits));
    }

    @Test
    public void testHive2VersionedFullAcidTableFails() throws Exception {
        Path tablePath = Files.createTempDirectory("TestBackgroundHiveSplitLoader", new FileAttribute[0]);
        Table table = TestBackgroundHiveSplitLoader.table(tablePath.toString(), (List<Column>)ImmutableList.of(), Optional.empty(), (ImmutableMap<String, String>)ImmutableMap.of((Object)"transactional", (Object)"true"));
        ImmutableList filePaths = ImmutableList.of((Object)(tablePath + "/000000_1"), (Object)(tablePath + "/delta_0000002_0000002_0000/bucket_00000"));
        for (String path : filePaths) {
            File file = new File(path);
            Assert.assertTrue((file.getParentFile().exists() || file.getParentFile().mkdirs() ? 1 : 0) != 0, (String)("Failed creating directory " + file.getParentFile()));
            TestBackgroundHiveSplitLoader.createOrcAcidFile(file);
        }
        ValidReaderWriteIdList validWriteIdsList = new ValidReaderWriteIdList(String.format("4$%s.%s:3:9223372036854775807::", table.getDatabaseName(), table.getTableName()));
        BackgroundHiveSplitLoader backgroundHiveSplitLoader = this.backgroundHiveSplitLoader(HiveTestUtils.HDFS_ENVIRONMENT, (TupleDomain<HiveColumnHandle>)TupleDomain.all(), Optional.empty(), table, Optional.empty(), Optional.of(validWriteIdsList));
        HiveSplitSource hiveSplitSource = this.hiveSplitSource((HiveSplitLoader)backgroundHiveSplitLoader);
        backgroundHiveSplitLoader.start(hiveSplitSource);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestBackgroundHiveSplitLoader.drain(hiveSplitSource)).isInstanceOfSatisfying(PrestoException.class, e -> Assert.assertEquals((Object)StandardErrorCode.NOT_SUPPORTED.toErrorCode(), (Object)e.getErrorCode()))).hasMessage("Hive transactional tables are supported with Hive 3.0 and only after a major compaction has been run");
        MoreFiles.deleteRecursively((Path)tablePath, (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
    }

    @Test
    public void testValidateFileBuckets() {
        ArrayListMultimap bucketFiles = ArrayListMultimap.create();
        bucketFiles.put((Object)1, null);
        bucketFiles.put((Object)3, null);
        bucketFiles.put((Object)4, null);
        bucketFiles.put((Object)6, null);
        bucketFiles.put((Object)9, null);
        PrestoExceptionAssert.assertPrestoExceptionThrownBy(() -> TestBackgroundHiveSplitLoader.lambda$testValidateFileBuckets$11((ListMultimap)bucketFiles)).hasErrorCode((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_BUCKET_FILES).hasMessage("Hive table 'tableName' is corrupt. The highest bucket number in the directory (9) exceeds the bucket number range defined by the declared bucket count (1) for partition: partitionName");
        PrestoExceptionAssert.assertPrestoExceptionThrownBy(() -> TestBackgroundHiveSplitLoader.lambda$testValidateFileBuckets$12((ListMultimap)bucketFiles)).hasErrorCode((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_BUCKET_FILES).hasMessage("Hive table 'tableName' is corrupt. The highest bucket number in the directory (9) exceeds the bucket number range defined by the declared bucket count (5) for partition: partitionName");
        PrestoExceptionAssert.assertPrestoExceptionThrownBy(() -> TestBackgroundHiveSplitLoader.lambda$testValidateFileBuckets$13((ListMultimap)bucketFiles)).hasErrorCode((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_BUCKET_FILES).hasMessage("Hive table 'tableName' is corrupt. The highest bucket number in the directory (9) exceeds the bucket number range defined by the declared bucket count (9) for partition: partitionName");
        BackgroundHiveSplitLoader.validateFileBuckets((ListMultimap)bucketFiles, (int)10, (String)"tableName", (String)"partitionName");
        BackgroundHiveSplitLoader.validateFileBuckets((ListMultimap)bucketFiles, (int)20, (String)"tableName", (String)"partitionName");
        BackgroundHiveSplitLoader.validateFileBuckets((ListMultimap)bucketFiles, (int)30, (String)"tableName", (String)"partitionName");
    }

    @Test
    public void testBuildManifestFileIterator() throws Exception {
        CachingDirectoryLister directoryLister = new CachingDirectoryLister(new Duration(5.0, TimeUnit.MINUTES), 1000L, (List)ImmutableList.of());
        Properties schema = new Properties();
        schema.setProperty("file.inputformat", SymlinkTextInputFormat.class.getName());
        schema.setProperty("serialization.lib", HiveStorageFormat.AVRO.getSerDe());
        org.apache.hadoop.fs.Path firstFilePath = new org.apache.hadoop.fs.Path("hdfs://VOL1:9000/db_name/table_name/file1");
        org.apache.hadoop.fs.Path secondFilePath = new org.apache.hadoop.fs.Path("hdfs://VOL1:9000/db_name/table_name/file2");
        ImmutableList paths = ImmutableList.of((Object)firstFilePath, (Object)secondFilePath);
        List files = (List)paths.stream().map(TestBackgroundHiveSplitLoader::locatedFileStatus).collect(ImmutableList.toImmutableList());
        BackgroundHiveSplitLoader backgroundHiveSplitLoader = this.backgroundHiveSplitLoader((List<LocatedFileStatus>)files, (DirectoryLister)directoryLister);
        Optional splitIterator = backgroundHiveSplitLoader.buildManifestFileIterator((InputFormat)new AvroContainerInputFormat(), "partition", schema, (List)ImmutableList.of(), TupleDomain.all(), () -> true, false, TableToPartitionMapping.empty(), new org.apache.hadoop.fs.Path("hdfs://VOL1:9000/db_name/table_name"), (List)paths, true);
        Assert.assertTrue((boolean)splitIterator.isPresent());
        ImmutableList splits = ImmutableList.copyOf((Iterator)((Iterator)splitIterator.get()));
        Assert.assertEquals((int)splits.size(), (int)2);
        Assert.assertEquals((String)((InternalHiveSplit)splits.get(0)).getPath(), (String)firstFilePath.toString());
        Assert.assertEquals((String)((InternalHiveSplit)splits.get(1)).getPath(), (String)secondFilePath.toString());
    }

    @Test
    public void testBuildManifestFileIteratorNestedDirectory() throws Exception {
        CachingDirectoryLister directoryLister = new CachingDirectoryLister(new Duration(5.0, TimeUnit.MINUTES), 1000L, (List)ImmutableList.of());
        Properties schema = new Properties();
        schema.setProperty("file.inputformat", SymlinkTextInputFormat.class.getName());
        schema.setProperty("serialization.lib", HiveStorageFormat.AVRO.getSerDe());
        org.apache.hadoop.fs.Path filePath = new org.apache.hadoop.fs.Path("hdfs://VOL1:9000/db_name/table_name/file1");
        org.apache.hadoop.fs.Path directoryPath = new org.apache.hadoop.fs.Path("hdfs://VOL1:9000/db_name/table_name/dir");
        ImmutableList paths = ImmutableList.of((Object)filePath, (Object)directoryPath);
        ImmutableList files = ImmutableList.of((Object)TestBackgroundHiveSplitLoader.locatedFileStatus(filePath), (Object)TestBackgroundHiveSplitLoader.locatedDirectoryStatus(directoryPath));
        BackgroundHiveSplitLoader backgroundHiveSplitLoader = this.backgroundHiveSplitLoader((List<LocatedFileStatus>)files, (DirectoryLister)directoryLister);
        Optional splitIterator = backgroundHiveSplitLoader.buildManifestFileIterator((InputFormat)new AvroContainerInputFormat(), "partition", schema, (List)ImmutableList.of(), TupleDomain.all(), () -> true, false, TableToPartitionMapping.empty(), new org.apache.hadoop.fs.Path("hdfs://VOL1:9000/db_name/table_name"), (List)paths, false);
        Assert.assertTrue((boolean)splitIterator.isEmpty());
    }

    private static void createOrcAcidFile(File file) throws IOException {
        if (file.getName().equals("_orc_acid_version")) {
            Files.write(file.toPath(), "2".getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            return;
        }
        Preconditions.checkState((boolean)file.createNewFile(), (String)"Failed to create file %s", (Object)file);
    }

    private static List<String> drain(HiveSplitSource source) throws Exception {
        return (List)TestBackgroundHiveSplitLoader.drainSplits(source).stream().map(HiveSplit::getPath).collect(ImmutableList.toImmutableList());
    }

    private static List<HiveSplit> drainSplits(HiveSplitSource source) throws Exception {
        ImmutableList.Builder splits = ImmutableList.builder();
        while (!source.isFinished()) {
            ((ConnectorSplitSource.ConnectorSplitBatch)source.getNextBatch(NotPartitionedPartitionHandle.NOT_PARTITIONED, 100).get()).getSplits().stream().map(HiveSplit.class::cast).forEach(arg_0 -> ((ImmutableList.Builder)splits).add(arg_0));
        }
        return splits.build();
    }

    private BackgroundHiveSplitLoader backgroundHiveSplitLoader(DynamicFilter dynamicFilter, Duration dynamicFilteringProbeBlockingTimeoutMillis) {
        return this.backgroundHiveSplitLoader(new TestingHdfsEnvironment(TEST_FILES), (TupleDomain<HiveColumnHandle>)TupleDomain.all(), dynamicFilter, dynamicFilteringProbeBlockingTimeoutMillis, Optional.empty(), SIMPLE_TABLE, Optional.empty(), Optional.empty());
    }

    private BackgroundHiveSplitLoader backgroundHiveSplitLoader(List<LocatedFileStatus> files, TupleDomain<HiveColumnHandle> tupleDomain) {
        return this.backgroundHiveSplitLoader(files, tupleDomain, Optional.empty(), SIMPLE_TABLE, Optional.empty());
    }

    private BackgroundHiveSplitLoader backgroundHiveSplitLoader(List<LocatedFileStatus> files, TupleDomain<HiveColumnHandle> compactEffectivePredicate, Optional<HiveBucketing.HiveBucketFilter> hiveBucketFilter, Table table, Optional<HiveBucketHandle> bucketHandle) {
        return this.backgroundHiveSplitLoader(files, compactEffectivePredicate, hiveBucketFilter, table, bucketHandle, Optional.empty());
    }

    private BackgroundHiveSplitLoader backgroundHiveSplitLoader(List<LocatedFileStatus> files, TupleDomain<HiveColumnHandle> compactEffectivePredicate, Optional<HiveBucketing.HiveBucketFilter> hiveBucketFilter, Table table, Optional<HiveBucketHandle> bucketHandle, Optional<ValidWriteIdList> validWriteIds) {
        return this.backgroundHiveSplitLoader(new TestingHdfsEnvironment(files), compactEffectivePredicate, hiveBucketFilter, table, bucketHandle, validWriteIds);
    }

    private BackgroundHiveSplitLoader backgroundHiveSplitLoader(HdfsEnvironment hdfsEnvironment, TupleDomain<HiveColumnHandle> compactEffectivePredicate, Optional<HiveBucketing.HiveBucketFilter> hiveBucketFilter, Table table, Optional<HiveBucketHandle> bucketHandle, Optional<ValidWriteIdList> validWriteIds) {
        return this.backgroundHiveSplitLoader(hdfsEnvironment, compactEffectivePredicate, DynamicFilter.EMPTY, Duration.valueOf((String)"0s"), hiveBucketFilter, table, bucketHandle, validWriteIds);
    }

    private BackgroundHiveSplitLoader backgroundHiveSplitLoader(HdfsEnvironment hdfsEnvironment, TupleDomain<HiveColumnHandle> compactEffectivePredicate, DynamicFilter dynamicFilter, Duration dynamicFilteringProbeBlockingTimeout, Optional<HiveBucketing.HiveBucketFilter> hiveBucketFilter, Table table, Optional<HiveBucketHandle> bucketHandle, Optional<ValidWriteIdList> validWriteIds) {
        ImmutableList hivePartitionMetadatas = ImmutableList.of((Object)new HivePartitionMetadata(new HivePartition(new SchemaTableName("testSchema", "table_name")), Optional.empty(), TableToPartitionMapping.empty()));
        return new BackgroundHiveSplitLoader(table, AcidTransaction.NO_ACID_TRANSACTION, (Iterable)hivePartitionMetadatas, compactEffectivePredicate, dynamicFilter, dynamicFilteringProbeBlockingTimeout, HiveTestUtils.TYPE_MANAGER, BackgroundHiveSplitLoader.BucketSplitInfo.createBucketSplitInfo(bucketHandle, hiveBucketFilter), HiveTestUtils.SESSION, hdfsEnvironment, new NamenodeStats(), (DirectoryLister)new CachingDirectoryLister(new HiveConfig()), (Executor)this.executor, 2, false, false, true, validWriteIds);
    }

    private BackgroundHiveSplitLoader backgroundHiveSplitLoader(List<LocatedFileStatus> files, DirectoryLister directoryLister) {
        ImmutableList hivePartitionMetadatas = ImmutableList.of((Object)new HivePartitionMetadata(new HivePartition(new SchemaTableName("testSchema", "table_name")), Optional.empty(), TableToPartitionMapping.empty()));
        ConnectorSession connectorSession = HiveTestUtils.getHiveSession(new HiveConfig().setMaxSplitSize(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.GIGABYTE)));
        return new BackgroundHiveSplitLoader(SIMPLE_TABLE, AcidTransaction.NO_ACID_TRANSACTION, (Iterable)hivePartitionMetadatas, TupleDomain.none(), DynamicFilter.EMPTY, Duration.valueOf((String)"0s"), HiveTestUtils.TYPE_MANAGER, Optional.empty(), connectorSession, (HdfsEnvironment)new TestingHdfsEnvironment(files), new NamenodeStats(), directoryLister, (Executor)this.executor, 2, false, false, true, Optional.empty());
    }

    private static BackgroundHiveSplitLoader backgroundHiveSplitLoaderOfflinePartitions() {
        ConnectorSession connectorSession = HiveTestUtils.getHiveSession(new HiveConfig().setMaxSplitSize(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.GIGABYTE)));
        return new BackgroundHiveSplitLoader(SIMPLE_TABLE, AcidTransaction.NO_ACID_TRANSACTION, TestBackgroundHiveSplitLoader.createPartitionMetadataWithOfflinePartitions(), TupleDomain.all(), DynamicFilter.EMPTY, Duration.valueOf((String)"0s"), HiveTestUtils.TYPE_MANAGER, BackgroundHiveSplitLoader.BucketSplitInfo.createBucketSplitInfo(Optional.empty(), Optional.empty()), connectorSession, (HdfsEnvironment)new TestingHdfsEnvironment(TEST_FILES), new NamenodeStats(), (DirectoryLister)new CachingDirectoryLister(new HiveConfig()), MoreExecutors.directExecutor(), 2, false, false, true, Optional.empty());
    }

    private static Iterable<HivePartitionMetadata> createPartitionMetadataWithOfflinePartitions() throws RuntimeException {
        return () -> new AbstractIterator<HivePartitionMetadata>(){
            private int position = -1;

            protected HivePartitionMetadata computeNext() {
                ++this.position;
                switch (this.position) {
                    case 0: {
                        return new HivePartitionMetadata(new HivePartition(new SchemaTableName("testSchema", "table_name")), Optional.empty(), TableToPartitionMapping.empty());
                    }
                    case 1: {
                        throw new RuntimeException("OFFLINE");
                    }
                }
                return (HivePartitionMetadata)this.endOfData();
            }
        };
    }

    private HiveSplitSource hiveSplitSource(HiveSplitLoader hiveSplitLoader) {
        return HiveSplitSource.allAtOnce((ConnectorSession)HiveTestUtils.SESSION, (String)SIMPLE_TABLE.getDatabaseName(), (String)SIMPLE_TABLE.getTableName(), (int)1, (int)1, (DataSize)DataSize.of((long)32L, (DataSize.Unit)DataSize.Unit.MEGABYTE), (int)Integer.MAX_VALUE, (HiveSplitLoader)hiveSplitLoader, (Executor)this.executor, (CounterStat)new CounterStat());
    }

    private static Table table(List<Column> partitionColumns, Optional<HiveBucketProperty> bucketProperty, ImmutableMap<String, String> tableParameters) {
        return TestBackgroundHiveSplitLoader.table(partitionColumns, bucketProperty, tableParameters, StorageFormat.create((String)"com.facebook.hive.orc.OrcSerde", (String)"org.apache.hadoop.hive.ql.io.RCFileInputFormat", (String)"org.apache.hadoop.hive.ql.io.RCFileInputFormat"));
    }

    private static Table table(String location, List<Column> partitionColumns, Optional<HiveBucketProperty> bucketProperty, ImmutableMap<String, String> tableParameters) {
        return TestBackgroundHiveSplitLoader.table(location, partitionColumns, bucketProperty, tableParameters, StorageFormat.create((String)"com.facebook.hive.orc.OrcSerde", (String)"org.apache.hadoop.hive.ql.io.RCFileInputFormat", (String)"org.apache.hadoop.hive.ql.io.RCFileInputFormat"));
    }

    private static Table table(List<Column> partitionColumns, Optional<HiveBucketProperty> bucketProperty, Map<String, String> tableParameters, StorageFormat storageFormat) {
        return TestBackgroundHiveSplitLoader.table("hdfs://VOL1:9000/db_name/table_name", partitionColumns, bucketProperty, tableParameters, storageFormat);
    }

    private static Table table(String location, List<Column> partitionColumns, Optional<HiveBucketProperty> bucketProperty, Map<String, String> tableParameters, StorageFormat storageFormat) {
        Table.Builder tableBuilder = Table.builder();
        tableBuilder.getStorageBuilder().setStorageFormat(storageFormat).setLocation(location).setSkewed(false).setBucketProperty(bucketProperty);
        return tableBuilder.setDatabaseName("test_dbname").setOwner("testOwner").setTableName("test_table").setTableType(TableType.MANAGED_TABLE.toString()).setDataColumns((List)ImmutableList.of((Object)new Column("col1", HiveType.HIVE_STRING, Optional.empty()))).setParameters(tableParameters).setPartitionColumns(partitionColumns).build();
    }

    private static LocatedFileStatus locatedFileStatus(org.apache.hadoop.fs.Path path) {
        return TestBackgroundHiveSplitLoader.locatedFileStatus(path, 0L);
    }

    private static LocatedFileStatus locatedFileStatus(org.apache.hadoop.fs.Path path, long fileLength) {
        return new LocatedFileStatus(fileLength, false, 0, 0L, 0L, 0L, null, null, null, null, path, new BlockLocation[]{new BlockLocation(new String[1], new String[]{"localhost"}, 0L, fileLength)});
    }

    private static LocatedFileStatus locatedFileStatusWithNoBlocks(org.apache.hadoop.fs.Path path) {
        return new LocatedFileStatus(0L, false, 0, 0L, 0L, 0L, null, null, null, null, path, new BlockLocation[0]);
    }

    private static LocatedFileStatus locatedDirectoryStatus(org.apache.hadoop.fs.Path path) {
        return new LocatedFileStatus(0L, true, 0, 0L, 0L, 0L, null, null, null, null, path, new BlockLocation[0]);
    }

    private static /* synthetic */ void lambda$testValidateFileBuckets$13(ListMultimap bucketFiles) throws Throwable {
        BackgroundHiveSplitLoader.validateFileBuckets((ListMultimap)bucketFiles, (int)9, (String)"tableName", (String)"partitionName");
    }

    private static /* synthetic */ void lambda$testValidateFileBuckets$12(ListMultimap bucketFiles) throws Throwable {
        BackgroundHiveSplitLoader.validateFileBuckets((ListMultimap)bucketFiles, (int)5, (String)"tableName", (String)"partitionName");
    }

    private static /* synthetic */ void lambda$testValidateFileBuckets$11(ListMultimap bucketFiles) throws Throwable {
        BackgroundHiveSplitLoader.validateFileBuckets((ListMultimap)bucketFiles, (int)1, (String)"tableName", (String)"partitionName");
    }

    private static /* synthetic */ boolean lambda$testFullAcidTableWithOriginalFiles$8(List filePaths, String p) {
        return p.contains((CharSequence)filePaths.get(1));
    }

    private static /* synthetic */ boolean lambda$testSplitsGenerationWithAbortedTransactions$6(List filePaths, String p) {
        return p.contains((CharSequence)filePaths.get(5));
    }

    private static /* synthetic */ boolean lambda$testSplitsGenerationWithAbortedTransactions$5(List filePaths, String p) {
        return p.contains((CharSequence)filePaths.get(1));
    }

    private static class TestingHdfsFileSystem
    extends FileSystem {
        private final List<LocatedFileStatus> files;

        public TestingHdfsFileSystem(List<LocatedFileStatus> files) {
            this.files = ImmutableList.copyOf(files);
        }

        public boolean delete(org.apache.hadoop.fs.Path f, boolean recursive) {
            throw new UnsupportedOperationException();
        }

        public boolean rename(org.apache.hadoop.fs.Path src, org.apache.hadoop.fs.Path dst) {
            throw new UnsupportedOperationException();
        }

        public void setWorkingDirectory(org.apache.hadoop.fs.Path dir) {
            throw new UnsupportedOperationException();
        }

        public FileStatus[] listStatus(org.apache.hadoop.fs.Path f) {
            throw new UnsupportedOperationException();
        }

        public RemoteIterator<LocatedFileStatus> listLocatedStatus(org.apache.hadoop.fs.Path f) {
            return new RemoteIterator<LocatedFileStatus>(){
                private final Iterator<LocatedFileStatus> iterator;
                {
                    this.iterator = files.iterator();
                }

                public boolean hasNext() {
                    return this.iterator.hasNext();
                }

                public LocatedFileStatus next() {
                    return this.iterator.next();
                }
            };
        }

        public FSDataOutputStream create(org.apache.hadoop.fs.Path f, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) {
            throw new UnsupportedOperationException();
        }

        public boolean mkdirs(org.apache.hadoop.fs.Path f, FsPermission permission) {
            throw new UnsupportedOperationException();
        }

        public FSDataOutputStream append(org.apache.hadoop.fs.Path f, int bufferSize, Progressable progress) {
            throw new UnsupportedOperationException();
        }

        public FSDataInputStream open(org.apache.hadoop.fs.Path f, int bufferSize) {
            throw new UnsupportedOperationException();
        }

        public FileStatus getFileStatus(org.apache.hadoop.fs.Path f) {
            throw new UnsupportedOperationException();
        }

        public org.apache.hadoop.fs.Path getWorkingDirectory() {
            throw new UnsupportedOperationException();
        }

        public URI getUri() {
            throw new UnsupportedOperationException();
        }
    }

    public static class TestingHdfsEnvironment
    extends HdfsEnvironment {
        private final List<LocatedFileStatus> files;

        public TestingHdfsEnvironment(List<LocatedFileStatus> files) {
            super((HdfsConfiguration)new HiveHdfsConfiguration(new HdfsConfigurationInitializer(new HdfsConfig()), (Set)ImmutableSet.of()), new HdfsConfig(), (HdfsAuthentication)new NoHdfsAuthentication());
            this.files = ImmutableList.copyOf(files);
        }

        public FileSystem getFileSystem(String user, org.apache.hadoop.fs.Path path, Configuration configuration) {
            return new TestingHdfsFileSystem(this.files);
        }
    }

    public static final class TestSplittableFailureInputFormat
    extends FileInputFormat<Void, Void> {
        protected boolean isSplitable(FileSystem fs, org.apache.hadoop.fs.Path filename) {
            throw new IllegalStateException("isSplittable called");
        }

        public RecordReader<Void, Void> getRecordReader(InputSplit inputSplit, JobConf jobConf, Reporter reporter) throws IOException {
            throw new UnsupportedOperationException();
        }
    }
}

