/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive;

import com.google.common.collect.ImmutableSet;
import io.prestosql.plugin.hive.HdfsConfig;
import io.prestosql.plugin.hive.HdfsConfiguration;
import io.prestosql.plugin.hive.HdfsConfigurationInitializer;
import io.prestosql.plugin.hive.HdfsEnvironment;
import io.prestosql.plugin.hive.HiveHdfsConfiguration;
import io.prestosql.plugin.hive.authentication.HadoopAuthentication;
import io.prestosql.plugin.hive.authentication.HdfsAuthentication;
import io.prestosql.plugin.hive.authentication.ImpersonatingHdfsAuthentication;
import io.prestosql.plugin.hive.authentication.SimpleHadoopAuthentication;
import java.io.IOException;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestFileSystemCache {
    @Test
    public void testFileSystemCache() throws IOException {
        HdfsEnvironment environment = new HdfsEnvironment((HdfsConfiguration)new HiveHdfsConfiguration(new HdfsConfigurationInitializer(new HdfsConfig()), (Set)ImmutableSet.of()), new HdfsConfig(), (HdfsAuthentication)new ImpersonatingHdfsAuthentication((HadoopAuthentication)new SimpleHadoopAuthentication()));
        FileSystem fs1 = this.getFileSystem(environment, "user");
        FileSystem fs2 = this.getFileSystem(environment, "user");
        Assert.assertSame((Object)fs1, (Object)fs2);
        FileSystem fs3 = this.getFileSystem(environment, "other_user");
        Assert.assertNotSame((Object)fs1, (Object)fs3);
        FileSystem fs4 = this.getFileSystem(environment, "other_user");
        Assert.assertSame((Object)fs3, (Object)fs4);
    }

    private FileSystem getFileSystem(HdfsEnvironment environment, String user) throws IOException {
        return environment.getFileSystem(user, new Path("/"), new Configuration(false));
    }
}

