/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.net.HostAndPort;
import io.airlift.configuration.testing.ConfigAssertions;
import io.airlift.units.Duration;
import io.prestosql.plugin.hive.HdfsConfig;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.testng.annotations.Test;

public class TestHdfsConfig {
    @Test
    public void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((HdfsConfig)ConfigAssertions.recordDefaults(HdfsConfig.class)).setResourceConfigFiles("").setNewDirectoryPermissions("0777").setNewFileInheritOwnership(false).setVerifyChecksum(true).setIpcPingInterval(new Duration(10.0, TimeUnit.SECONDS)).setDfsTimeout(new Duration(60.0, TimeUnit.SECONDS)).setDfsConnectTimeout(new Duration(500.0, TimeUnit.MILLISECONDS)).setDfsConnectMaxRetries(5).setDfsKeyProviderCacheTtl(new Duration(30.0, TimeUnit.MINUTES)).setDomainSocketPath(null).setSocksProxy(null).setWireEncryptionEnabled(false).setFileSystemMaxCacheSize(1000).setDfsReplication(null));
    }

    @Test
    public void testExplicitPropertyMappings() throws IOException {
        Path resource1 = Files.createTempFile(null, null, new FileAttribute[0]);
        Path resource2 = Files.createTempFile(null, null, new FileAttribute[0]);
        ImmutableMap properties = new ImmutableMap.Builder().put((Object)"hive.config.resources", (Object)(resource1.toString() + "," + resource2.toString())).put((Object)"hive.fs.new-directory-permissions", (Object)"0700").put((Object)"hive.fs.new-file-inherit-ownership", (Object)"true").put((Object)"hive.dfs.verify-checksum", (Object)"false").put((Object)"hive.dfs.ipc-ping-interval", (Object)"34s").put((Object)"hive.dfs-timeout", (Object)"33s").put((Object)"hive.dfs.connect.timeout", (Object)"20s").put((Object)"hive.dfs.connect.max-retries", (Object)"10").put((Object)"hive.dfs.key-provider.cache-ttl", (Object)"42s").put((Object)"hive.dfs.domain-socket-path", (Object)"/foo").put((Object)"hive.hdfs.socks-proxy", (Object)"localhost:4567").put((Object)"hive.hdfs.wire-encryption.enabled", (Object)"true").put((Object)"hive.fs.cache.max-size", (Object)"1010").put((Object)"hive.dfs.replication", (Object)"1").build();
        HdfsConfig expected = new HdfsConfig().setResourceConfigFiles((List)ImmutableList.of((Object)resource1.toFile(), (Object)resource2.toFile())).setNewDirectoryPermissions("0700").setNewFileInheritOwnership(true).setVerifyChecksum(false).setIpcPingInterval(new Duration(34.0, TimeUnit.SECONDS)).setDfsTimeout(new Duration(33.0, TimeUnit.SECONDS)).setDfsConnectTimeout(new Duration(20.0, TimeUnit.SECONDS)).setDfsConnectMaxRetries(10).setDfsKeyProviderCacheTtl(new Duration(42.0, TimeUnit.SECONDS)).setDomainSocketPath("/foo").setSocksProxy(HostAndPort.fromParts((String)"localhost", (int)4567)).setWireEncryptionEnabled(true).setFileSystemMaxCacheSize(1010).setDfsReplication(Integer.valueOf(1));
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }
}

