/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive;

import com.google.common.collect.ImmutableList;
import io.prestosql.plugin.hive.HiveApplyProjectionUtil;
import io.prestosql.spi.expression.ConnectorExpression;
import io.prestosql.spi.expression.Constant;
import io.prestosql.spi.expression.FieldDereference;
import io.prestosql.spi.expression.Variable;
import io.prestosql.spi.type.IntegerType;
import io.prestosql.spi.type.RowType;
import io.prestosql.spi.type.Type;
import java.util.Collection;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestHiveApplyProjectionUtil {
    private static final ConnectorExpression ROW_OF_ROW_VARIABLE = new Variable("a", (Type)RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((String)"b", (Type)RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((String)"c", (Type)IntegerType.INTEGER)}))}));
    private static final ConnectorExpression ONE_LEVEL_DEREFERENCE = new FieldDereference((Type)RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((String)"c", (Type)IntegerType.INTEGER)}), ROW_OF_ROW_VARIABLE, 0);
    private static final ConnectorExpression TWO_LEVEL_DEREFERENCE = new FieldDereference((Type)IntegerType.INTEGER, ONE_LEVEL_DEREFERENCE, 0);
    private static final ConnectorExpression INT_VARIABLE = new Variable("a", (Type)IntegerType.INTEGER);
    private static final ConnectorExpression CONSTANT = new Constant((Object)5, (Type)IntegerType.INTEGER);

    @Test
    public void testIsProjectionSupported() {
        Assert.assertTrue((boolean)HiveApplyProjectionUtil.isPushDownSupported((ConnectorExpression)ONE_LEVEL_DEREFERENCE));
        Assert.assertTrue((boolean)HiveApplyProjectionUtil.isPushDownSupported((ConnectorExpression)TWO_LEVEL_DEREFERENCE));
        Assert.assertTrue((boolean)HiveApplyProjectionUtil.isPushDownSupported((ConnectorExpression)INT_VARIABLE));
        Assert.assertFalse((boolean)HiveApplyProjectionUtil.isPushDownSupported((ConnectorExpression)CONSTANT));
    }

    @Test
    public void testExtractSupportedProjectionColumns() {
        Assert.assertEquals((Collection)HiveApplyProjectionUtil.extractSupportedProjectedColumns((ConnectorExpression)ONE_LEVEL_DEREFERENCE), (Collection)ImmutableList.of((Object)ONE_LEVEL_DEREFERENCE));
        Assert.assertEquals((Collection)HiveApplyProjectionUtil.extractSupportedProjectedColumns((ConnectorExpression)TWO_LEVEL_DEREFERENCE), (Collection)ImmutableList.of((Object)TWO_LEVEL_DEREFERENCE));
        Assert.assertEquals((Collection)HiveApplyProjectionUtil.extractSupportedProjectedColumns((ConnectorExpression)INT_VARIABLE), (Collection)ImmutableList.of((Object)INT_VARIABLE));
        Assert.assertEquals((Collection)HiveApplyProjectionUtil.extractSupportedProjectedColumns((ConnectorExpression)CONSTANT), (Collection)ImmutableList.of());
    }
}

