/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive;

import io.prestosql.plugin.hive.HiveBooleanParser;
import java.nio.charset.StandardCharsets;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestHiveBooleanParser {
    @Test
    public void testParse() {
        Assert.assertTrue((boolean)TestHiveBooleanParser.parseBoolean("true"));
        Assert.assertTrue((boolean)TestHiveBooleanParser.parseBoolean("TRUE"));
        Assert.assertTrue((boolean)TestHiveBooleanParser.parseBoolean("tRuE"));
        Assert.assertFalse((boolean)TestHiveBooleanParser.parseBoolean("false"));
        Assert.assertFalse((boolean)TestHiveBooleanParser.parseBoolean("FALSE"));
        Assert.assertFalse((boolean)TestHiveBooleanParser.parseBoolean("fAlSe"));
        Assert.assertNull((Object)TestHiveBooleanParser.parseBoolean("true "));
        Assert.assertNull((Object)TestHiveBooleanParser.parseBoolean(" true"));
        Assert.assertNull((Object)TestHiveBooleanParser.parseBoolean("false "));
        Assert.assertNull((Object)TestHiveBooleanParser.parseBoolean(" false"));
        Assert.assertNull((Object)TestHiveBooleanParser.parseBoolean("t"));
        Assert.assertNull((Object)TestHiveBooleanParser.parseBoolean("f"));
        Assert.assertNull((Object)TestHiveBooleanParser.parseBoolean(""));
        Assert.assertNull((Object)TestHiveBooleanParser.parseBoolean("blah"));
    }

    private static Boolean parseBoolean(String s) {
        return HiveBooleanParser.parseHiveBoolean((byte[])s.getBytes(StandardCharsets.US_ASCII), (int)0, (int)s.length());
    }
}

