/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive;

import com.google.common.collect.ImmutableMap;
import io.airlift.configuration.testing.ConfigAssertions;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.prestosql.plugin.hive.HiveCompressionCodec;
import io.prestosql.plugin.hive.HiveConfig;
import io.prestosql.plugin.hive.HiveSessionProperties;
import io.prestosql.plugin.hive.HiveStorageFormat;
import io.prestosql.plugin.hive.HiveTimestampPrecision;
import io.prestosql.plugin.hive.util.TestHiveUtil;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import org.testng.annotations.Test;

public class TestHiveConfig {
    @Test
    public void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((HiveConfig)ConfigAssertions.recordDefaults(HiveConfig.class)).setMaxSplitSize(DataSize.of((long)64L, (DataSize.Unit)DataSize.Unit.MEGABYTE)).setMaxPartitionsPerScan(100000).setMaxOutstandingSplits(1000).setMaxOutstandingSplitsSize(DataSize.of((long)256L, (DataSize.Unit)DataSize.Unit.MEGABYTE)).setMaxSplitIteratorThreads(1000).setAllowCorruptWritesForTesting(false).setPerTransactionMetastoreCacheMaximumSize(1000L).setMinPartitionBatchSize(10).setMaxPartitionBatchSize(100).setMaxInitialSplits(200).setMaxInitialSplitSize(DataSize.of((long)32L, (DataSize.Unit)DataSize.Unit.MEGABYTE)).setSplitLoaderConcurrency(4).setMaxSplitsPerSecond(null).setDomainCompactionThreshold(100).setWriterSortBufferSize(DataSize.of((long)64L, (DataSize.Unit)DataSize.Unit.MEGABYTE)).setForceLocalScheduling(false).setMaxConcurrentFileRenames(20).setMaxConcurrentMetastoreDrops(20).setMaxConcurrentMetastoreUpdates(20).setRecursiveDirWalkerEnabled(false).setIgnoreAbsentPartitions(false).setHiveStorageFormat(HiveStorageFormat.ORC).setHiveCompressionCodec(HiveCompressionCodec.GZIP).setRespectTableFormat(true).setImmutablePartitions(false).setInsertExistingPartitionsBehavior(HiveSessionProperties.InsertExistingPartitionsBehavior.APPEND).setCreateEmptyBucketFiles(false).setSortedWritingEnabled(true).setMaxPartitionsPerWriter(100).setMaxOpenSortFiles(50).setWriteValidationThreads(16).setValidateBucketing(true).setTextMaxLineLength(DataSize.of((long)100L, (DataSize.Unit)DataSize.Unit.MEGABYTE)).setOrcLegacyTimeZone(TimeZone.getDefault().getID()).setParquetTimeZone(TimeZone.getDefault().getID()).setUseParquetColumnNames(false).setRcfileTimeZone(TimeZone.getDefault().getID()).setRcfileWriterValidate(false).setSkipDeletionForAlter(false).setSkipTargetCleanupOnRollback(false).setBucketExecutionEnabled(true).setTableStatisticsEnabled(true).setOptimizeMismatchedBucketCount(false).setWritesToNonManagedTablesEnabled(false).setCreatesOfNonManagedTablesEnabled(true).setPartitionStatisticsSampleSize(100).setIgnoreCorruptedStatistics(false).setCollectColumnStatisticsOnWrite(true).setS3SelectPushdownEnabled(false).setS3SelectPushdownMaxConnections(500).setTemporaryStagingDirectoryEnabled(true).setTemporaryStagingDirectoryPath("/tmp/presto-${USER}").setFileStatusCacheExpireAfterWrite(new Duration(1.0, TimeUnit.MINUTES)).setFileStatusCacheMaxSize(1000000L).setFileStatusCacheTables("").setTranslateHiveViews(false).setHiveTransactionHeartbeatInterval(null).setHiveTransactionHeartbeatThreads(5).setAllowRegisterPartition(false).setQueryPartitionFilterRequired(false).setPartitionUseColumnNames(false).setProjectionPushdownEnabled(true).setDynamicFilteringProbeBlockingTimeout(new Duration(0.0, TimeUnit.MINUTES)).setTimestampPrecision(HiveTimestampPrecision.DEFAULT_PRECISION).setOptimizeSymlinkListing(true).setLegacyHiveViewTranslation(false));
    }

    @Test
    public void testExplicitPropertyMappings() {
        ImmutableMap properties = new ImmutableMap.Builder().put((Object)"hive.max-split-size", (Object)"256MB").put((Object)"hive.max-partitions-per-scan", (Object)"123").put((Object)"hive.max-outstanding-splits", (Object)"10").put((Object)"hive.max-outstanding-splits-size", (Object)"32MB").put((Object)"hive.max-split-iterator-threads", (Object)"10").put((Object)"hive.allow-corrupt-writes-for-testing", (Object)"true").put((Object)"hive.per-transaction-metastore-cache-maximum-size", (Object)"500").put((Object)"hive.metastore.partition-batch-size.min", (Object)"1").put((Object)"hive.metastore.partition-batch-size.max", (Object)"1000").put((Object)"hive.max-initial-splits", (Object)"10").put((Object)"hive.max-initial-split-size", (Object)"16MB").put((Object)"hive.split-loader-concurrency", (Object)"1").put((Object)"hive.max-splits-per-second", (Object)"1").put((Object)"hive.domain-compaction-threshold", (Object)"42").put((Object)"hive.writer-sort-buffer-size", (Object)"13MB").put((Object)"hive.recursive-directories", (Object)"true").put((Object)"hive.ignore-absent-partitions", (Object)"true").put((Object)"hive.storage-format", (Object)"SEQUENCEFILE").put((Object)"hive.compression-codec", (Object)"NONE").put((Object)"hive.respect-table-format", (Object)"false").put((Object)"hive.immutable-partitions", (Object)"true").put((Object)"hive.insert-existing-partitions-behavior", (Object)"OVERWRITE").put((Object)"hive.create-empty-bucket-files", (Object)"true").put((Object)"hive.max-partitions-per-writers", (Object)"222").put((Object)"hive.max-open-sort-files", (Object)"333").put((Object)"hive.write-validation-threads", (Object)"11").put((Object)"hive.validate-bucketing", (Object)"false").put((Object)"hive.force-local-scheduling", (Object)"true").put((Object)"hive.max-concurrent-file-renames", (Object)"100").put((Object)"hive.max-concurrent-metastore-drops", (Object)"100").put((Object)"hive.max-concurrent-metastore-updates", (Object)"100").put((Object)"hive.text.max-line-length", (Object)"13MB").put((Object)"hive.orc.time-zone", (Object)TestHiveUtil.nonDefaultTimeZone().getID()).put((Object)"hive.parquet.time-zone", (Object)TestHiveUtil.nonDefaultTimeZone().getID()).put((Object)"hive.parquet.use-column-names", (Object)"true").put((Object)"hive.rcfile.time-zone", (Object)TestHiveUtil.nonDefaultTimeZone().getID()).put((Object)"hive.rcfile.writer.validate", (Object)"true").put((Object)"hive.skip-deletion-for-alter", (Object)"true").put((Object)"hive.skip-target-cleanup-on-rollback", (Object)"true").put((Object)"hive.bucket-execution", (Object)"false").put((Object)"hive.sorted-writing", (Object)"false").put((Object)"hive.table-statistics-enabled", (Object)"false").put((Object)"hive.optimize-mismatched-bucket-count", (Object)"true").put((Object)"hive.non-managed-table-writes-enabled", (Object)"true").put((Object)"hive.non-managed-table-creates-enabled", (Object)"false").put((Object)"hive.partition-statistics-sample-size", (Object)"1234").put((Object)"hive.ignore-corrupted-statistics", (Object)"true").put((Object)"hive.collect-column-statistics-on-write", (Object)"false").put((Object)"hive.s3select-pushdown.enabled", (Object)"true").put((Object)"hive.s3select-pushdown.max-connections", (Object)"1234").put((Object)"hive.temporary-staging-directory-enabled", (Object)"false").put((Object)"hive.temporary-staging-directory-path", (Object)"updated").put((Object)"hive.file-status-cache-tables", (Object)"foo.bar1, foo.bar2").put((Object)"hive.file-status-cache-size", (Object)"1000").put((Object)"hive.file-status-cache-expire-time", (Object)"30m").put((Object)"hive.translate-hive-views", (Object)"true").put((Object)"hive.transaction-heartbeat-interval", (Object)"10s").put((Object)"hive.transaction-heartbeat-threads", (Object)"10").put((Object)"hive.allow-register-partition-procedure", (Object)"true").put((Object)"hive.query-partition-filter-required", (Object)"true").put((Object)"hive.partition-use-column-names", (Object)"true").put((Object)"hive.projection-pushdown-enabled", (Object)"false").put((Object)"hive.dynamic-filtering-probe-blocking-timeout", (Object)"10s").put((Object)"hive.timestamp-precision", (Object)"NANOSECONDS").put((Object)"hive.optimize-symlink-listing", (Object)"false").put((Object)"hive.legacy-hive-view-translation", (Object)"true").build();
        HiveConfig expected = new HiveConfig().setMaxSplitSize(DataSize.of((long)256L, (DataSize.Unit)DataSize.Unit.MEGABYTE)).setMaxPartitionsPerScan(123).setMaxOutstandingSplits(10).setMaxOutstandingSplitsSize(DataSize.of((long)32L, (DataSize.Unit)DataSize.Unit.MEGABYTE)).setMaxSplitIteratorThreads(10).setAllowCorruptWritesForTesting(true).setPerTransactionMetastoreCacheMaximumSize(500L).setMinPartitionBatchSize(1).setMaxPartitionBatchSize(1000).setMaxInitialSplits(10).setMaxInitialSplitSize(DataSize.of((long)16L, (DataSize.Unit)DataSize.Unit.MEGABYTE)).setSplitLoaderConcurrency(1).setMaxSplitsPerSecond(Integer.valueOf(1)).setDomainCompactionThreshold(42).setWriterSortBufferSize(DataSize.of((long)13L, (DataSize.Unit)DataSize.Unit.MEGABYTE)).setForceLocalScheduling(true).setMaxConcurrentFileRenames(100).setMaxConcurrentMetastoreDrops(100).setMaxConcurrentMetastoreUpdates(100).setRecursiveDirWalkerEnabled(true).setIgnoreAbsentPartitions(true).setHiveStorageFormat(HiveStorageFormat.SEQUENCEFILE).setHiveCompressionCodec(HiveCompressionCodec.NONE).setRespectTableFormat(false).setImmutablePartitions(true).setInsertExistingPartitionsBehavior(HiveSessionProperties.InsertExistingPartitionsBehavior.OVERWRITE).setCreateEmptyBucketFiles(true).setMaxPartitionsPerWriter(222).setMaxOpenSortFiles(333).setWriteValidationThreads(11).setValidateBucketing(false).setTextMaxLineLength(DataSize.of((long)13L, (DataSize.Unit)DataSize.Unit.MEGABYTE)).setOrcLegacyTimeZone(TestHiveUtil.nonDefaultTimeZone().getID()).setParquetTimeZone(TestHiveUtil.nonDefaultTimeZone().getID()).setUseParquetColumnNames(true).setRcfileTimeZone(TestHiveUtil.nonDefaultTimeZone().getID()).setRcfileWriterValidate(true).setSkipDeletionForAlter(true).setSkipTargetCleanupOnRollback(true).setBucketExecutionEnabled(false).setSortedWritingEnabled(false).setTableStatisticsEnabled(false).setOptimizeMismatchedBucketCount(true).setWritesToNonManagedTablesEnabled(true).setCreatesOfNonManagedTablesEnabled(false).setPartitionStatisticsSampleSize(1234).setIgnoreCorruptedStatistics(true).setCollectColumnStatisticsOnWrite(false).setS3SelectPushdownEnabled(true).setS3SelectPushdownMaxConnections(1234).setTemporaryStagingDirectoryEnabled(false).setTemporaryStagingDirectoryPath("updated").setFileStatusCacheTables("foo.bar1,foo.bar2").setFileStatusCacheMaxSize(1000L).setFileStatusCacheExpireAfterWrite(new Duration(30.0, TimeUnit.MINUTES)).setTranslateHiveViews(true).setHiveTransactionHeartbeatInterval(new Duration(10.0, TimeUnit.SECONDS)).setHiveTransactionHeartbeatThreads(10).setAllowRegisterPartition(true).setQueryPartitionFilterRequired(true).setPartitionUseColumnNames(true).setProjectionPushdownEnabled(false).setDynamicFilteringProbeBlockingTimeout(new Duration(10.0, TimeUnit.SECONDS)).setTimestampPrecision(HiveTimestampPrecision.NANOSECONDS).setOptimizeSymlinkListing(false).setLegacyHiveViewTranslation(true);
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }
}

