/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.Files;
import com.google.common.io.MoreFiles;
import com.google.common.io.RecursiveDeleteOption;
import io.prestosql.plugin.hive.HiveQueryRunner;
import io.prestosql.testing.AbstractTestQueryFramework;
import io.prestosql.testing.MaterializedResult;
import io.prestosql.testing.QueryAssertions;
import io.prestosql.testing.QueryRunner;
import io.prestosql.tpch.TpchTable;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public class TestHiveCreateExternalTable
extends AbstractTestQueryFramework {
    protected QueryRunner createQueryRunner() throws Exception {
        return HiveQueryRunner.builder().setHiveProperties((Map<String, String>)ImmutableMap.of((Object)"hive.non-managed-table-writes-enabled", (Object)"true")).setInitialTables((Iterable<TpchTable<?>>)ImmutableList.of((Object)TpchTable.ORDERS, (Object)TpchTable.CUSTOMER)).build();
    }

    @Test
    public void testCreateExternalTableWithData() throws IOException {
        File tempDir = Files.createTempDir();
        File tableLocation = new File(tempDir, "data");
        String createTableSql = String.format("CREATE TABLE test_create_external WITH (external_location = '%s') AS SELECT * FROM tpch.tiny.nation", tableLocation.toURI().toASCIIString());
        this.assertUpdate(createTableSql, 25L);
        MaterializedResult expected = this.computeActual("SELECT * FROM tpch.tiny.nation");
        MaterializedResult actual = this.computeActual("SELECT * FROM test_create_external");
        QueryAssertions.assertEqualsIgnoreOrder((Iterable)actual.getMaterializedRows(), (Iterable)expected.getMaterializedRows());
        MaterializedResult result = this.computeActual("SELECT DISTINCT regexp_replace(\"$path\", '/[^/]*$', '/') FROM test_create_external");
        String tablePath = (String)result.getOnlyValue();
        Assertions.assertThat((String)tablePath).startsWith((CharSequence)tableLocation.toURI().toString());
        this.assertUpdate("DROP TABLE test_create_external");
        MoreFiles.deleteRecursively((Path)tempDir.toPath(), (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
    }

    @Test
    public void testCreateExternalTableAsWithExistingDirectory() {
        File tempDir = Files.createTempDir();
        String createTableSql = String.format("CREATE TABLE test_create_external_exists WITH (external_location = '%s') AS SELECT * FROM tpch.tiny.nation", tempDir.toURI().toASCIIString());
        this.assertQueryFails(createTableSql, "Target directory for table '.*' already exists:.*");
    }
}

