/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.Files;
import com.google.common.io.MoreFiles;
import com.google.common.io.RecursiveDeleteOption;
import io.prestosql.plugin.hive.HiveQueryRunner;
import io.prestosql.testing.AbstractTestQueryFramework;
import io.prestosql.testing.QueryRunner;
import io.prestosql.tpch.TpchTable;
import java.io.File;
import java.nio.file.Path;
import java.util.Map;
import org.testng.annotations.Test;

public class TestHiveCreateExternalTableDisabled
extends AbstractTestQueryFramework {
    protected QueryRunner createQueryRunner() throws Exception {
        return HiveQueryRunner.builder().setHiveProperties((Map<String, String>)ImmutableMap.of((Object)"hive.non-managed-table-writes-enabled", (Object)"true", (Object)"hive.non-managed-table-creates-enabled", (Object)"false")).setInitialTables((Iterable<TpchTable<?>>)ImmutableList.of((Object)TpchTable.ORDERS, (Object)TpchTable.CUSTOMER)).build();
    }

    @Test
    public void testCreateExternalTableWithData() throws Exception {
        File tempDir = Files.createTempDir();
        String createTableSql = String.format("CREATE TABLE test_create_external WITH (external_location = '%s') AS SELECT * FROM tpch.tiny.nation", tempDir.toURI().toASCIIString());
        this.assertQueryFails(createTableSql, "Creating non-managed Hive tables is disabled");
        MoreFiles.deleteRecursively((Path)tempDir.toPath(), (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
    }

    @Test
    public void testCreateExternalTable() throws Exception {
        File tempDir = Files.createTempDir();
        String createTableSql = String.format("CREATE TABLE test_create_external (n TINYINT) WITH (external_location = '%s')", tempDir.toURI().toASCIIString());
        this.assertQueryFails(createTableSql, "Cannot create non-managed Hive table");
        MoreFiles.deleteRecursively((Path)tempDir.toPath(), (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
    }
}

