/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive;

import com.google.common.base.Verify;
import io.prestosql.Session;
import io.prestosql.execution.DynamicFilterConfig;
import io.prestosql.operator.OperatorStats;
import io.prestosql.plugin.hive.HiveQueryRunner;
import io.prestosql.sql.analyzer.FeaturesConfig;
import io.prestosql.testing.AbstractTestJoinQueries;
import io.prestosql.testing.MaterializedResult;
import io.prestosql.testing.QueryRunner;
import io.prestosql.testing.ResultWithQueryId;
import io.prestosql.tpch.TpchTable;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestHiveDistributedJoinQueries
extends AbstractTestJoinQueries {
    protected QueryRunner createQueryRunner() throws Exception {
        Verify.verify((boolean)new DynamicFilterConfig().isEnableDynamicFiltering(), (String)"this class assumes dynamic filtering is enabled by default", (Object[])new Object[0]);
        return HiveQueryRunner.builder().setInitialTables(TpchTable.getTables()).build();
    }

    @Test
    public void verifyDynamicFilteringEnabled() {
        this.assertQuery("SHOW SESSION LIKE 'enable_dynamic_filtering'", "VALUES ('enable_dynamic_filtering', 'true', 'true', 'boolean', 'Enable dynamic filtering')");
    }

    @Test
    public void testJoinWithEmptyBuildSide() {
        Session session = Session.builder((Session)this.getSession()).setSystemProperty("join_distribution_type", FeaturesConfig.JoinDistributionType.BROADCAST.name()).build();
        ResultWithQueryId result = this.getDistributedQueryRunner().executeWithQueryId(session, "SELECT * FROM lineitem JOIN orders ON lineitem.orderkey = orders.orderkey AND orders.totalprice = 123.4567");
        Assert.assertEquals((int)((MaterializedResult)result.getResult()).getRowCount(), (int)0);
        OperatorStats probeStats = this.searchScanFilterAndProjectOperatorStats(result.getQueryId(), "tpch:lineitem");
        Assert.assertEquals((long)probeStats.getInputPositions(), (long)0L);
        Assert.assertEquals((long)probeStats.getDynamicFilterSplitsProcessed(), (long)probeStats.getTotalDrivers());
    }
}

