/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive;

import com.google.common.collect.Iterables;
import io.prestosql.plugin.hive.HiveQueryRunner;
import io.prestosql.sql.tree.ExplainType;
import io.prestosql.testing.AbstractTestDistributedQueries;
import io.prestosql.testing.MaterializedResult;
import io.prestosql.testing.QueryRunner;
import io.prestosql.testing.sql.TestTable;
import io.prestosql.tpch.TpchTable;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.testng.Assert;
import org.testng.SkipException;
import org.testng.annotations.Test;

public class TestHiveDistributedQueries
extends AbstractTestDistributedQueries {
    protected QueryRunner createQueryRunner() throws Exception {
        return HiveQueryRunner.builder().setInitialTables(TpchTable.getTables()).build();
    }

    protected TestTable createTableWithDefaultColumns() {
        throw new SkipException("Hive connector does not support column default values");
    }

    protected boolean supportsCommentOnColumn() {
        return true;
    }

    public void testDelete() {
    }

    @Test
    public void testExplainOfCreateTableAs() {
        String query = "CREATE TABLE copy_orders AS SELECT * FROM orders";
        MaterializedResult result = this.computeActual("EXPLAIN " + query);
        Assert.assertEquals((Object)Iterables.getOnlyElement((Iterable)result.getOnlyColumnAsSet()), (Object)this.getExplainPlan(query, ExplainType.Type.DISTRIBUTED));
    }

    public void testColumnName(String columnName) {
        if (columnName.equals("atrailingspace ") || columnName.equals(" aleadingspace")) {
            Assertions.assertThatThrownBy(() -> super.testColumnName(columnName)).hasMessageMatching("Table '.*' does not have columns \\[" + columnName + "]");
            throw new SkipException("works incorrectly, column name is trimmed");
        }
        if (columnName.equals("a,comma")) {
            Assertions.assertThatThrownBy(() -> super.testColumnName(columnName)).hasMessageMatching("Table '.*' does not have columns \\[a,comma]");
            throw new SkipException("works incorrectly");
        }
        super.testColumnName(columnName);
    }

    protected Optional<AbstractTestDistributedQueries.DataMappingTestSetup> filterDataMappingSmokeTestData(AbstractTestDistributedQueries.DataMappingTestSetup dataMappingTestSetup) {
        String typeName = dataMappingTestSetup.getPrestoTypeName();
        if (typeName.equals("time") || typeName.equals("timestamp(3) with time zone")) {
            return Optional.of(dataMappingTestSetup.asUnsupported());
        }
        return Optional.of(dataMappingTestSetup);
    }
}

