/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import io.airlift.log.Logger;
import io.airlift.testing.Assertions;
import io.airlift.units.Duration;
import io.prestosql.Session;
import io.prestosql.plugin.hive.HiveQueryRunner;
import io.prestosql.server.DynamicFilterService;
import io.prestosql.spi.QueryId;
import io.prestosql.spi.predicate.Domain;
import io.prestosql.spi.predicate.Range;
import io.prestosql.spi.predicate.ValueSet;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.IntegerType;
import io.prestosql.spi.type.Type;
import io.prestosql.sql.analyzer.FeaturesConfig;
import io.prestosql.testing.AbstractTestQueryFramework;
import io.prestosql.testing.MaterializedResult;
import io.prestosql.testing.MaterializedRow;
import io.prestosql.testing.QueryRunner;
import io.prestosql.testing.ResultWithQueryId;
import io.prestosql.tpch.TpchTable;
import java.util.List;
import java.util.Map;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestHiveDynamicPartitionPruning
extends AbstractTestQueryFramework {
    private static final Logger log = Logger.get(TestHiveDynamicPartitionPruning.class);
    private static final String PARTITIONED_LINEITEM = "partitioned_lineitem";
    private static final long LINEITEM_COUNT = 60175L;

    protected QueryRunner createQueryRunner() throws Exception {
        return HiveQueryRunner.builder().addExtraProperty("dynamic-filtering.large-partitioned.max-distinct-values-per-driver", "100").addExtraProperty("dynamic-filtering.large-partitioned.range-row-limit-per-driver", "100000").setHiveProperties((Map<String, String>)ImmutableMap.of((Object)"hive.dynamic-filtering-probe-blocking-timeout", (Object)"1h")).setInitialTables(TpchTable.getTables()).build();
    }

    @BeforeClass
    public void init() throws Exception {
        super.init();
        String sql = String.format("CREATE TABLE %s WITH (format = 'TEXTFILE', partitioned_by=array['suppkey']) AS SELECT orderkey, partkey, suppkey FROM %s", PARTITIONED_LINEITEM, "tpch.tiny.lineitem");
        long start = System.nanoTime();
        long rows = (Long)((MaterializedRow)this.getQueryRunner().execute(sql).getMaterializedRows().get(0)).getField(0);
        log.info("Imported %s rows for %s in %s", new Object[]{rows, PARTITIONED_LINEITEM, Duration.nanosSince((long)start).convertToMostSuccinctTimeUnit()});
    }

    protected Session getSession() {
        return Session.builder((Session)super.getSession()).setSystemProperty("join_reordering_strategy", FeaturesConfig.JoinReorderingStrategy.NONE.name()).setSystemProperty("join_distribution_type", FeaturesConfig.JoinDistributionType.PARTITIONED.name()).setSystemProperty("enable_large_dynamic_filters", "true").build();
    }

    @Test(timeOut=30000L)
    public void testJoinWithEmptyBuildSide() {
        ResultWithQueryId result = this.getDistributedQueryRunner().executeWithQueryId(this.getSession(), "SELECT * FROM partitioned_lineitem JOIN supplier ON partitioned_lineitem.suppkey = supplier.suppkey AND supplier.name = 'abc'");
        Assert.assertEquals((int)((MaterializedResult)result.getResult()).getRowCount(), (int)0);
        DynamicFilterService.DynamicFiltersStats dynamicFiltersStats = this.getDynamicFilteringStats(result.getQueryId());
        Assert.assertEquals((long)dynamicFiltersStats.getTotalDynamicFilters(), (long)1L);
        Assert.assertEquals((long)dynamicFiltersStats.getLazyDynamicFilters(), (long)1L);
        Assert.assertEquals((long)dynamicFiltersStats.getReplicatedDynamicFilters(), (long)0L);
        Assert.assertEquals((long)dynamicFiltersStats.getDynamicFiltersCompleted(), (long)1L);
        DynamicFilterService.DynamicFilterDomainStats domainStats = (DynamicFilterService.DynamicFilterDomainStats)Iterables.getOnlyElement((Iterable)dynamicFiltersStats.getDynamicFilterDomainStats());
        Assert.assertEquals((String)domainStats.getSimplifiedDomain(), (String)Domain.none((Type)IntegerType.INTEGER).toString(this.getSession().toConnectorSession()));
        Assert.assertEquals((int)domainStats.getDiscreteValuesCount(), (int)0);
        Assert.assertEquals((int)domainStats.getRangeCount(), (int)0);
        Assert.assertTrue((boolean)domainStats.getCollectionDuration().isPresent());
    }

    @Test(timeOut=30000L)
    public void testJoinWithSelectiveBuildSide() {
        ResultWithQueryId result = this.getDistributedQueryRunner().executeWithQueryId(this.getSession(), "SELECT * FROM partitioned_lineitem JOIN supplier ON partitioned_lineitem.suppkey = supplier.suppkey AND supplier.name = 'Supplier#000000001'");
        Assertions.assertGreaterThan((Comparable)Integer.valueOf(((MaterializedResult)result.getResult()).getRowCount()), (Comparable)Integer.valueOf(0));
        DynamicFilterService.DynamicFiltersStats dynamicFiltersStats = this.getDynamicFilteringStats(result.getQueryId());
        Assert.assertEquals((long)dynamicFiltersStats.getTotalDynamicFilters(), (long)1L);
        Assert.assertEquals((long)dynamicFiltersStats.getLazyDynamicFilters(), (long)1L);
        Assert.assertEquals((long)dynamicFiltersStats.getReplicatedDynamicFilters(), (long)0L);
        Assert.assertEquals((long)dynamicFiltersStats.getDynamicFiltersCompleted(), (long)1L);
        DynamicFilterService.DynamicFilterDomainStats domainStats = (DynamicFilterService.DynamicFilterDomainStats)Iterables.getOnlyElement((Iterable)dynamicFiltersStats.getDynamicFilterDomainStats());
        Assert.assertEquals((String)domainStats.getSimplifiedDomain(), (String)Domain.singleValue((Type)IntegerType.INTEGER, (Object)1L).toString(this.getSession().toConnectorSession()));
        Assert.assertEquals((int)domainStats.getDiscreteValuesCount(), (int)0);
        Assert.assertEquals((int)domainStats.getRangeCount(), (int)1);
    }

    @Test(timeOut=30000L)
    public void testJoinWithNonSelectiveBuildSide() {
        ResultWithQueryId result = this.getDistributedQueryRunner().executeWithQueryId(this.getSession(), "SELECT * FROM partitioned_lineitem JOIN supplier ON partitioned_lineitem.suppkey = supplier.suppkey");
        Assert.assertEquals((long)((MaterializedResult)result.getResult()).getRowCount(), (long)60175L);
        DynamicFilterService.DynamicFiltersStats dynamicFiltersStats = this.getDynamicFilteringStats(result.getQueryId());
        Assert.assertEquals((long)dynamicFiltersStats.getTotalDynamicFilters(), (long)1L);
        Assert.assertEquals((long)dynamicFiltersStats.getLazyDynamicFilters(), (long)1L);
        Assert.assertEquals((long)dynamicFiltersStats.getReplicatedDynamicFilters(), (long)0L);
        Assert.assertEquals((long)dynamicFiltersStats.getDynamicFiltersCompleted(), (long)1L);
        DynamicFilterService.DynamicFilterDomainStats domainStats = (DynamicFilterService.DynamicFilterDomainStats)Iterables.getOnlyElement((Iterable)dynamicFiltersStats.getDynamicFilterDomainStats());
        Assert.assertEquals((String)domainStats.getSimplifiedDomain(), (String)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)IntegerType.INTEGER, (Object)1L, (boolean)true, (Object)100L, (boolean)true), (Range[])new Range[0]), (boolean)false).toString(this.getSession().toConnectorSession()));
        Assert.assertEquals((int)domainStats.getDiscreteValuesCount(), (int)0);
        Assert.assertEquals((int)domainStats.getRangeCount(), (int)100);
    }

    @Test(timeOut=30000L)
    public void testJoinLargeBuildSideRangeDynamicFiltering() {
        ResultWithQueryId result = this.getDistributedQueryRunner().executeWithQueryId(this.getSession(), "SELECT * FROM partitioned_lineitem JOIN orders ON partitioned_lineitem.orderkey = orders.orderkey");
        Assert.assertEquals((long)((MaterializedResult)result.getResult()).getRowCount(), (long)60175L);
        DynamicFilterService.DynamicFiltersStats dynamicFiltersStats = this.getDynamicFilteringStats(result.getQueryId());
        Assert.assertEquals((long)dynamicFiltersStats.getTotalDynamicFilters(), (long)1L);
        Assert.assertEquals((long)dynamicFiltersStats.getLazyDynamicFilters(), (long)1L);
        Assert.assertEquals((long)dynamicFiltersStats.getReplicatedDynamicFilters(), (long)0L);
        Assert.assertEquals((long)dynamicFiltersStats.getDynamicFiltersCompleted(), (long)1L);
        DynamicFilterService.DynamicFilterDomainStats domainStats = (DynamicFilterService.DynamicFilterDomainStats)Iterables.getOnlyElement((Iterable)dynamicFiltersStats.getDynamicFilterDomainStats());
        Assert.assertEquals((String)domainStats.getSimplifiedDomain(), (String)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)IntegerType.INTEGER, (Object)1L, (boolean)true, (Object)60000L, (boolean)true), (Range[])new Range[0]), (boolean)false).toString(this.getSession().toConnectorSession()));
        Assert.assertEquals((int)domainStats.getDiscreteValuesCount(), (int)0);
        Assert.assertEquals((int)domainStats.getRangeCount(), (int)1);
    }

    @Test(timeOut=30000L)
    public void testJoinWithMultipleDynamicFiltersOnProbe() {
        ResultWithQueryId result = this.getDistributedQueryRunner().executeWithQueryId(this.getSession(), "SELECT * FROM (SELECT supplier.suppkey FROM partitioned_lineitem JOIN tpch.tiny.supplier ON partitioned_lineitem.suppkey = supplier.suppkey AND supplier.name IN ('Supplier#000000001', 'Supplier#000000002')) t JOIN supplier ON t.suppkey = supplier.suppkey AND supplier.suppkey IN (2, 3)");
        Assertions.assertGreaterThan((Comparable)Integer.valueOf(((MaterializedResult)result.getResult()).getRowCount()), (Comparable)Integer.valueOf(0));
        DynamicFilterService.DynamicFiltersStats dynamicFiltersStats = this.getDynamicFilteringStats(result.getQueryId());
        Assert.assertEquals((long)dynamicFiltersStats.getTotalDynamicFilters(), (long)2L);
        Assert.assertEquals((long)dynamicFiltersStats.getLazyDynamicFilters(), (long)2L);
        Assert.assertEquals((long)dynamicFiltersStats.getReplicatedDynamicFilters(), (long)0L);
        Assert.assertEquals((int)dynamicFiltersStats.getDynamicFiltersCompleted(), (int)2);
        List domainStats = dynamicFiltersStats.getDynamicFilterDomainStats();
        Assert.assertEquals((int)domainStats.size(), (int)2);
        domainStats.forEach(stats -> {
            Assertions.assertGreaterThanOrEqual((Comparable)Integer.valueOf(stats.getRangeCount()), (Comparable)Integer.valueOf(1));
            Assert.assertEquals((int)stats.getDiscreteValuesCount(), (int)0);
        });
    }

    @Test(timeOut=30000L)
    public void testJoinWithImplicitCoercion() {
        this.assertUpdate("CREATE TABLE partitioned_lineitem_int WITH (format = 'TEXTFILE', partitioned_by=array['suppkey_int']) AS SELECT orderkey, CAST(suppkey as int) suppkey_int FROM tpch.tiny.lineitem", 60175L);
        ResultWithQueryId result = this.getDistributedQueryRunner().executeWithQueryId(this.getSession(), "SELECT * FROM partitioned_lineitem_int l JOIN supplier s ON l.suppkey_int = s.suppkey AND s.name = 'Supplier#000000001'");
        Assertions.assertGreaterThan((Comparable)Integer.valueOf(((MaterializedResult)result.getResult()).getRowCount()), (Comparable)Integer.valueOf(0));
        DynamicFilterService.DynamicFiltersStats dynamicFiltersStats = this.getDynamicFilteringStats(result.getQueryId());
        Assert.assertEquals((long)dynamicFiltersStats.getTotalDynamicFilters(), (long)1L);
        Assert.assertEquals((long)dynamicFiltersStats.getLazyDynamicFilters(), (long)1L);
        Assert.assertEquals((long)dynamicFiltersStats.getReplicatedDynamicFilters(), (long)0L);
        Assert.assertEquals((long)dynamicFiltersStats.getDynamicFiltersCompleted(), (long)1L);
        DynamicFilterService.DynamicFilterDomainStats domainStats = (DynamicFilterService.DynamicFilterDomainStats)Iterables.getOnlyElement((Iterable)dynamicFiltersStats.getDynamicFilterDomainStats());
        Assert.assertEquals((String)domainStats.getSimplifiedDomain(), (String)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L).toString(this.getSession().toConnectorSession()));
        Assert.assertEquals((int)domainStats.getDiscreteValuesCount(), (int)0);
        Assert.assertEquals((int)domainStats.getRangeCount(), (int)1);
    }

    @Test(timeOut=30000L)
    public void testSemiJoinWithEmptyBuildSide() {
        ResultWithQueryId result = this.getDistributedQueryRunner().executeWithQueryId(this.getSession(), "SELECT * FROM partitioned_lineitem WHERE suppkey IN (SELECT suppkey FROM supplier WHERE name = 'abc')");
        Assert.assertEquals((int)((MaterializedResult)result.getResult()).getRowCount(), (int)0);
        DynamicFilterService.DynamicFiltersStats dynamicFiltersStats = this.getDynamicFilteringStats(result.getQueryId());
        Assert.assertEquals((long)dynamicFiltersStats.getTotalDynamicFilters(), (long)1L);
        Assert.assertEquals((long)dynamicFiltersStats.getLazyDynamicFilters(), (long)1L);
        Assert.assertEquals((long)dynamicFiltersStats.getReplicatedDynamicFilters(), (long)0L);
        Assert.assertEquals((long)dynamicFiltersStats.getDynamicFiltersCompleted(), (long)1L);
        DynamicFilterService.DynamicFilterDomainStats domainStats = (DynamicFilterService.DynamicFilterDomainStats)Iterables.getOnlyElement((Iterable)dynamicFiltersStats.getDynamicFilterDomainStats());
        Assert.assertEquals((String)domainStats.getSimplifiedDomain(), (String)Domain.none((Type)IntegerType.INTEGER).toString(this.getSession().toConnectorSession()));
        Assert.assertEquals((int)domainStats.getDiscreteValuesCount(), (int)0);
        Assert.assertEquals((int)domainStats.getRangeCount(), (int)0);
    }

    @Test(timeOut=30000L)
    public void testSemiJoinWithSelectiveBuildSide() {
        ResultWithQueryId result = this.getDistributedQueryRunner().executeWithQueryId(this.getSession(), "SELECT * FROM partitioned_lineitem WHERE suppkey IN (SELECT suppkey FROM supplier WHERE name = 'Supplier#000000001')");
        Assertions.assertGreaterThan((Comparable)Integer.valueOf(((MaterializedResult)result.getResult()).getRowCount()), (Comparable)Integer.valueOf(0));
        DynamicFilterService.DynamicFiltersStats dynamicFiltersStats = this.getDynamicFilteringStats(result.getQueryId());
        Assert.assertEquals((long)dynamicFiltersStats.getTotalDynamicFilters(), (long)1L);
        Assert.assertEquals((long)dynamicFiltersStats.getLazyDynamicFilters(), (long)1L);
        Assert.assertEquals((long)dynamicFiltersStats.getReplicatedDynamicFilters(), (long)0L);
        Assert.assertEquals((long)dynamicFiltersStats.getDynamicFiltersCompleted(), (long)1L);
        DynamicFilterService.DynamicFilterDomainStats domainStats = (DynamicFilterService.DynamicFilterDomainStats)Iterables.getOnlyElement((Iterable)dynamicFiltersStats.getDynamicFilterDomainStats());
        Assert.assertEquals((String)domainStats.getSimplifiedDomain(), (String)Domain.singleValue((Type)IntegerType.INTEGER, (Object)1L).toString(this.getSession().toConnectorSession()));
        Assert.assertEquals((int)domainStats.getDiscreteValuesCount(), (int)0);
        Assert.assertEquals((int)domainStats.getRangeCount(), (int)1);
    }

    @Test(timeOut=30000L)
    public void testSemiJoinWithNonSelectiveBuildSide() {
        ResultWithQueryId result = this.getDistributedQueryRunner().executeWithQueryId(this.getSession(), "SELECT * FROM partitioned_lineitem WHERE suppkey IN (SELECT suppkey FROM supplier)");
        Assertions.assertGreaterThan((Comparable)Integer.valueOf(((MaterializedResult)result.getResult()).getRowCount()), (Comparable)Integer.valueOf(0));
        DynamicFilterService.DynamicFiltersStats dynamicFiltersStats = this.getDynamicFilteringStats(result.getQueryId());
        Assert.assertEquals((long)dynamicFiltersStats.getTotalDynamicFilters(), (long)1L);
        Assert.assertEquals((long)dynamicFiltersStats.getLazyDynamicFilters(), (long)1L);
        Assert.assertEquals((long)dynamicFiltersStats.getReplicatedDynamicFilters(), (long)0L);
        Assert.assertEquals((long)dynamicFiltersStats.getDynamicFiltersCompleted(), (long)1L);
        DynamicFilterService.DynamicFilterDomainStats domainStats = (DynamicFilterService.DynamicFilterDomainStats)Iterables.getOnlyElement((Iterable)dynamicFiltersStats.getDynamicFilterDomainStats());
        Assert.assertEquals((String)domainStats.getSimplifiedDomain(), (String)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)IntegerType.INTEGER, (Object)1L, (boolean)true, (Object)100L, (boolean)true), (Range[])new Range[0]), (boolean)false).toString(this.getSession().toConnectorSession()));
        Assert.assertEquals((int)domainStats.getDiscreteValuesCount(), (int)0);
        Assert.assertEquals((int)domainStats.getRangeCount(), (int)100);
    }

    @Test(timeOut=30000L)
    public void testSemiJoinLargeBuildSideRangeDynamicFiltering() {
        ResultWithQueryId result = this.getDistributedQueryRunner().executeWithQueryId(this.getSession(), "SELECT * FROM partitioned_lineitem WHERE orderkey IN (SELECT orderkey FROM orders)");
        Assert.assertEquals((long)((MaterializedResult)result.getResult()).getRowCount(), (long)60175L);
        DynamicFilterService.DynamicFiltersStats dynamicFiltersStats = this.getDynamicFilteringStats(result.getQueryId());
        Assert.assertEquals((long)dynamicFiltersStats.getTotalDynamicFilters(), (long)1L);
        Assert.assertEquals((long)dynamicFiltersStats.getLazyDynamicFilters(), (long)1L);
        Assert.assertEquals((long)dynamicFiltersStats.getReplicatedDynamicFilters(), (long)0L);
        Assert.assertEquals((long)dynamicFiltersStats.getDynamicFiltersCompleted(), (long)1L);
        DynamicFilterService.DynamicFilterDomainStats domainStats = (DynamicFilterService.DynamicFilterDomainStats)Iterables.getOnlyElement((Iterable)dynamicFiltersStats.getDynamicFilterDomainStats());
        Assert.assertEquals((String)domainStats.getSimplifiedDomain(), (String)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)IntegerType.INTEGER, (Object)1L, (boolean)true, (Object)60000L, (boolean)true), (Range[])new Range[0]), (boolean)false).toString(this.getSession().toConnectorSession()));
        Assert.assertEquals((int)domainStats.getDiscreteValuesCount(), (int)0);
        Assert.assertEquals((int)domainStats.getRangeCount(), (int)1);
    }

    @Test(timeOut=30000L)
    public void testRightJoinWithEmptyBuildSide() {
        ResultWithQueryId result = this.getDistributedQueryRunner().executeWithQueryId(this.getSession(), "SELECT * FROM partitioned_lineitem l RIGHT JOIN supplier s ON l.suppkey = s.suppkey WHERE name = 'abc'");
        Assert.assertEquals((int)((MaterializedResult)result.getResult()).getRowCount(), (int)0);
        DynamicFilterService.DynamicFiltersStats dynamicFiltersStats = this.getDynamicFilteringStats(result.getQueryId());
        Assert.assertEquals((long)dynamicFiltersStats.getTotalDynamicFilters(), (long)1L);
        Assert.assertEquals((long)dynamicFiltersStats.getLazyDynamicFilters(), (long)1L);
        Assert.assertEquals((long)dynamicFiltersStats.getReplicatedDynamicFilters(), (long)0L);
        Assert.assertEquals((long)dynamicFiltersStats.getDynamicFiltersCompleted(), (long)1L);
        DynamicFilterService.DynamicFilterDomainStats domainStats = (DynamicFilterService.DynamicFilterDomainStats)Iterables.getOnlyElement((Iterable)dynamicFiltersStats.getDynamicFilterDomainStats());
        Assert.assertEquals((String)domainStats.getSimplifiedDomain(), (String)Domain.none((Type)BigintType.BIGINT).toString(this.getSession().toConnectorSession()));
        Assert.assertEquals((int)domainStats.getDiscreteValuesCount(), (int)0);
        Assert.assertEquals((int)domainStats.getRangeCount(), (int)0);
    }

    @Test(timeOut=30000L)
    public void testRightJoinWithSelectiveBuildSide() {
        ResultWithQueryId result = this.getDistributedQueryRunner().executeWithQueryId(this.getSession(), "SELECT * FROM partitioned_lineitem l RIGHT JOIN supplier s ON l.suppkey = s.suppkey WHERE name = 'Supplier#000000001'");
        Assertions.assertGreaterThan((Comparable)Integer.valueOf(((MaterializedResult)result.getResult()).getRowCount()), (Comparable)Integer.valueOf(0));
        DynamicFilterService.DynamicFiltersStats dynamicFiltersStats = this.getDynamicFilteringStats(result.getQueryId());
        Assert.assertEquals((long)dynamicFiltersStats.getTotalDynamicFilters(), (long)1L);
        Assert.assertEquals((long)dynamicFiltersStats.getLazyDynamicFilters(), (long)1L);
        Assert.assertEquals((long)dynamicFiltersStats.getReplicatedDynamicFilters(), (long)0L);
        Assert.assertEquals((long)dynamicFiltersStats.getDynamicFiltersCompleted(), (long)1L);
        DynamicFilterService.DynamicFilterDomainStats domainStats = (DynamicFilterService.DynamicFilterDomainStats)Iterables.getOnlyElement((Iterable)dynamicFiltersStats.getDynamicFilterDomainStats());
        Assert.assertEquals((String)domainStats.getSimplifiedDomain(), (String)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L).toString(this.getSession().toConnectorSession()));
        Assert.assertEquals((int)domainStats.getDiscreteValuesCount(), (int)0);
        Assert.assertEquals((int)domainStats.getRangeCount(), (int)1);
    }

    @Test(timeOut=30000L)
    public void testRightJoinWithNonSelectiveBuildSide() {
        ResultWithQueryId result = this.getDistributedQueryRunner().executeWithQueryId(this.getSession(), "SELECT * FROM partitioned_lineitem l RIGHT JOIN supplier s ON l.suppkey = s.suppkey");
        Assertions.assertGreaterThan((Comparable)Integer.valueOf(((MaterializedResult)result.getResult()).getRowCount()), (Comparable)Integer.valueOf(0));
        DynamicFilterService.DynamicFiltersStats dynamicFiltersStats = this.getDynamicFilteringStats(result.getQueryId());
        Assert.assertEquals((long)dynamicFiltersStats.getTotalDynamicFilters(), (long)1L);
        Assert.assertEquals((long)dynamicFiltersStats.getLazyDynamicFilters(), (long)1L);
        Assert.assertEquals((long)dynamicFiltersStats.getReplicatedDynamicFilters(), (long)0L);
        Assert.assertEquals((long)dynamicFiltersStats.getDynamicFiltersCompleted(), (long)1L);
        DynamicFilterService.DynamicFilterDomainStats domainStats = (DynamicFilterService.DynamicFilterDomainStats)Iterables.getOnlyElement((Iterable)dynamicFiltersStats.getDynamicFilterDomainStats());
        Assert.assertEquals((String)domainStats.getSimplifiedDomain(), (String)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)BigintType.BIGINT, (Object)1L, (boolean)true, (Object)100L, (boolean)true), (Range[])new Range[0]), (boolean)false).toString(this.getSession().toConnectorSession()));
        Assert.assertEquals((int)domainStats.getDiscreteValuesCount(), (int)0);
        Assert.assertEquals((int)domainStats.getRangeCount(), (int)100);
    }

    private DynamicFilterService.DynamicFiltersStats getDynamicFilteringStats(QueryId queryId) {
        return this.getDistributedQueryRunner().getCoordinator().getQueryManager().getFullQueryInfo(queryId).getQueryStats().getDynamicFiltersStats();
    }
}

