/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.Resources;
import io.prestosql.Session;
import io.prestosql.plugin.hive.HiveQueryRunner;
import io.prestosql.spi.security.Identity;
import io.prestosql.testing.QueryRunner;
import io.prestosql.testing.TestingSession;
import io.prestosql.tpch.TpchTable;
import java.io.File;
import java.util.Map;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestHiveFileBasedSecurity {
    private QueryRunner queryRunner;

    @BeforeClass
    public void setUp() throws Exception {
        String path = new File(Resources.getResource(this.getClass(), (String)"security.json").toURI()).getPath();
        this.queryRunner = HiveQueryRunner.builder().setHiveProperties((Map<String, String>)ImmutableMap.of((Object)"hive.security", (Object)"file", (Object)"security.config-file", (Object)path)).setInitialTables((Iterable<TpchTable<?>>)ImmutableList.of((Object)TpchTable.NATION)).build();
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() {
        this.queryRunner.close();
        this.queryRunner = null;
    }

    @Test
    public void testAdminCanRead() {
        Session admin = this.getSession("hive");
        this.queryRunner.execute(admin, "SELECT * FROM nation");
    }

    @Test(expectedExceptions={RuntimeException.class}, expectedExceptionsMessageRegExp=".*Access Denied: Cannot select from table tpch.nation.*")
    public void testNonAdminCannotRead() {
        Session bob = this.getSession("bob");
        this.queryRunner.execute(bob, "SELECT * FROM nation");
    }

    private Session getSession(String user) {
        return TestingSession.testSessionBuilder().setCatalog((String)this.queryRunner.getDefaultSession().getCatalog().get()).setSchema((String)this.queryRunner.getDefaultSession().getSchema().get()).setIdentity(Identity.ofUser((String)user)).build();
    }
}

